# SSL targets used to managed self signed certificates

OPENSSL_CMD=@docker compose run --rm -v ${DEST}/conf/ssl:/datassl -e "DEPLOYHOST=${DEPLOYHOST}" apache2 openssl

### create a truststore in ${DEST}/conf/ssl/${DEPLOYHOST} containing ${DEST}/conf/ssl/${DEPLOYHOST}/fullchain.pem and privkey.pem
# truststore-build:
# 	@rm -rf ${DEST}/conf/ssl/${DEPLOYHOST}/truststore.p12
# 	${OPENSSL_CMD} pkcs12 -export -in /datassl/${DEPLOYHOST}/fullchain.pem -inkey /datassl/${DEPLOYHOST}/privkey.pem -name "${DEPLOYHOST}" -out /datassl/${DEPLOYHOST}/truststore.p12 -password pass:${TRUSTSTOREPASS}

#### list certificates from the truststore in ${DEST}/conf/ssl/${DEPLOYHOST} (requires keytool installed)
# truststore-show:
# 	@echo "Using ${DEST}/conf/ssl/${DEPLOYHOST}/truststore.p12"
# 	@keytool -list -keystore "${DEST}/conf/ssl/${DEPLOYHOST}/truststore.p12" -storepass ${TRUSTSTOREPASS}

### complete start with self-signed ssl certificates
start-with-selfsigned-ssl: ssl-genkey ssl-gencsr ssl-gencert startUntrustedSSL

### generate private key and put it in ${DEST}/conf/ssl/${DEPLOYHOST}
ssl-genkey:
	@mkdir -p ${DEST}/conf/ssl/${DEPLOYHOST}
	${OPENSSL_CMD} genrsa -out /datassl/${DEPLOYHOST}/privkey.pem 4096

### generate certificate using CSR and private key from ${DEST}/conf/ssl/${DEPLOYHOST}
ssl-gencert:
	${OPENSSL_CMD} x509 -in /datassl/${DEPLOYHOST}/csr.pem -out /datassl/${DEPLOYHOST}/fullchain.pem -req -signkey /datassl/${DEPLOYHOST}/privkey.pem -days 365 -extfile /datassl/csr_config -extensions req_ext

### generate CSR using private key from ${DEST}/conf/ssl/${DEPLOYHOST}
ssl-gencsr:
	${OPENSSL_CMD} req -new -key /datassl/${DEPLOYHOST}/privkey.pem -out /datassl/${DEPLOYHOST}/csr.pem -config /datassl/csr_config

### like start but also injects certificates
startUntrustedSSL: init-log-dir up
startUntrustedSSL: injectCertToSystemtruststore
startUntrustedSSL: restart-explore restart-dataintegration
startUntrustedSSL: wait-for-healthy

### injects given certificates into explore and dataintegration
injectCertToSystemtruststore:
	${CMD} exec dataintegration mkdir -p /cacerts
	${CMD} cp conf/ssl/${DEPLOYHOST}/fullchain.pem dataintegration:/cacerts/fullchain.pem
	${CMD} cp dataintegration:${DEFAULT_REQUESTS_CA_BUNDLE} ${DEST}/conf/ssl/${DEPLOYHOST}/pythoncacerts
	cat conf/ssl/${DEPLOYHOST}/fullchain.pem >> ${DEST}/conf/ssl/${DEPLOYHOST}/pythoncacerts
	${CMD} cp ${DEST}/conf/ssl/${DEPLOYHOST}/pythoncacerts dataintegration:${REQUESTS_CA_BUNDLE}
	
	${CMD} exec explore mkdir -p /cacerts
	${CMD} cp conf/ssl/${DEPLOYHOST}/fullchain.pem explore:/cacerts/fullchain.pem

ifneq ("$(wildcard conf/apache2/includes-enabled/${EXTENSION}.conf)","")
    # extension is enabled
	@echo "injecting certs to /cacerts into ${EXTENSION} container";
	${CMD} -f extensions/docker-compose.${EXTENSION}.yml exec ${EXTENSION} mkdir -p /cacerts || true
	${CMD} -f extensions/docker-compose.${EXTENSION}.yml cp conf/ssl/${DEPLOYHOST}/fullchain.pem ${EXTENSION}:/cacerts/fullchain.pem || true
	@echo "Restarting ${EXTENSION} container";
	${CMD} -f extensions/docker-compose.${EXTENSION}.yml restart ${EXTENSION} || true
else
    # no extension enabled so skip
	@echo "No need to inject into any extension container.";
endif
