# How to deploy the prometheus extension

First have the CO up and running in your preferred setup.
This is important because you need to have the apache httpd up for the next step

```sh
# fresh start
make clean-pull-start-bootstrap

# or
make start
```

In some cases it might be needed to have grafana's data volume writable for others. This depends on the permissions the docker daemon has inside the data directory.

```sh
mkdir -p data/grafana
chmod 777 data/grafana
```

Start the extension.

```sh
make enable-extension EXTENSION=metrics
```
You can do this also in one single call:

``` sh
make clean-pull-start-bootstrap enable-extension EXTENSION=metrics
```

There is now a grafana instance at `http://$DEPLOYHOST/metrics`. Account is `admin`. Password as well `admin`.
There also is a cadviser container running, which can be accessed at `http://localhost:8080`, to see if your docker stats are also scraped.

## Docker container stats

### Docker for Desktop (Mac/Win)

To get container stats in docker for desktop add this to your docker configuration (in the _Docker Engine_ sections):

```json
{
  "metrics-addr": "127.0.0.1:9323"
}
```

### Docker CLI (Linux)

This file also exists in `/etc/docker/daemon.json`. See https://docs.docker.com/config/daemon/prometheus/#configure-the-daemon for more details.
