const sass = require("sass");
const tildeImporter = require("node-sass-package-importer");
const yargs = require("yargs");
const sassRenderSyncConfig = require("@eccenca/gui-elements/config/sassOptions");

const args = yargs(process.argv.slice(2)).argv;

const styles = sass.renderSync({
    importer: tildeImporter(),
    ...sassRenderSyncConfig,
    outputStyle: "compressed",
    file: "scss/styles.scss",
    includePaths: ["node_modules"], // Carbon does not use tilde import syntax
});

if (args.outputCss) {
    console.log(styles.css.toString());
}
