#!/usr/bin/env bash
# @(#) Import the tutorials from the web
# shellcheck disable=SC1090
# Use the unofficial bash strict mode: http://redsymbol.net/articles/unofficial-bash-strict-mode/
set -euo pipefail; export FS=$'\n\t'

DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
CMEMC="docker compose run --rm -i -e OAUTH_CLIENT_SECRET=${CMEM_SERVICE_ACCOUNT_CLIENT_SECRET} -v ${DIR}/../conf/cmemc/cmemc.ini:/config/cmemc.ini cmemc -c cmem"

tutorial_csv_url=https://documentation.eccenca.com/latest/build/lift-data-from-tabular-data-such-as-csv-xslx-or-database-tables/tutorial-csv.project.zip
tutorial_xml_url=https://documentation.eccenca.com/latest/build/lift-data-from-json-and-xml-sources/tutorial-xml.project.zip
tutorial_json_url=https://documentation.eccenca.com/latest/build/lift-data-from-json-and-xml-sources/tutorial-json.project.zip
tutorial_webapi_url=https://documentation.eccenca.com/latest/build/extracting-data-from-a-web-api/tutorial-webapi.project.zip
tutorial_varinput_url=https://documentation.eccenca.com/latest/automate/processing-data-with-variable-input-workflows/tutorial-varinput.project.zip

# Import tutorials
${CMEMC} project import ${tutorial_csv_url}
${CMEMC} project import ${tutorial_xml_url}
${CMEMC} project import ${tutorial_json_url}
${CMEMC} project import ${tutorial_webapi_url}
${CMEMC} project import ${tutorial_varinput_url}

