# targets for backup and restore (not part of the distribution)

#######################
# BACKUP/RESTORE CMEM #
#######################

DATETIME := $(shell date "+%Y-%m-%d_%H-%M")
BACKUPS_DIR := data/backups
DI_PLUGINS_DIR := data/python-packages
KEYCLOAK_POSTGRES_RESTORE_DIR := conf/postgres/docker-entrypoint-initdb.d

## Backup cmem instance completely
backup: keycloak-backup 
backup: backup-workspace
backup: backup-python-packages
backup: backup-graphs
backup: zip-backup

### (deprecated) for backwards compatibility - Backup Keycloak's postgres DB
keycloak-backup: backup-keycloak

### Backup Keycloak's postgres DB
backup-keycloak:
	@echo "Backing up Keycloak."
	@mkdir -p ${BACKUPS_DIR}/keycloak
	@scripts/keycloakBackup.dist.sh ${BACKUPS_DIR}/keycloak
	mv ${BACKUPS_DIR}/keycloak/keycloak.sql ${BACKUPS_DIR}/keycloak/${DATETIME}.sql
	ln -sf ${DATETIME}.sql ${BACKUPS_DIR}/keycloak/latest.sql

### Export workspace using cmemc
backup-workspace: setup-cmemc-env
	@echo "Backing up Dataintegration workspace."
	@mkdir -p ${BACKUPS_DIR}/workspace
	@chmod o+w ${BACKUPS_DIR}/workspace
	${CMEMC} admin workspace export /data/backups/workspace/${DATETIME}.zip
	ln -sf ${DATETIME}.zip ${BACKUPS_DIR}/workspace/latest.zip

backup-python-packages:
	@echo "Backing up Python package volume."
	@mkdir -p ${BACKUPS_DIR}/python-packages
	zip -r ${BACKUPS_DIR}/python-packages/${DATETIME}.zip data/python-packages
	ln -sf ${DATETIME}.zip ${BACKUPS_DIR}/python-packages/latest.zip

### Backup all graphs using cmemc
backup-graphs: setup-cmemc-env
	@echo "Backing up Graphs."
	@mkdir -p ${BACKUPS_DIR}/graphs
	@chmod o+w ${BACKUPS_DIR}/graphs
	${CMEMC} admin store export /data/backups/graphs/${DATETIME}.zip
	ln -sf ${DATETIME}.zip ${BACKUPS_DIR}/graphs/latest.zip

### compresses the ${BACKUPS_DIR}/zip-tmp folder into a ${BACKUPS_DIR}/*.cmemc.zip file
zip-backup:
	@echo "Backing up Graphs."
	zip -r ${BACKUPS_DIR}/${DATETIME}.zip ${BACKUPS_DIR}/keycloak/${DATETIME}.sql ${BACKUPS_DIR}/workspace/${DATETIME}.zip ${BACKUPS_DIR}/graphs/${DATETIME}.zip ${BACKUPS_DIR}/python-packages/${DATETIME}.zip
#	rm -f ${BACKUPS_DIR}/keycloak/${DATETIME}.sql ${BACKUPS_DIR}/workspace/${DATETIME}.zip ${BACKUPS_DIR}/graphs/${DATETIME}.zip ${BACKUPS_DIR}/python-packages/${DATETIME}.zip
	ln -sf ${DATETIME}.zip ${BACKUPS_DIR}/latest.zip

### removes all backups
backups-remove:
	@if [ -z ${BACKUPS_DIR} ]; then \
		echo "WARNING this could be dangerous. Make sure BACKUPS_DIR is set."; \
		exit 1; \
	fi;
	rm -f ${BACKUPS_DIR}/workspace/*
	rm -f ${BACKUPS_DIR}/graphs/*
	rm -rf ${BACKUPS_DIR}/python-packages/*
	rm -f ${BACKUPS_DIR}/keycloak/*
	rm -f ${BACKUPS_DIR}/*.zip

## list all available backups ${BACKUPS_DIR} folder
backups-list:
	@echo "The following backups (${BACKUPS_DIR}/*.zip) are available:"
	@cd ${BACKUPS_DIR} && ls *.zip | perl -pe 's/.zip//g'
	@echo "Please define BACKUP (backup filename without .cmemc.zip, like BACKUP=2016-12-22-clean).";

## Restore cmem instance completely. Either tries latest or use STATE env variable
restore:
	@if [ -z ${BACKUP} ]; then \
		echo "No export defined (BACKUP not set), try using latest."; \
		if [ -f ${BACKUPS_DIR}/latest.zip ]; then \
			echo "Found latest: ${BACKUPS_DIR}/latest.zip ... extracting"; \
			unzip -o ${BACKUPS_DIR}/latest.zip; \
			export BACKUP=latest ; \
			make internal-restore; \
		else \
			echo "No latest file exists, abort."; \
			exit 1; \
		fi \
	else \
		if [ -f ${BACKUPS_DIR}/${BACKUP}.zip ]; then \
			echo "Backup exists. extracting"; \
			unzip -o ${BACKUPS_DIR}/${BACKUP}.zip; \
			make internal-restore; \
		else \
			echo "File does not exist, abort."; \
			exit 1; \
		fi \
	fi \

# 
internal-restore: delete-all-graphs
internal-restore: delete-all-projects
internal-restore: restore-keycloak
internal-restore: restore-python-packages
internal-restore: wait-for-healthy
internal-restore: restore-workspace
internal-restore: restore-graphs
internal-restore: wait-for-healthy

### deletes all graphs using cmemc
delete-all-graphs: setup-cmemc-env
	${CMEMC} graph delete --all

### deletes all DI projects using cmemc
delete-all-projects: setup-cmemc-env
	${CMEMC} project delete --all

restore-keycloak:
	cp -L ${BACKUPS_DIR}/keycloak/${BACKUP}.sql ${KEYCLOAK_POSTGRES_RESTORE_DIR}/keycloak_db.sql
	chmod 755 ${KEYCLOAK_POSTGRES_RESTORE_DIR}/keycloak_db.sql
	${CMD} up -d --force-recreate -V postgres

restore-python-packages:
	unzip -o ${BACKUPS_DIR}/python-packages/${BACKUP}.zip 
	make restart-dataintegration

restore-workspace:
	${CMEMC} admin workspace import /data/backups/workspace/${BACKUP}.zip

restore-graphs:
	${CMEMC} admin store import /data/backups/graphs/${BACKUP}.zip
