# How to deploy the Graph Insights extension

Graph Insights requires authentication similar to Explore and Build (DataIntegration).
There is the need for a client to authenticate in a browser and a second client to allow inter-component communication.

For convenience, by default we use the same clients as for the rest of the application:
    - client for browser: cmem
    - client for component communication: cmem-service-account

In case you want to have separate clients for production deployments, have a look at the end of this file.

First, have the CO up and running in your preferred setup.
This is important because you need to have the apache httpd up for the next step.

``` sh
# fresh start
make clean-pull-start-bootstrap

# or
make start
```

Start the extension.

``` sh
make enable-extension EXTENSION=graphinsights
```

You can do this also in one single call:

``` sh
make clean-pull-start-bootstrap enable-extension EXTENSION=graphinsights
```

## Start with custom or untrusted certificates

To have the Graph Insights extension setup with some custom or untrusted certificates, you have to make sure the extension
runs with the proper environments and also have the certificates injected into the `graphinsights` container `/cacerts` folder.
Once the `*.pem` or `*.crt` files are in place, restarting the container will add them into its truststore.

``` sh
EXTENSION=graphinsights CONFIGFILE=environments/config.ssl.env make start-with-selfsigned-ssl bootstrap enable-extension
EXTENSION=graphinsights CONFIGFILE=environments/config.ssl.env make injectCertToSystemtruststore
```

## Prepare deployment to run with separate keycloak clients

If you start Corporate Memory for the first time, the separate clients are already created when starting the Postgresql container.
In an already running deployment you would have to create those clients on your own.
We documented that in our [documentation](https://documentation.eccenca.com/latest/deploy-and-configure/configuration/keycloak/#client-configuration).

To enrol those other clients, please follow these steps:

1.) take a look at `environments/default.env` and copy these variables to your `environments/config.env` file:

``` Makefile
# This is the browser client:
GRAPHINSIGHTS_OAUTH_CLIENT_ID=graph-insights
# was this before:
# GRAPHINSIGHTS_OAUTH_CLIENT_ID=${OAUTH_CLIENT_ID}

# This is the inter component client:
GRAPHINSIGHTS_OAUTH_SERVICE_CLIENT_ID=graph-insights-service-account
# change the credital depending on your client secret, default would be: 7Ctw7eZvTeFYdwwvwopy8OjuMUVPb8A9
GRAPHINSIGHTS_OAUTH_SERVICE_CLIENT_SECRET=changeme
```

2.) Replace this in `docker-compose.yml`:

``` yaml
      - "EXPLORE_CMEM_SERVICE_CLIENT=${CMEM_SERVICE_ACCOUNT_CLIENT_ID}"
      - "EXPLORE_CMEM_SERVICE_CLIENT_SECRET=${CMEM_SERVICE_ACCOUNT_CLIENT_SECRET}"
      # with:
      - "EXPLORE_CMEM_SERVICE_CLIENT=${GRAPHINSIGHTS_OAUTH_SERVICE_CLIENT_ID}"
      - "EXPLORE_CMEM_SERVICE_CLIENT_SECRET=${GRAPHINSIGHTS_OAUTH_SERVICE_CLIENT_SECRET}"
```

3.) And also replace this in `extensions/docker-compose.graphinsights.yml`

``` yaml
      - "GRAPHINSIGHTS_OAUTH_SERVICE_CLIENT_ID=${CMEM_SERVICE_ACCOUNT_CLIENT_ID}"
      - "GRAPHINSIGHTS_OAUTH_SERVICE_CLIENT_SECRET=${CMEM_SERVICE_ACCOUNT_CLIENT_SECRET}"
      # with:
      - "GRAPHINSIGHTS_OAUTH_SERVICE_CLIENT_ID=${GRAPHINSIGHTS_OAUTH_SERVICE_CLIENT_ID}"
      - "GRAPHINSIGHTS_OAUTH_SERVICE_CLIENT_SECRET=${GRAPHINSIGHTS_OAUTH_SERVICE_CLIENT_SECRET}"
```

4.) Then start as described above.

## Caveats

### Service not started - Log: A serialization issue occurred

After upgrading the extension, there could be an error like this in the log - with a service which was not started.

The easiest way to solve this, is by deleting the persisted data  and restarting everything:

``` sh
rm -rf data/explore-graphinsights/
```

