# letsencypt specific targets

OPENSSL_CMD=@docker run --rm -it -v ${DEST}/conf/ssl:/datassl -e "DEPLOYHOST=${DEPLOYHOST}" docker-registry.eccenca.com/eccenca-apache2:${APACHE2_VERSION} openssl

# generates Diffi Hellman Eliptique Curves for SSL encryption
dhparam:
	${OPENSSL_CMD} dhparam -out /datassl/dhparam.pem 2048

### request letsencrypt certitificates and save to ${DEST}/conf/ssl/${DEPLOYHOST}/
letsencrypt-create:
	#@echo "Make sure this machine is reachable from the internet"
	@docker run --rm -v "${DEST}/conf/ssl/${DEPLOYHOST}/:/etc/letsencrypt" -p 80\:80 -p 443\:443 certbot/certbot certonly --standalone -d ${DEPLOYHOST} -m ${LETSENCRYPT_MAIL} --agree-tos

### request letsencrypt certitificate for a SUBDOMAIN and save to ${DEST}/conf/ssl/${SUBDOMAIN}.${DEPLOYHOST}/
letsencrypt-create-subdomain:
	@if [ -z ${SUBDOMAIN} ]; then \
		echo "no subdoamin specified, use SUBDOMAIN=<your-sub-domain>"; exit 1 ; \
	else \
		echo "Make sure this machine is reachable from the internet. This might mean you need to stop apache in order to run this successfully." ; \
		docker run --rm -v "${DEST}/conf/ssl/${DEPLOYHOST}/:/etc/letsencrypt" -p 80\:80 -p 443\:443 certbot/certbot certonly --standalone -d ${SUBDOMAIN}.${DEPLOYHOST} -m ${LETSENCRYPT_MAIL} --agree-tos ; \
	fi

### renew letsencrypt certitificates from ${DEST}/conf/ssl/${DEPLOYHOST}/ directory
letsencrypt-renew:
	@echo "Make sure this machine is reachable from the internet"
	@docker run --rm -v ${DEST}/conf/ssl/${DEPLOYHOST}/:/etc/letsencrypt -p 80\:80 -p 443\:443 certbot/certbot renew

