#!/usr/bin/env bash
set -Eeuo pipefail

# If the metadata file does NOT exist, build the index.
if [[ ! -f "cmem.meta-data.json" ]]; then
  # Send an empty line to IndexBuilderMain, pipe output to a log file.
  echo '' | IndexBuilderMain \
    --file-format nt \
    --kg-input-file - \
    --index-basename cmem \
    | tee cmem.index-log.txt
fi

# start QLever in the foreground on the provided port/token.
exec qlever start \
--kill-existing-with-same-port \
--port "${QLEVER_PORT}" \
--run-in-foreground \
--persist-updates \
--system native \
--name cmem \
--description "cmem base index" \
--access-token "${QLEVER_ACCESS_TOKEN}"
