--
-- PostgreSQL database dump
--

-- Dumped from database version 17.5
-- Dumped by pg_dump version 17.5

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET transaction_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: admin_event_entity; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.admin_event_entity (
    id character varying(36) NOT NULL,
    admin_event_time bigint,
    realm_id character varying(255),
    operation_type character varying(255),
    auth_realm_id character varying(255),
    auth_client_id character varying(255),
    auth_user_id character varying(255),
    ip_address character varying(255),
    resource_path character varying(2550),
    representation text,
    error character varying(255),
    resource_type character varying(64),
    details_json text
);


ALTER TABLE public.admin_event_entity OWNER TO keycloak;

--
-- Name: associated_policy; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.associated_policy (
    policy_id character varying(36) NOT NULL,
    associated_policy_id character varying(36) NOT NULL
);


ALTER TABLE public.associated_policy OWNER TO keycloak;

--
-- Name: authentication_execution; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.authentication_execution (
    id character varying(36) NOT NULL,
    alias character varying(255),
    authenticator character varying(36),
    realm_id character varying(36),
    flow_id character varying(36),
    requirement integer,
    priority integer,
    authenticator_flow boolean DEFAULT false NOT NULL,
    auth_flow_id character varying(36),
    auth_config character varying(36)
);


ALTER TABLE public.authentication_execution OWNER TO keycloak;

--
-- Name: authentication_flow; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.authentication_flow (
    id character varying(36) NOT NULL,
    alias character varying(255),
    description character varying(255),
    realm_id character varying(36),
    provider_id character varying(36) DEFAULT 'basic-flow'::character varying NOT NULL,
    top_level boolean DEFAULT false NOT NULL,
    built_in boolean DEFAULT false NOT NULL
);


ALTER TABLE public.authentication_flow OWNER TO keycloak;

--
-- Name: authenticator_config; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.authenticator_config (
    id character varying(36) NOT NULL,
    alias character varying(255),
    realm_id character varying(36)
);


ALTER TABLE public.authenticator_config OWNER TO keycloak;

--
-- Name: authenticator_config_entry; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.authenticator_config_entry (
    authenticator_id character varying(36) NOT NULL,
    value text,
    name character varying(255) NOT NULL
);


ALTER TABLE public.authenticator_config_entry OWNER TO keycloak;

--
-- Name: broker_link; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.broker_link (
    identity_provider character varying(255) NOT NULL,
    storage_provider_id character varying(255),
    realm_id character varying(36) NOT NULL,
    broker_user_id character varying(255),
    broker_username character varying(255),
    token text,
    user_id character varying(255) NOT NULL
);


ALTER TABLE public.broker_link OWNER TO keycloak;

--
-- Name: client; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.client (
    id character varying(36) NOT NULL,
    enabled boolean DEFAULT false NOT NULL,
    full_scope_allowed boolean DEFAULT false NOT NULL,
    client_id character varying(255),
    not_before integer,
    public_client boolean DEFAULT false NOT NULL,
    secret character varying(255),
    base_url character varying(255),
    bearer_only boolean DEFAULT false NOT NULL,
    management_url character varying(255),
    surrogate_auth_required boolean DEFAULT false NOT NULL,
    realm_id character varying(36),
    protocol character varying(255),
    node_rereg_timeout integer DEFAULT 0,
    frontchannel_logout boolean DEFAULT false NOT NULL,
    consent_required boolean DEFAULT false NOT NULL,
    name character varying(255),
    service_accounts_enabled boolean DEFAULT false NOT NULL,
    client_authenticator_type character varying(255),
    root_url character varying(255),
    description character varying(255),
    registration_token character varying(255),
    standard_flow_enabled boolean DEFAULT true NOT NULL,
    implicit_flow_enabled boolean DEFAULT false NOT NULL,
    direct_access_grants_enabled boolean DEFAULT false NOT NULL,
    always_display_in_console boolean DEFAULT false NOT NULL
);


ALTER TABLE public.client OWNER TO keycloak;

--
-- Name: client_attributes; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.client_attributes (
    client_id character varying(36) NOT NULL,
    name character varying(255) NOT NULL,
    value text
);


ALTER TABLE public.client_attributes OWNER TO keycloak;

--
-- Name: client_auth_flow_bindings; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.client_auth_flow_bindings (
    client_id character varying(36) NOT NULL,
    flow_id character varying(36),
    binding_name character varying(255) NOT NULL
);


ALTER TABLE public.client_auth_flow_bindings OWNER TO keycloak;

--
-- Name: client_initial_access; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.client_initial_access (
    id character varying(36) NOT NULL,
    realm_id character varying(36) NOT NULL,
    "timestamp" integer,
    expiration integer,
    count integer,
    remaining_count integer
);


ALTER TABLE public.client_initial_access OWNER TO keycloak;

--
-- Name: client_node_registrations; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.client_node_registrations (
    client_id character varying(36) NOT NULL,
    value integer,
    name character varying(255) NOT NULL
);


ALTER TABLE public.client_node_registrations OWNER TO keycloak;

--
-- Name: client_scope; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.client_scope (
    id character varying(36) NOT NULL,
    name character varying(255),
    realm_id character varying(36),
    description character varying(255),
    protocol character varying(255)
);


ALTER TABLE public.client_scope OWNER TO keycloak;

--
-- Name: client_scope_attributes; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.client_scope_attributes (
    scope_id character varying(36) NOT NULL,
    value character varying(2048),
    name character varying(255) NOT NULL
);


ALTER TABLE public.client_scope_attributes OWNER TO keycloak;

--
-- Name: client_scope_client; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.client_scope_client (
    client_id character varying(255) NOT NULL,
    scope_id character varying(255) NOT NULL,
    default_scope boolean DEFAULT false NOT NULL
);


ALTER TABLE public.client_scope_client OWNER TO keycloak;

--
-- Name: client_scope_role_mapping; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.client_scope_role_mapping (
    scope_id character varying(36) NOT NULL,
    role_id character varying(36) NOT NULL
);


ALTER TABLE public.client_scope_role_mapping OWNER TO keycloak;

--
-- Name: component; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.component (
    id character varying(36) NOT NULL,
    name character varying(255),
    parent_id character varying(36),
    provider_id character varying(36),
    provider_type character varying(255),
    realm_id character varying(36),
    sub_type character varying(255)
);


ALTER TABLE public.component OWNER TO keycloak;

--
-- Name: component_config; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.component_config (
    id character varying(36) NOT NULL,
    component_id character varying(36) NOT NULL,
    name character varying(255) NOT NULL,
    value text
);


ALTER TABLE public.component_config OWNER TO keycloak;

--
-- Name: composite_role; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.composite_role (
    composite character varying(36) NOT NULL,
    child_role character varying(36) NOT NULL
);


ALTER TABLE public.composite_role OWNER TO keycloak;

--
-- Name: credential; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.credential (
    id character varying(36) NOT NULL,
    salt bytea,
    type character varying(255),
    user_id character varying(36),
    created_date bigint,
    user_label character varying(255),
    secret_data text,
    credential_data text,
    priority integer,
    version integer DEFAULT 0
);


ALTER TABLE public.credential OWNER TO keycloak;

--
-- Name: databasechangelog; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.databasechangelog (
    id character varying(255) NOT NULL,
    author character varying(255) NOT NULL,
    filename character varying(255) NOT NULL,
    dateexecuted timestamp without time zone NOT NULL,
    orderexecuted integer NOT NULL,
    exectype character varying(10) NOT NULL,
    md5sum character varying(35),
    description character varying(255),
    comments character varying(255),
    tag character varying(255),
    liquibase character varying(20),
    contexts character varying(255),
    labels character varying(255),
    deployment_id character varying(10)
);


ALTER TABLE public.databasechangelog OWNER TO keycloak;

--
-- Name: databasechangeloglock; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.databasechangeloglock (
    id integer NOT NULL,
    locked boolean NOT NULL,
    lockgranted timestamp without time zone,
    lockedby character varying(255)
);


ALTER TABLE public.databasechangeloglock OWNER TO keycloak;

--
-- Name: default_client_scope; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.default_client_scope (
    realm_id character varying(36) NOT NULL,
    scope_id character varying(36) NOT NULL,
    default_scope boolean DEFAULT false NOT NULL
);


ALTER TABLE public.default_client_scope OWNER TO keycloak;

--
-- Name: event_entity; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.event_entity (
    id character varying(36) NOT NULL,
    client_id character varying(255),
    details_json character varying(2550),
    error character varying(255),
    ip_address character varying(255),
    realm_id character varying(255),
    session_id character varying(255),
    event_time bigint,
    type character varying(255),
    user_id character varying(255),
    details_json_long_value text
);


ALTER TABLE public.event_entity OWNER TO keycloak;

--
-- Name: fed_user_attribute; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.fed_user_attribute (
    id character varying(36) NOT NULL,
    name character varying(255) NOT NULL,
    user_id character varying(255) NOT NULL,
    realm_id character varying(36) NOT NULL,
    storage_provider_id character varying(36),
    value character varying(2024),
    long_value_hash bytea,
    long_value_hash_lower_case bytea,
    long_value text
);


ALTER TABLE public.fed_user_attribute OWNER TO keycloak;

--
-- Name: fed_user_consent; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.fed_user_consent (
    id character varying(36) NOT NULL,
    client_id character varying(255),
    user_id character varying(255) NOT NULL,
    realm_id character varying(36) NOT NULL,
    storage_provider_id character varying(36),
    created_date bigint,
    last_updated_date bigint,
    client_storage_provider character varying(36),
    external_client_id character varying(255)
);


ALTER TABLE public.fed_user_consent OWNER TO keycloak;

--
-- Name: fed_user_consent_cl_scope; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.fed_user_consent_cl_scope (
    user_consent_id character varying(36) NOT NULL,
    scope_id character varying(36) NOT NULL
);


ALTER TABLE public.fed_user_consent_cl_scope OWNER TO keycloak;

--
-- Name: fed_user_credential; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.fed_user_credential (
    id character varying(36) NOT NULL,
    salt bytea,
    type character varying(255),
    created_date bigint,
    user_id character varying(255) NOT NULL,
    realm_id character varying(36) NOT NULL,
    storage_provider_id character varying(36),
    user_label character varying(255),
    secret_data text,
    credential_data text,
    priority integer
);


ALTER TABLE public.fed_user_credential OWNER TO keycloak;

--
-- Name: fed_user_group_membership; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.fed_user_group_membership (
    group_id character varying(36) NOT NULL,
    user_id character varying(255) NOT NULL,
    realm_id character varying(36) NOT NULL,
    storage_provider_id character varying(36)
);


ALTER TABLE public.fed_user_group_membership OWNER TO keycloak;

--
-- Name: fed_user_required_action; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.fed_user_required_action (
    required_action character varying(255) DEFAULT ' '::character varying NOT NULL,
    user_id character varying(255) NOT NULL,
    realm_id character varying(36) NOT NULL,
    storage_provider_id character varying(36)
);


ALTER TABLE public.fed_user_required_action OWNER TO keycloak;

--
-- Name: fed_user_role_mapping; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.fed_user_role_mapping (
    role_id character varying(36) NOT NULL,
    user_id character varying(255) NOT NULL,
    realm_id character varying(36) NOT NULL,
    storage_provider_id character varying(36)
);


ALTER TABLE public.fed_user_role_mapping OWNER TO keycloak;

--
-- Name: federated_identity; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.federated_identity (
    identity_provider character varying(255) NOT NULL,
    realm_id character varying(36),
    federated_user_id character varying(255),
    federated_username character varying(255),
    token text,
    user_id character varying(36) NOT NULL
);


ALTER TABLE public.federated_identity OWNER TO keycloak;

--
-- Name: federated_user; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.federated_user (
    id character varying(255) NOT NULL,
    storage_provider_id character varying(255),
    realm_id character varying(36) NOT NULL
);


ALTER TABLE public.federated_user OWNER TO keycloak;

--
-- Name: group_attribute; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.group_attribute (
    id character varying(36) DEFAULT 'sybase-needs-something-here'::character varying NOT NULL,
    name character varying(255) NOT NULL,
    value character varying(255),
    group_id character varying(36) NOT NULL
);


ALTER TABLE public.group_attribute OWNER TO keycloak;

--
-- Name: group_role_mapping; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.group_role_mapping (
    role_id character varying(36) NOT NULL,
    group_id character varying(36) NOT NULL
);


ALTER TABLE public.group_role_mapping OWNER TO keycloak;

--
-- Name: identity_provider; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.identity_provider (
    internal_id character varying(36) NOT NULL,
    enabled boolean DEFAULT false NOT NULL,
    provider_alias character varying(255),
    provider_id character varying(255),
    store_token boolean DEFAULT false NOT NULL,
    authenticate_by_default boolean DEFAULT false NOT NULL,
    realm_id character varying(36),
    add_token_role boolean DEFAULT true NOT NULL,
    trust_email boolean DEFAULT false NOT NULL,
    first_broker_login_flow_id character varying(36),
    post_broker_login_flow_id character varying(36),
    provider_display_name character varying(255),
    link_only boolean DEFAULT false NOT NULL,
    organization_id character varying(255),
    hide_on_login boolean DEFAULT false
);


ALTER TABLE public.identity_provider OWNER TO keycloak;

--
-- Name: identity_provider_config; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.identity_provider_config (
    identity_provider_id character varying(36) NOT NULL,
    value text,
    name character varying(255) NOT NULL
);


ALTER TABLE public.identity_provider_config OWNER TO keycloak;

--
-- Name: identity_provider_mapper; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.identity_provider_mapper (
    id character varying(36) NOT NULL,
    name character varying(255) NOT NULL,
    idp_alias character varying(255) NOT NULL,
    idp_mapper_name character varying(255) NOT NULL,
    realm_id character varying(36) NOT NULL
);


ALTER TABLE public.identity_provider_mapper OWNER TO keycloak;

--
-- Name: idp_mapper_config; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.idp_mapper_config (
    idp_mapper_id character varying(36) NOT NULL,
    value text,
    name character varying(255) NOT NULL
);


ALTER TABLE public.idp_mapper_config OWNER TO keycloak;

--
-- Name: jgroups_ping; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.jgroups_ping (
    address character varying(200) NOT NULL,
    name character varying(200),
    cluster_name character varying(200) NOT NULL,
    ip character varying(200) NOT NULL,
    coord boolean
);


ALTER TABLE public.jgroups_ping OWNER TO keycloak;

--
-- Name: keycloak_group; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.keycloak_group (
    id character varying(36) NOT NULL,
    name character varying(255),
    parent_group character varying(36) NOT NULL,
    realm_id character varying(36),
    type integer DEFAULT 0 NOT NULL,
    description character varying(255)
);


ALTER TABLE public.keycloak_group OWNER TO keycloak;

--
-- Name: keycloak_role; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.keycloak_role (
    id character varying(36) NOT NULL,
    client_realm_constraint character varying(255),
    client_role boolean DEFAULT false NOT NULL,
    description character varying(255),
    name character varying(255),
    realm_id character varying(255),
    client character varying(36),
    realm character varying(36)
);


ALTER TABLE public.keycloak_role OWNER TO keycloak;

--
-- Name: migration_model; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.migration_model (
    id character varying(36) NOT NULL,
    version character varying(36),
    update_time bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.migration_model OWNER TO keycloak;

--
-- Name: offline_client_session; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.offline_client_session (
    user_session_id character varying(36) NOT NULL,
    client_id character varying(255) NOT NULL,
    offline_flag character varying(4) NOT NULL,
    "timestamp" integer,
    data text,
    client_storage_provider character varying(36) DEFAULT 'local'::character varying NOT NULL,
    external_client_id character varying(255) DEFAULT 'local'::character varying NOT NULL,
    version integer DEFAULT 0
);


ALTER TABLE public.offline_client_session OWNER TO keycloak;

--
-- Name: offline_user_session; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.offline_user_session (
    user_session_id character varying(36) NOT NULL,
    user_id character varying(255) NOT NULL,
    realm_id character varying(36) NOT NULL,
    created_on integer NOT NULL,
    offline_flag character varying(4) NOT NULL,
    data text,
    last_session_refresh integer DEFAULT 0 NOT NULL,
    broker_session_id character varying(1024),
    version integer DEFAULT 0
);


ALTER TABLE public.offline_user_session OWNER TO keycloak;

--
-- Name: org; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.org (
    id character varying(255) NOT NULL,
    enabled boolean NOT NULL,
    realm_id character varying(255) NOT NULL,
    group_id character varying(255) NOT NULL,
    name character varying(255) NOT NULL,
    description character varying(4000),
    alias character varying(255) NOT NULL,
    redirect_url character varying(2048)
);


ALTER TABLE public.org OWNER TO keycloak;

--
-- Name: org_domain; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.org_domain (
    id character varying(36) NOT NULL,
    name character varying(255) NOT NULL,
    verified boolean NOT NULL,
    org_id character varying(255) NOT NULL
);


ALTER TABLE public.org_domain OWNER TO keycloak;

--
-- Name: policy_config; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.policy_config (
    policy_id character varying(36) NOT NULL,
    name character varying(255) NOT NULL,
    value text
);


ALTER TABLE public.policy_config OWNER TO keycloak;

--
-- Name: protocol_mapper; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.protocol_mapper (
    id character varying(36) NOT NULL,
    name character varying(255) NOT NULL,
    protocol character varying(255) NOT NULL,
    protocol_mapper_name character varying(255) NOT NULL,
    client_id character varying(36),
    client_scope_id character varying(36)
);


ALTER TABLE public.protocol_mapper OWNER TO keycloak;

--
-- Name: protocol_mapper_config; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.protocol_mapper_config (
    protocol_mapper_id character varying(36) NOT NULL,
    value text,
    name character varying(255) NOT NULL
);


ALTER TABLE public.protocol_mapper_config OWNER TO keycloak;

--
-- Name: realm; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.realm (
    id character varying(36) NOT NULL,
    access_code_lifespan integer,
    user_action_lifespan integer,
    access_token_lifespan integer,
    account_theme character varying(255),
    admin_theme character varying(255),
    email_theme character varying(255),
    enabled boolean DEFAULT false NOT NULL,
    events_enabled boolean DEFAULT false NOT NULL,
    events_expiration bigint,
    login_theme character varying(255),
    name character varying(255),
    not_before integer,
    password_policy character varying(2550),
    registration_allowed boolean DEFAULT false NOT NULL,
    remember_me boolean DEFAULT false NOT NULL,
    reset_password_allowed boolean DEFAULT false NOT NULL,
    social boolean DEFAULT false NOT NULL,
    ssl_required character varying(255),
    sso_idle_timeout integer,
    sso_max_lifespan integer,
    update_profile_on_soc_login boolean DEFAULT false NOT NULL,
    verify_email boolean DEFAULT false NOT NULL,
    master_admin_client character varying(36),
    login_lifespan integer,
    internationalization_enabled boolean DEFAULT false NOT NULL,
    default_locale character varying(255),
    reg_email_as_username boolean DEFAULT false NOT NULL,
    admin_events_enabled boolean DEFAULT false NOT NULL,
    admin_events_details_enabled boolean DEFAULT false NOT NULL,
    edit_username_allowed boolean DEFAULT false NOT NULL,
    otp_policy_counter integer DEFAULT 0,
    otp_policy_window integer DEFAULT 1,
    otp_policy_period integer DEFAULT 30,
    otp_policy_digits integer DEFAULT 6,
    otp_policy_alg character varying(36) DEFAULT 'HmacSHA1'::character varying,
    otp_policy_type character varying(36) DEFAULT 'totp'::character varying,
    browser_flow character varying(36),
    registration_flow character varying(36),
    direct_grant_flow character varying(36),
    reset_credentials_flow character varying(36),
    client_auth_flow character varying(36),
    offline_session_idle_timeout integer DEFAULT 0,
    revoke_refresh_token boolean DEFAULT false NOT NULL,
    access_token_life_implicit integer DEFAULT 0,
    login_with_email_allowed boolean DEFAULT true NOT NULL,
    duplicate_emails_allowed boolean DEFAULT false NOT NULL,
    docker_auth_flow character varying(36),
    refresh_token_max_reuse integer DEFAULT 0,
    allow_user_managed_access boolean DEFAULT false NOT NULL,
    sso_max_lifespan_remember_me integer DEFAULT 0 NOT NULL,
    sso_idle_timeout_remember_me integer DEFAULT 0 NOT NULL,
    default_role character varying(255)
);


ALTER TABLE public.realm OWNER TO keycloak;

--
-- Name: realm_attribute; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.realm_attribute (
    name character varying(255) NOT NULL,
    realm_id character varying(36) NOT NULL,
    value text
);


ALTER TABLE public.realm_attribute OWNER TO keycloak;

--
-- Name: realm_default_groups; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.realm_default_groups (
    realm_id character varying(36) NOT NULL,
    group_id character varying(36) NOT NULL
);


ALTER TABLE public.realm_default_groups OWNER TO keycloak;

--
-- Name: realm_enabled_event_types; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.realm_enabled_event_types (
    realm_id character varying(36) NOT NULL,
    value character varying(255) NOT NULL
);


ALTER TABLE public.realm_enabled_event_types OWNER TO keycloak;

--
-- Name: realm_events_listeners; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.realm_events_listeners (
    realm_id character varying(36) NOT NULL,
    value character varying(255) NOT NULL
);


ALTER TABLE public.realm_events_listeners OWNER TO keycloak;

--
-- Name: realm_localizations; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.realm_localizations (
    realm_id character varying(255) NOT NULL,
    locale character varying(255) NOT NULL,
    texts text NOT NULL
);


ALTER TABLE public.realm_localizations OWNER TO keycloak;

--
-- Name: realm_required_credential; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.realm_required_credential (
    type character varying(255) NOT NULL,
    form_label character varying(255),
    input boolean DEFAULT false NOT NULL,
    secret boolean DEFAULT false NOT NULL,
    realm_id character varying(36) NOT NULL
);


ALTER TABLE public.realm_required_credential OWNER TO keycloak;

--
-- Name: realm_smtp_config; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.realm_smtp_config (
    realm_id character varying(36) NOT NULL,
    value character varying(255),
    name character varying(255) NOT NULL
);


ALTER TABLE public.realm_smtp_config OWNER TO keycloak;

--
-- Name: realm_supported_locales; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.realm_supported_locales (
    realm_id character varying(36) NOT NULL,
    value character varying(255) NOT NULL
);


ALTER TABLE public.realm_supported_locales OWNER TO keycloak;

--
-- Name: redirect_uris; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.redirect_uris (
    client_id character varying(36) NOT NULL,
    value character varying(255) NOT NULL
);


ALTER TABLE public.redirect_uris OWNER TO keycloak;

--
-- Name: required_action_config; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.required_action_config (
    required_action_id character varying(36) NOT NULL,
    value text,
    name character varying(255) NOT NULL
);


ALTER TABLE public.required_action_config OWNER TO keycloak;

--
-- Name: required_action_provider; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.required_action_provider (
    id character varying(36) NOT NULL,
    alias character varying(255),
    name character varying(255),
    realm_id character varying(36),
    enabled boolean DEFAULT false NOT NULL,
    default_action boolean DEFAULT false NOT NULL,
    provider_id character varying(255),
    priority integer
);


ALTER TABLE public.required_action_provider OWNER TO keycloak;

--
-- Name: resource_attribute; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.resource_attribute (
    id character varying(36) DEFAULT 'sybase-needs-something-here'::character varying NOT NULL,
    name character varying(255) NOT NULL,
    value character varying(255),
    resource_id character varying(36) NOT NULL
);


ALTER TABLE public.resource_attribute OWNER TO keycloak;

--
-- Name: resource_policy; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.resource_policy (
    resource_id character varying(36) NOT NULL,
    policy_id character varying(36) NOT NULL
);


ALTER TABLE public.resource_policy OWNER TO keycloak;

--
-- Name: resource_scope; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.resource_scope (
    resource_id character varying(36) NOT NULL,
    scope_id character varying(36) NOT NULL
);


ALTER TABLE public.resource_scope OWNER TO keycloak;

--
-- Name: resource_server; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.resource_server (
    id character varying(36) NOT NULL,
    allow_rs_remote_mgmt boolean DEFAULT false NOT NULL,
    policy_enforce_mode smallint NOT NULL,
    decision_strategy smallint DEFAULT 1 NOT NULL
);


ALTER TABLE public.resource_server OWNER TO keycloak;

--
-- Name: resource_server_perm_ticket; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.resource_server_perm_ticket (
    id character varying(36) NOT NULL,
    owner character varying(255) NOT NULL,
    requester character varying(255) NOT NULL,
    created_timestamp bigint NOT NULL,
    granted_timestamp bigint,
    resource_id character varying(36) NOT NULL,
    scope_id character varying(36),
    resource_server_id character varying(36) NOT NULL,
    policy_id character varying(36)
);


ALTER TABLE public.resource_server_perm_ticket OWNER TO keycloak;

--
-- Name: resource_server_policy; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.resource_server_policy (
    id character varying(36) NOT NULL,
    name character varying(255) NOT NULL,
    description character varying(255),
    type character varying(255) NOT NULL,
    decision_strategy smallint,
    logic smallint,
    resource_server_id character varying(36) NOT NULL,
    owner character varying(255)
);


ALTER TABLE public.resource_server_policy OWNER TO keycloak;

--
-- Name: resource_server_resource; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.resource_server_resource (
    id character varying(36) NOT NULL,
    name character varying(255) NOT NULL,
    type character varying(255),
    icon_uri character varying(255),
    owner character varying(255) NOT NULL,
    resource_server_id character varying(36) NOT NULL,
    owner_managed_access boolean DEFAULT false NOT NULL,
    display_name character varying(255)
);


ALTER TABLE public.resource_server_resource OWNER TO keycloak;

--
-- Name: resource_server_scope; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.resource_server_scope (
    id character varying(36) NOT NULL,
    name character varying(255) NOT NULL,
    icon_uri character varying(255),
    resource_server_id character varying(36) NOT NULL,
    display_name character varying(255)
);


ALTER TABLE public.resource_server_scope OWNER TO keycloak;

--
-- Name: resource_uris; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.resource_uris (
    resource_id character varying(36) NOT NULL,
    value character varying(255) NOT NULL
);


ALTER TABLE public.resource_uris OWNER TO keycloak;

--
-- Name: revoked_token; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.revoked_token (
    id character varying(255) NOT NULL,
    expire bigint NOT NULL
);


ALTER TABLE public.revoked_token OWNER TO keycloak;

--
-- Name: role_attribute; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.role_attribute (
    id character varying(36) NOT NULL,
    role_id character varying(36) NOT NULL,
    name character varying(255) NOT NULL,
    value character varying(255)
);


ALTER TABLE public.role_attribute OWNER TO keycloak;

--
-- Name: scope_mapping; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.scope_mapping (
    client_id character varying(36) NOT NULL,
    role_id character varying(36) NOT NULL
);


ALTER TABLE public.scope_mapping OWNER TO keycloak;

--
-- Name: scope_policy; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.scope_policy (
    scope_id character varying(36) NOT NULL,
    policy_id character varying(36) NOT NULL
);


ALTER TABLE public.scope_policy OWNER TO keycloak;

--
-- Name: server_config; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.server_config (
    server_config_key character varying(255) NOT NULL,
    value text NOT NULL,
    version integer DEFAULT 0
);


ALTER TABLE public.server_config OWNER TO keycloak;

--
-- Name: user_attribute; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.user_attribute (
    name character varying(255) NOT NULL,
    value character varying(255),
    user_id character varying(36) NOT NULL,
    id character varying(36) DEFAULT 'sybase-needs-something-here'::character varying NOT NULL,
    long_value_hash bytea,
    long_value_hash_lower_case bytea,
    long_value text
);


ALTER TABLE public.user_attribute OWNER TO keycloak;

--
-- Name: user_consent; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.user_consent (
    id character varying(36) NOT NULL,
    client_id character varying(255),
    user_id character varying(36) NOT NULL,
    created_date bigint,
    last_updated_date bigint,
    client_storage_provider character varying(36),
    external_client_id character varying(255)
);


ALTER TABLE public.user_consent OWNER TO keycloak;

--
-- Name: user_consent_client_scope; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.user_consent_client_scope (
    user_consent_id character varying(36) NOT NULL,
    scope_id character varying(36) NOT NULL
);


ALTER TABLE public.user_consent_client_scope OWNER TO keycloak;

--
-- Name: user_entity; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.user_entity (
    id character varying(36) NOT NULL,
    email character varying(255),
    email_constraint character varying(255),
    email_verified boolean DEFAULT false NOT NULL,
    enabled boolean DEFAULT false NOT NULL,
    federation_link character varying(255),
    first_name character varying(255),
    last_name character varying(255),
    realm_id character varying(255),
    username character varying(255),
    created_timestamp bigint,
    service_account_client_link character varying(255),
    not_before integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.user_entity OWNER TO keycloak;

--
-- Name: user_federation_config; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.user_federation_config (
    user_federation_provider_id character varying(36) NOT NULL,
    value character varying(255),
    name character varying(255) NOT NULL
);


ALTER TABLE public.user_federation_config OWNER TO keycloak;

--
-- Name: user_federation_mapper; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.user_federation_mapper (
    id character varying(36) NOT NULL,
    name character varying(255) NOT NULL,
    federation_provider_id character varying(36) NOT NULL,
    federation_mapper_type character varying(255) NOT NULL,
    realm_id character varying(36) NOT NULL
);


ALTER TABLE public.user_federation_mapper OWNER TO keycloak;

--
-- Name: user_federation_mapper_config; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.user_federation_mapper_config (
    user_federation_mapper_id character varying(36) NOT NULL,
    value character varying(255),
    name character varying(255) NOT NULL
);


ALTER TABLE public.user_federation_mapper_config OWNER TO keycloak;

--
-- Name: user_federation_provider; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.user_federation_provider (
    id character varying(36) NOT NULL,
    changed_sync_period integer,
    display_name character varying(255),
    full_sync_period integer,
    last_sync integer,
    priority integer,
    provider_name character varying(255),
    realm_id character varying(36)
);


ALTER TABLE public.user_federation_provider OWNER TO keycloak;

--
-- Name: user_group_membership; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.user_group_membership (
    group_id character varying(36) NOT NULL,
    user_id character varying(36) NOT NULL,
    membership_type character varying(255) NOT NULL
);


ALTER TABLE public.user_group_membership OWNER TO keycloak;

--
-- Name: user_required_action; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.user_required_action (
    user_id character varying(36) NOT NULL,
    required_action character varying(255) DEFAULT ' '::character varying NOT NULL
);


ALTER TABLE public.user_required_action OWNER TO keycloak;

--
-- Name: user_role_mapping; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.user_role_mapping (
    role_id character varying(255) NOT NULL,
    user_id character varying(36) NOT NULL
);


ALTER TABLE public.user_role_mapping OWNER TO keycloak;

--
-- Name: web_origins; Type: TABLE; Schema: public; Owner: keycloak
--

CREATE TABLE public.web_origins (
    client_id character varying(36) NOT NULL,
    value character varying(255) NOT NULL
);


ALTER TABLE public.web_origins OWNER TO keycloak;

--
-- Data for Name: admin_event_entity; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.admin_event_entity (id, admin_event_time, realm_id, operation_type, auth_realm_id, auth_client_id, auth_user_id, ip_address, resource_path, representation, error, resource_type, details_json) FROM stdin;
\.


--
-- Data for Name: associated_policy; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.associated_policy (policy_id, associated_policy_id) FROM stdin;
\.


--
-- Data for Name: authentication_execution; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.authentication_execution (id, alias, authenticator, realm_id, flow_id, requirement, priority, authenticator_flow, auth_flow_id, auth_config) FROM stdin;
8156f2a8-f0dd-4cd8-a151-6bb3af5e1a73	\N	auth-cookie	master	f890fd5b-38c5-4df7-a5d6-b7cbdf410b51	2	10	f	\N	\N
6ef93edb-e47a-452a-873b-ab1b155080dd	\N	auth-spnego	master	f890fd5b-38c5-4df7-a5d6-b7cbdf410b51	3	20	f	\N	\N
33732fdb-a279-47c4-b461-1a4976046e8b	\N	identity-provider-redirector	master	f890fd5b-38c5-4df7-a5d6-b7cbdf410b51	2	25	f	\N	\N
4b71e6ee-ab4b-4841-8fbe-a1d2abe52eb8	\N	\N	master	f890fd5b-38c5-4df7-a5d6-b7cbdf410b51	2	30	t	c59f307c-2f20-4898-862a-a0fb87823bf6	\N
f2430369-db68-491f-b827-bdbbd6600b61	\N	auth-username-password-form	master	c59f307c-2f20-4898-862a-a0fb87823bf6	0	10	f	\N	\N
9fc9323e-de69-4f30-9d9f-7eb5a719260c	\N	direct-grant-validate-username	master	bc5b14ed-460a-43f5-b35a-98d633854427	0	10	f	\N	\N
6ee941f7-e440-4c23-8d75-a6621bd3c602	\N	direct-grant-validate-password	master	bc5b14ed-460a-43f5-b35a-98d633854427	0	20	f	\N	\N
4d936062-b712-4c1e-8128-7748169a0c82	\N	registration-page-form	master	1d54f170-d0c8-407b-b21c-ca2874086817	0	10	t	32b57db2-1325-4785-861a-db5eb2a4655f	\N
1e5de895-d2ca-436f-98a0-a3bec542e988	\N	registration-user-creation	master	32b57db2-1325-4785-861a-db5eb2a4655f	0	20	f	\N	\N
692b1512-d716-486c-bde6-ad55ad4f93ef	\N	registration-password-action	master	32b57db2-1325-4785-861a-db5eb2a4655f	0	50	f	\N	\N
3fb5a025-1b9f-41ec-933d-8fe7de649dbf	\N	registration-recaptcha-action	master	32b57db2-1325-4785-861a-db5eb2a4655f	3	60	f	\N	\N
a7c4cb13-d23b-4b84-8823-b99e12bb9dba	\N	reset-credentials-choose-user	master	d9ac52f8-8409-42d5-b770-c1cf0d36b338	0	10	f	\N	\N
57fcd633-7967-4842-9cfc-72e4047a60d9	\N	reset-credential-email	master	d9ac52f8-8409-42d5-b770-c1cf0d36b338	0	20	f	\N	\N
a51ae2cc-dac4-41c7-bf76-b09d1270a89b	\N	reset-password	master	d9ac52f8-8409-42d5-b770-c1cf0d36b338	0	30	f	\N	\N
58f0c2ef-8607-4566-a3d6-1933287865b3	\N	client-secret	master	cb2a9494-1724-4c24-b5ac-13140c538e62	2	10	f	\N	\N
b5bfd3a6-c75c-48fd-b37c-03e45f796801	\N	client-jwt	master	cb2a9494-1724-4c24-b5ac-13140c538e62	2	20	f	\N	\N
451039db-e792-4e27-a563-78d29add67e7	\N	client-secret-jwt	master	cb2a9494-1724-4c24-b5ac-13140c538e62	2	30	f	\N	\N
78d2b845-9ecf-4c35-8525-3668a078f512	\N	client-x509	master	cb2a9494-1724-4c24-b5ac-13140c538e62	2	40	f	\N	\N
17ef4266-c0ff-44db-9ef3-e46551995cea	\N	idp-review-profile	master	521105ab-005a-463e-8ea9-2641afb0559e	0	10	f	\N	6e31700b-43f0-4d25-8a26-eb3d6f1b21bd
3bf00f93-6352-403c-9768-9c734e4717d0	\N	idp-confirm-link	master	5e240ac3-5bb1-4f61-bf8e-ece2bb87f2f7	0	10	f	\N	\N
b04dab95-5789-4dae-bc55-4ea5f93c839c	\N	idp-username-password-form	master	3849c100-eec6-47d9-97ca-07248351afdf	0	10	f	\N	\N
35e1068e-0c2f-400f-b377-8dd8736bf34f	\N	http-basic-authenticator	master	58fbd6ea-f1c8-48f7-a5ee-89a87d967288	0	10	f	\N	\N
8f6e488b-6e88-41f9-ad79-d23e23bf85be	\N	docker-http-basic-authenticator	master	9e65b1a4-1145-4b54-9ab1-e2b0ebb342f2	0	10	f	\N	\N
3b0aa26f-4795-4655-bf75-f12546e7c3c2	\N	idp-confirm-link	cmem	b76b9855-1854-4e79-b98a-6531cbf6a9bb	0	10	f	\N	\N
7553aa84-0a03-4640-b57d-9ad623584d0b	\N	idp-username-password-form	cmem	04a0b8ce-562b-4c6b-8e0a-5e891d896c5f	0	10	f	\N	\N
767282c3-bb5d-4df3-be61-4e52ae4d419a	\N	auth-cookie	cmem	33f564f5-744b-470d-b68d-ad5bf265138c	2	10	f	\N	\N
d3e5e3ec-da4f-40a6-9720-d9d8e5294580	\N	auth-spnego	cmem	33f564f5-744b-470d-b68d-ad5bf265138c	3	20	f	\N	\N
ca87b022-ddc8-4f2a-acd7-33a569499b24	\N	identity-provider-redirector	cmem	33f564f5-744b-470d-b68d-ad5bf265138c	2	25	f	\N	\N
4da724da-f6ab-4ad7-9467-7858c39e2d06	\N	\N	cmem	33f564f5-744b-470d-b68d-ad5bf265138c	2	30	t	0e781562-fe73-4aff-8c5d-b4304377e666	\N
6a7e787b-03ad-4a50-8a0b-7e6c51479c4b	\N	client-secret	cmem	c4efad04-66ca-4729-a116-26d0d144d136	2	10	f	\N	\N
6c29e5c0-5302-4cd1-a453-b5fb15741d0b	\N	client-jwt	cmem	c4efad04-66ca-4729-a116-26d0d144d136	2	20	f	\N	\N
1ddc638e-cb20-4ee2-b643-63dddadb630c	\N	client-secret-jwt	cmem	c4efad04-66ca-4729-a116-26d0d144d136	2	30	f	\N	\N
949d8894-c66d-4fc7-a371-f129b82c327f	\N	client-x509	cmem	c4efad04-66ca-4729-a116-26d0d144d136	2	40	f	\N	\N
73059566-7333-4ec2-9d53-dbea7b1c589f	\N	direct-grant-validate-username	cmem	5483b483-e820-4638-adeb-7218483f6303	0	10	f	\N	\N
4a309cc8-afce-41de-a3d0-d5269ed3eb05	\N	direct-grant-validate-password	cmem	5483b483-e820-4638-adeb-7218483f6303	0	20	f	\N	\N
023d036d-3c9b-4932-84e0-bd6c273fb786	\N	docker-http-basic-authenticator	cmem	b0ef60b5-bc51-41c1-b22a-cbc35e9b276d	0	10	f	\N	\N
928ff0ca-61c2-4f09-a898-e50e5f55cd88	\N	idp-review-profile	cmem	922ee2f8-c90e-4696-a38e-96850189298b	0	10	f	\N	eb52b5ba-e220-4b7a-b736-a6445eff3525
7752b607-c6be-4a81-bb40-a493bf0784bd	\N	auth-username-password-form	cmem	0e781562-fe73-4aff-8c5d-b4304377e666	0	10	f	\N	\N
91947ed0-7d4d-47c8-ba74-fdfd8bb09502	\N	registration-page-form	cmem	14c43aaa-6e87-45d6-bcec-0d089c948af1	0	10	t	3b83d9df-c009-4a34-91bc-87caa4a61b26	\N
8ec6eb15-c27f-4ad7-817f-6c4ce296a1c4	\N	registration-user-creation	cmem	3b83d9df-c009-4a34-91bc-87caa4a61b26	0	20	f	\N	\N
2ffbbe2b-ae67-41a2-ae1d-ed47207ece53	\N	registration-password-action	cmem	3b83d9df-c009-4a34-91bc-87caa4a61b26	0	50	f	\N	\N
7e8fd3a8-2289-4c03-99d4-65f4992b1161	\N	registration-recaptcha-action	cmem	3b83d9df-c009-4a34-91bc-87caa4a61b26	3	60	f	\N	\N
c9e25189-6084-4492-9b99-09caab05fd81	\N	reset-credentials-choose-user	cmem	d17934b3-018e-452a-8602-69f579abd0a8	0	10	f	\N	\N
35502f50-e378-41bc-ac19-5085010cc384	\N	reset-credential-email	cmem	d17934b3-018e-452a-8602-69f579abd0a8	0	20	f	\N	\N
99e43e57-e9e8-4ba7-993d-399c5c4a7fc9	\N	reset-password	cmem	d17934b3-018e-452a-8602-69f579abd0a8	0	30	f	\N	\N
1537828e-35b5-41f7-8fad-f91a77956454	\N	http-basic-authenticator	cmem	6746412d-c6a8-4bf9-9978-58f114fd3b62	0	10	f	\N	\N
7aed6d5c-6e1a-432d-ba56-98291c8106a9	\N	\N	master	c59f307c-2f20-4898-862a-a0fb87823bf6	1	20	t	1b5a76e5-e669-411b-9c4c-588c502e7dae	\N
66c448c0-b53b-487c-ba3f-8f9a9df2a2b1	\N	conditional-user-configured	master	1b5a76e5-e669-411b-9c4c-588c502e7dae	0	10	f	\N	\N
ae84e0bc-5612-4dc5-95d9-99aa2a9a2a7a	\N	auth-otp-form	master	1b5a76e5-e669-411b-9c4c-588c502e7dae	0	20	f	\N	\N
ccbe0068-c3c5-4c91-a739-9c8ebad487d8	\N	\N	master	bc5b14ed-460a-43f5-b35a-98d633854427	1	30	t	8e0f602b-dbc0-49e6-9811-b2661085b648	\N
2a14936e-7d64-43f2-8c97-dfe9a0418cce	\N	conditional-user-configured	master	8e0f602b-dbc0-49e6-9811-b2661085b648	0	10	f	\N	\N
e1cfe8d8-1142-4977-ba33-bcc89d3e9490	\N	direct-grant-validate-otp	master	8e0f602b-dbc0-49e6-9811-b2661085b648	0	20	f	\N	\N
ff29d665-af41-49b2-bd40-7e98cd59c011	\N	\N	master	d9ac52f8-8409-42d5-b770-c1cf0d36b338	1	40	t	4ba7b1f5-e6e2-4034-8e23-90133f10540a	\N
7d7aa2b5-47a0-4e63-ad79-778da84304f6	\N	conditional-user-configured	master	4ba7b1f5-e6e2-4034-8e23-90133f10540a	0	10	f	\N	\N
ea7bb819-0613-456b-b357-b9a1d88a45b7	\N	reset-otp	master	4ba7b1f5-e6e2-4034-8e23-90133f10540a	0	20	f	\N	\N
f81e9cd7-be10-44cf-a351-809501a2dce5	\N	\N	master	3849c100-eec6-47d9-97ca-07248351afdf	1	20	t	c18612a8-f86c-4ac1-9c62-e458d796048d	\N
0553f508-3373-4298-9a54-4696068bda8e	\N	conditional-user-configured	master	c18612a8-f86c-4ac1-9c62-e458d796048d	0	10	f	\N	\N
331541da-0015-4c02-9dbf-f67357437966	\N	auth-otp-form	master	c18612a8-f86c-4ac1-9c62-e458d796048d	0	20	f	\N	\N
6b3f3b2e-f07a-4e17-89d2-8c4d6a4e2947	\N	\N	cmem	04a0b8ce-562b-4c6b-8e0a-5e891d896c5f	1	20	t	895dc00c-ad06-4b83-bbd7-d19ba33ab8f9	\N
3e1519ae-b8ee-4e86-93fe-a603e1841c41	\N	conditional-user-configured	cmem	895dc00c-ad06-4b83-bbd7-d19ba33ab8f9	0	10	f	\N	\N
06ddba9e-6732-4d50-8113-581a042a95a1	\N	auth-otp-form	cmem	895dc00c-ad06-4b83-bbd7-d19ba33ab8f9	0	20	f	\N	\N
033d628d-7494-4ff0-857a-03e4b5df334c	\N	\N	cmem	5483b483-e820-4638-adeb-7218483f6303	1	30	t	3a92de2a-913d-4fc9-aca1-b31aab28eb97	\N
93ddf33e-57f1-4d4b-9f48-ef0906efa599	\N	conditional-user-configured	cmem	3a92de2a-913d-4fc9-aca1-b31aab28eb97	0	10	f	\N	\N
5f6aacd1-cd87-48a1-9e53-aa8c16c5573e	\N	direct-grant-validate-otp	cmem	3a92de2a-913d-4fc9-aca1-b31aab28eb97	0	20	f	\N	\N
d0a2fab3-05e3-4f33-9430-7ae6fb348a7b	\N	\N	cmem	0e781562-fe73-4aff-8c5d-b4304377e666	1	20	t	eadcd47a-7c63-4686-8a2f-c8e859fb4137	\N
80693a30-2319-4458-b000-7713a4499b8a	\N	conditional-user-configured	cmem	eadcd47a-7c63-4686-8a2f-c8e859fb4137	0	10	f	\N	\N
f3d78f65-7c33-4217-84fd-f0b66bcca7ac	\N	auth-otp-form	cmem	eadcd47a-7c63-4686-8a2f-c8e859fb4137	0	20	f	\N	\N
c2381bf3-d7c7-4fb5-a596-60272db3cec1	\N	\N	cmem	d17934b3-018e-452a-8602-69f579abd0a8	1	40	t	8abc7cd9-65d8-4b1e-9d0c-1f0a4755f15c	\N
5e3edac2-4325-46a6-b058-75c8b09000ac	\N	conditional-user-configured	cmem	8abc7cd9-65d8-4b1e-9d0c-1f0a4755f15c	0	10	f	\N	\N
bd094261-d120-43af-856d-1c4aac292553	\N	reset-otp	cmem	8abc7cd9-65d8-4b1e-9d0c-1f0a4755f15c	0	20	f	\N	\N
9bc80f07-8a46-47d1-9dad-34a4ab5f7905	\N	\N	master	521105ab-005a-463e-8ea9-2641afb0559e	0	20	t	e511223b-c6ed-45f4-980c-22036d84a0eb	\N
4ac0df51-d421-481c-97fe-5770046d4e59	\N	idp-create-user-if-unique	master	e511223b-c6ed-45f4-980c-22036d84a0eb	2	10	f	\N	459bfb64-1dd2-44fd-b31d-8d9bc3ab311d
7d3d406c-fde5-4637-bdd8-88151b6b46a2	\N	\N	master	e511223b-c6ed-45f4-980c-22036d84a0eb	2	20	t	5e240ac3-5bb1-4f61-bf8e-ece2bb87f2f7	\N
b4e0bd87-185e-4b49-a475-3e3d21b63dff	\N	\N	master	5e240ac3-5bb1-4f61-bf8e-ece2bb87f2f7	0	20	t	46efd823-585a-4637-b984-e069c5e24ea1	\N
ac189ee0-3998-4d8f-a6f4-711e83bbcbe4	\N	idp-email-verification	master	46efd823-585a-4637-b984-e069c5e24ea1	2	10	f	\N	\N
afaf54ea-cc22-473c-96c4-a830c16bfdda	\N	\N	master	46efd823-585a-4637-b984-e069c5e24ea1	2	20	t	3849c100-eec6-47d9-97ca-07248351afdf	\N
d94845c5-30c1-4c34-8986-f55ae275ffa2	\N	\N	cmem	b76b9855-1854-4e79-b98a-6531cbf6a9bb	0	20	t	6bf7cbf2-fd11-4355-ab75-c0b9b3b34223	\N
2706a436-bd57-4eac-b624-d00c7db189d1	\N	idp-email-verification	cmem	6bf7cbf2-fd11-4355-ab75-c0b9b3b34223	2	10	f	\N	\N
5b61122e-de69-40dc-b1e6-5e77fbfebed4	\N	\N	cmem	6bf7cbf2-fd11-4355-ab75-c0b9b3b34223	2	20	t	04a0b8ce-562b-4c6b-8e0a-5e891d896c5f	\N
52cee8cd-028f-46fb-aee8-9a400a14c350	\N	\N	cmem	922ee2f8-c90e-4696-a38e-96850189298b	0	20	t	a1d79f5c-0afa-4821-b8a2-a993a9ae0a51	\N
69995b84-d8b0-405e-b787-9c5f13f78b5f	\N	idp-create-user-if-unique	cmem	a1d79f5c-0afa-4821-b8a2-a993a9ae0a51	2	10	f	\N	b58881df-a2b5-49a3-8553-c0c716dea20c
ad67236f-de03-4f18-8af2-7400eb7b46ba	\N	\N	cmem	a1d79f5c-0afa-4821-b8a2-a993a9ae0a51	2	20	t	b76b9855-1854-4e79-b98a-6531cbf6a9bb	\N
\.


--
-- Data for Name: authentication_flow; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.authentication_flow (id, alias, description, realm_id, provider_id, top_level, built_in) FROM stdin;
f890fd5b-38c5-4df7-a5d6-b7cbdf410b51	browser	browser based authentication	master	basic-flow	t	t
c59f307c-2f20-4898-862a-a0fb87823bf6	forms	Username, password, otp and other auth forms.	master	basic-flow	f	t
bc5b14ed-460a-43f5-b35a-98d633854427	direct grant	OpenID Connect Resource Owner Grant	master	basic-flow	t	t
1d54f170-d0c8-407b-b21c-ca2874086817	registration	registration flow	master	basic-flow	t	t
32b57db2-1325-4785-861a-db5eb2a4655f	registration form	registration form	master	form-flow	f	t
d9ac52f8-8409-42d5-b770-c1cf0d36b338	reset credentials	Reset credentials for a user if they forgot their password or something	master	basic-flow	t	t
cb2a9494-1724-4c24-b5ac-13140c538e62	clients	Base authentication for clients	master	client-flow	t	t
521105ab-005a-463e-8ea9-2641afb0559e	first broker login	Actions taken after first broker login with identity provider account, which is not yet linked to any Keycloak account	master	basic-flow	t	t
5e240ac3-5bb1-4f61-bf8e-ece2bb87f2f7	Handle Existing Account	Handle what to do if there is existing account with same email/username like authenticated identity provider	master	basic-flow	f	t
3849c100-eec6-47d9-97ca-07248351afdf	Verify Existing Account by Re-authentication	Reauthentication of existing account	master	basic-flow	f	t
58fbd6ea-f1c8-48f7-a5ee-89a87d967288	saml ecp	SAML ECP Profile Authentication Flow	master	basic-flow	t	t
9e65b1a4-1145-4b54-9ab1-e2b0ebb342f2	docker auth	Used by Docker clients to authenticate against the IDP	master	basic-flow	t	t
b76b9855-1854-4e79-b98a-6531cbf6a9bb	Handle Existing Account	Handle what to do if there is existing account with same email/username like authenticated identity provider	cmem	basic-flow	f	t
04a0b8ce-562b-4c6b-8e0a-5e891d896c5f	Verify Existing Account by Re-authentication	Reauthentication of existing account	cmem	basic-flow	f	t
33f564f5-744b-470d-b68d-ad5bf265138c	browser	browser based authentication	cmem	basic-flow	t	t
c4efad04-66ca-4729-a116-26d0d144d136	clients	Base authentication for clients	cmem	client-flow	t	t
5483b483-e820-4638-adeb-7218483f6303	direct grant	OpenID Connect Resource Owner Grant	cmem	basic-flow	t	t
b0ef60b5-bc51-41c1-b22a-cbc35e9b276d	docker auth	Used by Docker clients to authenticate against the IDP	cmem	basic-flow	t	t
922ee2f8-c90e-4696-a38e-96850189298b	first broker login	Actions taken after first broker login with identity provider account, which is not yet linked to any Keycloak account	cmem	basic-flow	t	t
0e781562-fe73-4aff-8c5d-b4304377e666	forms	Username, password, otp and other auth forms.	cmem	basic-flow	f	t
14c43aaa-6e87-45d6-bcec-0d089c948af1	registration	registration flow	cmem	basic-flow	t	t
3b83d9df-c009-4a34-91bc-87caa4a61b26	registration form	registration form	cmem	form-flow	f	t
d17934b3-018e-452a-8602-69f579abd0a8	reset credentials	Reset credentials for a user if they forgot their password or something	cmem	basic-flow	t	t
6746412d-c6a8-4bf9-9978-58f114fd3b62	saml ecp	SAML ECP Profile Authentication Flow	cmem	basic-flow	t	t
1b5a76e5-e669-411b-9c4c-588c502e7dae	forms - auth-otp-form - Conditional	Flow to determine if the auth-otp-form authenticator should be used or not.	master	basic-flow	f	t
8e0f602b-dbc0-49e6-9811-b2661085b648	direct grant - direct-grant-validate-otp - Conditional	Flow to determine if the direct-grant-validate-otp authenticator should be used or not.	master	basic-flow	f	t
4ba7b1f5-e6e2-4034-8e23-90133f10540a	reset credentials - reset-otp - Conditional	Flow to determine if the reset-otp authenticator should be used or not.	master	basic-flow	f	t
c18612a8-f86c-4ac1-9c62-e458d796048d	Verify Existing Account by Re-authentication - auth-otp-form - Conditional	Flow to determine if the auth-otp-form authenticator should be used or not.	master	basic-flow	f	t
895dc00c-ad06-4b83-bbd7-d19ba33ab8f9	Verify Existing Account by Re-authentication - auth-otp-form - Conditional	Flow to determine if the auth-otp-form authenticator should be used or not.	cmem	basic-flow	f	t
3a92de2a-913d-4fc9-aca1-b31aab28eb97	direct grant - direct-grant-validate-otp - Conditional	Flow to determine if the direct-grant-validate-otp authenticator should be used or not.	cmem	basic-flow	f	t
eadcd47a-7c63-4686-8a2f-c8e859fb4137	forms - auth-otp-form - Conditional	Flow to determine if the auth-otp-form authenticator should be used or not.	cmem	basic-flow	f	t
8abc7cd9-65d8-4b1e-9d0c-1f0a4755f15c	reset credentials - reset-otp - Conditional	Flow to determine if the reset-otp authenticator should be used or not.	cmem	basic-flow	f	t
e511223b-c6ed-45f4-980c-22036d84a0eb	first broker login - Alternatives - 0	Subflow of first broker login with alternative executions	master	basic-flow	f	t
46efd823-585a-4637-b984-e069c5e24ea1	Handle Existing Account - Alternatives - 0	Subflow of Handle Existing Account with alternative executions	master	basic-flow	f	t
6bf7cbf2-fd11-4355-ab75-c0b9b3b34223	Handle Existing Account - Alternatives - 0	Subflow of Handle Existing Account with alternative executions	cmem	basic-flow	f	t
a1d79f5c-0afa-4821-b8a2-a993a9ae0a51	first broker login - Alternatives - 0	Subflow of first broker login with alternative executions	cmem	basic-flow	f	t
\.


--
-- Data for Name: authenticator_config; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.authenticator_config (id, alias, realm_id) FROM stdin;
6e31700b-43f0-4d25-8a26-eb3d6f1b21bd	review profile config	master
459bfb64-1dd2-44fd-b31d-8d9bc3ab311d	create unique user config	master
b58881df-a2b5-49a3-8553-c0c716dea20c	create unique user config	cmem
eb52b5ba-e220-4b7a-b736-a6445eff3525	review profile config	cmem
\.


--
-- Data for Name: authenticator_config_entry; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.authenticator_config_entry (authenticator_id, value, name) FROM stdin;
6e31700b-43f0-4d25-8a26-eb3d6f1b21bd	missing	update.profile.on.first.login
459bfb64-1dd2-44fd-b31d-8d9bc3ab311d	false	require.password.update.after.registration
b58881df-a2b5-49a3-8553-c0c716dea20c	false	require.password.update.after.registration
eb52b5ba-e220-4b7a-b736-a6445eff3525	missing	update.profile.on.first.login
\.


--
-- Data for Name: broker_link; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.broker_link (identity_provider, storage_provider_id, realm_id, broker_user_id, broker_username, token, user_id) FROM stdin;
\.


--
-- Data for Name: client; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.client (id, enabled, full_scope_allowed, client_id, not_before, public_client, secret, base_url, bearer_only, management_url, surrogate_auth_required, realm_id, protocol, node_rereg_timeout, frontchannel_logout, consent_required, name, service_accounts_enabled, client_authenticator_type, root_url, description, registration_token, standard_flow_enabled, implicit_flow_enabled, direct_access_grants_enabled, always_display_in_console) FROM stdin;
360b5c9e-6960-451f-b5d4-9eaae2dacdda	t	t	master-realm	0	f	1f68d7e5-bdc6-43e1-8b73-d0b24398f420	\N	t	\N	f	master	\N	0	f	f	master Realm	f	client-secret	\N	\N	\N	t	f	f	f
23cd6fb4-696a-41d2-b04f-037e548db556	t	f	broker	0	f	786cd74d-7dd9-4167-974d-f39b963bbca1	\N	f	\N	f	master	openid-connect	0	f	f	${client_broker}	f	client-secret	\N	\N	\N	t	f	f	f
688ef36e-12f7-462a-bf89-cceec001558f	t	t	cmem-realm	0	f	8a537ea7-b3ac-4d1a-9375-cd514cf1ce90	\N	t	\N	f	master	\N	0	f	f	cmem Realm	f	client-secret	\N	\N	\N	t	f	f	f
ace265c3-5eff-4002-898f-3f1cc8b3c30f	t	t	cmemc	0	t	0ae117c9-983d-4a80-8293-544535d185b3	\N	f	\N	f	cmem	openid-connect	-1	f	f	eccenca Corporate Memory Control	f	client-secret	\N	cmemc is the eccenca Command Line Interface as described in https://eccenca.com/go/cmemc	\N	f	f	t	f
75ba9e57-8bd3-4560-af7b-8d8bc74cae0d	t	f	account	0	f	297b751e-6c90-4d1f-b160-49508296e144	/realms/master/account/	f	\N	f	master	openid-connect	0	f	f	${client_account}	f	client-secret	${authBaseUrl}	\N	\N	t	f	f	f
3aa98620-e55f-4c26-af5a-37e7d694964e	t	f	account-console	0	t	fe932ac3-263d-431b-93fa-3c5368a50a9e	/realms/master/account/	f	\N	f	master	openid-connect	0	f	f	${client_account-console}	f	client-secret	${authBaseUrl}	\N	\N	t	f	f	f
f5473ca3-5293-4d61-b46c-422cf2664546	f	t	power-bi	0	t	\N		f		f	cmem	openid-connect	-1	f	f	eccenca Power BI Connector	f	client-secret		eccenca Corporate Memory Power BI Connector as described at https://eccenca.com/go/power-bi-connector	\N	f	f	t	f
35c8443a-bcd5-40da-b3b7-805c6dc6bc5a	t	t	cmem	0	t	\N		f		f	cmem	openid-connect	-1	f	f	Corporate Memory	f	client-secret		A general client allowing login from DM DP DI	\N	t	f	f	f
6338d0ff-f06e-4987-af63-197be726c44c	t	f	account	0	t	\N	/realms/cmem/account/	f		f	cmem	openid-connect	0	f	f	${client_account}	f	client-secret	${authBaseUrl}	Used by the keycloak account settings user interface.	\N	t	t	f	f
5748140e-1c07-4a3d-9302-26cb6208dd5d	t	f	account-console	0	t	\N	/realms/cmem/account/	f		f	cmem	openid-connect	0	f	f	${client_account-console}	f	client-secret	${authBaseUrl}		\N	t	f	f	f
eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	f	f	realm-management	0	f	\N	\N	t		f	cmem	openid-connect	0	f	f	${client_realm-management}	f	client-secret	\N		\N	t	f	f	f
dd485b6a-ee8f-47a8-b459-cc65a10f8cc0	f	f	broker	0	t	\N		f		f	cmem	openid-connect	0	f	f	${client_broker}	f	client-secret		Enable in case you want to use Identity Providers.	\N	t	f	f	f
e9ab4ab5-754b-4f19-9d50-232bdf8cb322	t	t	cmem-service-account	0	f	c8c12828-000c-467b-9b6d-2d6b5e16df4a		f		f	cmem	openid-connect	-1	f	f	CMEM service account	t	client-secret		Generic machine user to automate Corporate Memory activities with cmemc.	\N	f	f	f	f
110e1f10-2989-4463-8f9b-f8f50d4b7ab4	t	t	security-admin-console	0	t	efa32988-c490-4201-8b3d-41cbc2fc4d07	/admin/master/console/	f	\N	f	master	openid-connect	0	f	f	${client_security-admin-console}	f	client-secret	${authAdminUrl}	\N	\N	t	f	f	f
ba918616-f25d-4a37-9594-18f20f731fdc	t	t	admin-cli	0	t	41eebcf2-093c-4fd5-a6f6-e5ecec9ebeb6	\N	f	\N	f	master	openid-connect	0	f	f	${client_admin-cli}	f	client-secret	\N	\N	\N	f	f	t	f
d8c9cb3a-59eb-440a-9cb5-d8870bd8f180	f	t	security-admin-console	0	t	\N	/admin/cmem/console/	f		f	cmem	openid-connect	0	f	f	${client_security-admin-console}	f	client-secret	${authAdminUrl}	Enable this client in case you want to allow a login to the keycloak admin UI for this realm.	\N	t	f	f	f
5e55f24c-2b31-4540-b833-d65755f887d5	f	t	admin-cli	0	t	\N		f		f	cmem	openid-connect	0	f	f	${client_admin-cli}	f	client-secret			\N	f	f	t	f
3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	t	t	graph-insights-service-account	0	f	7Ctw7eZvTeFYdwwvwopy8OjuMUVPb8A9		f		f	cmem	openid-connect	-1	f	f	graph-insights service account	t	client-secret		Generic machine user to connect Corporate Memory activities with graph-insights.	\N	f	f	f	f
8fae8698-811f-4da1-b479-dbcce9ac9de5	t	t	graph-insights	0	t	\N		f		f	cmem	openid-connect	-1	f	f	Graph Insights	f	client-secret		A general client allowing login from Graph Insights	\N	t	f	f	f
\.


--
-- Data for Name: client_attributes; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.client_attributes (client_id, name, value) FROM stdin;
ace265c3-5eff-4002-898f-3f1cc8b3c30f	saml.server.signature	false
ace265c3-5eff-4002-898f-3f1cc8b3c30f	saml.server.signature.keyinfo.ext	false
ace265c3-5eff-4002-898f-3f1cc8b3c30f	saml.assertion.signature	false
ace265c3-5eff-4002-898f-3f1cc8b3c30f	saml.client.signature	false
ace265c3-5eff-4002-898f-3f1cc8b3c30f	saml.encrypt	false
ace265c3-5eff-4002-898f-3f1cc8b3c30f	saml.authnstatement	false
ace265c3-5eff-4002-898f-3f1cc8b3c30f	saml.onetimeuse.condition	false
ace265c3-5eff-4002-898f-3f1cc8b3c30f	saml_force_name_id_format	false
ace265c3-5eff-4002-898f-3f1cc8b3c30f	saml.multivalued.roles	false
ace265c3-5eff-4002-898f-3f1cc8b3c30f	saml.force.post.binding	false
ace265c3-5eff-4002-898f-3f1cc8b3c30f	exclude.session.state.from.auth.response	false
ace265c3-5eff-4002-898f-3f1cc8b3c30f	tls.client.certificate.bound.access.tokens	false
ace265c3-5eff-4002-898f-3f1cc8b3c30f	display.on.consent.screen	false
110e1f10-2989-4463-8f9b-f8f50d4b7ab4	pkce.code.challenge.method	S256
3aa98620-e55f-4c26-af5a-37e7d694964e	pkce.code.challenge.method	S256
75ba9e57-8bd3-4560-af7b-8d8bc74cae0d	post.logout.redirect.uris	+
3aa98620-e55f-4c26-af5a-37e7d694964e	post.logout.redirect.uris	+
110e1f10-2989-4463-8f9b-f8f50d4b7ab4	post.logout.redirect.uris	+
f5473ca3-5293-4d61-b46c-422cf2664546	display.on.consent.screen	false
f5473ca3-5293-4d61-b46c-422cf2664546	exclude.session.state.from.auth.response	false
f5473ca3-5293-4d61-b46c-422cf2664546	saml.assertion.signature	false
f5473ca3-5293-4d61-b46c-422cf2664546	saml.authnstatement	false
f5473ca3-5293-4d61-b46c-422cf2664546	saml.client.signature	false
f5473ca3-5293-4d61-b46c-422cf2664546	saml.encrypt	false
f5473ca3-5293-4d61-b46c-422cf2664546	saml.force.post.binding	false
f5473ca3-5293-4d61-b46c-422cf2664546	saml.multivalued.roles	false
f5473ca3-5293-4d61-b46c-422cf2664546	saml.onetimeuse.condition	false
f5473ca3-5293-4d61-b46c-422cf2664546	saml.server.signature	false
f5473ca3-5293-4d61-b46c-422cf2664546	saml.server.signature.keyinfo.ext	false
f5473ca3-5293-4d61-b46c-422cf2664546	saml_force_name_id_format	false
f5473ca3-5293-4d61-b46c-422cf2664546	tls.client.certificate.bound.access.tokens	false
35c8443a-bcd5-40da-b3b7-805c6dc6bc5a	acr.loa.map	{}
35c8443a-bcd5-40da-b3b7-805c6dc6bc5a	backchannel.logout.revoke.offline.tokens	false
35c8443a-bcd5-40da-b3b7-805c6dc6bc5a	client_credentials.use_refresh_token	false
35c8443a-bcd5-40da-b3b7-805c6dc6bc5a	display.on.consent.screen	false
35c8443a-bcd5-40da-b3b7-805c6dc6bc5a	oauth2.device.authorization.grant.enabled	false
35c8443a-bcd5-40da-b3b7-805c6dc6bc5a	oidc.ciba.grant.enabled	false
35c8443a-bcd5-40da-b3b7-805c6dc6bc5a	post.logout.redirect.uris	+
35c8443a-bcd5-40da-b3b7-805c6dc6bc5a	require.pushed.authorization.requests	false
35c8443a-bcd5-40da-b3b7-805c6dc6bc5a	tls-client-certificate-bound-access-tokens	false
35c8443a-bcd5-40da-b3b7-805c6dc6bc5a	token.response.type.bearer.lower-case	false
35c8443a-bcd5-40da-b3b7-805c6dc6bc5a	use.refresh.tokens	true
f5473ca3-5293-4d61-b46c-422cf2664546	post.logout.redirect.uris	+
5748140e-1c07-4a3d-9302-26cb6208dd5d	pkce.code.challenge.method	S256
5748140e-1c07-4a3d-9302-26cb6208dd5d	post.logout.redirect.uris	+
f5473ca3-5293-4d61-b46c-422cf2664546	oauth2.device.authorization.grant.enabled	false
f5473ca3-5293-4d61-b46c-422cf2664546	oidc.ciba.grant.enabled	false
f5473ca3-5293-4d61-b46c-422cf2664546	backchannel.logout.session.required	true
f5473ca3-5293-4d61-b46c-422cf2664546	backchannel.logout.revoke.offline.tokens	false
6338d0ff-f06e-4987-af63-197be726c44c	acr.loa.map	{}
6338d0ff-f06e-4987-af63-197be726c44c	backchannel.logout.revoke.offline.tokens	false
6338d0ff-f06e-4987-af63-197be726c44c	backchannel.logout.session.required	true
6338d0ff-f06e-4987-af63-197be726c44c	client_credentials.use_refresh_token	false
6338d0ff-f06e-4987-af63-197be726c44c	display.on.consent.screen	false
6338d0ff-f06e-4987-af63-197be726c44c	oauth2.device.authorization.grant.enabled	false
6338d0ff-f06e-4987-af63-197be726c44c	oidc.ciba.grant.enabled	false
6338d0ff-f06e-4987-af63-197be726c44c	post.logout.redirect.uris	+
dd485b6a-ee8f-47a8-b459-cc65a10f8cc0	backchannel.logout.revoke.offline.tokens	false
dd485b6a-ee8f-47a8-b459-cc65a10f8cc0	backchannel.logout.session.required	true
e9ab4ab5-754b-4f19-9d50-232bdf8cb322	display.on.consent.screen	false
e9ab4ab5-754b-4f19-9d50-232bdf8cb322	exclude.session.state.from.auth.response	false
e9ab4ab5-754b-4f19-9d50-232bdf8cb322	post.logout.redirect.uris	+
e9ab4ab5-754b-4f19-9d50-232bdf8cb322	saml.assertion.signature	false
e9ab4ab5-754b-4f19-9d50-232bdf8cb322	saml.authnstatement	false
6338d0ff-f06e-4987-af63-197be726c44c	require.pushed.authorization.requests	false
6338d0ff-f06e-4987-af63-197be726c44c	tls-client-certificate-bound-access-tokens	false
6338d0ff-f06e-4987-af63-197be726c44c	token.response.type.bearer.lower-case	false
6338d0ff-f06e-4987-af63-197be726c44c	use.refresh.tokens	true
5748140e-1c07-4a3d-9302-26cb6208dd5d	backchannel.logout.revoke.offline.tokens	false
5748140e-1c07-4a3d-9302-26cb6208dd5d	backchannel.logout.session.required	true
5748140e-1c07-4a3d-9302-26cb6208dd5d	display.on.consent.screen	false
5748140e-1c07-4a3d-9302-26cb6208dd5d	oauth2.device.authorization.grant.enabled	false
5748140e-1c07-4a3d-9302-26cb6208dd5d	oidc.ciba.grant.enabled	false
d8c9cb3a-59eb-440a-9cb5-d8870bd8f180	backchannel.logout.revoke.offline.tokens	false
d8c9cb3a-59eb-440a-9cb5-d8870bd8f180	backchannel.logout.session.required	true
d8c9cb3a-59eb-440a-9cb5-d8870bd8f180	display.on.consent.screen	false
d8c9cb3a-59eb-440a-9cb5-d8870bd8f180	oauth2.device.authorization.grant.enabled	false
d8c9cb3a-59eb-440a-9cb5-d8870bd8f180	oidc.ciba.grant.enabled	false
d8c9cb3a-59eb-440a-9cb5-d8870bd8f180	pkce.code.challenge.method	S256
d8c9cb3a-59eb-440a-9cb5-d8870bd8f180	post.logout.redirect.uris	+
dd485b6a-ee8f-47a8-b459-cc65a10f8cc0	display.on.consent.screen	false
dd485b6a-ee8f-47a8-b459-cc65a10f8cc0	oauth2.device.authorization.grant.enabled	false
dd485b6a-ee8f-47a8-b459-cc65a10f8cc0	oidc.ciba.grant.enabled	false
5e55f24c-2b31-4540-b833-d65755f887d5	backchannel.logout.revoke.offline.tokens	false
5e55f24c-2b31-4540-b833-d65755f887d5	backchannel.logout.session.required	true
5e55f24c-2b31-4540-b833-d65755f887d5	display.on.consent.screen	false
5e55f24c-2b31-4540-b833-d65755f887d5	oauth2.device.authorization.grant.enabled	false
5e55f24c-2b31-4540-b833-d65755f887d5	oidc.ciba.grant.enabled	false
e9ab4ab5-754b-4f19-9d50-232bdf8cb322	oauth2.device.authorization.grant.enabled	false
e9ab4ab5-754b-4f19-9d50-232bdf8cb322	oidc.ciba.grant.enabled	false
e9ab4ab5-754b-4f19-9d50-232bdf8cb322	backchannel.logout.session.required	true
e9ab4ab5-754b-4f19-9d50-232bdf8cb322	backchannel.logout.revoke.offline.tokens	false
e9ab4ab5-754b-4f19-9d50-232bdf8cb322	saml.client.signature	false
e9ab4ab5-754b-4f19-9d50-232bdf8cb322	saml.encrypt	false
e9ab4ab5-754b-4f19-9d50-232bdf8cb322	saml.force.post.binding	false
e9ab4ab5-754b-4f19-9d50-232bdf8cb322	saml.multivalued.roles	false
e9ab4ab5-754b-4f19-9d50-232bdf8cb322	saml.onetimeuse.condition	false
e9ab4ab5-754b-4f19-9d50-232bdf8cb322	saml.server.signature	false
e9ab4ab5-754b-4f19-9d50-232bdf8cb322	saml.server.signature.keyinfo.ext	false
e9ab4ab5-754b-4f19-9d50-232bdf8cb322	saml_force_name_id_format	false
e9ab4ab5-754b-4f19-9d50-232bdf8cb322	tls.client.certificate.bound.access.tokens	false
110e1f10-2989-4463-8f9b-f8f50d4b7ab4	client.use.lightweight.access.token.enabled	true
ba918616-f25d-4a37-9594-18f20f731fdc	client.use.lightweight.access.token.enabled	true
d8c9cb3a-59eb-440a-9cb5-d8870bd8f180	client.use.lightweight.access.token.enabled	true
5e55f24c-2b31-4540-b833-d65755f887d5	client.use.lightweight.access.token.enabled	true
3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	saml.assertion.signature	false
3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	saml.force.post.binding	false
3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	saml.multivalued.roles	false
3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	saml.encrypt	false
3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	post.logout.redirect.uris	+
3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	oauth2.device.authorization.grant.enabled	false
3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	backchannel.logout.revoke.offline.tokens	false
3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	saml.server.signature	false
3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	saml.server.signature.keyinfo.ext	false
3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	exclude.session.state.from.auth.response	false
3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	realm_client	false
3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	oidc.ciba.grant.enabled	false
3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	backchannel.logout.session.required	true
3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	saml_force_name_id_format	false
3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	saml.client.signature	false
3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	tls.client.certificate.bound.access.tokens	false
3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	saml.authnstatement	false
3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	display.on.consent.screen	false
3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	saml.onetimeuse.condition	false
3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	standard.token.exchange.enabled	false
3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	client.secret.creation.time	1760430860
8fae8698-811f-4da1-b479-dbcce9ac9de5	standard.token.exchange.enabled	false
8fae8698-811f-4da1-b479-dbcce9ac9de5	post.logout.redirect.uris	+
8fae8698-811f-4da1-b479-dbcce9ac9de5	oauth2.device.authorization.grant.enabled	false
8fae8698-811f-4da1-b479-dbcce9ac9de5	backchannel.logout.revoke.offline.tokens	false
8fae8698-811f-4da1-b479-dbcce9ac9de5	use.refresh.tokens	true
8fae8698-811f-4da1-b479-dbcce9ac9de5	tls-client-certificate-bound-access-tokens	false
8fae8698-811f-4da1-b479-dbcce9ac9de5	realm_client	false
8fae8698-811f-4da1-b479-dbcce9ac9de5	oidc.ciba.grant.enabled	false
8fae8698-811f-4da1-b479-dbcce9ac9de5	backchannel.logout.session.required	true
8fae8698-811f-4da1-b479-dbcce9ac9de5	backchannel.logout.url	http://docker.localhost/graphinsights/logout/connect/back-channel/keycloak
8fae8698-811f-4da1-b479-dbcce9ac9de5	client_credentials.use_refresh_token	false
8fae8698-811f-4da1-b479-dbcce9ac9de5	acr.loa.map	{}
8fae8698-811f-4da1-b479-dbcce9ac9de5	require.pushed.authorization.requests	false
8fae8698-811f-4da1-b479-dbcce9ac9de5	display.on.consent.screen	false
8fae8698-811f-4da1-b479-dbcce9ac9de5	token.response.type.bearer.lower-case	false
35c8443a-bcd5-40da-b3b7-805c6dc6bc5a	realm_client	false
35c8443a-bcd5-40da-b3b7-805c6dc6bc5a	standard.token.exchange.enabled	false
35c8443a-bcd5-40da-b3b7-805c6dc6bc5a	dpop.bound.access.tokens	false
35c8443a-bcd5-40da-b3b7-805c6dc6bc5a	backchannel.logout.url	http://docker.localhost/graphinsights/logout/connect/back-channel/keycloak
35c8443a-bcd5-40da-b3b7-805c6dc6bc5a	backchannel.logout.session.required	false
\.


--
-- Data for Name: client_auth_flow_bindings; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.client_auth_flow_bindings (client_id, flow_id, binding_name) FROM stdin;
\.


--
-- Data for Name: client_initial_access; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.client_initial_access (id, realm_id, "timestamp", expiration, count, remaining_count) FROM stdin;
\.


--
-- Data for Name: client_node_registrations; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.client_node_registrations (client_id, value, name) FROM stdin;
\.


--
-- Data for Name: client_scope; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.client_scope (id, name, realm_id, description, protocol) FROM stdin;
5fa108cf-082d-4259-a83b-0e6bafe2dc52	offline_access	master	OpenID Connect built-in scope: offline_access	openid-connect
b0bd9d13-2656-482b-983a-7e035271249c	role_list	master	SAML role list	saml
836e4bec-bf2b-413e-8ab9-f8cfe4df2c92	profile	master	OpenID Connect built-in scope: profile	openid-connect
a6bdff04-29c8-4182-a724-8c1ea6eeaa34	email	master	OpenID Connect built-in scope: email	openid-connect
d2e82da6-ba0e-4f79-97d4-72b214da0c93	address	master	OpenID Connect built-in scope: address	openid-connect
c702175b-726a-483d-b634-c78824e9e5e4	phone	master	OpenID Connect built-in scope: phone	openid-connect
2d908280-64c7-48e7-a550-2087fec991fd	roles	master	OpenID Connect scope for add user roles to the access token	openid-connect
337849c0-068b-4df7-8065-7f36d6b66c5e	web-origins	master	OpenID Connect scope for add allowed web origins to the access token	openid-connect
03b1f2aa-882b-47d2-b047-de00af7de64a	address	cmem	OpenID Connect built-in scope: address	openid-connect
ea902ac2-db2b-4cc5-b709-188c14ffa8c9	email	cmem	OpenID Connect built-in scope: email	openid-connect
c91b964b-1c79-478e-89b2-05673ce63a8d	offline_access	cmem	OpenID Connect built-in scope: offline_access	openid-connect
b58ca5a7-117a-4398-a793-821f80967282	phone	cmem	OpenID Connect built-in scope: phone	openid-connect
09515dc1-d9ed-43f6-a128-aa8b30a0b1fb	profile	cmem	OpenID Connect built-in scope: profile	openid-connect
4a28cf61-9dc1-41a2-acbe-d4655458c19d	role_list	cmem	SAML role list	saml
a6bcb9ab-69ca-415f-a30f-f588d60d0598	roles	cmem	OpenID Connect scope for add user roles to the access token	openid-connect
d2b63358-a813-447c-afbf-f4c22fc9e183	web-origins	cmem	OpenID Connect scope for add allowed web origins to the access token	openid-connect
7e284e72-20ce-4a0c-b9c5-5d0dffd775a4	microprofile-jwt	master	Microprofile - JWT built-in scope	openid-connect
4b60c78d-a296-4047-beb6-92b487da43b8	microprofile-jwt	cmem	Microprofile - JWT built-in scope	openid-connect
dd479ceb-03a2-4490-b511-12a5515745f0	acr	cmem	OpenID Connect scope for add acr (authentication context class reference) to the token	openid-connect
ae5dcb24-0f95-4c5e-b079-04b45d578ded	acr	master	OpenID Connect scope for add acr (authentication context class reference) to the token	openid-connect
d959d7f7-5626-4024-b420-9c47982bb617	basic	master	OpenID Connect scope for add all basic claims to the token	openid-connect
7db28b56-71d1-4b95-a422-93450c685e7a	basic	cmem	OpenID Connect scope for add all basic claims to the token	openid-connect
ca6d6584-0182-41d1-b0ec-101e578bec3f	service_account	master	Specific scope for a client enabled for service accounts	openid-connect
5e0dab1d-d1b8-47f2-97ca-602c13bfc4e9	service_account	cmem	Specific scope for a client enabled for service accounts	openid-connect
\.


--
-- Data for Name: client_scope_attributes; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.client_scope_attributes (scope_id, value, name) FROM stdin;
5fa108cf-082d-4259-a83b-0e6bafe2dc52	true	display.on.consent.screen
5fa108cf-082d-4259-a83b-0e6bafe2dc52	${offlineAccessScopeConsentText}	consent.screen.text
b0bd9d13-2656-482b-983a-7e035271249c	true	display.on.consent.screen
b0bd9d13-2656-482b-983a-7e035271249c	${samlRoleListScopeConsentText}	consent.screen.text
836e4bec-bf2b-413e-8ab9-f8cfe4df2c92	true	display.on.consent.screen
836e4bec-bf2b-413e-8ab9-f8cfe4df2c92	${profileScopeConsentText}	consent.screen.text
836e4bec-bf2b-413e-8ab9-f8cfe4df2c92	true	include.in.token.scope
a6bdff04-29c8-4182-a724-8c1ea6eeaa34	true	display.on.consent.screen
a6bdff04-29c8-4182-a724-8c1ea6eeaa34	${emailScopeConsentText}	consent.screen.text
a6bdff04-29c8-4182-a724-8c1ea6eeaa34	true	include.in.token.scope
d2e82da6-ba0e-4f79-97d4-72b214da0c93	true	display.on.consent.screen
d2e82da6-ba0e-4f79-97d4-72b214da0c93	${addressScopeConsentText}	consent.screen.text
d2e82da6-ba0e-4f79-97d4-72b214da0c93	true	include.in.token.scope
c702175b-726a-483d-b634-c78824e9e5e4	true	display.on.consent.screen
c702175b-726a-483d-b634-c78824e9e5e4	${phoneScopeConsentText}	consent.screen.text
c702175b-726a-483d-b634-c78824e9e5e4	true	include.in.token.scope
2d908280-64c7-48e7-a550-2087fec991fd	true	display.on.consent.screen
2d908280-64c7-48e7-a550-2087fec991fd	${rolesScopeConsentText}	consent.screen.text
2d908280-64c7-48e7-a550-2087fec991fd	false	include.in.token.scope
337849c0-068b-4df7-8065-7f36d6b66c5e	false	display.on.consent.screen
337849c0-068b-4df7-8065-7f36d6b66c5e		consent.screen.text
337849c0-068b-4df7-8065-7f36d6b66c5e	false	include.in.token.scope
03b1f2aa-882b-47d2-b047-de00af7de64a	true	include.in.token.scope
03b1f2aa-882b-47d2-b047-de00af7de64a	true	display.on.consent.screen
03b1f2aa-882b-47d2-b047-de00af7de64a	${addressScopeConsentText}	consent.screen.text
ea902ac2-db2b-4cc5-b709-188c14ffa8c9	true	include.in.token.scope
ea902ac2-db2b-4cc5-b709-188c14ffa8c9	true	display.on.consent.screen
ea902ac2-db2b-4cc5-b709-188c14ffa8c9	${emailScopeConsentText}	consent.screen.text
c91b964b-1c79-478e-89b2-05673ce63a8d	${offlineAccessScopeConsentText}	consent.screen.text
c91b964b-1c79-478e-89b2-05673ce63a8d	true	display.on.consent.screen
b58ca5a7-117a-4398-a793-821f80967282	true	include.in.token.scope
b58ca5a7-117a-4398-a793-821f80967282	true	display.on.consent.screen
b58ca5a7-117a-4398-a793-821f80967282	${phoneScopeConsentText}	consent.screen.text
09515dc1-d9ed-43f6-a128-aa8b30a0b1fb	true	include.in.token.scope
09515dc1-d9ed-43f6-a128-aa8b30a0b1fb	true	display.on.consent.screen
09515dc1-d9ed-43f6-a128-aa8b30a0b1fb	${profileScopeConsentText}	consent.screen.text
4a28cf61-9dc1-41a2-acbe-d4655458c19d	${samlRoleListScopeConsentText}	consent.screen.text
4a28cf61-9dc1-41a2-acbe-d4655458c19d	true	display.on.consent.screen
a6bcb9ab-69ca-415f-a30f-f588d60d0598	false	include.in.token.scope
a6bcb9ab-69ca-415f-a30f-f588d60d0598	true	display.on.consent.screen
a6bcb9ab-69ca-415f-a30f-f588d60d0598	${rolesScopeConsentText}	consent.screen.text
d2b63358-a813-447c-afbf-f4c22fc9e183	false	include.in.token.scope
d2b63358-a813-447c-afbf-f4c22fc9e183	false	display.on.consent.screen
d2b63358-a813-447c-afbf-f4c22fc9e183		consent.screen.text
7e284e72-20ce-4a0c-b9c5-5d0dffd775a4	false	display.on.consent.screen
7e284e72-20ce-4a0c-b9c5-5d0dffd775a4	true	include.in.token.scope
4b60c78d-a296-4047-beb6-92b487da43b8	false	display.on.consent.screen
4b60c78d-a296-4047-beb6-92b487da43b8	true	include.in.token.scope
dd479ceb-03a2-4490-b511-12a5515745f0	false	display.on.consent.screen
dd479ceb-03a2-4490-b511-12a5515745f0	false	include.in.token.scope
ae5dcb24-0f95-4c5e-b079-04b45d578ded	false	display.on.consent.screen
ae5dcb24-0f95-4c5e-b079-04b45d578ded	false	include.in.token.scope
d959d7f7-5626-4024-b420-9c47982bb617	false	display.on.consent.screen
d959d7f7-5626-4024-b420-9c47982bb617	false	include.in.token.scope
7db28b56-71d1-4b95-a422-93450c685e7a	false	display.on.consent.screen
7db28b56-71d1-4b95-a422-93450c685e7a	false	include.in.token.scope
ca6d6584-0182-41d1-b0ec-101e578bec3f	false	display.on.consent.screen
ca6d6584-0182-41d1-b0ec-101e578bec3f	false	include.in.token.scope
5e0dab1d-d1b8-47f2-97ca-602c13bfc4e9	false	display.on.consent.screen
5e0dab1d-d1b8-47f2-97ca-602c13bfc4e9	false	include.in.token.scope
\.


--
-- Data for Name: client_scope_client; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.client_scope_client (client_id, scope_id, default_scope) FROM stdin;
75ba9e57-8bd3-4560-af7b-8d8bc74cae0d	b0bd9d13-2656-482b-983a-7e035271249c	t
ba918616-f25d-4a37-9594-18f20f731fdc	b0bd9d13-2656-482b-983a-7e035271249c	t
23cd6fb4-696a-41d2-b04f-037e548db556	b0bd9d13-2656-482b-983a-7e035271249c	t
360b5c9e-6960-451f-b5d4-9eaae2dacdda	b0bd9d13-2656-482b-983a-7e035271249c	t
110e1f10-2989-4463-8f9b-f8f50d4b7ab4	b0bd9d13-2656-482b-983a-7e035271249c	t
75ba9e57-8bd3-4560-af7b-8d8bc74cae0d	836e4bec-bf2b-413e-8ab9-f8cfe4df2c92	t
75ba9e57-8bd3-4560-af7b-8d8bc74cae0d	a6bdff04-29c8-4182-a724-8c1ea6eeaa34	t
75ba9e57-8bd3-4560-af7b-8d8bc74cae0d	2d908280-64c7-48e7-a550-2087fec991fd	t
75ba9e57-8bd3-4560-af7b-8d8bc74cae0d	337849c0-068b-4df7-8065-7f36d6b66c5e	t
75ba9e57-8bd3-4560-af7b-8d8bc74cae0d	5fa108cf-082d-4259-a83b-0e6bafe2dc52	f
75ba9e57-8bd3-4560-af7b-8d8bc74cae0d	d2e82da6-ba0e-4f79-97d4-72b214da0c93	f
75ba9e57-8bd3-4560-af7b-8d8bc74cae0d	c702175b-726a-483d-b634-c78824e9e5e4	f
ba918616-f25d-4a37-9594-18f20f731fdc	836e4bec-bf2b-413e-8ab9-f8cfe4df2c92	t
ba918616-f25d-4a37-9594-18f20f731fdc	a6bdff04-29c8-4182-a724-8c1ea6eeaa34	t
ba918616-f25d-4a37-9594-18f20f731fdc	2d908280-64c7-48e7-a550-2087fec991fd	t
ba918616-f25d-4a37-9594-18f20f731fdc	337849c0-068b-4df7-8065-7f36d6b66c5e	t
ba918616-f25d-4a37-9594-18f20f731fdc	5fa108cf-082d-4259-a83b-0e6bafe2dc52	f
ba918616-f25d-4a37-9594-18f20f731fdc	d2e82da6-ba0e-4f79-97d4-72b214da0c93	f
ba918616-f25d-4a37-9594-18f20f731fdc	c702175b-726a-483d-b634-c78824e9e5e4	f
23cd6fb4-696a-41d2-b04f-037e548db556	836e4bec-bf2b-413e-8ab9-f8cfe4df2c92	t
23cd6fb4-696a-41d2-b04f-037e548db556	a6bdff04-29c8-4182-a724-8c1ea6eeaa34	t
23cd6fb4-696a-41d2-b04f-037e548db556	2d908280-64c7-48e7-a550-2087fec991fd	t
23cd6fb4-696a-41d2-b04f-037e548db556	337849c0-068b-4df7-8065-7f36d6b66c5e	t
23cd6fb4-696a-41d2-b04f-037e548db556	5fa108cf-082d-4259-a83b-0e6bafe2dc52	f
23cd6fb4-696a-41d2-b04f-037e548db556	d2e82da6-ba0e-4f79-97d4-72b214da0c93	f
23cd6fb4-696a-41d2-b04f-037e548db556	c702175b-726a-483d-b634-c78824e9e5e4	f
360b5c9e-6960-451f-b5d4-9eaae2dacdda	836e4bec-bf2b-413e-8ab9-f8cfe4df2c92	t
360b5c9e-6960-451f-b5d4-9eaae2dacdda	a6bdff04-29c8-4182-a724-8c1ea6eeaa34	t
360b5c9e-6960-451f-b5d4-9eaae2dacdda	2d908280-64c7-48e7-a550-2087fec991fd	t
360b5c9e-6960-451f-b5d4-9eaae2dacdda	337849c0-068b-4df7-8065-7f36d6b66c5e	t
360b5c9e-6960-451f-b5d4-9eaae2dacdda	5fa108cf-082d-4259-a83b-0e6bafe2dc52	f
360b5c9e-6960-451f-b5d4-9eaae2dacdda	d2e82da6-ba0e-4f79-97d4-72b214da0c93	f
360b5c9e-6960-451f-b5d4-9eaae2dacdda	c702175b-726a-483d-b634-c78824e9e5e4	f
110e1f10-2989-4463-8f9b-f8f50d4b7ab4	836e4bec-bf2b-413e-8ab9-f8cfe4df2c92	t
110e1f10-2989-4463-8f9b-f8f50d4b7ab4	a6bdff04-29c8-4182-a724-8c1ea6eeaa34	t
110e1f10-2989-4463-8f9b-f8f50d4b7ab4	2d908280-64c7-48e7-a550-2087fec991fd	t
110e1f10-2989-4463-8f9b-f8f50d4b7ab4	337849c0-068b-4df7-8065-7f36d6b66c5e	t
110e1f10-2989-4463-8f9b-f8f50d4b7ab4	5fa108cf-082d-4259-a83b-0e6bafe2dc52	f
110e1f10-2989-4463-8f9b-f8f50d4b7ab4	d2e82da6-ba0e-4f79-97d4-72b214da0c93	f
110e1f10-2989-4463-8f9b-f8f50d4b7ab4	c702175b-726a-483d-b634-c78824e9e5e4	f
688ef36e-12f7-462a-bf89-cceec001558f	b0bd9d13-2656-482b-983a-7e035271249c	t
688ef36e-12f7-462a-bf89-cceec001558f	836e4bec-bf2b-413e-8ab9-f8cfe4df2c92	t
688ef36e-12f7-462a-bf89-cceec001558f	a6bdff04-29c8-4182-a724-8c1ea6eeaa34	t
688ef36e-12f7-462a-bf89-cceec001558f	2d908280-64c7-48e7-a550-2087fec991fd	t
688ef36e-12f7-462a-bf89-cceec001558f	337849c0-068b-4df7-8065-7f36d6b66c5e	t
688ef36e-12f7-462a-bf89-cceec001558f	5fa108cf-082d-4259-a83b-0e6bafe2dc52	f
688ef36e-12f7-462a-bf89-cceec001558f	d2e82da6-ba0e-4f79-97d4-72b214da0c93	f
688ef36e-12f7-462a-bf89-cceec001558f	c702175b-726a-483d-b634-c78824e9e5e4	f
6338d0ff-f06e-4987-af63-197be726c44c	d2b63358-a813-447c-afbf-f4c22fc9e183	t
6338d0ff-f06e-4987-af63-197be726c44c	4a28cf61-9dc1-41a2-acbe-d4655458c19d	t
6338d0ff-f06e-4987-af63-197be726c44c	09515dc1-d9ed-43f6-a128-aa8b30a0b1fb	t
6338d0ff-f06e-4987-af63-197be726c44c	a6bcb9ab-69ca-415f-a30f-f588d60d0598	t
6338d0ff-f06e-4987-af63-197be726c44c	ea902ac2-db2b-4cc5-b709-188c14ffa8c9	t
6338d0ff-f06e-4987-af63-197be726c44c	03b1f2aa-882b-47d2-b047-de00af7de64a	f
6338d0ff-f06e-4987-af63-197be726c44c	b58ca5a7-117a-4398-a793-821f80967282	f
6338d0ff-f06e-4987-af63-197be726c44c	c91b964b-1c79-478e-89b2-05673ce63a8d	f
5e55f24c-2b31-4540-b833-d65755f887d5	d2b63358-a813-447c-afbf-f4c22fc9e183	t
5e55f24c-2b31-4540-b833-d65755f887d5	4a28cf61-9dc1-41a2-acbe-d4655458c19d	t
5e55f24c-2b31-4540-b833-d65755f887d5	09515dc1-d9ed-43f6-a128-aa8b30a0b1fb	t
5e55f24c-2b31-4540-b833-d65755f887d5	a6bcb9ab-69ca-415f-a30f-f588d60d0598	t
5e55f24c-2b31-4540-b833-d65755f887d5	ea902ac2-db2b-4cc5-b709-188c14ffa8c9	t
5e55f24c-2b31-4540-b833-d65755f887d5	03b1f2aa-882b-47d2-b047-de00af7de64a	f
5e55f24c-2b31-4540-b833-d65755f887d5	b58ca5a7-117a-4398-a793-821f80967282	f
5e55f24c-2b31-4540-b833-d65755f887d5	c91b964b-1c79-478e-89b2-05673ce63a8d	f
dd485b6a-ee8f-47a8-b459-cc65a10f8cc0	d2b63358-a813-447c-afbf-f4c22fc9e183	t
dd485b6a-ee8f-47a8-b459-cc65a10f8cc0	4a28cf61-9dc1-41a2-acbe-d4655458c19d	t
dd485b6a-ee8f-47a8-b459-cc65a10f8cc0	09515dc1-d9ed-43f6-a128-aa8b30a0b1fb	t
dd485b6a-ee8f-47a8-b459-cc65a10f8cc0	a6bcb9ab-69ca-415f-a30f-f588d60d0598	t
dd485b6a-ee8f-47a8-b459-cc65a10f8cc0	ea902ac2-db2b-4cc5-b709-188c14ffa8c9	t
dd485b6a-ee8f-47a8-b459-cc65a10f8cc0	03b1f2aa-882b-47d2-b047-de00af7de64a	f
dd485b6a-ee8f-47a8-b459-cc65a10f8cc0	b58ca5a7-117a-4398-a793-821f80967282	f
dd485b6a-ee8f-47a8-b459-cc65a10f8cc0	c91b964b-1c79-478e-89b2-05673ce63a8d	f
e9ab4ab5-754b-4f19-9d50-232bdf8cb322	d2b63358-a813-447c-afbf-f4c22fc9e183	t
e9ab4ab5-754b-4f19-9d50-232bdf8cb322	4a28cf61-9dc1-41a2-acbe-d4655458c19d	t
e9ab4ab5-754b-4f19-9d50-232bdf8cb322	09515dc1-d9ed-43f6-a128-aa8b30a0b1fb	t
e9ab4ab5-754b-4f19-9d50-232bdf8cb322	a6bcb9ab-69ca-415f-a30f-f588d60d0598	t
e9ab4ab5-754b-4f19-9d50-232bdf8cb322	ea902ac2-db2b-4cc5-b709-188c14ffa8c9	t
e9ab4ab5-754b-4f19-9d50-232bdf8cb322	03b1f2aa-882b-47d2-b047-de00af7de64a	f
e9ab4ab5-754b-4f19-9d50-232bdf8cb322	b58ca5a7-117a-4398-a793-821f80967282	f
e9ab4ab5-754b-4f19-9d50-232bdf8cb322	c91b964b-1c79-478e-89b2-05673ce63a8d	f
eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	d2b63358-a813-447c-afbf-f4c22fc9e183	t
eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	4a28cf61-9dc1-41a2-acbe-d4655458c19d	t
eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	09515dc1-d9ed-43f6-a128-aa8b30a0b1fb	t
eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	a6bcb9ab-69ca-415f-a30f-f588d60d0598	t
eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	ea902ac2-db2b-4cc5-b709-188c14ffa8c9	t
eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	03b1f2aa-882b-47d2-b047-de00af7de64a	f
eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	b58ca5a7-117a-4398-a793-821f80967282	f
eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	c91b964b-1c79-478e-89b2-05673ce63a8d	f
d8c9cb3a-59eb-440a-9cb5-d8870bd8f180	d2b63358-a813-447c-afbf-f4c22fc9e183	t
d8c9cb3a-59eb-440a-9cb5-d8870bd8f180	4a28cf61-9dc1-41a2-acbe-d4655458c19d	t
d8c9cb3a-59eb-440a-9cb5-d8870bd8f180	09515dc1-d9ed-43f6-a128-aa8b30a0b1fb	t
d8c9cb3a-59eb-440a-9cb5-d8870bd8f180	a6bcb9ab-69ca-415f-a30f-f588d60d0598	t
d8c9cb3a-59eb-440a-9cb5-d8870bd8f180	ea902ac2-db2b-4cc5-b709-188c14ffa8c9	t
d8c9cb3a-59eb-440a-9cb5-d8870bd8f180	03b1f2aa-882b-47d2-b047-de00af7de64a	f
d8c9cb3a-59eb-440a-9cb5-d8870bd8f180	b58ca5a7-117a-4398-a793-821f80967282	f
d8c9cb3a-59eb-440a-9cb5-d8870bd8f180	c91b964b-1c79-478e-89b2-05673ce63a8d	f
f5473ca3-5293-4d61-b46c-422cf2664546	4a28cf61-9dc1-41a2-acbe-d4655458c19d	t
f5473ca3-5293-4d61-b46c-422cf2664546	09515dc1-d9ed-43f6-a128-aa8b30a0b1fb	t
f5473ca3-5293-4d61-b46c-422cf2664546	a6bcb9ab-69ca-415f-a30f-f588d60d0598	t
f5473ca3-5293-4d61-b46c-422cf2664546	d2b63358-a813-447c-afbf-f4c22fc9e183	t
f5473ca3-5293-4d61-b46c-422cf2664546	ea902ac2-db2b-4cc5-b709-188c14ffa8c9	t
f5473ca3-5293-4d61-b46c-422cf2664546	03b1f2aa-882b-47d2-b047-de00af7de64a	f
f5473ca3-5293-4d61-b46c-422cf2664546	b58ca5a7-117a-4398-a793-821f80967282	f
f5473ca3-5293-4d61-b46c-422cf2664546	c91b964b-1c79-478e-89b2-05673ce63a8d	f
ace265c3-5eff-4002-898f-3f1cc8b3c30f	4a28cf61-9dc1-41a2-acbe-d4655458c19d	t
ace265c3-5eff-4002-898f-3f1cc8b3c30f	09515dc1-d9ed-43f6-a128-aa8b30a0b1fb	t
ace265c3-5eff-4002-898f-3f1cc8b3c30f	a6bcb9ab-69ca-415f-a30f-f588d60d0598	t
ace265c3-5eff-4002-898f-3f1cc8b3c30f	d2b63358-a813-447c-afbf-f4c22fc9e183	t
ace265c3-5eff-4002-898f-3f1cc8b3c30f	ea902ac2-db2b-4cc5-b709-188c14ffa8c9	t
ace265c3-5eff-4002-898f-3f1cc8b3c30f	03b1f2aa-882b-47d2-b047-de00af7de64a	f
ace265c3-5eff-4002-898f-3f1cc8b3c30f	b58ca5a7-117a-4398-a793-821f80967282	f
ace265c3-5eff-4002-898f-3f1cc8b3c30f	c91b964b-1c79-478e-89b2-05673ce63a8d	f
75ba9e57-8bd3-4560-af7b-8d8bc74cae0d	7e284e72-20ce-4a0c-b9c5-5d0dffd775a4	f
ba918616-f25d-4a37-9594-18f20f731fdc	7e284e72-20ce-4a0c-b9c5-5d0dffd775a4	f
23cd6fb4-696a-41d2-b04f-037e548db556	7e284e72-20ce-4a0c-b9c5-5d0dffd775a4	f
110e1f10-2989-4463-8f9b-f8f50d4b7ab4	7e284e72-20ce-4a0c-b9c5-5d0dffd775a4	f
6338d0ff-f06e-4987-af63-197be726c44c	4b60c78d-a296-4047-beb6-92b487da43b8	f
5e55f24c-2b31-4540-b833-d65755f887d5	4b60c78d-a296-4047-beb6-92b487da43b8	f
dd485b6a-ee8f-47a8-b459-cc65a10f8cc0	4b60c78d-a296-4047-beb6-92b487da43b8	f
9ef63961-4068-4b5a-b67f-ddf01d048b0d	4b60c78d-a296-4047-beb6-92b487da43b8	f
e9ab4ab5-754b-4f19-9d50-232bdf8cb322	4b60c78d-a296-4047-beb6-92b487da43b8	f
ace265c3-5eff-4002-898f-3f1cc8b3c30f	4b60c78d-a296-4047-beb6-92b487da43b8	f
f5473ca3-5293-4d61-b46c-422cf2664546	4b60c78d-a296-4047-beb6-92b487da43b8	f
d8c9cb3a-59eb-440a-9cb5-d8870bd8f180	4b60c78d-a296-4047-beb6-92b487da43b8	f
3aa98620-e55f-4c26-af5a-37e7d694964e	b0bd9d13-2656-482b-983a-7e035271249c	t
3aa98620-e55f-4c26-af5a-37e7d694964e	836e4bec-bf2b-413e-8ab9-f8cfe4df2c92	t
3aa98620-e55f-4c26-af5a-37e7d694964e	2d908280-64c7-48e7-a550-2087fec991fd	t
3aa98620-e55f-4c26-af5a-37e7d694964e	337849c0-068b-4df7-8065-7f36d6b66c5e	t
3aa98620-e55f-4c26-af5a-37e7d694964e	a6bdff04-29c8-4182-a724-8c1ea6eeaa34	t
3aa98620-e55f-4c26-af5a-37e7d694964e	c702175b-726a-483d-b634-c78824e9e5e4	f
3aa98620-e55f-4c26-af5a-37e7d694964e	5fa108cf-082d-4259-a83b-0e6bafe2dc52	f
3aa98620-e55f-4c26-af5a-37e7d694964e	d2e82da6-ba0e-4f79-97d4-72b214da0c93	f
3aa98620-e55f-4c26-af5a-37e7d694964e	7e284e72-20ce-4a0c-b9c5-5d0dffd775a4	f
5748140e-1c07-4a3d-9302-26cb6208dd5d	4a28cf61-9dc1-41a2-acbe-d4655458c19d	t
5748140e-1c07-4a3d-9302-26cb6208dd5d	a6bcb9ab-69ca-415f-a30f-f588d60d0598	t
5748140e-1c07-4a3d-9302-26cb6208dd5d	09515dc1-d9ed-43f6-a128-aa8b30a0b1fb	t
5748140e-1c07-4a3d-9302-26cb6208dd5d	d2b63358-a813-447c-afbf-f4c22fc9e183	t
5748140e-1c07-4a3d-9302-26cb6208dd5d	ea902ac2-db2b-4cc5-b709-188c14ffa8c9	t
5748140e-1c07-4a3d-9302-26cb6208dd5d	03b1f2aa-882b-47d2-b047-de00af7de64a	f
5748140e-1c07-4a3d-9302-26cb6208dd5d	c91b964b-1c79-478e-89b2-05673ce63a8d	f
5748140e-1c07-4a3d-9302-26cb6208dd5d	4b60c78d-a296-4047-beb6-92b487da43b8	f
5748140e-1c07-4a3d-9302-26cb6208dd5d	b58ca5a7-117a-4398-a793-821f80967282	f
35c8443a-bcd5-40da-b3b7-805c6dc6bc5a	a6bcb9ab-69ca-415f-a30f-f588d60d0598	t
35c8443a-bcd5-40da-b3b7-805c6dc6bc5a	dd479ceb-03a2-4490-b511-12a5515745f0	t
35c8443a-bcd5-40da-b3b7-805c6dc6bc5a	09515dc1-d9ed-43f6-a128-aa8b30a0b1fb	t
35c8443a-bcd5-40da-b3b7-805c6dc6bc5a	d2b63358-a813-447c-afbf-f4c22fc9e183	t
35c8443a-bcd5-40da-b3b7-805c6dc6bc5a	ea902ac2-db2b-4cc5-b709-188c14ffa8c9	t
35c8443a-bcd5-40da-b3b7-805c6dc6bc5a	03b1f2aa-882b-47d2-b047-de00af7de64a	f
35c8443a-bcd5-40da-b3b7-805c6dc6bc5a	c91b964b-1c79-478e-89b2-05673ce63a8d	f
35c8443a-bcd5-40da-b3b7-805c6dc6bc5a	4b60c78d-a296-4047-beb6-92b487da43b8	f
35c8443a-bcd5-40da-b3b7-805c6dc6bc5a	b58ca5a7-117a-4398-a793-821f80967282	f
23cd6fb4-696a-41d2-b04f-037e548db556	d959d7f7-5626-4024-b420-9c47982bb617	t
ba918616-f25d-4a37-9594-18f20f731fdc	d959d7f7-5626-4024-b420-9c47982bb617	t
110e1f10-2989-4463-8f9b-f8f50d4b7ab4	d959d7f7-5626-4024-b420-9c47982bb617	t
75ba9e57-8bd3-4560-af7b-8d8bc74cae0d	d959d7f7-5626-4024-b420-9c47982bb617	t
3aa98620-e55f-4c26-af5a-37e7d694964e	d959d7f7-5626-4024-b420-9c47982bb617	t
ace265c3-5eff-4002-898f-3f1cc8b3c30f	7db28b56-71d1-4b95-a422-93450c685e7a	t
f5473ca3-5293-4d61-b46c-422cf2664546	7db28b56-71d1-4b95-a422-93450c685e7a	t
35c8443a-bcd5-40da-b3b7-805c6dc6bc5a	7db28b56-71d1-4b95-a422-93450c685e7a	t
6338d0ff-f06e-4987-af63-197be726c44c	7db28b56-71d1-4b95-a422-93450c685e7a	t
5748140e-1c07-4a3d-9302-26cb6208dd5d	7db28b56-71d1-4b95-a422-93450c685e7a	t
d8c9cb3a-59eb-440a-9cb5-d8870bd8f180	7db28b56-71d1-4b95-a422-93450c685e7a	t
dd485b6a-ee8f-47a8-b459-cc65a10f8cc0	7db28b56-71d1-4b95-a422-93450c685e7a	t
5e55f24c-2b31-4540-b833-d65755f887d5	7db28b56-71d1-4b95-a422-93450c685e7a	t
e9ab4ab5-754b-4f19-9d50-232bdf8cb322	7db28b56-71d1-4b95-a422-93450c685e7a	t
3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	d2b63358-a813-447c-afbf-f4c22fc9e183	t
3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	a6bcb9ab-69ca-415f-a30f-f588d60d0598	t
3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	09515dc1-d9ed-43f6-a128-aa8b30a0b1fb	t
3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	7db28b56-71d1-4b95-a422-93450c685e7a	t
3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	ea902ac2-db2b-4cc5-b709-188c14ffa8c9	t
3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	03b1f2aa-882b-47d2-b047-de00af7de64a	f
3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	b58ca5a7-117a-4398-a793-821f80967282	f
3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	c91b964b-1c79-478e-89b2-05673ce63a8d	f
3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	4b60c78d-a296-4047-beb6-92b487da43b8	f
3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	5e0dab1d-d1b8-47f2-97ca-602c13bfc4e9	t
8fae8698-811f-4da1-b479-dbcce9ac9de5	d2b63358-a813-447c-afbf-f4c22fc9e183	t
8fae8698-811f-4da1-b479-dbcce9ac9de5	dd479ceb-03a2-4490-b511-12a5515745f0	t
8fae8698-811f-4da1-b479-dbcce9ac9de5	a6bcb9ab-69ca-415f-a30f-f588d60d0598	t
8fae8698-811f-4da1-b479-dbcce9ac9de5	09515dc1-d9ed-43f6-a128-aa8b30a0b1fb	t
8fae8698-811f-4da1-b479-dbcce9ac9de5	7db28b56-71d1-4b95-a422-93450c685e7a	t
8fae8698-811f-4da1-b479-dbcce9ac9de5	ea902ac2-db2b-4cc5-b709-188c14ffa8c9	t
8fae8698-811f-4da1-b479-dbcce9ac9de5	03b1f2aa-882b-47d2-b047-de00af7de64a	f
8fae8698-811f-4da1-b479-dbcce9ac9de5	b58ca5a7-117a-4398-a793-821f80967282	f
8fae8698-811f-4da1-b479-dbcce9ac9de5	c91b964b-1c79-478e-89b2-05673ce63a8d	f
8fae8698-811f-4da1-b479-dbcce9ac9de5	4b60c78d-a296-4047-beb6-92b487da43b8	f
\.


--
-- Data for Name: client_scope_role_mapping; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.client_scope_role_mapping (scope_id, role_id) FROM stdin;
5fa108cf-082d-4259-a83b-0e6bafe2dc52	c41a715c-2c3d-4abc-ac16-cad7784b222c
c91b964b-1c79-478e-89b2-05673ce63a8d	73819e85-b0fc-45c9-9d43-0cd4cfa8edf7
\.


--
-- Data for Name: component; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.component (id, name, parent_id, provider_id, provider_type, realm_id, sub_type) FROM stdin;
684acac2-e523-4f48-9b89-eb1d25d2a0fe	Trusted Hosts	master	trusted-hosts	org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy	master	anonymous
d9e685dd-7e23-4f34-999e-2820ea8dc0c5	Consent Required	master	consent-required	org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy	master	anonymous
3ff9324f-fb8b-46b6-b91d-8aaa7b653b4b	Full Scope Disabled	master	scope	org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy	master	anonymous
143b8ec3-9e23-4fef-a5ee-97688570bd74	Max Clients Limit	master	max-clients	org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy	master	anonymous
7369aba9-57d0-405a-a303-838f12a1ceac	Allowed Protocol Mapper Types	master	allowed-protocol-mappers	org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy	master	anonymous
bc41f706-278d-4be5-98ca-eedbc1feefd0	Allowed Client Scopes	master	allowed-client-templates	org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy	master	anonymous
31829b6d-7a30-483f-9fbb-221c6bbbdd0b	Allowed Protocol Mapper Types	master	allowed-protocol-mappers	org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy	master	authenticated
d901ed06-893a-43a9-9700-57a515d23145	Allowed Client Scopes	master	allowed-client-templates	org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy	master	authenticated
8185441c-3cdf-42dd-9081-1d92f86c7d1a	Max Clients Limit	cmem	max-clients	org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy	cmem	anonymous
eaa138c4-e045-4b3d-8298-f580678f2954	Allowed Protocol Mapper Types	cmem	allowed-protocol-mappers	org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy	cmem	authenticated
9dcc4096-6beb-4379-ada4-1daaf2a02d5a	Allowed Client Scopes	cmem	allowed-client-templates	org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy	cmem	authenticated
83a592c3-9f04-474c-9f59-dad96bb585b8	Allowed Client Scopes	cmem	allowed-client-templates	org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy	cmem	anonymous
f8ba722f-1bd1-47c9-a295-5bb0edc7e4f2	Trusted Hosts	cmem	trusted-hosts	org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy	cmem	anonymous
f72a2c96-3a95-4dc2-a5e2-3a7d2182e4da	Full Scope Disabled	cmem	scope	org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy	cmem	anonymous
9c479ea3-53f7-405d-89a1-9680a3d41b84	Allowed Protocol Mapper Types	cmem	allowed-protocol-mappers	org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy	cmem	anonymous
766c12e2-39bc-48c9-b0db-7418590ad870	Consent Required	cmem	consent-required	org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy	cmem	anonymous
\.


--
-- Data for Name: component_config; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.component_config (id, component_id, name, value) FROM stdin;
25869835-2bcf-4e26-980f-2cbc6b497597	143b8ec3-9e23-4fef-a5ee-97688570bd74	max-clients	200
f64b3923-8f88-42c3-b11d-24c880857f49	bc41f706-278d-4be5-98ca-eedbc1feefd0	allow-default-scopes	true
0d534195-987e-44fa-9096-1469df4064d0	31829b6d-7a30-483f-9fbb-221c6bbbdd0b	allowed-protocol-mapper-types	saml-user-property-mapper
d19edfdc-e80a-44ff-b4c4-6a6c4076dade	31829b6d-7a30-483f-9fbb-221c6bbbdd0b	allowed-protocol-mapper-types	saml-user-attribute-mapper
9e94cbb6-fb92-48bd-a33f-c7ccba222b09	31829b6d-7a30-483f-9fbb-221c6bbbdd0b	allowed-protocol-mapper-types	oidc-sha256-pairwise-sub-mapper
5c1e8c1f-7af6-423e-b131-cbd9593063af	31829b6d-7a30-483f-9fbb-221c6bbbdd0b	allowed-protocol-mapper-types	oidc-address-mapper
a5d67624-92e3-42bc-9f57-5bb1f820ec17	31829b6d-7a30-483f-9fbb-221c6bbbdd0b	allowed-protocol-mapper-types	saml-role-list-mapper
ed1d2c47-3057-4c65-9367-24ad1fbd7e69	31829b6d-7a30-483f-9fbb-221c6bbbdd0b	allowed-protocol-mapper-types	oidc-full-name-mapper
b880d377-1eec-4624-a74c-65e961dfc7e6	31829b6d-7a30-483f-9fbb-221c6bbbdd0b	allowed-protocol-mapper-types	oidc-usermodel-property-mapper
0905a5d8-ff24-4abf-bbe5-5e6f39512dbd	31829b6d-7a30-483f-9fbb-221c6bbbdd0b	allowed-protocol-mapper-types	oidc-usermodel-attribute-mapper
580877e9-39ab-42ad-bef2-daf97eb5b0fa	7369aba9-57d0-405a-a303-838f12a1ceac	allowed-protocol-mapper-types	oidc-usermodel-attribute-mapper
deaebac7-f9e2-40f8-bff6-75c9ce750068	7369aba9-57d0-405a-a303-838f12a1ceac	allowed-protocol-mapper-types	oidc-usermodel-property-mapper
0f6ffcdd-2abb-454a-bfde-15ba6737f910	7369aba9-57d0-405a-a303-838f12a1ceac	allowed-protocol-mapper-types	saml-user-attribute-mapper
8e859355-541c-4022-8fe2-3c47ed93a5ff	7369aba9-57d0-405a-a303-838f12a1ceac	allowed-protocol-mapper-types	oidc-sha256-pairwise-sub-mapper
d3d93e8e-6d73-4385-ae45-ba75efc367cd	7369aba9-57d0-405a-a303-838f12a1ceac	allowed-protocol-mapper-types	oidc-address-mapper
425b837a-319f-46f2-85aa-114dd722be8a	7369aba9-57d0-405a-a303-838f12a1ceac	allowed-protocol-mapper-types	saml-role-list-mapper
5600cd75-5bf2-45d7-a8b4-dbf9a903a97a	7369aba9-57d0-405a-a303-838f12a1ceac	allowed-protocol-mapper-types	saml-user-property-mapper
db4dcaf8-6c8d-443f-b3b4-937d1a9320f6	7369aba9-57d0-405a-a303-838f12a1ceac	allowed-protocol-mapper-types	oidc-full-name-mapper
94269082-7965-46ba-95df-5575f81ed699	d901ed06-893a-43a9-9700-57a515d23145	allow-default-scopes	true
d4ebb676-13aa-46dc-9f03-c61e6a42e5c7	684acac2-e523-4f48-9b89-eb1d25d2a0fe	client-uris-must-match	true
2a0ab4f9-1562-45b4-b8d1-5c94225d4b17	684acac2-e523-4f48-9b89-eb1d25d2a0fe	host-sending-registration-request-must-match	true
41a5dd15-927a-4448-8d80-66d92ef08345	8185441c-3cdf-42dd-9081-1d92f86c7d1a	max-clients	200
efb03954-f168-4b3b-bcf7-f42b64ae3e82	eaa138c4-e045-4b3d-8298-f580678f2954	allowed-protocol-mapper-types	saml-user-attribute-mapper
c3e2102b-8755-47e2-a782-4120b472e984	eaa138c4-e045-4b3d-8298-f580678f2954	allowed-protocol-mapper-types	oidc-usermodel-property-mapper
de9a2890-81c1-4b0f-a30d-711e7801a02a	eaa138c4-e045-4b3d-8298-f580678f2954	allowed-protocol-mapper-types	saml-role-list-mapper
04004538-eb17-48fd-81b9-4721e026c1c2	eaa138c4-e045-4b3d-8298-f580678f2954	allowed-protocol-mapper-types	oidc-full-name-mapper
c09153f5-c319-44f6-bfa8-e935eb4e6acf	eaa138c4-e045-4b3d-8298-f580678f2954	allowed-protocol-mapper-types	saml-user-property-mapper
b0aefdc0-9040-43b1-bbef-c284b817f7a9	eaa138c4-e045-4b3d-8298-f580678f2954	allowed-protocol-mapper-types	oidc-address-mapper
5a0a730c-9695-4dfa-9a90-5e524c70ba4f	eaa138c4-e045-4b3d-8298-f580678f2954	allowed-protocol-mapper-types	oidc-usermodel-attribute-mapper
1cd702b5-0504-4467-be40-71ced3f8a316	eaa138c4-e045-4b3d-8298-f580678f2954	allowed-protocol-mapper-types	oidc-sha256-pairwise-sub-mapper
64061715-1a79-4aa4-be65-1317bc7ceb02	9dcc4096-6beb-4379-ada4-1daaf2a02d5a	allow-default-scopes	true
2c48dc49-a8da-4928-8a40-82d32b82421b	83a592c3-9f04-474c-9f59-dad96bb585b8	allow-default-scopes	true
4c81bc6f-1d64-45a6-a578-ac5bc83b8b7f	f8ba722f-1bd1-47c9-a295-5bb0edc7e4f2	client-uris-must-match	true
f8bb5222-a8a6-4e16-9fbd-8c215db16b04	f8ba722f-1bd1-47c9-a295-5bb0edc7e4f2	host-sending-registration-request-must-match	true
9b350245-4475-4557-8217-8f967a12ea1e	9c479ea3-53f7-405d-89a1-9680a3d41b84	allowed-protocol-mapper-types	saml-role-list-mapper
65f969fe-1c2d-44fc-86c0-d2c135861a34	9c479ea3-53f7-405d-89a1-9680a3d41b84	allowed-protocol-mapper-types	oidc-usermodel-attribute-mapper
7d3770ba-fea4-4c8b-af86-ed5ad824c54f	9c479ea3-53f7-405d-89a1-9680a3d41b84	allowed-protocol-mapper-types	oidc-full-name-mapper
c39401ce-d8ed-49c6-ac0c-dcae01b37398	9c479ea3-53f7-405d-89a1-9680a3d41b84	allowed-protocol-mapper-types	oidc-address-mapper
ad962884-54a0-4f8b-93d0-5a23bc4e1a54	9c479ea3-53f7-405d-89a1-9680a3d41b84	allowed-protocol-mapper-types	oidc-sha256-pairwise-sub-mapper
0b4448af-0d5a-4423-8594-a61585392f5f	9c479ea3-53f7-405d-89a1-9680a3d41b84	allowed-protocol-mapper-types	oidc-usermodel-property-mapper
7935d234-e39c-4eb3-8345-9a5e7c552e9b	9c479ea3-53f7-405d-89a1-9680a3d41b84	allowed-protocol-mapper-types	saml-user-property-mapper
aba37f6a-ad6e-4c52-a73c-471e1e3df544	9c479ea3-53f7-405d-89a1-9680a3d41b84	allowed-protocol-mapper-types	saml-user-attribute-mapper
\.


--
-- Data for Name: composite_role; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.composite_role (composite, child_role) FROM stdin;
665badf5-9f53-4a3b-bea0-6268d02aa280	0f8acfdf-8a93-4847-ac14-8b4e9f834216
665badf5-9f53-4a3b-bea0-6268d02aa280	02efdcd6-7cf6-4126-9444-82dce223a519
665badf5-9f53-4a3b-bea0-6268d02aa280	37aa8703-9363-4332-9fb6-957153ec5382
665badf5-9f53-4a3b-bea0-6268d02aa280	e938e12b-2699-412b-8134-7cf04f07762f
665badf5-9f53-4a3b-bea0-6268d02aa280	eba140fa-a129-4646-83a0-9dbec3d651f6
665badf5-9f53-4a3b-bea0-6268d02aa280	e0cc291f-0155-46cf-81a8-c42de8a2b212
665badf5-9f53-4a3b-bea0-6268d02aa280	b82e3bdf-a7bc-4cbe-aed0-2da3f2e8ad4b
665badf5-9f53-4a3b-bea0-6268d02aa280	5c92c736-f2c1-4a51-96ca-89305cbe45b6
665badf5-9f53-4a3b-bea0-6268d02aa280	9071b665-4722-4821-ab89-0a6da7518408
665badf5-9f53-4a3b-bea0-6268d02aa280	085cb850-1881-4b22-a105-98d1accaf3ba
665badf5-9f53-4a3b-bea0-6268d02aa280	704b7a7e-a0ff-4086-9349-e7c178639a5c
665badf5-9f53-4a3b-bea0-6268d02aa280	c99f29b8-58d2-4256-97a0-b1cf2f7278e8
665badf5-9f53-4a3b-bea0-6268d02aa280	a048e9bf-75a2-4451-8657-00d60f0a25e8
665badf5-9f53-4a3b-bea0-6268d02aa280	2ee634c0-46b4-431b-b5f5-562c6e03b340
665badf5-9f53-4a3b-bea0-6268d02aa280	8a1a39c7-2ab8-4754-af1c-4110caae4732
665badf5-9f53-4a3b-bea0-6268d02aa280	eb3e2c6e-3fe4-4fd7-9676-735874dcaab6
665badf5-9f53-4a3b-bea0-6268d02aa280	642c9771-ac2a-478e-afd5-a27f575091ee
665badf5-9f53-4a3b-bea0-6268d02aa280	41e58bd8-ccde-4cd7-9dea-bf611bd7ec32
e938e12b-2699-412b-8134-7cf04f07762f	8a1a39c7-2ab8-4754-af1c-4110caae4732
e938e12b-2699-412b-8134-7cf04f07762f	41e58bd8-ccde-4cd7-9dea-bf611bd7ec32
eba140fa-a129-4646-83a0-9dbec3d651f6	eb3e2c6e-3fe4-4fd7-9676-735874dcaab6
37e3b8f2-8f1c-44f3-ae56-e298c46deed0	8e67fd63-af4b-42b1-ac87-284cd307819a
665badf5-9f53-4a3b-bea0-6268d02aa280	4b34637c-7d2d-4974-8063-5d011ec1198b
665badf5-9f53-4a3b-bea0-6268d02aa280	40b126cd-1bfb-422a-bbec-d22303d2b8b8
665badf5-9f53-4a3b-bea0-6268d02aa280	3856e4eb-bdf6-4887-becf-05f21c07025e
665badf5-9f53-4a3b-bea0-6268d02aa280	48b19074-f82f-4bae-a904-fbbf8d8d36a0
665badf5-9f53-4a3b-bea0-6268d02aa280	5e867812-7365-4e3f-9e6b-6512eae4312f
665badf5-9f53-4a3b-bea0-6268d02aa280	988cbd16-21cd-4f96-93f7-a1e1e06d18a2
665badf5-9f53-4a3b-bea0-6268d02aa280	b3b50103-8fe8-4eea-ae79-64d251675e00
665badf5-9f53-4a3b-bea0-6268d02aa280	291cb973-ce0e-4b23-9036-974fcad70ddb
665badf5-9f53-4a3b-bea0-6268d02aa280	23101069-6480-4249-8fb1-2afc6f627a9a
665badf5-9f53-4a3b-bea0-6268d02aa280	6d9565dd-5bd1-4c99-b7d7-83a24fcbbdcf
665badf5-9f53-4a3b-bea0-6268d02aa280	17e96725-c2f2-4d28-b964-8b8948f3719b
665badf5-9f53-4a3b-bea0-6268d02aa280	f750cc29-252e-4b00-bb6f-be66cbb7ffc2
665badf5-9f53-4a3b-bea0-6268d02aa280	ea8ad40c-3c56-4bf9-b372-78d37f17689e
665badf5-9f53-4a3b-bea0-6268d02aa280	5119c5ea-b11d-498c-ad10-690cf1364426
665badf5-9f53-4a3b-bea0-6268d02aa280	ab017b9c-ce8d-460b-94e2-2b1173507d5d
665badf5-9f53-4a3b-bea0-6268d02aa280	82d54e28-9e61-4621-8ca5-5f01c849dcc3
665badf5-9f53-4a3b-bea0-6268d02aa280	9e6e338d-87f1-4d46-803d-9b3cedcd09d9
665badf5-9f53-4a3b-bea0-6268d02aa280	ffcacb55-56e0-47e3-ad58-b1106b817073
48b19074-f82f-4bae-a904-fbbf8d8d36a0	ffcacb55-56e0-47e3-ad58-b1106b817073
48b19074-f82f-4bae-a904-fbbf8d8d36a0	ab017b9c-ce8d-460b-94e2-2b1173507d5d
5e867812-7365-4e3f-9e6b-6512eae4312f	82d54e28-9e61-4621-8ca5-5f01c849dcc3
43cf8c78-18a0-4abd-8a63-90e664204489	63831177-2338-4695-a117-67cd6b88c331
43cf8c78-18a0-4abd-8a63-90e664204489	8dc73c1c-b2ba-4f5b-acb8-d8535fbd4f07
43cf8c78-18a0-4abd-8a63-90e664204489	ccfc3214-2eb3-484a-b5f9-86d9e013edf2
43cf8c78-18a0-4abd-8a63-90e664204489	f83bae0d-306d-4a24-b7a8-09080693a50b
43cf8c78-18a0-4abd-8a63-90e664204489	601fdf42-dcc4-468a-9c0c-539aa3f0eee3
43cf8c78-18a0-4abd-8a63-90e664204489	879c1043-3414-43fa-a15e-1d10cc0c14b5
43cf8c78-18a0-4abd-8a63-90e664204489	c36947a9-3d30-4c76-8845-496ec7d01908
43cf8c78-18a0-4abd-8a63-90e664204489	bc751e50-8103-4fa0-8bfd-251af522c6d5
43cf8c78-18a0-4abd-8a63-90e664204489	e0a80c5f-b0c2-4830-a8d6-bb99920fa39f
43cf8c78-18a0-4abd-8a63-90e664204489	b27e707e-ed58-4505-a20d-35de1d82cb92
43cf8c78-18a0-4abd-8a63-90e664204489	93d49bd2-4cb5-4c95-8d82-53dddc08657a
43cf8c78-18a0-4abd-8a63-90e664204489	24e53135-6172-4fea-aa45-828dd2baa81c
43cf8c78-18a0-4abd-8a63-90e664204489	266c63c4-e3ba-4a18-bf35-1695a10c9a09
43cf8c78-18a0-4abd-8a63-90e664204489	9b0bbb07-927d-482b-9529-88152786572b
43cf8c78-18a0-4abd-8a63-90e664204489	5158587b-0da6-46ec-8230-e512fc1c1631
43cf8c78-18a0-4abd-8a63-90e664204489	bfa394b0-4163-4f98-8db6-3d3f6c0fbd7f
43cf8c78-18a0-4abd-8a63-90e664204489	a10f130f-680a-47ce-9a9a-73c827162795
43cf8c78-18a0-4abd-8a63-90e664204489	cdd71ce5-3694-4233-9898-4fbb5e344114
24e53135-6172-4fea-aa45-828dd2baa81c	93d49bd2-4cb5-4c95-8d82-53dddc08657a
cdd71ce5-3694-4233-9898-4fbb5e344114	ccfc3214-2eb3-484a-b5f9-86d9e013edf2
cdd71ce5-3694-4233-9898-4fbb5e344114	c36947a9-3d30-4c76-8845-496ec7d01908
3213869f-7ce1-4bcf-9c7a-50193557b1ca	208d4ee9-3790-4c1b-925a-084c62907599
665badf5-9f53-4a3b-bea0-6268d02aa280	9d86012c-5c40-4c04-b8b8-82ad57d8a4af
b19a9b33-3cca-40a0-900d-8fa5fd79675a	276c3977-bdb7-4442-a394-397329553103
f63f36d6-7989-43fa-b74d-cabd2d66a828	1ca136d1-8cd6-4eaa-bf2b-7b47b887f45e
1a4b720e-9278-46d9-93ce-3c0dc7c6f51c	73819e85-b0fc-45c9-9d43-0cd4cfa8edf7
1a4b720e-9278-46d9-93ce-3c0dc7c6f51c	8393c807-bc46-4249-bdec-76afcd5676eb
1a4b720e-9278-46d9-93ce-3c0dc7c6f51c	3213869f-7ce1-4bcf-9c7a-50193557b1ca
1a4b720e-9278-46d9-93ce-3c0dc7c6f51c	5fbde31c-9e26-4bd3-ae04-8126f74569df
ca307c76-8087-436a-a34d-b2cedf5d75d7	c41a715c-2c3d-4abc-ac16-cad7784b222c
ca307c76-8087-436a-a34d-b2cedf5d75d7	de1fa12a-0e9b-4c51-9a7d-0e6e69f44648
ca307c76-8087-436a-a34d-b2cedf5d75d7	5e57000a-9f7b-4d0a-839a-7d6e328ef8aa
ca307c76-8087-436a-a34d-b2cedf5d75d7	37e3b8f2-8f1c-44f3-ae56-e298c46deed0
\.


--
-- Data for Name: credential; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.credential (id, salt, type, user_id, created_date, user_label, secret_data, credential_data, priority, version) FROM stdin;
73c4ebac-8af1-44e5-9f83-d0c3977629a0	\N	password	41d9200c-4676-42f4-ae48-f407bd5db1d8	1553008011849	\N	{"value":"t66D1380wj+VTZQm0ozDQNwa5vHh9xF3xWW0Z/bwyGovU94LwDPeaOBE4gFM+tuOEb8ZgoRuLVZgWrclaIhm9Q==","salt":"8NAZ6PfTX+uUb59rRg+90g=="}	{"hashIterations":27500,"algorithm":"pbkdf2-sha256"}	10	0
f30c94e7-c4c3-472c-8d07-d262d1b59560	\N	password	b25ae075-620c-46f8-880e-42405e06d1d4	1566476493283	\N	{"value":"H+MquOweb9lUysFjp8Y2q9/jGdpFc0mOloc/dEOZNlA=","salt":"G8loX665f0tuIoOSwD1rzA==","additionalParameters":{}}	{"hashIterations":5,"algorithm":"argon2","additionalParameters":{"hashLength":["32"],"memory":["7168"],"type":["id"],"version":["1.3"],"parallelism":["1"]}}	10	1
\.


--
-- Data for Name: databasechangelog; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.databasechangelog (id, author, filename, dateexecuted, orderexecuted, exectype, md5sum, description, comments, tag, liquibase, contexts, labels, deployment_id) FROM stdin;
8.0.0-updating-credential-data-not-oracle	keycloak	META-INF/jpa-changelog-8.0.0.xml	2022-03-07 14:36:25.203058	73	EXECUTED	\N	update tableName=CREDENTIAL; update tableName=CREDENTIAL; update tableName=CREDENTIAL; update tableName=FED_USER_CREDENTIAL; update tableName=FED_USER_CREDENTIAL; update tableName=FED_USER_CREDENTIAL		\N	3.5.4	\N	\N	6663785066
8.0.0-updating-credential-data-oracle	keycloak	META-INF/jpa-changelog-8.0.0.xml	2022-03-07 14:36:25.20854	74	MARK_RAN	\N	update tableName=CREDENTIAL; update tableName=CREDENTIAL; update tableName=CREDENTIAL; update tableName=FED_USER_CREDENTIAL; update tableName=FED_USER_CREDENTIAL; update tableName=FED_USER_CREDENTIAL		\N	3.5.4	\N	\N	6663785066
1.0.0.Final-KEYCLOAK-5461	sthorger@redhat.com	META-INF/jpa-changelog-1.0.0.Final.xml	2019-04-25 13:43:18.960387	1	EXECUTED	9:6f1016664e21e16d26517a4418f5e3df	createTable tableName=APPLICATION_DEFAULT_ROLES; createTable tableName=CLIENT; createTable tableName=CLIENT_SESSION; createTable tableName=CLIENT_SESSION_ROLE; createTable tableName=COMPOSITE_ROLE; createTable tableName=CREDENTIAL; createTable tab...		\N	3.5.4	\N	\N	6199798439
1.0.0.Final-KEYCLOAK-5461	sthorger@redhat.com	META-INF/db2-jpa-changelog-1.0.0.Final.xml	2019-04-25 13:43:18.976732	2	MARK_RAN	9:828775b1596a07d1200ba1d49e5e3941	createTable tableName=APPLICATION_DEFAULT_ROLES; createTable tableName=CLIENT; createTable tableName=CLIENT_SESSION; createTable tableName=CLIENT_SESSION_ROLE; createTable tableName=COMPOSITE_ROLE; createTable tableName=CREDENTIAL; createTable tab...		\N	3.5.4	\N	\N	6199798439
1.1.0.Beta1	sthorger@redhat.com	META-INF/jpa-changelog-1.1.0.Beta1.xml	2019-04-25 13:43:19.035502	3	EXECUTED	9:5f090e44a7d595883c1fb61f4b41fd38	delete tableName=CLIENT_SESSION_ROLE; delete tableName=CLIENT_SESSION; delete tableName=USER_SESSION; createTable tableName=CLIENT_ATTRIBUTES; createTable tableName=CLIENT_SESSION_NOTE; createTable tableName=APP_NODE_REGISTRATIONS; addColumn table...		\N	3.5.4	\N	\N	6199798439
1.1.0.Final	sthorger@redhat.com	META-INF/jpa-changelog-1.1.0.Final.xml	2019-04-25 13:43:19.043064	4	EXECUTED	9:c07e577387a3d2c04d1adc9aaad8730e	renameColumn newColumnName=EVENT_TIME, oldColumnName=TIME, tableName=EVENT_ENTITY		\N	3.5.4	\N	\N	6199798439
1.2.0.Beta1	psilva@redhat.com	META-INF/jpa-changelog-1.2.0.Beta1.xml	2019-04-25 13:43:19.232594	5	EXECUTED	9:b68ce996c655922dbcd2fe6b6ae72686	delete tableName=CLIENT_SESSION_ROLE; delete tableName=CLIENT_SESSION_NOTE; delete tableName=CLIENT_SESSION; delete tableName=USER_SESSION; createTable tableName=PROTOCOL_MAPPER; createTable tableName=PROTOCOL_MAPPER_CONFIG; createTable tableName=...		\N	3.5.4	\N	\N	6199798439
1.2.0.Beta1	psilva@redhat.com	META-INF/db2-jpa-changelog-1.2.0.Beta1.xml	2019-04-25 13:43:19.243743	6	MARK_RAN	9:543b5c9989f024fe35c6f6c5a97de88e	delete tableName=CLIENT_SESSION_ROLE; delete tableName=CLIENT_SESSION_NOTE; delete tableName=CLIENT_SESSION; delete tableName=USER_SESSION; createTable tableName=PROTOCOL_MAPPER; createTable tableName=PROTOCOL_MAPPER_CONFIG; createTable tableName=...		\N	3.5.4	\N	\N	6199798439
1.2.0.RC1	bburke@redhat.com	META-INF/jpa-changelog-1.2.0.CR1.xml	2019-04-25 13:43:19.441994	7	EXECUTED	9:765afebbe21cf5bbca048e632df38336	delete tableName=CLIENT_SESSION_ROLE; delete tableName=CLIENT_SESSION_NOTE; delete tableName=CLIENT_SESSION; delete tableName=USER_SESSION_NOTE; delete tableName=USER_SESSION; createTable tableName=MIGRATION_MODEL; createTable tableName=IDENTITY_P...		\N	3.5.4	\N	\N	6199798439
1.2.0.RC1	bburke@redhat.com	META-INF/db2-jpa-changelog-1.2.0.CR1.xml	2019-04-25 13:43:19.447533	8	MARK_RAN	9:db4a145ba11a6fdaefb397f6dbf829a1	delete tableName=CLIENT_SESSION_ROLE; delete tableName=CLIENT_SESSION_NOTE; delete tableName=CLIENT_SESSION; delete tableName=USER_SESSION_NOTE; delete tableName=USER_SESSION; createTable tableName=MIGRATION_MODEL; createTable tableName=IDENTITY_P...		\N	3.5.4	\N	\N	6199798439
1.2.0.Final	keycloak	META-INF/jpa-changelog-1.2.0.Final.xml	2019-04-25 13:43:19.458812	9	EXECUTED	9:9d05c7be10cdb873f8bcb41bc3a8ab23	update tableName=CLIENT; update tableName=CLIENT; update tableName=CLIENT		\N	3.5.4	\N	\N	6199798439
1.3.0	bburke@redhat.com	META-INF/jpa-changelog-1.3.0.xml	2019-04-25 13:43:19.669014	10	EXECUTED	9:18593702353128d53111f9b1ff0b82b8	delete tableName=CLIENT_SESSION_ROLE; delete tableName=CLIENT_SESSION_PROT_MAPPER; delete tableName=CLIENT_SESSION_NOTE; delete tableName=CLIENT_SESSION; delete tableName=USER_SESSION_NOTE; delete tableName=USER_SESSION; createTable tableName=ADMI...		\N	3.5.4	\N	\N	6199798439
1.4.0	bburke@redhat.com	META-INF/jpa-changelog-1.4.0.xml	2019-04-25 13:43:19.823969	11	EXECUTED	9:6122efe5f090e41a85c0f1c9e52cbb62	delete tableName=CLIENT_SESSION_AUTH_STATUS; delete tableName=CLIENT_SESSION_ROLE; delete tableName=CLIENT_SESSION_PROT_MAPPER; delete tableName=CLIENT_SESSION_NOTE; delete tableName=CLIENT_SESSION; delete tableName=USER_SESSION_NOTE; delete table...		\N	3.5.4	\N	\N	6199798439
1.4.0	bburke@redhat.com	META-INF/db2-jpa-changelog-1.4.0.xml	2019-04-25 13:43:19.829952	12	MARK_RAN	9:e1ff28bf7568451453f844c5d54bb0b5	delete tableName=CLIENT_SESSION_AUTH_STATUS; delete tableName=CLIENT_SESSION_ROLE; delete tableName=CLIENT_SESSION_PROT_MAPPER; delete tableName=CLIENT_SESSION_NOTE; delete tableName=CLIENT_SESSION; delete tableName=USER_SESSION_NOTE; delete table...		\N	3.5.4	\N	\N	6199798439
1.5.0	bburke@redhat.com	META-INF/jpa-changelog-1.5.0.xml	2019-04-25 13:43:19.870667	13	EXECUTED	9:7af32cd8957fbc069f796b61217483fd	delete tableName=CLIENT_SESSION_AUTH_STATUS; delete tableName=CLIENT_SESSION_ROLE; delete tableName=CLIENT_SESSION_PROT_MAPPER; delete tableName=CLIENT_SESSION_NOTE; delete tableName=CLIENT_SESSION; delete tableName=USER_SESSION_NOTE; delete table...		\N	3.5.4	\N	\N	6199798439
1.6.1_from15	mposolda@redhat.com	META-INF/jpa-changelog-1.6.1.xml	2019-04-25 13:43:19.917113	14	EXECUTED	9:6005e15e84714cd83226bf7879f54190	addColumn tableName=REALM; addColumn tableName=KEYCLOAK_ROLE; addColumn tableName=CLIENT; createTable tableName=OFFLINE_USER_SESSION; createTable tableName=OFFLINE_CLIENT_SESSION; addPrimaryKey constraintName=CONSTRAINT_OFFL_US_SES_PK2, tableName=...		\N	3.5.4	\N	\N	6199798439
1.6.1_from16-pre	mposolda@redhat.com	META-INF/jpa-changelog-1.6.1.xml	2019-04-25 13:43:19.921172	15	MARK_RAN	9:bf656f5a2b055d07f314431cae76f06c	delete tableName=OFFLINE_CLIENT_SESSION; delete tableName=OFFLINE_USER_SESSION		\N	3.5.4	\N	\N	6199798439
1.6.1_from16	mposolda@redhat.com	META-INF/jpa-changelog-1.6.1.xml	2019-04-25 13:43:19.931139	16	MARK_RAN	9:f8dadc9284440469dcf71e25ca6ab99b	dropPrimaryKey constraintName=CONSTRAINT_OFFLINE_US_SES_PK, tableName=OFFLINE_USER_SESSION; dropPrimaryKey constraintName=CONSTRAINT_OFFLINE_CL_SES_PK, tableName=OFFLINE_CLIENT_SESSION; addColumn tableName=OFFLINE_USER_SESSION; update tableName=OF...		\N	3.5.4	\N	\N	6199798439
1.6.1	mposolda@redhat.com	META-INF/jpa-changelog-1.6.1.xml	2019-04-25 13:43:19.942123	17	EXECUTED	9:d41d8cd98f00b204e9800998ecf8427e	empty		\N	3.5.4	\N	\N	6199798439
1.7.0	bburke@redhat.com	META-INF/jpa-changelog-1.7.0.xml	2019-04-25 13:43:20.026416	18	EXECUTED	9:3368ff0be4c2855ee2dd9ca813b38d8e	createTable tableName=KEYCLOAK_GROUP; createTable tableName=GROUP_ROLE_MAPPING; createTable tableName=GROUP_ATTRIBUTE; createTable tableName=USER_GROUP_MEMBERSHIP; createTable tableName=REALM_DEFAULT_GROUPS; addColumn tableName=IDENTITY_PROVIDER; ...		\N	3.5.4	\N	\N	6199798439
1.8.0	mposolda@redhat.com	META-INF/jpa-changelog-1.8.0.xml	2019-04-25 13:43:20.089936	19	EXECUTED	9:8ac2fb5dd030b24c0570a763ed75ed20	addColumn tableName=IDENTITY_PROVIDER; createTable tableName=CLIENT_TEMPLATE; createTable tableName=CLIENT_TEMPLATE_ATTRIBUTES; createTable tableName=TEMPLATE_SCOPE_MAPPING; dropNotNullConstraint columnName=CLIENT_ID, tableName=PROTOCOL_MAPPER; ad...		\N	3.5.4	\N	\N	6199798439
1.8.0-2	keycloak	META-INF/jpa-changelog-1.8.0.xml	2019-04-25 13:43:20.104213	20	EXECUTED	9:f91ddca9b19743db60e3057679810e6c	dropDefaultValue columnName=ALGORITHM, tableName=CREDENTIAL; update tableName=CREDENTIAL		\N	3.5.4	\N	\N	6199798439
1.8.0	mposolda@redhat.com	META-INF/db2-jpa-changelog-1.8.0.xml	2019-04-25 13:43:20.10872	21	MARK_RAN	9:831e82914316dc8a57dc09d755f23c51	addColumn tableName=IDENTITY_PROVIDER; createTable tableName=CLIENT_TEMPLATE; createTable tableName=CLIENT_TEMPLATE_ATTRIBUTES; createTable tableName=TEMPLATE_SCOPE_MAPPING; dropNotNullConstraint columnName=CLIENT_ID, tableName=PROTOCOL_MAPPER; ad...		\N	3.5.4	\N	\N	6199798439
1.8.0-2	keycloak	META-INF/db2-jpa-changelog-1.8.0.xml	2019-04-25 13:43:20.112401	22	MARK_RAN	9:f91ddca9b19743db60e3057679810e6c	dropDefaultValue columnName=ALGORITHM, tableName=CREDENTIAL; update tableName=CREDENTIAL		\N	3.5.4	\N	\N	6199798439
1.9.0	mposolda@redhat.com	META-INF/jpa-changelog-1.9.0.xml	2019-04-25 13:43:20.139008	23	EXECUTED	9:bc3d0f9e823a69dc21e23e94c7a94bb1	update tableName=REALM; update tableName=REALM; update tableName=REALM; update tableName=REALM; update tableName=CREDENTIAL; update tableName=CREDENTIAL; update tableName=CREDENTIAL; update tableName=REALM; update tableName=REALM; customChange; dr...		\N	3.5.4	\N	\N	6199798439
1.9.1	keycloak	META-INF/jpa-changelog-1.9.1.xml	2019-04-25 13:43:20.145783	24	EXECUTED	9:c9999da42f543575ab790e76439a2679	modifyDataType columnName=PRIVATE_KEY, tableName=REALM; modifyDataType columnName=PUBLIC_KEY, tableName=REALM; modifyDataType columnName=CERTIFICATE, tableName=REALM		\N	3.5.4	\N	\N	6199798439
1.9.1	keycloak	META-INF/db2-jpa-changelog-1.9.1.xml	2019-04-25 13:43:20.148273	25	MARK_RAN	9:0d6c65c6f58732d81569e77b10ba301d	modifyDataType columnName=PRIVATE_KEY, tableName=REALM; modifyDataType columnName=CERTIFICATE, tableName=REALM		\N	3.5.4	\N	\N	6199798439
1.9.2	keycloak	META-INF/jpa-changelog-1.9.2.xml	2019-04-25 13:43:20.191697	26	EXECUTED	9:fc576660fc016ae53d2d4778d84d86d0	createIndex indexName=IDX_USER_EMAIL, tableName=USER_ENTITY; createIndex indexName=IDX_USER_ROLE_MAPPING, tableName=USER_ROLE_MAPPING; createIndex indexName=IDX_USER_GROUP_MAPPING, tableName=USER_GROUP_MEMBERSHIP; createIndex indexName=IDX_USER_CO...		\N	3.5.4	\N	\N	6199798439
authz-2.0.0	psilva@redhat.com	META-INF/jpa-changelog-authz-2.0.0.xml	2019-04-25 13:43:20.302631	27	EXECUTED	9:43ed6b0da89ff77206289e87eaa9c024	createTable tableName=RESOURCE_SERVER; addPrimaryKey constraintName=CONSTRAINT_FARS, tableName=RESOURCE_SERVER; addUniqueConstraint constraintName=UK_AU8TT6T700S9V50BU18WS5HA6, tableName=RESOURCE_SERVER; createTable tableName=RESOURCE_SERVER_RESOU...		\N	3.5.4	\N	\N	6199798439
authz-2.5.1	psilva@redhat.com	META-INF/jpa-changelog-authz-2.5.1.xml	2019-04-25 13:43:20.307982	28	EXECUTED	9:44bae577f551b3738740281eceb4ea70	update tableName=RESOURCE_SERVER_POLICY		\N	3.5.4	\N	\N	6199798439
2.1.0-KEYCLOAK-5461	bburke@redhat.com	META-INF/jpa-changelog-2.1.0.xml	2019-04-25 13:43:20.424658	29	EXECUTED	9:bd88e1f833df0420b01e114533aee5e8	createTable tableName=BROKER_LINK; createTable tableName=FED_USER_ATTRIBUTE; createTable tableName=FED_USER_CONSENT; createTable tableName=FED_USER_CONSENT_ROLE; createTable tableName=FED_USER_CONSENT_PROT_MAPPER; createTable tableName=FED_USER_CR...		\N	3.5.4	\N	\N	6199798439
2.2.0	bburke@redhat.com	META-INF/jpa-changelog-2.2.0.xml	2019-04-25 13:43:20.443397	30	EXECUTED	9:a7022af5267f019d020edfe316ef4371	addColumn tableName=ADMIN_EVENT_ENTITY; createTable tableName=CREDENTIAL_ATTRIBUTE; createTable tableName=FED_CREDENTIAL_ATTRIBUTE; modifyDataType columnName=VALUE, tableName=CREDENTIAL; addForeignKeyConstraint baseTableName=FED_CREDENTIAL_ATTRIBU...		\N	3.5.4	\N	\N	6199798439
2.3.0	bburke@redhat.com	META-INF/jpa-changelog-2.3.0.xml	2019-04-25 13:43:20.46569	31	EXECUTED	9:fc155c394040654d6a79227e56f5e25a	createTable tableName=FEDERATED_USER; addPrimaryKey constraintName=CONSTR_FEDERATED_USER, tableName=FEDERATED_USER; dropDefaultValue columnName=TOTP, tableName=USER_ENTITY; dropColumn columnName=TOTP, tableName=USER_ENTITY; addColumn tableName=IDE...		\N	3.5.4	\N	\N	6199798439
2.4.0	bburke@redhat.com	META-INF/jpa-changelog-2.4.0.xml	2019-04-25 13:43:20.471102	32	EXECUTED	9:eac4ffb2a14795e5dc7b426063e54d88	customChange		\N	3.5.4	\N	\N	6199798439
2.5.0	bburke@redhat.com	META-INF/jpa-changelog-2.5.0.xml	2019-04-25 13:43:20.47881	33	EXECUTED	9:54937c05672568c4c64fc9524c1e9462	customChange; modifyDataType columnName=USER_ID, tableName=OFFLINE_USER_SESSION		\N	3.5.4	\N	\N	6199798439
2.5.0-unicode-oracle	hmlnarik@redhat.com	META-INF/jpa-changelog-2.5.0.xml	2019-04-25 13:43:20.481363	34	MARK_RAN	9:f9753208029f582525ed12011a19d054	modifyDataType columnName=DESCRIPTION, tableName=AUTHENTICATION_FLOW; modifyDataType columnName=DESCRIPTION, tableName=CLIENT_TEMPLATE; modifyDataType columnName=DESCRIPTION, tableName=RESOURCE_SERVER_POLICY; modifyDataType columnName=DESCRIPTION,...		\N	3.5.4	\N	\N	6199798439
2.5.0-unicode-other-dbs	hmlnarik@redhat.com	META-INF/jpa-changelog-2.5.0.xml	2019-04-25 13:43:20.529777	35	EXECUTED	9:33d72168746f81f98ae3a1e8e0ca3554	modifyDataType columnName=DESCRIPTION, tableName=AUTHENTICATION_FLOW; modifyDataType columnName=DESCRIPTION, tableName=CLIENT_TEMPLATE; modifyDataType columnName=DESCRIPTION, tableName=RESOURCE_SERVER_POLICY; modifyDataType columnName=DESCRIPTION,...		\N	3.5.4	\N	\N	6199798439
2.5.0-duplicate-email-support	slawomir@dabek.name	META-INF/jpa-changelog-2.5.0.xml	2019-04-25 13:43:20.544114	36	EXECUTED	9:61b6d3d7a4c0e0024b0c839da283da0c	addColumn tableName=REALM		\N	3.5.4	\N	\N	6199798439
2.5.0-unique-group-names	hmlnarik@redhat.com	META-INF/jpa-changelog-2.5.0.xml	2019-04-25 13:43:20.552472	37	EXECUTED	9:8dcac7bdf7378e7d823cdfddebf72fda	addUniqueConstraint constraintName=SIBLING_NAMES, tableName=KEYCLOAK_GROUP		\N	3.5.4	\N	\N	6199798439
2.5.1	bburke@redhat.com	META-INF/jpa-changelog-2.5.1.xml	2019-04-25 13:43:20.555997	38	EXECUTED	9:a2b870802540cb3faa72098db5388af3	addColumn tableName=FED_USER_CONSENT		\N	3.5.4	\N	\N	6199798439
3.0.0	bburke@redhat.com	META-INF/jpa-changelog-3.0.0.xml	2019-04-25 13:43:20.559584	39	EXECUTED	9:132a67499ba24bcc54fb5cbdcfe7e4c0	addColumn tableName=IDENTITY_PROVIDER		\N	3.5.4	\N	\N	6199798439
3.2.0-fix	keycloak	META-INF/jpa-changelog-3.2.0.xml	2019-04-25 13:43:20.562026	40	MARK_RAN	9:938f894c032f5430f2b0fafb1a243462	addNotNullConstraint columnName=REALM_ID, tableName=CLIENT_INITIAL_ACCESS		\N	3.5.4	\N	\N	6199798439
3.2.0-fix-with-keycloak-5416	keycloak	META-INF/jpa-changelog-3.2.0.xml	2019-04-25 13:43:20.564659	41	MARK_RAN	9:845c332ff1874dc5d35974b0babf3006	dropIndex indexName=IDX_CLIENT_INIT_ACC_REALM, tableName=CLIENT_INITIAL_ACCESS; addNotNullConstraint columnName=REALM_ID, tableName=CLIENT_INITIAL_ACCESS; createIndex indexName=IDX_CLIENT_INIT_ACC_REALM, tableName=CLIENT_INITIAL_ACCESS		\N	3.5.4	\N	\N	6199798439
3.2.0-fix-offline-sessions	hmlnarik	META-INF/jpa-changelog-3.2.0.xml	2019-04-25 13:43:20.572207	42	EXECUTED	9:fc86359c079781adc577c5a217e4d04c	customChange		\N	3.5.4	\N	\N	6199798439
3.2.0-fixed	keycloak	META-INF/jpa-changelog-3.2.0.xml	2019-04-25 13:43:20.798408	43	EXECUTED	9:59a64800e3c0d09b825f8a3b444fa8f4	addColumn tableName=REALM; dropPrimaryKey constraintName=CONSTRAINT_OFFL_CL_SES_PK2, tableName=OFFLINE_CLIENT_SESSION; dropColumn columnName=CLIENT_SESSION_ID, tableName=OFFLINE_CLIENT_SESSION; addPrimaryKey constraintName=CONSTRAINT_OFFL_CL_SES_P...		\N	3.5.4	\N	\N	6199798439
3.3.0	keycloak	META-INF/jpa-changelog-3.3.0.xml	2019-04-25 13:43:20.804515	44	EXECUTED	9:d48d6da5c6ccf667807f633fe489ce88	addColumn tableName=USER_ENTITY		\N	3.5.4	\N	\N	6199798439
authz-3.4.0.CR1-resource-server-pk-change-part1	glavoie@gmail.com	META-INF/jpa-changelog-authz-3.4.0.CR1.xml	2019-04-25 13:43:20.8093	45	EXECUTED	9:dde36f7973e80d71fceee683bc5d2951	addColumn tableName=RESOURCE_SERVER_POLICY; addColumn tableName=RESOURCE_SERVER_RESOURCE; addColumn tableName=RESOURCE_SERVER_SCOPE		\N	3.5.4	\N	\N	6199798439
authz-3.4.0.CR1-resource-server-pk-change-part2-KEYCLOAK-6095	hmlnarik@redhat.com	META-INF/jpa-changelog-authz-3.4.0.CR1.xml	2019-04-25 13:43:20.814184	46	EXECUTED	9:b855e9b0a406b34fa323235a0cf4f640	customChange		\N	3.5.4	\N	\N	6199798439
authz-3.4.0.CR1-resource-server-pk-change-part3-fixed	glavoie@gmail.com	META-INF/jpa-changelog-authz-3.4.0.CR1.xml	2019-04-25 13:43:20.816654	47	MARK_RAN	9:51abbacd7b416c50c4421a8cabf7927e	dropIndex indexName=IDX_RES_SERV_POL_RES_SERV, tableName=RESOURCE_SERVER_POLICY; dropIndex indexName=IDX_RES_SRV_RES_RES_SRV, tableName=RESOURCE_SERVER_RESOURCE; dropIndex indexName=IDX_RES_SRV_SCOPE_RES_SRV, tableName=RESOURCE_SERVER_SCOPE		\N	3.5.4	\N	\N	6199798439
authz-3.4.0.CR1-resource-server-pk-change-part3-fixed-nodropindex	glavoie@gmail.com	META-INF/jpa-changelog-authz-3.4.0.CR1.xml	2019-04-25 13:43:20.87226	48	EXECUTED	9:bdc99e567b3398bac83263d375aad143	addNotNullConstraint columnName=RESOURCE_SERVER_CLIENT_ID, tableName=RESOURCE_SERVER_POLICY; addNotNullConstraint columnName=RESOURCE_SERVER_CLIENT_ID, tableName=RESOURCE_SERVER_RESOURCE; addNotNullConstraint columnName=RESOURCE_SERVER_CLIENT_ID, ...		\N	3.5.4	\N	\N	6199798439
authn-3.4.0.CR1-refresh-token-max-reuse	glavoie@gmail.com	META-INF/jpa-changelog-authz-3.4.0.CR1.xml	2019-04-25 13:43:20.877691	49	EXECUTED	9:d198654156881c46bfba39abd7769e69	addColumn tableName=REALM		\N	3.5.4	\N	\N	6199798439
3.4.0	keycloak	META-INF/jpa-changelog-3.4.0.xml	2019-04-25 13:43:20.985783	50	EXECUTED	9:cfdd8736332ccdd72c5256ccb42335db	addPrimaryKey constraintName=CONSTRAINT_REALM_DEFAULT_ROLES, tableName=REALM_DEFAULT_ROLES; addPrimaryKey constraintName=CONSTRAINT_COMPOSITE_ROLE, tableName=COMPOSITE_ROLE; addPrimaryKey constraintName=CONSTR_REALM_DEFAULT_GROUPS, tableName=REALM...		\N	3.5.4	\N	\N	6199798439
3.4.0-KEYCLOAK-5230	hmlnarik@redhat.com	META-INF/jpa-changelog-3.4.0.xml	2019-04-25 13:43:21.069384	51	EXECUTED	9:7c84de3d9bd84d7f077607c1a4dcb714	createIndex indexName=IDX_FU_ATTRIBUTE, tableName=FED_USER_ATTRIBUTE; createIndex indexName=IDX_FU_CONSENT, tableName=FED_USER_CONSENT; createIndex indexName=IDX_FU_CONSENT_RU, tableName=FED_USER_CONSENT; createIndex indexName=IDX_FU_CREDENTIAL, t...		\N	3.5.4	\N	\N	6199798439
3.4.1	psilva@redhat.com	META-INF/jpa-changelog-3.4.1.xml	2019-04-25 13:43:21.075525	52	EXECUTED	9:5a6bb36cbefb6a9d6928452c0852af2d	modifyDataType columnName=VALUE, tableName=CLIENT_ATTRIBUTES		\N	3.5.4	\N	\N	6199798439
3.4.2	keycloak	META-INF/jpa-changelog-3.4.2.xml	2019-04-25 13:43:21.080829	53	EXECUTED	9:8f23e334dbc59f82e0a328373ca6ced0	update tableName=REALM		\N	3.5.4	\N	\N	6199798439
3.4.2-KEYCLOAK-5172	mkanis@redhat.com	META-INF/jpa-changelog-3.4.2.xml	2019-04-25 13:43:21.094538	54	EXECUTED	9:9156214268f09d970cdf0e1564d866af	update tableName=CLIENT		\N	3.5.4	\N	\N	6199798439
4.0.0-KEYCLOAK-6335	bburke@redhat.com	META-INF/jpa-changelog-4.0.0.xml	2019-04-25 13:43:21.117166	55	EXECUTED	9:db806613b1ed154826c02610b7dbdf74	createTable tableName=CLIENT_AUTH_FLOW_BINDINGS; addPrimaryKey constraintName=C_CLI_FLOW_BIND, tableName=CLIENT_AUTH_FLOW_BINDINGS		\N	3.5.4	\N	\N	6199798439
4.0.0-CLEANUP-UNUSED-TABLE	bburke@redhat.com	META-INF/jpa-changelog-4.0.0.xml	2019-04-25 13:43:21.12466	56	EXECUTED	9:229a041fb72d5beac76bb94a5fa709de	dropTable tableName=CLIENT_IDENTITY_PROV_MAPPING		\N	3.5.4	\N	\N	6199798439
4.0.0-KEYCLOAK-6228	bburke@redhat.com	META-INF/jpa-changelog-4.0.0.xml	2019-04-25 13:43:21.152134	57	EXECUTED	9:079899dade9c1e683f26b2aa9ca6ff04	dropUniqueConstraint constraintName=UK_JKUWUVD56ONTGSUHOGM8UEWRT, tableName=USER_CONSENT; dropNotNullConstraint columnName=CLIENT_ID, tableName=USER_CONSENT; addColumn tableName=USER_CONSENT; addUniqueConstraint constraintName=UK_JKUWUVD56ONTGSUHO...		\N	3.5.4	\N	\N	6199798439
4.0.0-KEYCLOAK-5579-fixed	mposolda@redhat.com	META-INF/jpa-changelog-4.0.0.xml	2019-04-25 13:43:21.325644	58	EXECUTED	9:139b79bcbbfe903bb1c2d2a4dbf001d9	dropForeignKeyConstraint baseTableName=CLIENT_TEMPLATE_ATTRIBUTES, constraintName=FK_CL_TEMPL_ATTR_TEMPL; renameTable newTableName=CLIENT_SCOPE_ATTRIBUTES, oldTableName=CLIENT_TEMPLATE_ATTRIBUTES; renameColumn newColumnName=SCOPE_ID, oldColumnName...		\N	3.5.4	\N	\N	6199798439
authz-4.0.0.CR1	psilva@redhat.com	META-INF/jpa-changelog-authz-4.0.0.CR1.xml	2019-04-25 13:43:21.376221	59	EXECUTED	9:b55738ad889860c625ba2bf483495a04	createTable tableName=RESOURCE_SERVER_PERM_TICKET; addPrimaryKey constraintName=CONSTRAINT_FAPMT, tableName=RESOURCE_SERVER_PERM_TICKET; addForeignKeyConstraint baseTableName=RESOURCE_SERVER_PERM_TICKET, constraintName=FK_FRSRHO213XCX4WNKOG82SSPMT...		\N	3.5.4	\N	\N	6199798439
authz-4.0.0.Beta3	psilva@redhat.com	META-INF/jpa-changelog-authz-4.0.0.Beta3.xml	2019-04-25 13:43:21.392332	60	EXECUTED	9:e0057eac39aa8fc8e09ac6cfa4ae15fe	addColumn tableName=RESOURCE_SERVER_POLICY; addColumn tableName=RESOURCE_SERVER_PERM_TICKET; addForeignKeyConstraint baseTableName=RESOURCE_SERVER_PERM_TICKET, constraintName=FK_FRSRPO2128CX4WNKOG82SSRFY, referencedTableName=RESOURCE_SERVER_POLICY		\N	3.5.4	\N	\N	6199798439
authz-4.2.0.Final	mhajas@redhat.com	META-INF/jpa-changelog-authz-4.2.0.Final.xml	2019-04-25 13:43:21.406453	61	EXECUTED	9:42a33806f3a0443fe0e7feeec821326c	createTable tableName=RESOURCE_URIS; addForeignKeyConstraint baseTableName=RESOURCE_URIS, constraintName=FK_RESOURCE_SERVER_URIS, referencedTableName=RESOURCE_SERVER_RESOURCE; customChange; dropColumn columnName=URI, tableName=RESOURCE_SERVER_RESO...		\N	3.5.4	\N	\N	6199798439
4.2.0-KEYCLOAK-6313	wadahiro@gmail.com	META-INF/jpa-changelog-4.2.0.xml	2019-04-25 13:43:21.412	62	EXECUTED	9:92143a6daea0a3f3b8f598c97ce55c3d	addColumn tableName=REQUIRED_ACTION_PROVIDER		\N	3.5.4	\N	\N	6199798439
4.3.0-KEYCLOAK-7984	wadahiro@gmail.com	META-INF/jpa-changelog-4.3.0.xml	2019-04-25 13:43:21.416297	63	EXECUTED	9:82bab26a27195d889fb0429003b18f40	update tableName=REQUIRED_ACTION_PROVIDER		\N	3.5.4	\N	\N	6199798439
4.6.0-KEYCLOAK-7950	psilva@redhat.com	META-INF/jpa-changelog-4.6.0.xml	2019-04-25 13:43:21.421236	64	EXECUTED	9:e590c88ddc0b38b0ae4249bbfcb5abc3	update tableName=RESOURCE_SERVER_RESOURCE		\N	3.5.4	\N	\N	6199798439
4.6.0-KEYCLOAK-8377	keycloak	META-INF/jpa-changelog-4.6.0.xml	2019-04-25 13:43:21.444496	65	EXECUTED	9:5c1f475536118dbdc38d5d7977950cc0	createTable tableName=ROLE_ATTRIBUTE; addPrimaryKey constraintName=CONSTRAINT_ROLE_ATTRIBUTE_PK, tableName=ROLE_ATTRIBUTE; addForeignKeyConstraint baseTableName=ROLE_ATTRIBUTE, constraintName=FK_ROLE_ATTRIBUTE_ID, referencedTableName=KEYCLOAK_ROLE...		\N	3.5.4	\N	\N	6199798439
4.6.0-KEYCLOAK-8555	gideonray@gmail.com	META-INF/jpa-changelog-4.6.0.xml	2019-04-25 13:43:21.45372	66	EXECUTED	9:e7c9f5f9c4d67ccbbcc215440c718a17	createIndex indexName=IDX_COMPONENT_PROVIDER_TYPE, tableName=COMPONENT		\N	3.5.4	\N	\N	6199798439
4.7.0-KEYCLOAK-1267	sguilhen@redhat.com	META-INF/jpa-changelog-4.7.0.xml	2019-04-25 13:43:21.460696	67	EXECUTED	9:88e0bfdda924690d6f4e430c53447dd5	addColumn tableName=REALM		\N	3.5.4	\N	\N	6199798439
4.7.0-KEYCLOAK-7275	keycloak	META-INF/jpa-changelog-4.7.0.xml	2019-04-25 13:43:21.497648	68	EXECUTED	9:f53177f137e1c46b6a88c59ec1cb5218	renameColumn newColumnName=CREATED_ON, oldColumnName=LAST_SESSION_REFRESH, tableName=OFFLINE_USER_SESSION; addNotNullConstraint columnName=CREATED_ON, tableName=OFFLINE_USER_SESSION; addColumn tableName=OFFLINE_USER_SESSION; customChange; createIn...		\N	3.5.4	\N	\N	6199798439
4.8.0-KEYCLOAK-8835	sguilhen@redhat.com	META-INF/jpa-changelog-4.8.0.xml	2019-04-25 13:43:21.503147	69	EXECUTED	9:a74d33da4dc42a37ec27121580d1459f	addNotNullConstraint columnName=SSO_MAX_LIFESPAN_REMEMBER_ME, tableName=REALM; addNotNullConstraint columnName=SSO_IDLE_TIMEOUT_REMEMBER_ME, tableName=REALM		\N	3.5.4	\N	\N	6199798439
authz-4.2.0.Final-KEYCLOAK-9944	hmlnarik@redhat.com	META-INF/jpa-changelog-authz-4.2.0.Final.xml	2022-03-07 14:36:25.114626	70	EXECUTED	9:9968206fca46eecc1f51db9c024bfe56	addPrimaryKey constraintName=CONSTRAINT_RESOUR_URIS_PK, tableName=RESOURCE_URIS		\N	3.5.4	\N	\N	6663785066
authz-7.0.0-KEYCLOAK-10443	psilva@redhat.com	META-INF/jpa-changelog-authz-7.0.0.xml	2022-03-07 14:36:25.160822	71	EXECUTED	9:fd4ade7b90c3b67fae0bfcfcb42dfb5f	addColumn tableName=RESOURCE_SERVER		\N	3.5.4	\N	\N	6663785066
8.0.0-adding-credential-columns	keycloak	META-INF/jpa-changelog-8.0.0.xml	2022-03-07 14:36:25.183273	72	EXECUTED	9:aa072ad090bbba210d8f18781b8cebf4	addColumn tableName=CREDENTIAL; addColumn tableName=FED_USER_CREDENTIAL		\N	3.5.4	\N	\N	6663785066
8.0.0-credential-cleanup-fixed	keycloak	META-INF/jpa-changelog-8.0.0.xml	2022-03-07 14:36:25.255203	75	EXECUTED	9:2b9cc12779be32c5b40e2e67711a218b	dropDefaultValue columnName=COUNTER, tableName=CREDENTIAL; dropDefaultValue columnName=DIGITS, tableName=CREDENTIAL; dropDefaultValue columnName=PERIOD, tableName=CREDENTIAL; dropDefaultValue columnName=ALGORITHM, tableName=CREDENTIAL; dropColumn ...		\N	3.5.4	\N	\N	6663785066
8.0.0-resource-tag-support	keycloak	META-INF/jpa-changelog-8.0.0.xml	2022-03-07 14:36:25.272346	76	EXECUTED	9:91fa186ce7a5af127a2d7a91ee083cc5	addColumn tableName=MIGRATION_MODEL; createIndex indexName=IDX_UPDATE_TIME, tableName=MIGRATION_MODEL		\N	3.5.4	\N	\N	6663785066
9.0.0-always-display-client	keycloak	META-INF/jpa-changelog-9.0.0.xml	2022-03-07 14:36:25.286507	77	EXECUTED	9:6335e5c94e83a2639ccd68dd24e2e5ad	addColumn tableName=CLIENT		\N	3.5.4	\N	\N	6663785066
9.0.0-drop-constraints-for-column-increase	keycloak	META-INF/jpa-changelog-9.0.0.xml	2022-03-07 14:36:25.293576	78	MARK_RAN	9:6bdb5658951e028bfe16fa0a8228b530	dropUniqueConstraint constraintName=UK_FRSR6T700S9V50BU18WS5PMT, tableName=RESOURCE_SERVER_PERM_TICKET; dropUniqueConstraint constraintName=UK_FRSR6T700S9V50BU18WS5HA6, tableName=RESOURCE_SERVER_RESOURCE; dropPrimaryKey constraintName=CONSTRAINT_O...		\N	3.5.4	\N	\N	6663785066
9.0.0-increase-column-size-federated-fk	keycloak	META-INF/jpa-changelog-9.0.0.xml	2022-03-07 14:36:25.328326	79	EXECUTED	9:d5bc15a64117ccad481ce8792d4c608f	modifyDataType columnName=CLIENT_ID, tableName=FED_USER_CONSENT; modifyDataType columnName=CLIENT_REALM_CONSTRAINT, tableName=KEYCLOAK_ROLE; modifyDataType columnName=OWNER, tableName=RESOURCE_SERVER_POLICY; modifyDataType columnName=CLIENT_ID, ta...		\N	3.5.4	\N	\N	6663785066
9.0.0-recreate-constraints-after-column-increase	keycloak	META-INF/jpa-changelog-9.0.0.xml	2022-03-07 14:36:25.332567	80	MARK_RAN	9:077cba51999515f4d3e7ad5619ab592c	addNotNullConstraint columnName=CLIENT_ID, tableName=OFFLINE_CLIENT_SESSION; addNotNullConstraint columnName=OWNER, tableName=RESOURCE_SERVER_PERM_TICKET; addNotNullConstraint columnName=REQUESTER, tableName=RESOURCE_SERVER_PERM_TICKET; addNotNull...		\N	3.5.4	\N	\N	6663785066
9.0.1-add-index-to-client.client_id	keycloak	META-INF/jpa-changelog-9.0.1.xml	2022-03-07 14:36:25.34309	81	EXECUTED	9:be969f08a163bf47c6b9e9ead8ac2afb	createIndex indexName=IDX_CLIENT_ID, tableName=CLIENT		\N	3.5.4	\N	\N	6663785066
9.0.1-KEYCLOAK-12579-drop-constraints	keycloak	META-INF/jpa-changelog-9.0.1.xml	2022-03-07 14:36:25.347074	82	MARK_RAN	9:6d3bb4408ba5a72f39bd8a0b301ec6e3	dropUniqueConstraint constraintName=SIBLING_NAMES, tableName=KEYCLOAK_GROUP		\N	3.5.4	\N	\N	6663785066
9.0.1-KEYCLOAK-12579-add-not-null-constraint	keycloak	META-INF/jpa-changelog-9.0.1.xml	2022-03-07 14:36:25.354599	83	EXECUTED	9:966bda61e46bebf3cc39518fbed52fa7	addNotNullConstraint columnName=PARENT_GROUP, tableName=KEYCLOAK_GROUP		\N	3.5.4	\N	\N	6663785066
9.0.1-KEYCLOAK-12579-recreate-constraints	keycloak	META-INF/jpa-changelog-9.0.1.xml	2022-03-07 14:36:25.357996	84	MARK_RAN	9:8dcac7bdf7378e7d823cdfddebf72fda	addUniqueConstraint constraintName=SIBLING_NAMES, tableName=KEYCLOAK_GROUP		\N	3.5.4	\N	\N	6663785066
9.0.1-add-index-to-events	keycloak	META-INF/jpa-changelog-9.0.1.xml	2022-03-07 14:36:25.367233	85	EXECUTED	9:7d93d602352a30c0c317e6a609b56599	createIndex indexName=IDX_EVENT_TIME, tableName=EVENT_ENTITY		\N	3.5.4	\N	\N	6663785066
map-remove-ri	keycloak	META-INF/jpa-changelog-11.0.0.xml	2022-03-07 14:36:25.375245	86	EXECUTED	9:71c5969e6cdd8d7b6f47cebc86d37627	dropForeignKeyConstraint baseTableName=REALM, constraintName=FK_TRAF444KK6QRKMS7N56AIWQ5Y; dropForeignKeyConstraint baseTableName=KEYCLOAK_ROLE, constraintName=FK_KJHO5LE2C0RAL09FL8CM9WFW9		\N	3.5.4	\N	\N	6663785066
map-remove-ri	keycloak	META-INF/jpa-changelog-12.0.0.xml	2022-03-07 14:36:25.3847	87	EXECUTED	9:a9ba7d47f065f041b7da856a81762021	dropForeignKeyConstraint baseTableName=REALM_DEFAULT_GROUPS, constraintName=FK_DEF_GROUPS_GROUP; dropForeignKeyConstraint baseTableName=REALM_DEFAULT_ROLES, constraintName=FK_H4WPD7W4HSOOLNI3H0SW7BTJE; dropForeignKeyConstraint baseTableName=CLIENT...		\N	3.5.4	\N	\N	6663785066
12.1.0-add-realm-localization-table	keycloak	META-INF/jpa-changelog-12.0.0.xml	2022-03-07 14:36:25.399504	88	EXECUTED	9:fffabce2bc01e1a8f5110d5278500065	createTable tableName=REALM_LOCALIZATIONS; addPrimaryKey tableName=REALM_LOCALIZATIONS		\N	3.5.4	\N	\N	6663785066
8.0.0-updating-credential-data-not-oracle-fixed	keycloak	META-INF/jpa-changelog-8.0.0.xml	2022-03-21 12:07:54.553274	89	MARK_RAN	9:1ae6be29bab7c2aa376f6983b932be37	update tableName=CREDENTIAL; update tableName=CREDENTIAL; update tableName=CREDENTIAL; update tableName=FED_USER_CREDENTIAL; update tableName=FED_USER_CREDENTIAL; update tableName=FED_USER_CREDENTIAL		\N	3.5.4	\N	\N	7864474317
8.0.0-updating-credential-data-oracle-fixed	keycloak	META-INF/jpa-changelog-8.0.0.xml	2022-03-21 12:07:54.568454	90	MARK_RAN	9:14706f286953fc9a25286dbd8fb30d97	update tableName=CREDENTIAL; update tableName=CREDENTIAL; update tableName=CREDENTIAL; update tableName=FED_USER_CREDENTIAL; update tableName=FED_USER_CREDENTIAL; update tableName=FED_USER_CREDENTIAL		\N	3.5.4	\N	\N	7864474317
default-roles	keycloak	META-INF/jpa-changelog-13.0.0.xml	2022-03-21 12:07:54.762571	91	EXECUTED	9:fa8a5b5445e3857f4b010bafb5009957	addColumn tableName=REALM; customChange		\N	3.5.4	\N	\N	7864474317
default-roles-cleanup	keycloak	META-INF/jpa-changelog-13.0.0.xml	2022-03-21 12:07:54.789402	92	EXECUTED	9:67ac3241df9a8582d591c5ed87125f39	dropTable tableName=REALM_DEFAULT_ROLES; dropTable tableName=CLIENT_DEFAULT_ROLES		\N	3.5.4	\N	\N	7864474317
13.0.0-KEYCLOAK-16844	keycloak	META-INF/jpa-changelog-13.0.0.xml	2022-03-21 12:07:54.813301	93	EXECUTED	9:ad1194d66c937e3ffc82386c050ba089	createIndex indexName=IDX_OFFLINE_USS_PRELOAD, tableName=OFFLINE_USER_SESSION		\N	3.5.4	\N	\N	7864474317
map-remove-ri-13.0.0	keycloak	META-INF/jpa-changelog-13.0.0.xml	2022-03-21 12:07:54.862346	94	EXECUTED	9:d9be619d94af5a2f5d07b9f003543b91	dropForeignKeyConstraint baseTableName=DEFAULT_CLIENT_SCOPE, constraintName=FK_R_DEF_CLI_SCOPE_SCOPE; dropForeignKeyConstraint baseTableName=CLIENT_SCOPE_CLIENT, constraintName=FK_C_CLI_SCOPE_SCOPE; dropForeignKeyConstraint baseTableName=CLIENT_SC...		\N	3.5.4	\N	\N	7864474317
13.0.0-KEYCLOAK-17992-drop-constraints	keycloak	META-INF/jpa-changelog-13.0.0.xml	2022-03-21 12:07:54.871921	95	MARK_RAN	9:544d201116a0fcc5a5da0925fbbc3bde	dropPrimaryKey constraintName=C_CLI_SCOPE_BIND, tableName=CLIENT_SCOPE_CLIENT; dropIndex indexName=IDX_CLSCOPE_CL, tableName=CLIENT_SCOPE_CLIENT; dropIndex indexName=IDX_CL_CLSCOPE, tableName=CLIENT_SCOPE_CLIENT		\N	3.5.4	\N	\N	7864474317
13.0.0-increase-column-size-federated	keycloak	META-INF/jpa-changelog-13.0.0.xml	2022-03-21 12:07:54.919574	96	EXECUTED	9:43c0c1055b6761b4b3e89de76d612ccf	modifyDataType columnName=CLIENT_ID, tableName=CLIENT_SCOPE_CLIENT; modifyDataType columnName=SCOPE_ID, tableName=CLIENT_SCOPE_CLIENT		\N	3.5.4	\N	\N	7864474317
13.0.0-KEYCLOAK-17992-recreate-constraints	keycloak	META-INF/jpa-changelog-13.0.0.xml	2022-03-21 12:07:54.947792	97	MARK_RAN	9:8bd711fd0330f4fe980494ca43ab1139	addNotNullConstraint columnName=CLIENT_ID, tableName=CLIENT_SCOPE_CLIENT; addNotNullConstraint columnName=SCOPE_ID, tableName=CLIENT_SCOPE_CLIENT; addPrimaryKey constraintName=C_CLI_SCOPE_BIND, tableName=CLIENT_SCOPE_CLIENT; createIndex indexName=...		\N	3.5.4	\N	\N	7864474317
json-string-accomodation-fixed	keycloak	META-INF/jpa-changelog-13.0.0.xml	2022-03-21 12:07:55.019256	98	EXECUTED	9:e07d2bc0970c348bb06fb63b1f82ddbf	addColumn tableName=REALM_ATTRIBUTE; update tableName=REALM_ATTRIBUTE; dropColumn columnName=VALUE, tableName=REALM_ATTRIBUTE; renameColumn newColumnName=VALUE, oldColumnName=VALUE_NEW, tableName=REALM_ATTRIBUTE		\N	3.5.4	\N	\N	7864474317
14.0.0-KEYCLOAK-11019	keycloak	META-INF/jpa-changelog-14.0.0.xml	2022-03-21 12:07:55.055555	99	EXECUTED	9:24fb8611e97f29989bea412aa38d12b7	createIndex indexName=IDX_OFFLINE_CSS_PRELOAD, tableName=OFFLINE_CLIENT_SESSION; createIndex indexName=IDX_OFFLINE_USS_BY_USER, tableName=OFFLINE_USER_SESSION; createIndex indexName=IDX_OFFLINE_USS_BY_USERSESS, tableName=OFFLINE_USER_SESSION		\N	3.5.4	\N	\N	7864474317
14.0.0-KEYCLOAK-18286	keycloak	META-INF/jpa-changelog-14.0.0.xml	2022-03-21 12:07:55.069771	100	MARK_RAN	9:259f89014ce2506ee84740cbf7163aa7	createIndex indexName=IDX_CLIENT_ATT_BY_NAME_VALUE, tableName=CLIENT_ATTRIBUTES		\N	3.5.4	\N	\N	7864474317
14.0.0-KEYCLOAK-18286-revert	keycloak	META-INF/jpa-changelog-14.0.0.xml	2022-03-21 12:07:55.088706	101	MARK_RAN	9:04baaf56c116ed19951cbc2cca584022	dropIndex indexName=IDX_CLIENT_ATT_BY_NAME_VALUE, tableName=CLIENT_ATTRIBUTES		\N	3.5.4	\N	\N	7864474317
14.0.0-KEYCLOAK-18286-supported-dbs	keycloak	META-INF/jpa-changelog-14.0.0.xml	2022-03-21 12:07:55.118816	102	EXECUTED	9:60ca84a0f8c94ec8c3504a5a3bc88ee8	createIndex indexName=IDX_CLIENT_ATT_BY_NAME_VALUE, tableName=CLIENT_ATTRIBUTES		\N	3.5.4	\N	\N	7864474317
14.0.0-KEYCLOAK-18286-unsupported-dbs	keycloak	META-INF/jpa-changelog-14.0.0.xml	2022-03-21 12:07:55.129428	103	MARK_RAN	9:d3d977031d431db16e2c181ce49d73e9	createIndex indexName=IDX_CLIENT_ATT_BY_NAME_VALUE, tableName=CLIENT_ATTRIBUTES		\N	3.5.4	\N	\N	7864474317
KEYCLOAK-17267-add-index-to-user-attributes	keycloak	META-INF/jpa-changelog-14.0.0.xml	2022-03-21 12:07:55.147335	104	EXECUTED	9:0b305d8d1277f3a89a0a53a659ad274c	createIndex indexName=IDX_USER_ATTRIBUTE_NAME, tableName=USER_ATTRIBUTE		\N	3.5.4	\N	\N	7864474317
KEYCLOAK-18146-add-saml-art-binding-identifier	keycloak	META-INF/jpa-changelog-14.0.0.xml	2022-03-21 12:07:55.174861	105	EXECUTED	9:2c374ad2cdfe20e2905a84c8fac48460	customChange		\N	3.5.4	\N	\N	7864474317
15.0.0-KEYCLOAK-18467	keycloak	META-INF/jpa-changelog-15.0.0.xml	2022-03-21 12:07:55.20202	106	EXECUTED	9:47a760639ac597360a8219f5b768b4de	addColumn tableName=REALM_LOCALIZATIONS; update tableName=REALM_LOCALIZATIONS; dropColumn columnName=TEXTS, tableName=REALM_LOCALIZATIONS; renameColumn newColumnName=TEXTS, oldColumnName=TEXTS_NEW, tableName=REALM_LOCALIZATIONS; addNotNullConstrai...		\N	3.5.4	\N	\N	7864474317
17.0.0-9562	keycloak	META-INF/jpa-changelog-17.0.0.xml	2023-03-15 10:29:08.973526	107	EXECUTED	9:a6272f0576727dd8cad2522335f5d99e	createIndex indexName=IDX_USER_SERVICE_ACCOUNT, tableName=USER_ENTITY		\N	4.8.0	\N	\N	8876148799
18.0.0-10625-IDX_ADMIN_EVENT_TIME	keycloak	META-INF/jpa-changelog-18.0.0.xml	2023-03-15 10:29:09.011351	108	EXECUTED	9:015479dbd691d9cc8669282f4828c41d	createIndex indexName=IDX_ADMIN_EVENT_TIME, tableName=ADMIN_EVENT_ENTITY		\N	4.8.0	\N	\N	8876148799
18.0.15-30992-index-consent	keycloak	META-INF/jpa-changelog-18.0.15.xml	2025-10-14 07:37:10.490967	113	EXECUTED	9:80071ede7a05604b1f4906f3bf3b00f0	createIndex indexName=IDX_USCONSENT_SCOPE_ID, tableName=USER_CONSENT_CLIENT_SCOPE		\N	4.29.1	\N	\N	0427430424
19.0.0-10135	keycloak	META-INF/jpa-changelog-19.0.0.xml	2023-03-15 10:29:09.081405	109	EXECUTED	9:9518e495fdd22f78ad6425cc30630221	customChange		\N	4.8.0	\N	\N	8876148799
20.0.0-12964-supported-dbs	keycloak	META-INF/jpa-changelog-20.0.0.xml	2023-03-15 10:29:09.090192	110	EXECUTED	9:e5f243877199fd96bcc842f27a1656ac	createIndex indexName=IDX_GROUP_ATT_BY_NAME_VALUE, tableName=GROUP_ATTRIBUTE		\N	4.8.0	\N	\N	8876148799
20.0.0-12964-unsupported-dbs	keycloak	META-INF/jpa-changelog-20.0.0.xml	2023-03-15 10:29:09.100036	111	MARK_RAN	9:1a6fcaa85e20bdeae0a9ce49b41946a5	createIndex indexName=IDX_GROUP_ATT_BY_NAME_VALUE, tableName=GROUP_ATTRIBUTE		\N	4.8.0	\N	\N	8876148799
client-attributes-string-accomodation-fixed	keycloak	META-INF/jpa-changelog-20.0.0.xml	2023-03-15 10:29:09.118179	112	EXECUTED	9:3f332e13e90739ed0c35b0b25b7822ca	addColumn tableName=CLIENT_ATTRIBUTES; update tableName=CLIENT_ATTRIBUTES; dropColumn columnName=VALUE, tableName=CLIENT_ATTRIBUTES; renameColumn newColumnName=VALUE, oldColumnName=VALUE_NEW, tableName=CLIENT_ATTRIBUTES		\N	4.8.0	\N	\N	8876148799
21.0.2-17277	keycloak	META-INF/jpa-changelog-21.0.2.xml	2025-10-14 07:37:10.502657	114	EXECUTED	9:7ee1f7a3fb8f5588f171fb9a6ab623c0	customChange		\N	4.29.1	\N	\N	0427430424
21.1.0-19404	keycloak	META-INF/jpa-changelog-21.1.0.xml	2025-10-14 07:37:10.50931	115	EXECUTED	9:3d7e830b52f33676b9d64f7f2b2ea634	modifyDataType columnName=DECISION_STRATEGY, tableName=RESOURCE_SERVER_POLICY; modifyDataType columnName=LOGIC, tableName=RESOURCE_SERVER_POLICY; modifyDataType columnName=POLICY_ENFORCE_MODE, tableName=RESOURCE_SERVER		\N	4.29.1	\N	\N	0427430424
21.1.0-19404-2	keycloak	META-INF/jpa-changelog-21.1.0.xml	2025-10-14 07:37:10.511824	116	MARK_RAN	9:627d032e3ef2c06c0e1f73d2ae25c26c	addColumn tableName=RESOURCE_SERVER_POLICY; update tableName=RESOURCE_SERVER_POLICY; dropColumn columnName=DECISION_STRATEGY, tableName=RESOURCE_SERVER_POLICY; renameColumn newColumnName=DECISION_STRATEGY, oldColumnName=DECISION_STRATEGY_NEW, tabl...		\N	4.29.1	\N	\N	0427430424
22.0.0-17484-updated	keycloak	META-INF/jpa-changelog-22.0.0.xml	2025-10-14 07:37:10.517041	117	EXECUTED	9:90af0bfd30cafc17b9f4d6eccd92b8b3	customChange		\N	4.29.1	\N	\N	0427430424
22.0.5-24031	keycloak	META-INF/jpa-changelog-22.0.0.xml	2025-10-14 07:37:10.517967	118	MARK_RAN	9:a60d2d7b315ec2d3eba9e2f145f9df28	customChange		\N	4.29.1	\N	\N	0427430424
23.0.0-12062	keycloak	META-INF/jpa-changelog-23.0.0.xml	2025-10-14 07:37:10.523159	119	EXECUTED	9:2168fbe728fec46ae9baf15bf80927b8	addColumn tableName=COMPONENT_CONFIG; update tableName=COMPONENT_CONFIG; dropColumn columnName=VALUE, tableName=COMPONENT_CONFIG; renameColumn newColumnName=VALUE, oldColumnName=VALUE_NEW, tableName=COMPONENT_CONFIG		\N	4.29.1	\N	\N	0427430424
23.0.0-17258	keycloak	META-INF/jpa-changelog-23.0.0.xml	2025-10-14 07:37:10.525046	120	EXECUTED	9:36506d679a83bbfda85a27ea1864dca8	addColumn tableName=EVENT_ENTITY		\N	4.29.1	\N	\N	0427430424
24.0.0-9758	keycloak	META-INF/jpa-changelog-24.0.0.xml	2025-10-14 07:37:10.638935	121	EXECUTED	9:502c557a5189f600f0f445a9b49ebbce	addColumn tableName=USER_ATTRIBUTE; addColumn tableName=FED_USER_ATTRIBUTE; createIndex indexName=USER_ATTR_LONG_VALUES, tableName=USER_ATTRIBUTE; createIndex indexName=FED_USER_ATTR_LONG_VALUES, tableName=FED_USER_ATTRIBUTE; createIndex indexName...		\N	4.29.1	\N	\N	0427430424
24.0.0-9758-2	keycloak	META-INF/jpa-changelog-24.0.0.xml	2025-10-14 07:37:10.64188	122	EXECUTED	9:bf0fdee10afdf597a987adbf291db7b2	customChange		\N	4.29.1	\N	\N	0427430424
24.0.0-26618-drop-index-if-present	keycloak	META-INF/jpa-changelog-24.0.0.xml	2025-10-14 07:37:10.644717	123	MARK_RAN	9:04baaf56c116ed19951cbc2cca584022	dropIndex indexName=IDX_CLIENT_ATT_BY_NAME_VALUE, tableName=CLIENT_ATTRIBUTES		\N	4.29.1	\N	\N	0427430424
24.0.0-26618-reindex	keycloak	META-INF/jpa-changelog-24.0.0.xml	2025-10-14 07:37:10.668638	124	EXECUTED	9:08707c0f0db1cef6b352db03a60edc7f	createIndex indexName=IDX_CLIENT_ATT_BY_NAME_VALUE, tableName=CLIENT_ATTRIBUTES		\N	4.29.1	\N	\N	0427430424
24.0.2-27228	keycloak	META-INF/jpa-changelog-24.0.2.xml	2025-10-14 07:37:10.671572	125	EXECUTED	9:eaee11f6b8aa25d2cc6a84fb86fc6238	customChange		\N	4.29.1	\N	\N	0427430424
24.0.2-27967-drop-index-if-present	keycloak	META-INF/jpa-changelog-24.0.2.xml	2025-10-14 07:37:10.672354	126	MARK_RAN	9:04baaf56c116ed19951cbc2cca584022	dropIndex indexName=IDX_CLIENT_ATT_BY_NAME_VALUE, tableName=CLIENT_ATTRIBUTES		\N	4.29.1	\N	\N	0427430424
24.0.2-27967-reindex	keycloak	META-INF/jpa-changelog-24.0.2.xml	2025-10-14 07:37:10.673469	127	MARK_RAN	9:d3d977031d431db16e2c181ce49d73e9	createIndex indexName=IDX_CLIENT_ATT_BY_NAME_VALUE, tableName=CLIENT_ATTRIBUTES		\N	4.29.1	\N	\N	0427430424
25.0.0-28265-tables	keycloak	META-INF/jpa-changelog-25.0.0.xml	2025-10-14 07:37:10.677348	128	EXECUTED	9:deda2df035df23388af95bbd36c17cef	addColumn tableName=OFFLINE_USER_SESSION; addColumn tableName=OFFLINE_CLIENT_SESSION		\N	4.29.1	\N	\N	0427430424
25.0.0-28265-index-creation	keycloak	META-INF/jpa-changelog-25.0.0.xml	2025-10-14 07:37:10.701853	129	EXECUTED	9:3e96709818458ae49f3c679ae58d263a	createIndex indexName=IDX_OFFLINE_USS_BY_LAST_SESSION_REFRESH, tableName=OFFLINE_USER_SESSION		\N	4.29.1	\N	\N	0427430424
25.0.0-28265-index-cleanup-uss-createdon	keycloak	META-INF/jpa-changelog-25.0.0.xml	2025-10-14 07:37:10.806602	130	EXECUTED	9:78ab4fc129ed5e8265dbcc3485fba92f	dropIndex indexName=IDX_OFFLINE_USS_CREATEDON, tableName=OFFLINE_USER_SESSION		\N	4.29.1	\N	\N	0427430424
25.0.0-28265-index-cleanup-uss-preload	keycloak	META-INF/jpa-changelog-25.0.0.xml	2025-10-14 07:37:10.90097	131	EXECUTED	9:de5f7c1f7e10994ed8b62e621d20eaab	dropIndex indexName=IDX_OFFLINE_USS_PRELOAD, tableName=OFFLINE_USER_SESSION		\N	4.29.1	\N	\N	0427430424
25.0.0-28265-index-cleanup-uss-by-usersess	keycloak	META-INF/jpa-changelog-25.0.0.xml	2025-10-14 07:37:10.990091	132	EXECUTED	9:6eee220d024e38e89c799417ec33667f	dropIndex indexName=IDX_OFFLINE_USS_BY_USERSESS, tableName=OFFLINE_USER_SESSION		\N	4.29.1	\N	\N	0427430424
25.0.0-28265-index-cleanup-css-preload	keycloak	META-INF/jpa-changelog-25.0.0.xml	2025-10-14 07:37:11.076515	133	EXECUTED	9:5411d2fb2891d3e8d63ddb55dfa3c0c9	dropIndex indexName=IDX_OFFLINE_CSS_PRELOAD, tableName=OFFLINE_CLIENT_SESSION		\N	4.29.1	\N	\N	0427430424
25.0.0-28265-index-2-mysql	keycloak	META-INF/jpa-changelog-25.0.0.xml	2025-10-14 07:37:11.077586	134	MARK_RAN	9:b7ef76036d3126bb83c2423bf4d449d6	createIndex indexName=IDX_OFFLINE_USS_BY_BROKER_SESSION_ID, tableName=OFFLINE_USER_SESSION		\N	4.29.1	\N	\N	0427430424
25.0.0-28265-index-2-not-mysql	keycloak	META-INF/jpa-changelog-25.0.0.xml	2025-10-14 07:37:11.09828	135	EXECUTED	9:23396cf51ab8bc1ae6f0cac7f9f6fcf7	createIndex indexName=IDX_OFFLINE_USS_BY_BROKER_SESSION_ID, tableName=OFFLINE_USER_SESSION		\N	4.29.1	\N	\N	0427430424
25.0.0-org	keycloak	META-INF/jpa-changelog-25.0.0.xml	2025-10-14 07:37:11.104555	136	EXECUTED	9:5c859965c2c9b9c72136c360649af157	createTable tableName=ORG; addUniqueConstraint constraintName=UK_ORG_NAME, tableName=ORG; addUniqueConstraint constraintName=UK_ORG_GROUP, tableName=ORG; createTable tableName=ORG_DOMAIN		\N	4.29.1	\N	\N	0427430424
unique-consentuser	keycloak	META-INF/jpa-changelog-25.0.0.xml	2025-10-14 07:37:11.111313	137	EXECUTED	9:5857626a2ea8767e9a6c66bf3a2cb32f	customChange; dropUniqueConstraint constraintName=UK_JKUWUVD56ONTGSUHOGM8UEWRT, tableName=USER_CONSENT; addUniqueConstraint constraintName=UK_LOCAL_CONSENT, tableName=USER_CONSENT; addUniqueConstraint constraintName=UK_EXTERNAL_CONSENT, tableName=...		\N	4.29.1	\N	\N	0427430424
unique-consentuser-mysql	keycloak	META-INF/jpa-changelog-25.0.0.xml	2025-10-14 07:37:11.112151	138	MARK_RAN	9:b79478aad5adaa1bc428e31563f55e8e	customChange; dropUniqueConstraint constraintName=UK_JKUWUVD56ONTGSUHOGM8UEWRT, tableName=USER_CONSENT; addUniqueConstraint constraintName=UK_LOCAL_CONSENT, tableName=USER_CONSENT; addUniqueConstraint constraintName=UK_EXTERNAL_CONSENT, tableName=...		\N	4.29.1	\N	\N	0427430424
25.0.0-28861-index-creation	keycloak	META-INF/jpa-changelog-25.0.0.xml	2025-10-14 07:37:11.15183	139	EXECUTED	9:b9acb58ac958d9ada0fe12a5d4794ab1	createIndex indexName=IDX_PERM_TICKET_REQUESTER, tableName=RESOURCE_SERVER_PERM_TICKET; createIndex indexName=IDX_PERM_TICKET_OWNER, tableName=RESOURCE_SERVER_PERM_TICKET		\N	4.29.1	\N	\N	0427430424
26.0.0-org-alias	keycloak	META-INF/jpa-changelog-26.0.0.xml	2025-10-14 07:37:11.15591	140	EXECUTED	9:6ef7d63e4412b3c2d66ed179159886a4	addColumn tableName=ORG; update tableName=ORG; addNotNullConstraint columnName=ALIAS, tableName=ORG; addUniqueConstraint constraintName=UK_ORG_ALIAS, tableName=ORG		\N	4.29.1	\N	\N	0427430424
26.0.0-org-group	keycloak	META-INF/jpa-changelog-26.0.0.xml	2025-10-14 07:37:11.161764	141	EXECUTED	9:da8e8087d80ef2ace4f89d8c5b9ca223	addColumn tableName=KEYCLOAK_GROUP; update tableName=KEYCLOAK_GROUP; addNotNullConstraint columnName=TYPE, tableName=KEYCLOAK_GROUP; customChange		\N	4.29.1	\N	\N	0427430424
26.0.0-org-indexes	keycloak	META-INF/jpa-changelog-26.0.0.xml	2025-10-14 07:37:11.184012	142	EXECUTED	9:79b05dcd610a8c7f25ec05135eec0857	createIndex indexName=IDX_ORG_DOMAIN_ORG_ID, tableName=ORG_DOMAIN		\N	4.29.1	\N	\N	0427430424
26.0.0-org-group-membership	keycloak	META-INF/jpa-changelog-26.0.0.xml	2025-10-14 07:37:11.18743	143	EXECUTED	9:a6ace2ce583a421d89b01ba2a28dc2d4	addColumn tableName=USER_GROUP_MEMBERSHIP; update tableName=USER_GROUP_MEMBERSHIP; addNotNullConstraint columnName=MEMBERSHIP_TYPE, tableName=USER_GROUP_MEMBERSHIP		\N	4.29.1	\N	\N	0427430424
31296-persist-revoked-access-tokens	keycloak	META-INF/jpa-changelog-26.0.0.xml	2025-10-14 07:37:11.190932	144	EXECUTED	9:64ef94489d42a358e8304b0e245f0ed4	createTable tableName=REVOKED_TOKEN; addPrimaryKey constraintName=CONSTRAINT_RT, tableName=REVOKED_TOKEN		\N	4.29.1	\N	\N	0427430424
31725-index-persist-revoked-access-tokens	keycloak	META-INF/jpa-changelog-26.0.0.xml	2025-10-14 07:37:11.209751	145	EXECUTED	9:b994246ec2bf7c94da881e1d28782c7b	createIndex indexName=IDX_REV_TOKEN_ON_EXPIRE, tableName=REVOKED_TOKEN		\N	4.29.1	\N	\N	0427430424
26.0.0-idps-for-login	keycloak	META-INF/jpa-changelog-26.0.0.xml	2025-10-14 07:37:11.251656	146	EXECUTED	9:51f5fffadf986983d4bd59582c6c1604	addColumn tableName=IDENTITY_PROVIDER; createIndex indexName=IDX_IDP_REALM_ORG, tableName=IDENTITY_PROVIDER; createIndex indexName=IDX_IDP_FOR_LOGIN, tableName=IDENTITY_PROVIDER; customChange		\N	4.29.1	\N	\N	0427430424
26.0.0-32583-drop-redundant-index-on-client-session	keycloak	META-INF/jpa-changelog-26.0.0.xml	2025-10-14 07:37:11.37947	147	EXECUTED	9:24972d83bf27317a055d234187bb4af9	dropIndex indexName=IDX_US_SESS_ID_ON_CL_SESS, tableName=OFFLINE_CLIENT_SESSION		\N	4.29.1	\N	\N	0427430424
26.0.0.32582-remove-tables-user-session-user-session-note-and-client-session	keycloak	META-INF/jpa-changelog-26.0.0.xml	2025-10-14 07:37:11.387604	148	EXECUTED	9:febdc0f47f2ed241c59e60f58c3ceea5	dropTable tableName=CLIENT_SESSION_ROLE; dropTable tableName=CLIENT_SESSION_NOTE; dropTable tableName=CLIENT_SESSION_PROT_MAPPER; dropTable tableName=CLIENT_SESSION_AUTH_STATUS; dropTable tableName=CLIENT_USER_SESSION_NOTE; dropTable tableName=CLI...		\N	4.29.1	\N	\N	0427430424
26.0.0-33201-org-redirect-url	keycloak	META-INF/jpa-changelog-26.0.0.xml	2025-10-14 07:37:11.389937	149	EXECUTED	9:4d0e22b0ac68ebe9794fa9cb752ea660	addColumn tableName=ORG		\N	4.29.1	\N	\N	0427430424
29399-jdbc-ping-default	keycloak	META-INF/jpa-changelog-26.1.0.xml	2025-10-14 07:37:11.39359	150	EXECUTED	9:007dbe99d7203fca403b89d4edfdf21e	createTable tableName=JGROUPS_PING; addPrimaryKey constraintName=CONSTRAINT_JGROUPS_PING, tableName=JGROUPS_PING		\N	4.29.1	\N	\N	0427430424
26.1.0-34013	keycloak	META-INF/jpa-changelog-26.1.0.xml	2025-10-14 07:37:11.398262	151	EXECUTED	9:e6b686a15759aef99a6d758a5c4c6a26	addColumn tableName=ADMIN_EVENT_ENTITY		\N	4.29.1	\N	\N	0427430424
26.1.0-34380	keycloak	META-INF/jpa-changelog-26.1.0.xml	2025-10-14 07:37:11.401621	152	EXECUTED	9:ac8b9edb7c2b6c17a1c7a11fcf5ccf01	dropTable tableName=USERNAME_LOGIN_FAILURE		\N	4.29.1	\N	\N	0427430424
26.2.0-36750	keycloak	META-INF/jpa-changelog-26.2.0.xml	2025-10-14 07:37:11.407469	153	EXECUTED	9:b49ce951c22f7eb16480ff085640a33a	createTable tableName=SERVER_CONFIG		\N	4.29.1	\N	\N	0427430424
26.2.0-26106	keycloak	META-INF/jpa-changelog-26.2.0.xml	2025-10-14 07:37:11.420583	154	EXECUTED	9:b5877d5dab7d10ff3a9d209d7beb6680	addColumn tableName=CREDENTIAL		\N	4.29.1	\N	\N	0427430424
26.2.6-39866-duplicate	keycloak	META-INF/jpa-changelog-26.2.6.xml	2025-10-14 07:37:11.424512	155	EXECUTED	9:1dc67ccee24f30331db2cba4f372e40e	customChange		\N	4.29.1	\N	\N	0427430424
26.2.6-39866-uk	keycloak	META-INF/jpa-changelog-26.2.6.xml	2025-10-14 07:37:11.427525	156	EXECUTED	9:b70b76f47210cf0a5f4ef0e219eac7cd	addUniqueConstraint constraintName=UK_MIGRATION_VERSION, tableName=MIGRATION_MODEL		\N	4.29.1	\N	\N	0427430424
26.2.6-40088-duplicate	keycloak	META-INF/jpa-changelog-26.2.6.xml	2025-10-14 07:37:11.433095	157	EXECUTED	9:cc7e02ed69ab31979afb1982f9670e8f	customChange		\N	4.29.1	\N	\N	0427430424
26.2.6-40088-uk	keycloak	META-INF/jpa-changelog-26.2.6.xml	2025-10-14 07:37:11.435979	158	EXECUTED	9:5bb848128da7bc4595cc507383325241	addUniqueConstraint constraintName=UK_MIGRATION_UPDATE_TIME, tableName=MIGRATION_MODEL		\N	4.29.1	\N	\N	0427430424
26.3.0-groups-description	keycloak	META-INF/jpa-changelog-26.3.0.xml	2025-10-14 07:37:11.438532	159	EXECUTED	9:e1a3c05574326fb5b246b73b9a4c4d49	addColumn tableName=KEYCLOAK_GROUP		\N	4.29.1	\N	\N	0427430424
\.


--
-- Data for Name: databasechangeloglock; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.databasechangeloglock (id, locked, lockgranted, lockedby) FROM stdin;
1	f	\N	\N
1000	f	\N	\N
1001	f	\N	\N
\.


--
-- Data for Name: default_client_scope; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.default_client_scope (realm_id, scope_id, default_scope) FROM stdin;
master	5fa108cf-082d-4259-a83b-0e6bafe2dc52	f
master	b0bd9d13-2656-482b-983a-7e035271249c	t
master	836e4bec-bf2b-413e-8ab9-f8cfe4df2c92	t
master	a6bdff04-29c8-4182-a724-8c1ea6eeaa34	t
master	d2e82da6-ba0e-4f79-97d4-72b214da0c93	f
master	c702175b-726a-483d-b634-c78824e9e5e4	f
master	2d908280-64c7-48e7-a550-2087fec991fd	t
master	337849c0-068b-4df7-8065-7f36d6b66c5e	t
cmem	09515dc1-d9ed-43f6-a128-aa8b30a0b1fb	t
cmem	4a28cf61-9dc1-41a2-acbe-d4655458c19d	t
cmem	a6bcb9ab-69ca-415f-a30f-f588d60d0598	t
cmem	d2b63358-a813-447c-afbf-f4c22fc9e183	t
cmem	ea902ac2-db2b-4cc5-b709-188c14ffa8c9	t
cmem	03b1f2aa-882b-47d2-b047-de00af7de64a	f
cmem	b58ca5a7-117a-4398-a793-821f80967282	f
cmem	c91b964b-1c79-478e-89b2-05673ce63a8d	f
master	7e284e72-20ce-4a0c-b9c5-5d0dffd775a4	f
cmem	4b60c78d-a296-4047-beb6-92b487da43b8	f
cmem	dd479ceb-03a2-4490-b511-12a5515745f0	t
master	ae5dcb24-0f95-4c5e-b079-04b45d578ded	t
master	d959d7f7-5626-4024-b420-9c47982bb617	t
cmem	7db28b56-71d1-4b95-a422-93450c685e7a	t
\.


--
-- Data for Name: event_entity; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.event_entity (id, client_id, details_json, error, ip_address, realm_id, session_id, event_time, type, user_id, details_json_long_value) FROM stdin;
\.


--
-- Data for Name: fed_user_attribute; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.fed_user_attribute (id, name, user_id, realm_id, storage_provider_id, value, long_value_hash, long_value_hash_lower_case, long_value) FROM stdin;
\.


--
-- Data for Name: fed_user_consent; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.fed_user_consent (id, client_id, user_id, realm_id, storage_provider_id, created_date, last_updated_date, client_storage_provider, external_client_id) FROM stdin;
\.


--
-- Data for Name: fed_user_consent_cl_scope; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.fed_user_consent_cl_scope (user_consent_id, scope_id) FROM stdin;
\.


--
-- Data for Name: fed_user_credential; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.fed_user_credential (id, salt, type, created_date, user_id, realm_id, storage_provider_id, user_label, secret_data, credential_data, priority) FROM stdin;
\.


--
-- Data for Name: fed_user_group_membership; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.fed_user_group_membership (group_id, user_id, realm_id, storage_provider_id) FROM stdin;
\.


--
-- Data for Name: fed_user_required_action; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.fed_user_required_action (required_action, user_id, realm_id, storage_provider_id) FROM stdin;
\.


--
-- Data for Name: fed_user_role_mapping; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.fed_user_role_mapping (role_id, user_id, realm_id, storage_provider_id) FROM stdin;
\.


--
-- Data for Name: federated_identity; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.federated_identity (identity_provider, realm_id, federated_user_id, federated_username, token, user_id) FROM stdin;
\.


--
-- Data for Name: federated_user; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.federated_user (id, storage_provider_id, realm_id) FROM stdin;
\.


--
-- Data for Name: group_attribute; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.group_attribute (id, name, value, group_id) FROM stdin;
\.


--
-- Data for Name: group_role_mapping; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.group_role_mapping (role_id, group_id) FROM stdin;
\.


--
-- Data for Name: identity_provider; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.identity_provider (internal_id, enabled, provider_alias, provider_id, store_token, authenticate_by_default, realm_id, add_token_role, trust_email, first_broker_login_flow_id, post_broker_login_flow_id, provider_display_name, link_only, organization_id, hide_on_login) FROM stdin;
\.


--
-- Data for Name: identity_provider_config; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.identity_provider_config (identity_provider_id, value, name) FROM stdin;
\.


--
-- Data for Name: identity_provider_mapper; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.identity_provider_mapper (id, name, idp_alias, idp_mapper_name, realm_id) FROM stdin;
\.


--
-- Data for Name: idp_mapper_config; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.idp_mapper_config (idp_mapper_id, value, name) FROM stdin;
\.


--
-- Data for Name: jgroups_ping; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.jgroups_ping (address, name, cluster_name, ip, coord) FROM stdin;
uuid://00000000-0000-0000-0000-000000000002	74b68e6d7b3d-52471	ISPN	172.19.0.2:7800	t
\.


--
-- Data for Name: keycloak_group; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.keycloak_group (id, name, parent_group, realm_id, type, description) FROM stdin;
aac88e00-3c36-4001-9af3-b746c06eb773	local-admins	 	cmem	0	\N
5dc7d6ae-37bb-4381-92ca-1b194fd284c7	local-users	 	cmem	0	\N
27294582-70ad-4ee7-8303-bc5ab783a954	elds-admins	 	cmem	0	\N
\.


--
-- Data for Name: keycloak_role; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.keycloak_role (id, client_realm_constraint, client_role, description, name, realm_id, client, realm) FROM stdin;
665badf5-9f53-4a3b-bea0-6268d02aa280	master	f	${role_admin}	admin	master	\N	master
0f8acfdf-8a93-4847-ac14-8b4e9f834216	master	f	${role_create-realm}	create-realm	master	\N	master
02efdcd6-7cf6-4126-9444-82dce223a519	360b5c9e-6960-451f-b5d4-9eaae2dacdda	t	${role_create-client}	create-client	master	360b5c9e-6960-451f-b5d4-9eaae2dacdda	\N
37aa8703-9363-4332-9fb6-957153ec5382	360b5c9e-6960-451f-b5d4-9eaae2dacdda	t	${role_view-realm}	view-realm	master	360b5c9e-6960-451f-b5d4-9eaae2dacdda	\N
e938e12b-2699-412b-8134-7cf04f07762f	360b5c9e-6960-451f-b5d4-9eaae2dacdda	t	${role_view-users}	view-users	master	360b5c9e-6960-451f-b5d4-9eaae2dacdda	\N
eba140fa-a129-4646-83a0-9dbec3d651f6	360b5c9e-6960-451f-b5d4-9eaae2dacdda	t	${role_view-clients}	view-clients	master	360b5c9e-6960-451f-b5d4-9eaae2dacdda	\N
e0cc291f-0155-46cf-81a8-c42de8a2b212	360b5c9e-6960-451f-b5d4-9eaae2dacdda	t	${role_view-events}	view-events	master	360b5c9e-6960-451f-b5d4-9eaae2dacdda	\N
b82e3bdf-a7bc-4cbe-aed0-2da3f2e8ad4b	360b5c9e-6960-451f-b5d4-9eaae2dacdda	t	${role_view-identity-providers}	view-identity-providers	master	360b5c9e-6960-451f-b5d4-9eaae2dacdda	\N
5c92c736-f2c1-4a51-96ca-89305cbe45b6	360b5c9e-6960-451f-b5d4-9eaae2dacdda	t	${role_view-authorization}	view-authorization	master	360b5c9e-6960-451f-b5d4-9eaae2dacdda	\N
9071b665-4722-4821-ab89-0a6da7518408	360b5c9e-6960-451f-b5d4-9eaae2dacdda	t	${role_manage-realm}	manage-realm	master	360b5c9e-6960-451f-b5d4-9eaae2dacdda	\N
085cb850-1881-4b22-a105-98d1accaf3ba	360b5c9e-6960-451f-b5d4-9eaae2dacdda	t	${role_manage-users}	manage-users	master	360b5c9e-6960-451f-b5d4-9eaae2dacdda	\N
704b7a7e-a0ff-4086-9349-e7c178639a5c	360b5c9e-6960-451f-b5d4-9eaae2dacdda	t	${role_manage-clients}	manage-clients	master	360b5c9e-6960-451f-b5d4-9eaae2dacdda	\N
c99f29b8-58d2-4256-97a0-b1cf2f7278e8	360b5c9e-6960-451f-b5d4-9eaae2dacdda	t	${role_manage-events}	manage-events	master	360b5c9e-6960-451f-b5d4-9eaae2dacdda	\N
a048e9bf-75a2-4451-8657-00d60f0a25e8	360b5c9e-6960-451f-b5d4-9eaae2dacdda	t	${role_manage-identity-providers}	manage-identity-providers	master	360b5c9e-6960-451f-b5d4-9eaae2dacdda	\N
2ee634c0-46b4-431b-b5f5-562c6e03b340	360b5c9e-6960-451f-b5d4-9eaae2dacdda	t	${role_manage-authorization}	manage-authorization	master	360b5c9e-6960-451f-b5d4-9eaae2dacdda	\N
8a1a39c7-2ab8-4754-af1c-4110caae4732	360b5c9e-6960-451f-b5d4-9eaae2dacdda	t	${role_query-users}	query-users	master	360b5c9e-6960-451f-b5d4-9eaae2dacdda	\N
eb3e2c6e-3fe4-4fd7-9676-735874dcaab6	360b5c9e-6960-451f-b5d4-9eaae2dacdda	t	${role_query-clients}	query-clients	master	360b5c9e-6960-451f-b5d4-9eaae2dacdda	\N
642c9771-ac2a-478e-afd5-a27f575091ee	360b5c9e-6960-451f-b5d4-9eaae2dacdda	t	${role_query-realms}	query-realms	master	360b5c9e-6960-451f-b5d4-9eaae2dacdda	\N
41e58bd8-ccde-4cd7-9dea-bf611bd7ec32	360b5c9e-6960-451f-b5d4-9eaae2dacdda	t	${role_query-groups}	query-groups	master	360b5c9e-6960-451f-b5d4-9eaae2dacdda	\N
5e57000a-9f7b-4d0a-839a-7d6e328ef8aa	75ba9e57-8bd3-4560-af7b-8d8bc74cae0d	t	${role_view-profile}	view-profile	master	75ba9e57-8bd3-4560-af7b-8d8bc74cae0d	\N
37e3b8f2-8f1c-44f3-ae56-e298c46deed0	75ba9e57-8bd3-4560-af7b-8d8bc74cae0d	t	${role_manage-account}	manage-account	master	75ba9e57-8bd3-4560-af7b-8d8bc74cae0d	\N
8e67fd63-af4b-42b1-ac87-284cd307819a	75ba9e57-8bd3-4560-af7b-8d8bc74cae0d	t	${role_manage-account-links}	manage-account-links	master	75ba9e57-8bd3-4560-af7b-8d8bc74cae0d	\N
2d72a39f-be73-454d-9628-f92470aec1ea	23cd6fb4-696a-41d2-b04f-037e548db556	t	${role_read-token}	read-token	master	23cd6fb4-696a-41d2-b04f-037e548db556	\N
4b34637c-7d2d-4974-8063-5d011ec1198b	360b5c9e-6960-451f-b5d4-9eaae2dacdda	t	${role_impersonation}	impersonation	master	360b5c9e-6960-451f-b5d4-9eaae2dacdda	\N
c41a715c-2c3d-4abc-ac16-cad7784b222c	master	f	${role_offline-access}	offline_access	master	\N	master
de1fa12a-0e9b-4c51-9a7d-0e6e69f44648	master	f	${role_uma_authorization}	uma_authorization	master	\N	master
40b126cd-1bfb-422a-bbec-d22303d2b8b8	688ef36e-12f7-462a-bf89-cceec001558f	t	${role_create-client}	create-client	master	688ef36e-12f7-462a-bf89-cceec001558f	\N
3856e4eb-bdf6-4887-becf-05f21c07025e	688ef36e-12f7-462a-bf89-cceec001558f	t	${role_view-realm}	view-realm	master	688ef36e-12f7-462a-bf89-cceec001558f	\N
48b19074-f82f-4bae-a904-fbbf8d8d36a0	688ef36e-12f7-462a-bf89-cceec001558f	t	${role_view-users}	view-users	master	688ef36e-12f7-462a-bf89-cceec001558f	\N
5e867812-7365-4e3f-9e6b-6512eae4312f	688ef36e-12f7-462a-bf89-cceec001558f	t	${role_view-clients}	view-clients	master	688ef36e-12f7-462a-bf89-cceec001558f	\N
988cbd16-21cd-4f96-93f7-a1e1e06d18a2	688ef36e-12f7-462a-bf89-cceec001558f	t	${role_view-events}	view-events	master	688ef36e-12f7-462a-bf89-cceec001558f	\N
b3b50103-8fe8-4eea-ae79-64d251675e00	688ef36e-12f7-462a-bf89-cceec001558f	t	${role_view-identity-providers}	view-identity-providers	master	688ef36e-12f7-462a-bf89-cceec001558f	\N
291cb973-ce0e-4b23-9036-974fcad70ddb	688ef36e-12f7-462a-bf89-cceec001558f	t	${role_view-authorization}	view-authorization	master	688ef36e-12f7-462a-bf89-cceec001558f	\N
23101069-6480-4249-8fb1-2afc6f627a9a	688ef36e-12f7-462a-bf89-cceec001558f	t	${role_manage-realm}	manage-realm	master	688ef36e-12f7-462a-bf89-cceec001558f	\N
6d9565dd-5bd1-4c99-b7d7-83a24fcbbdcf	688ef36e-12f7-462a-bf89-cceec001558f	t	${role_manage-users}	manage-users	master	688ef36e-12f7-462a-bf89-cceec001558f	\N
17e96725-c2f2-4d28-b964-8b8948f3719b	688ef36e-12f7-462a-bf89-cceec001558f	t	${role_manage-clients}	manage-clients	master	688ef36e-12f7-462a-bf89-cceec001558f	\N
f750cc29-252e-4b00-bb6f-be66cbb7ffc2	688ef36e-12f7-462a-bf89-cceec001558f	t	${role_manage-events}	manage-events	master	688ef36e-12f7-462a-bf89-cceec001558f	\N
ea8ad40c-3c56-4bf9-b372-78d37f17689e	688ef36e-12f7-462a-bf89-cceec001558f	t	${role_manage-identity-providers}	manage-identity-providers	master	688ef36e-12f7-462a-bf89-cceec001558f	\N
5119c5ea-b11d-498c-ad10-690cf1364426	688ef36e-12f7-462a-bf89-cceec001558f	t	${role_manage-authorization}	manage-authorization	master	688ef36e-12f7-462a-bf89-cceec001558f	\N
ab017b9c-ce8d-460b-94e2-2b1173507d5d	688ef36e-12f7-462a-bf89-cceec001558f	t	${role_query-users}	query-users	master	688ef36e-12f7-462a-bf89-cceec001558f	\N
82d54e28-9e61-4621-8ca5-5f01c849dcc3	688ef36e-12f7-462a-bf89-cceec001558f	t	${role_query-clients}	query-clients	master	688ef36e-12f7-462a-bf89-cceec001558f	\N
9e6e338d-87f1-4d46-803d-9b3cedcd09d9	688ef36e-12f7-462a-bf89-cceec001558f	t	${role_query-realms}	query-realms	master	688ef36e-12f7-462a-bf89-cceec001558f	\N
ffcacb55-56e0-47e3-ad58-b1106b817073	688ef36e-12f7-462a-bf89-cceec001558f	t	${role_query-groups}	query-groups	master	688ef36e-12f7-462a-bf89-cceec001558f	\N
8393c807-bc46-4249-bdec-76afcd5676eb	cmem	f	${role_uma_authorization}	uma_authorization	cmem	\N	cmem
73819e85-b0fc-45c9-9d43-0cd4cfa8edf7	cmem	f	${role_offline-access}	offline_access	cmem	\N	cmem
63831177-2338-4695-a117-67cd6b88c331	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	t	${role_view-identity-providers}	view-identity-providers	cmem	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	\N
8dc73c1c-b2ba-4f5b-acb8-d8535fbd4f07	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	t	${role_manage-identity-providers}	manage-identity-providers	cmem	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	\N
43cf8c78-18a0-4abd-8a63-90e664204489	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	t	${role_realm-admin}	realm-admin	cmem	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	\N
f83bae0d-306d-4a24-b7a8-09080693a50b	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	t	${role_view-authorization}	view-authorization	cmem	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	\N
ccfc3214-2eb3-484a-b5f9-86d9e013edf2	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	t	${role_query-users}	query-users	cmem	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	\N
601fdf42-dcc4-468a-9c0c-539aa3f0eee3	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	t	${role_manage-users}	manage-users	cmem	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	\N
879c1043-3414-43fa-a15e-1d10cc0c14b5	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	t	${role_create-client}	create-client	cmem	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	\N
c36947a9-3d30-4c76-8845-496ec7d01908	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	t	${role_query-groups}	query-groups	cmem	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	\N
e0a80c5f-b0c2-4830-a8d6-bb99920fa39f	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	t	${role_manage-clients}	manage-clients	cmem	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	\N
bc751e50-8103-4fa0-8bfd-251af522c6d5	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	t	${role_query-realms}	query-realms	cmem	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	\N
b27e707e-ed58-4505-a20d-35de1d82cb92	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	t	${role_manage-authorization}	manage-authorization	cmem	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	\N
93d49bd2-4cb5-4c95-8d82-53dddc08657a	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	t	${role_query-clients}	query-clients	cmem	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	\N
24e53135-6172-4fea-aa45-828dd2baa81c	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	t	${role_view-clients}	view-clients	cmem	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	\N
266c63c4-e3ba-4a18-bf35-1695a10c9a09	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	t	${role_manage-events}	manage-events	cmem	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	\N
9b0bbb07-927d-482b-9529-88152786572b	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	t	${role_manage-realm}	manage-realm	cmem	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	\N
bfa394b0-4163-4f98-8db6-3d3f6c0fbd7f	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	t	${role_view-events}	view-events	cmem	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	\N
5158587b-0da6-46ec-8230-e512fc1c1631	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	t	${role_impersonation}	impersonation	cmem	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	\N
a10f130f-680a-47ce-9a9a-73c827162795	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	t	${role_view-realm}	view-realm	cmem	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	\N
cdd71ce5-3694-4233-9898-4fbb5e344114	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	t	${role_view-users}	view-users	cmem	eb3b652a-021c-442f-b5a8-ea2fcf7e5efb	\N
75856fb4-6ffb-4e43-b83a-b9da8090c79f	dd485b6a-ee8f-47a8-b459-cc65a10f8cc0	t	${role_read-token}	read-token	cmem	dd485b6a-ee8f-47a8-b459-cc65a10f8cc0	\N
208d4ee9-3790-4c1b-925a-084c62907599	6338d0ff-f06e-4987-af63-197be726c44c	t	${role_manage-account-links}	manage-account-links	cmem	6338d0ff-f06e-4987-af63-197be726c44c	\N
3213869f-7ce1-4bcf-9c7a-50193557b1ca	6338d0ff-f06e-4987-af63-197be726c44c	t	${role_manage-account}	manage-account	cmem	6338d0ff-f06e-4987-af63-197be726c44c	\N
5fbde31c-9e26-4bd3-ae04-8126f74569df	6338d0ff-f06e-4987-af63-197be726c44c	t	${role_view-profile}	view-profile	cmem	6338d0ff-f06e-4987-af63-197be726c44c	\N
9d86012c-5c40-4c04-b8b8-82ad57d8a4af	688ef36e-12f7-462a-bf89-cceec001558f	t	${role_impersonation}	impersonation	master	688ef36e-12f7-462a-bf89-cceec001558f	\N
b2690d78-24f5-4835-9435-5030e33bf476	e9ab4ab5-754b-4f19-9d50-232bdf8cb322	t	\N	elds-admins	cmem	e9ab4ab5-754b-4f19-9d50-232bdf8cb322	\N
bd883e49-b471-4e20-99b0-0bb320286212	75ba9e57-8bd3-4560-af7b-8d8bc74cae0d	t	${role_view-applications}	view-applications	master	75ba9e57-8bd3-4560-af7b-8d8bc74cae0d	\N
276c3977-bdb7-4442-a394-397329553103	75ba9e57-8bd3-4560-af7b-8d8bc74cae0d	t	${role_view-consent}	view-consent	master	75ba9e57-8bd3-4560-af7b-8d8bc74cae0d	\N
b19a9b33-3cca-40a0-900d-8fa5fd79675a	75ba9e57-8bd3-4560-af7b-8d8bc74cae0d	t	${role_manage-consent}	manage-consent	master	75ba9e57-8bd3-4560-af7b-8d8bc74cae0d	\N
916a2810-526d-4dfd-8f90-fd30c238460f	6338d0ff-f06e-4987-af63-197be726c44c	t	${role_view-applications}	view-applications	cmem	6338d0ff-f06e-4987-af63-197be726c44c	\N
1ca136d1-8cd6-4eaa-bf2b-7b47b887f45e	6338d0ff-f06e-4987-af63-197be726c44c	t	${role_view-consent}	view-consent	cmem	6338d0ff-f06e-4987-af63-197be726c44c	\N
f63f36d6-7989-43fa-b74d-cabd2d66a828	6338d0ff-f06e-4987-af63-197be726c44c	t	${role_manage-consent}	manage-consent	cmem	6338d0ff-f06e-4987-af63-197be726c44c	\N
53fe722e-acf5-4d0e-ba73-6d419e0b0379	75ba9e57-8bd3-4560-af7b-8d8bc74cae0d	t	${role_delete-account}	delete-account	master	75ba9e57-8bd3-4560-af7b-8d8bc74cae0d	\N
10dba2bf-1e56-45f0-9620-60cbb5ebc9cf	6338d0ff-f06e-4987-af63-197be726c44c	t	${role_delete-account}	delete-account	cmem	6338d0ff-f06e-4987-af63-197be726c44c	\N
1a4b720e-9278-46d9-93ce-3c0dc7c6f51c	cmem	f	${role_default-roles-cmem}	default-roles-cmem	cmem	\N	cmem
ca307c76-8087-436a-a34d-b2cedf5d75d7	master	f	${role_default-roles-master}	default-roles-master	master	\N	master
865b8c69-58d8-4827-b0c5-f4c7aee9c973	6338d0ff-f06e-4987-af63-197be726c44c	t	${role_view-groups}	view-groups	cmem	6338d0ff-f06e-4987-af63-197be726c44c	\N
cbb78552-e80d-482b-b90d-0b99d4dbea0b	75ba9e57-8bd3-4560-af7b-8d8bc74cae0d	t	${role_view-groups}	view-groups	master	75ba9e57-8bd3-4560-af7b-8d8bc74cae0d	\N
4f9d8043-706e-48ab-a2b8-73d7a7ee74e0	3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	t		elds-admins	cmem	3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	\N
\.


--
-- Data for Name: migration_model; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.migration_model (id, version, update_time) FROM stdin;
SINGLETON	4.6.0	0
9z681	12.0.4	1646663797
exvd8	16.1.1	1647864477
czs6d	20.0.5	1678876151
fw5la	26.3.3	1760427433
\.


--
-- Data for Name: offline_client_session; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.offline_client_session (user_session_id, client_id, offline_flag, "timestamp", data, client_storage_provider, external_client_id, version) FROM stdin;
\.


--
-- Data for Name: offline_user_session; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.offline_user_session (user_session_id, user_id, realm_id, created_on, offline_flag, data, last_session_refresh, broker_session_id, version) FROM stdin;
\.


--
-- Data for Name: org; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.org (id, enabled, realm_id, group_id, name, description, alias, redirect_url) FROM stdin;
\.


--
-- Data for Name: org_domain; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.org_domain (id, name, verified, org_id) FROM stdin;
\.


--
-- Data for Name: policy_config; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.policy_config (policy_id, name, value) FROM stdin;
\.


--
-- Data for Name: protocol_mapper; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.protocol_mapper (id, name, protocol, protocol_mapper_name, client_id, client_scope_id) FROM stdin;
3e56e601-09d8-4048-be9b-803f00165623	locale	openid-connect	oidc-usermodel-attribute-mapper	110e1f10-2989-4463-8f9b-f8f50d4b7ab4	\N
5c8a386b-a1c2-4573-a41e-dbfb5e726b08	role list	saml	saml-role-list-mapper	\N	b0bd9d13-2656-482b-983a-7e035271249c
dffd8b0a-13a1-4125-abba-9f9d2a5db5bc	full name	openid-connect	oidc-full-name-mapper	\N	836e4bec-bf2b-413e-8ab9-f8cfe4df2c92
635ba14c-4af8-407e-90a0-dfd1b740ec69	family name	openid-connect	oidc-usermodel-property-mapper	\N	836e4bec-bf2b-413e-8ab9-f8cfe4df2c92
da0c46e9-0038-406b-8d54-4ee536b54e63	given name	openid-connect	oidc-usermodel-property-mapper	\N	836e4bec-bf2b-413e-8ab9-f8cfe4df2c92
49c90cec-d376-43b5-990c-3bd8ecf57703	middle name	openid-connect	oidc-usermodel-attribute-mapper	\N	836e4bec-bf2b-413e-8ab9-f8cfe4df2c92
90f176ba-5a99-4a35-b6f3-55f14449a1ad	nickname	openid-connect	oidc-usermodel-attribute-mapper	\N	836e4bec-bf2b-413e-8ab9-f8cfe4df2c92
60e58e7d-2e49-4cc6-b6eb-1a8469e735a6	username	openid-connect	oidc-usermodel-property-mapper	\N	836e4bec-bf2b-413e-8ab9-f8cfe4df2c92
7b72bb8b-b195-46ec-a323-86af78bacfb7	profile	openid-connect	oidc-usermodel-attribute-mapper	\N	836e4bec-bf2b-413e-8ab9-f8cfe4df2c92
0fe81355-fff3-41de-906f-6d37823da668	picture	openid-connect	oidc-usermodel-attribute-mapper	\N	836e4bec-bf2b-413e-8ab9-f8cfe4df2c92
2119cfc5-7f1b-4402-8b58-643db9aff359	website	openid-connect	oidc-usermodel-attribute-mapper	\N	836e4bec-bf2b-413e-8ab9-f8cfe4df2c92
de610f83-d394-4116-a157-754536389f49	gender	openid-connect	oidc-usermodel-attribute-mapper	\N	836e4bec-bf2b-413e-8ab9-f8cfe4df2c92
1fc693ef-9f21-4d30-abea-728fd2eb7bea	birthdate	openid-connect	oidc-usermodel-attribute-mapper	\N	836e4bec-bf2b-413e-8ab9-f8cfe4df2c92
8f261552-5fa6-4846-8e32-f6b930f1d366	zoneinfo	openid-connect	oidc-usermodel-attribute-mapper	\N	836e4bec-bf2b-413e-8ab9-f8cfe4df2c92
7851ecd8-4bd8-4d0c-8e16-c28f91317fd8	locale	openid-connect	oidc-usermodel-attribute-mapper	\N	836e4bec-bf2b-413e-8ab9-f8cfe4df2c92
7e4f5378-4f37-4c29-a9ab-ceeb8aa6d0bd	updated at	openid-connect	oidc-usermodel-attribute-mapper	\N	836e4bec-bf2b-413e-8ab9-f8cfe4df2c92
f647d493-11fc-42ab-846f-fd7765bdcf69	email	openid-connect	oidc-usermodel-property-mapper	\N	a6bdff04-29c8-4182-a724-8c1ea6eeaa34
035ed604-00fe-423f-a866-92c6c861166a	email verified	openid-connect	oidc-usermodel-property-mapper	\N	a6bdff04-29c8-4182-a724-8c1ea6eeaa34
f887ae4b-bcdc-461c-83e9-0f273989d249	address	openid-connect	oidc-address-mapper	\N	d2e82da6-ba0e-4f79-97d4-72b214da0c93
ff2f2775-0796-493f-95f7-ec0fb86f25ac	phone number	openid-connect	oidc-usermodel-attribute-mapper	\N	c702175b-726a-483d-b634-c78824e9e5e4
8fd45cba-53e6-459a-a731-823437a8f0ce	phone number verified	openid-connect	oidc-usermodel-attribute-mapper	\N	c702175b-726a-483d-b634-c78824e9e5e4
e019db02-2a8b-4f50-abb1-2d7c1ea3b0cd	realm roles	openid-connect	oidc-usermodel-realm-role-mapper	\N	2d908280-64c7-48e7-a550-2087fec991fd
6ff088af-b631-4f16-abd1-28aa1f4285b2	client roles	openid-connect	oidc-usermodel-client-role-mapper	\N	2d908280-64c7-48e7-a550-2087fec991fd
54b72683-14f4-46ad-84f5-19efe277ef47	audience resolve	openid-connect	oidc-audience-resolve-mapper	\N	2d908280-64c7-48e7-a550-2087fec991fd
e0f7cd0f-3682-48be-a16d-2f21228741bf	allowed web origins	openid-connect	oidc-allowed-origins-mapper	\N	337849c0-068b-4df7-8065-7f36d6b66c5e
09c065d6-3dbc-4f9e-a7d1-2d524a866b64	address	openid-connect	oidc-address-mapper	\N	03b1f2aa-882b-47d2-b047-de00af7de64a
0ea4d7ac-0d8a-40d4-ac8c-af595cbca6d1	email verified	openid-connect	oidc-usermodel-property-mapper	\N	ea902ac2-db2b-4cc5-b709-188c14ffa8c9
294ad6e0-6d95-4946-b026-f7efa4cec524	email	openid-connect	oidc-usermodel-property-mapper	\N	ea902ac2-db2b-4cc5-b709-188c14ffa8c9
f007ca94-5832-4370-8cf3-d9037ee500a0	phone number	openid-connect	oidc-usermodel-attribute-mapper	\N	b58ca5a7-117a-4398-a793-821f80967282
2d175494-ffb0-4f6d-a545-dfe74cff97db	phone number verified	openid-connect	oidc-usermodel-attribute-mapper	\N	b58ca5a7-117a-4398-a793-821f80967282
f6923e19-61a7-4ad6-8a46-60a5772872c1	given name	openid-connect	oidc-usermodel-property-mapper	\N	09515dc1-d9ed-43f6-a128-aa8b30a0b1fb
631de126-6cb8-4967-be21-32f7fdeaf6d4	updated at	openid-connect	oidc-usermodel-attribute-mapper	\N	09515dc1-d9ed-43f6-a128-aa8b30a0b1fb
e5717b57-4ca1-4299-8cb5-fb0fddb94807	birthdate	openid-connect	oidc-usermodel-attribute-mapper	\N	09515dc1-d9ed-43f6-a128-aa8b30a0b1fb
7b2c83ca-a94b-4de6-8a24-960c28ba8b87	profile	openid-connect	oidc-usermodel-attribute-mapper	\N	09515dc1-d9ed-43f6-a128-aa8b30a0b1fb
eff9c53b-d3a6-4cea-99d8-108fd2efd904	locale	openid-connect	oidc-usermodel-attribute-mapper	\N	09515dc1-d9ed-43f6-a128-aa8b30a0b1fb
67db5129-a67c-47d7-bcb8-8be68af4d33b	gender	openid-connect	oidc-usermodel-attribute-mapper	\N	09515dc1-d9ed-43f6-a128-aa8b30a0b1fb
abee741b-b4df-41d3-9295-68f3dd361e37	zoneinfo	openid-connect	oidc-usermodel-attribute-mapper	\N	09515dc1-d9ed-43f6-a128-aa8b30a0b1fb
2677e6b3-93a6-4eaf-8a2f-e5275117da3f	nickname	openid-connect	oidc-usermodel-attribute-mapper	\N	09515dc1-d9ed-43f6-a128-aa8b30a0b1fb
517c8b0b-871a-473d-b5fd-a040a4d40a7d	username	openid-connect	oidc-usermodel-property-mapper	\N	09515dc1-d9ed-43f6-a128-aa8b30a0b1fb
95e0a4bc-ee28-4ecd-980c-f200ebbec750	family name	openid-connect	oidc-usermodel-property-mapper	\N	09515dc1-d9ed-43f6-a128-aa8b30a0b1fb
01db02fe-0ddd-47a8-abb5-51b7ce631eed	picture	openid-connect	oidc-usermodel-attribute-mapper	\N	09515dc1-d9ed-43f6-a128-aa8b30a0b1fb
7f0ec684-6c89-41be-8ea9-5d2092e3b3b0	website	openid-connect	oidc-usermodel-attribute-mapper	\N	09515dc1-d9ed-43f6-a128-aa8b30a0b1fb
1771f228-2b8f-44e0-b45b-d25c915576cd	middle name	openid-connect	oidc-usermodel-attribute-mapper	\N	09515dc1-d9ed-43f6-a128-aa8b30a0b1fb
4e8e6ec9-62b4-4261-8263-0afd889af5bd	full name	openid-connect	oidc-full-name-mapper	\N	09515dc1-d9ed-43f6-a128-aa8b30a0b1fb
9ee5df25-3a34-4d28-a7c5-f3d01fb26a70	role list	saml	saml-role-list-mapper	\N	4a28cf61-9dc1-41a2-acbe-d4655458c19d
00196e52-03f8-48b5-8da2-9acdcdb33f8b	client roles	openid-connect	oidc-usermodel-client-role-mapper	\N	a6bcb9ab-69ca-415f-a30f-f588d60d0598
6cc7bbed-0807-4f3b-9688-83c4eb0860e0	audience resolve	openid-connect	oidc-audience-resolve-mapper	\N	a6bcb9ab-69ca-415f-a30f-f588d60d0598
37459c11-8053-47b0-8122-0dff2d3a4c9f	realm roles	openid-connect	oidc-usermodel-realm-role-mapper	\N	a6bcb9ab-69ca-415f-a30f-f588d60d0598
095a6259-ffc8-40e4-b812-e2c6d00b7a85	allowed web origins	openid-connect	oidc-allowed-origins-mapper	\N	d2b63358-a813-447c-afbf-f4c22fc9e183
b8d4e62a-c193-4ecb-96d5-80e1a6918f32	groups	openid-connect	oidc-group-membership-mapper	ace265c3-5eff-4002-898f-3f1cc8b3c30f	\N
245bc56a-8b24-4286-b70e-5719afdfd466	upn	openid-connect	oidc-usermodel-property-mapper	\N	7e284e72-20ce-4a0c-b9c5-5d0dffd775a4
804b08db-20b8-4c5e-a65b-3ffcf4736999	groups	openid-connect	oidc-usermodel-realm-role-mapper	\N	7e284e72-20ce-4a0c-b9c5-5d0dffd775a4
97b826ea-af56-49b3-a46c-9f155fff2a2d	upn	openid-connect	oidc-usermodel-property-mapper	\N	4b60c78d-a296-4047-beb6-92b487da43b8
b5b53b3f-1133-4e66-8318-e7e350d694fd	groups	openid-connect	oidc-usermodel-realm-role-mapper	\N	4b60c78d-a296-4047-beb6-92b487da43b8
88fac316-5f85-4e40-a8f4-7c8a6244a361	audience resolve	openid-connect	oidc-audience-resolve-mapper	3aa98620-e55f-4c26-af5a-37e7d694964e	\N
23ebcb06-86b1-4f0c-a1d9-dd60eaaaebd6	acr loa level	openid-connect	oidc-acr-mapper	\N	dd479ceb-03a2-4490-b511-12a5515745f0
d65c224c-b8ff-4e3e-9f9a-628f9b888a28	acr loa level	openid-connect	oidc-acr-mapper	\N	ae5dcb24-0f95-4c5e-b079-04b45d578ded
f59d19f0-7b90-4fed-94b4-87a3cce07f89	groups	openid-connect	oidc-group-membership-mapper	f5473ca3-5293-4d61-b46c-422cf2664546	\N
06ac63f8-a19b-4d6f-823e-cae9bf1418a0	groups	openid-connect	oidc-group-membership-mapper	35c8443a-bcd5-40da-b3b7-805c6dc6bc5a	\N
3879c1e8-5285-491b-91dc-17522d52db66	audience resolve	openid-connect	oidc-audience-resolve-mapper	5748140e-1c07-4a3d-9302-26cb6208dd5d	\N
3620f350-fbf4-42cd-8f0d-d40f5a43bbfc	locale	openid-connect	oidc-usermodel-attribute-mapper	d8c9cb3a-59eb-440a-9cb5-d8870bd8f180	\N
48023b14-b250-4c57-9ba4-e247f312baba	DataPlatform audience	openid-connect	oidc-audience-mapper	e9ab4ab5-754b-4f19-9d50-232bdf8cb322	\N
a52ef9e4-b96c-4f19-a6a9-e67d6dfec267	Client ID	openid-connect	oidc-usersessionmodel-note-mapper	e9ab4ab5-754b-4f19-9d50-232bdf8cb322	\N
25186ada-5bae-42d6-b600-687e04d8bcc7	Client Host	openid-connect	oidc-usersessionmodel-note-mapper	e9ab4ab5-754b-4f19-9d50-232bdf8cb322	\N
0bc77849-ef09-4ad2-b59a-a41cfb45cc89	roles	openid-connect	oidc-usermodel-client-role-mapper	e9ab4ab5-754b-4f19-9d50-232bdf8cb322	\N
ca55e51b-f8cc-48ac-9822-fb99d096a3c4	Client IP Address	openid-connect	oidc-usersessionmodel-note-mapper	e9ab4ab5-754b-4f19-9d50-232bdf8cb322	\N
bf14e772-6b31-4fdc-9c2f-c53585724953	auth_time	openid-connect	oidc-usersessionmodel-note-mapper	\N	d959d7f7-5626-4024-b420-9c47982bb617
de0e2f0b-bdbb-4d4d-9caf-99f63d1d16e9	sub	openid-connect	oidc-sub-mapper	\N	d959d7f7-5626-4024-b420-9c47982bb617
695f6bb9-e734-4ae1-b12f-821b75766784	auth_time	openid-connect	oidc-usersessionmodel-note-mapper	\N	7db28b56-71d1-4b95-a422-93450c685e7a
a46e3725-c8f1-4723-8853-1773eeb47bda	sub	openid-connect	oidc-sub-mapper	\N	7db28b56-71d1-4b95-a422-93450c685e7a
92f164da-a7bb-4a30-bcfb-0e7070fb63d2	Client ID	openid-connect	oidc-usersessionmodel-note-mapper	\N	ca6d6584-0182-41d1-b0ec-101e578bec3f
23f24498-a572-44c3-b1b1-571ad1a21e39	Client Host	openid-connect	oidc-usersessionmodel-note-mapper	\N	ca6d6584-0182-41d1-b0ec-101e578bec3f
febda328-6f74-4927-a050-970512880198	Client IP Address	openid-connect	oidc-usersessionmodel-note-mapper	\N	ca6d6584-0182-41d1-b0ec-101e578bec3f
1e2c72f2-84d4-450a-a46f-0a3fb21320a2	Client ID	openid-connect	oidc-usersessionmodel-note-mapper	\N	5e0dab1d-d1b8-47f2-97ca-602c13bfc4e9
32c1288d-40c1-4326-a4c9-649fc6e44617	Client Host	openid-connect	oidc-usersessionmodel-note-mapper	\N	5e0dab1d-d1b8-47f2-97ca-602c13bfc4e9
e6bab1a2-896f-4962-a128-c95dd173eb09	Client IP Address	openid-connect	oidc-usersessionmodel-note-mapper	\N	5e0dab1d-d1b8-47f2-97ca-602c13bfc4e9
17196c53-810e-4751-bda3-ab40c7ddcfb7	DataPlatform audience	openid-connect	oidc-audience-mapper	3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	\N
2a276af3-b30f-4cef-a32a-6ca305a0960c	Client ID	openid-connect	oidc-usersessionmodel-note-mapper	3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	\N
f581880e-bba8-4b2f-acdf-a9c4d4f93056	Client Host	openid-connect	oidc-usersessionmodel-note-mapper	3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	\N
461e7bea-12f4-4280-9265-2d44a09cb35f	roles	openid-connect	oidc-usermodel-client-role-mapper	3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	\N
c8b775e8-c90c-4a63-8e89-e36d401978df	Client IP Address	openid-connect	oidc-usersessionmodel-note-mapper	3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	\N
d86bf8b4-d933-4b18-873b-59e575d2ac4f	groups	openid-connect	oidc-group-membership-mapper	8fae8698-811f-4da1-b479-dbcce9ac9de5	\N
\.


--
-- Data for Name: protocol_mapper_config; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.protocol_mapper_config (protocol_mapper_id, value, name) FROM stdin;
3e56e601-09d8-4048-be9b-803f00165623	true	userinfo.token.claim
3e56e601-09d8-4048-be9b-803f00165623	locale	user.attribute
3e56e601-09d8-4048-be9b-803f00165623	true	id.token.claim
3e56e601-09d8-4048-be9b-803f00165623	true	access.token.claim
3e56e601-09d8-4048-be9b-803f00165623	locale	claim.name
3e56e601-09d8-4048-be9b-803f00165623	String	jsonType.label
5c8a386b-a1c2-4573-a41e-dbfb5e726b08	false	single
5c8a386b-a1c2-4573-a41e-dbfb5e726b08	Basic	attribute.nameformat
5c8a386b-a1c2-4573-a41e-dbfb5e726b08	Role	attribute.name
dffd8b0a-13a1-4125-abba-9f9d2a5db5bc	true	userinfo.token.claim
dffd8b0a-13a1-4125-abba-9f9d2a5db5bc	true	id.token.claim
dffd8b0a-13a1-4125-abba-9f9d2a5db5bc	true	access.token.claim
635ba14c-4af8-407e-90a0-dfd1b740ec69	true	userinfo.token.claim
635ba14c-4af8-407e-90a0-dfd1b740ec69	lastName	user.attribute
635ba14c-4af8-407e-90a0-dfd1b740ec69	true	id.token.claim
635ba14c-4af8-407e-90a0-dfd1b740ec69	true	access.token.claim
635ba14c-4af8-407e-90a0-dfd1b740ec69	family_name	claim.name
635ba14c-4af8-407e-90a0-dfd1b740ec69	String	jsonType.label
da0c46e9-0038-406b-8d54-4ee536b54e63	true	userinfo.token.claim
da0c46e9-0038-406b-8d54-4ee536b54e63	firstName	user.attribute
da0c46e9-0038-406b-8d54-4ee536b54e63	true	id.token.claim
da0c46e9-0038-406b-8d54-4ee536b54e63	true	access.token.claim
da0c46e9-0038-406b-8d54-4ee536b54e63	given_name	claim.name
da0c46e9-0038-406b-8d54-4ee536b54e63	String	jsonType.label
49c90cec-d376-43b5-990c-3bd8ecf57703	true	userinfo.token.claim
49c90cec-d376-43b5-990c-3bd8ecf57703	middleName	user.attribute
49c90cec-d376-43b5-990c-3bd8ecf57703	true	id.token.claim
49c90cec-d376-43b5-990c-3bd8ecf57703	true	access.token.claim
49c90cec-d376-43b5-990c-3bd8ecf57703	middle_name	claim.name
49c90cec-d376-43b5-990c-3bd8ecf57703	String	jsonType.label
90f176ba-5a99-4a35-b6f3-55f14449a1ad	true	userinfo.token.claim
90f176ba-5a99-4a35-b6f3-55f14449a1ad	nickname	user.attribute
90f176ba-5a99-4a35-b6f3-55f14449a1ad	true	id.token.claim
90f176ba-5a99-4a35-b6f3-55f14449a1ad	true	access.token.claim
90f176ba-5a99-4a35-b6f3-55f14449a1ad	nickname	claim.name
90f176ba-5a99-4a35-b6f3-55f14449a1ad	String	jsonType.label
60e58e7d-2e49-4cc6-b6eb-1a8469e735a6	true	userinfo.token.claim
60e58e7d-2e49-4cc6-b6eb-1a8469e735a6	username	user.attribute
60e58e7d-2e49-4cc6-b6eb-1a8469e735a6	true	id.token.claim
60e58e7d-2e49-4cc6-b6eb-1a8469e735a6	true	access.token.claim
60e58e7d-2e49-4cc6-b6eb-1a8469e735a6	preferred_username	claim.name
60e58e7d-2e49-4cc6-b6eb-1a8469e735a6	String	jsonType.label
7b72bb8b-b195-46ec-a323-86af78bacfb7	true	userinfo.token.claim
7b72bb8b-b195-46ec-a323-86af78bacfb7	profile	user.attribute
7b72bb8b-b195-46ec-a323-86af78bacfb7	true	id.token.claim
7b72bb8b-b195-46ec-a323-86af78bacfb7	true	access.token.claim
7b72bb8b-b195-46ec-a323-86af78bacfb7	profile	claim.name
7b72bb8b-b195-46ec-a323-86af78bacfb7	String	jsonType.label
0fe81355-fff3-41de-906f-6d37823da668	true	userinfo.token.claim
0fe81355-fff3-41de-906f-6d37823da668	picture	user.attribute
0fe81355-fff3-41de-906f-6d37823da668	true	id.token.claim
0fe81355-fff3-41de-906f-6d37823da668	true	access.token.claim
0fe81355-fff3-41de-906f-6d37823da668	picture	claim.name
0fe81355-fff3-41de-906f-6d37823da668	String	jsonType.label
2119cfc5-7f1b-4402-8b58-643db9aff359	true	userinfo.token.claim
2119cfc5-7f1b-4402-8b58-643db9aff359	website	user.attribute
2119cfc5-7f1b-4402-8b58-643db9aff359	true	id.token.claim
2119cfc5-7f1b-4402-8b58-643db9aff359	true	access.token.claim
2119cfc5-7f1b-4402-8b58-643db9aff359	website	claim.name
2119cfc5-7f1b-4402-8b58-643db9aff359	String	jsonType.label
de610f83-d394-4116-a157-754536389f49	true	userinfo.token.claim
de610f83-d394-4116-a157-754536389f49	gender	user.attribute
de610f83-d394-4116-a157-754536389f49	true	id.token.claim
de610f83-d394-4116-a157-754536389f49	true	access.token.claim
de610f83-d394-4116-a157-754536389f49	gender	claim.name
de610f83-d394-4116-a157-754536389f49	String	jsonType.label
1fc693ef-9f21-4d30-abea-728fd2eb7bea	true	userinfo.token.claim
1fc693ef-9f21-4d30-abea-728fd2eb7bea	birthdate	user.attribute
1fc693ef-9f21-4d30-abea-728fd2eb7bea	true	id.token.claim
1fc693ef-9f21-4d30-abea-728fd2eb7bea	true	access.token.claim
1fc693ef-9f21-4d30-abea-728fd2eb7bea	birthdate	claim.name
1fc693ef-9f21-4d30-abea-728fd2eb7bea	String	jsonType.label
8f261552-5fa6-4846-8e32-f6b930f1d366	true	userinfo.token.claim
8f261552-5fa6-4846-8e32-f6b930f1d366	zoneinfo	user.attribute
8f261552-5fa6-4846-8e32-f6b930f1d366	true	id.token.claim
8f261552-5fa6-4846-8e32-f6b930f1d366	true	access.token.claim
8f261552-5fa6-4846-8e32-f6b930f1d366	zoneinfo	claim.name
8f261552-5fa6-4846-8e32-f6b930f1d366	String	jsonType.label
7851ecd8-4bd8-4d0c-8e16-c28f91317fd8	true	userinfo.token.claim
7851ecd8-4bd8-4d0c-8e16-c28f91317fd8	locale	user.attribute
7851ecd8-4bd8-4d0c-8e16-c28f91317fd8	true	id.token.claim
7851ecd8-4bd8-4d0c-8e16-c28f91317fd8	true	access.token.claim
7851ecd8-4bd8-4d0c-8e16-c28f91317fd8	locale	claim.name
7851ecd8-4bd8-4d0c-8e16-c28f91317fd8	String	jsonType.label
7e4f5378-4f37-4c29-a9ab-ceeb8aa6d0bd	true	userinfo.token.claim
7e4f5378-4f37-4c29-a9ab-ceeb8aa6d0bd	updatedAt	user.attribute
7e4f5378-4f37-4c29-a9ab-ceeb8aa6d0bd	true	id.token.claim
7e4f5378-4f37-4c29-a9ab-ceeb8aa6d0bd	true	access.token.claim
7e4f5378-4f37-4c29-a9ab-ceeb8aa6d0bd	updated_at	claim.name
7e4f5378-4f37-4c29-a9ab-ceeb8aa6d0bd	String	jsonType.label
f647d493-11fc-42ab-846f-fd7765bdcf69	true	userinfo.token.claim
f647d493-11fc-42ab-846f-fd7765bdcf69	email	user.attribute
f647d493-11fc-42ab-846f-fd7765bdcf69	true	id.token.claim
f647d493-11fc-42ab-846f-fd7765bdcf69	true	access.token.claim
f647d493-11fc-42ab-846f-fd7765bdcf69	email	claim.name
f647d493-11fc-42ab-846f-fd7765bdcf69	String	jsonType.label
035ed604-00fe-423f-a866-92c6c861166a	true	userinfo.token.claim
035ed604-00fe-423f-a866-92c6c861166a	emailVerified	user.attribute
035ed604-00fe-423f-a866-92c6c861166a	true	id.token.claim
035ed604-00fe-423f-a866-92c6c861166a	true	access.token.claim
035ed604-00fe-423f-a866-92c6c861166a	email_verified	claim.name
035ed604-00fe-423f-a866-92c6c861166a	boolean	jsonType.label
f887ae4b-bcdc-461c-83e9-0f273989d249	formatted	user.attribute.formatted
f887ae4b-bcdc-461c-83e9-0f273989d249	country	user.attribute.country
f887ae4b-bcdc-461c-83e9-0f273989d249	postal_code	user.attribute.postal_code
f887ae4b-bcdc-461c-83e9-0f273989d249	true	userinfo.token.claim
f887ae4b-bcdc-461c-83e9-0f273989d249	street	user.attribute.street
f887ae4b-bcdc-461c-83e9-0f273989d249	true	id.token.claim
f887ae4b-bcdc-461c-83e9-0f273989d249	region	user.attribute.region
f887ae4b-bcdc-461c-83e9-0f273989d249	true	access.token.claim
f887ae4b-bcdc-461c-83e9-0f273989d249	locality	user.attribute.locality
ff2f2775-0796-493f-95f7-ec0fb86f25ac	true	userinfo.token.claim
ff2f2775-0796-493f-95f7-ec0fb86f25ac	phoneNumber	user.attribute
ff2f2775-0796-493f-95f7-ec0fb86f25ac	true	id.token.claim
ff2f2775-0796-493f-95f7-ec0fb86f25ac	true	access.token.claim
ff2f2775-0796-493f-95f7-ec0fb86f25ac	phone_number	claim.name
ff2f2775-0796-493f-95f7-ec0fb86f25ac	String	jsonType.label
8fd45cba-53e6-459a-a731-823437a8f0ce	true	userinfo.token.claim
8fd45cba-53e6-459a-a731-823437a8f0ce	phoneNumberVerified	user.attribute
8fd45cba-53e6-459a-a731-823437a8f0ce	true	id.token.claim
8fd45cba-53e6-459a-a731-823437a8f0ce	true	access.token.claim
8fd45cba-53e6-459a-a731-823437a8f0ce	phone_number_verified	claim.name
8fd45cba-53e6-459a-a731-823437a8f0ce	boolean	jsonType.label
e019db02-2a8b-4f50-abb1-2d7c1ea3b0cd	true	multivalued
e019db02-2a8b-4f50-abb1-2d7c1ea3b0cd	foo	user.attribute
e019db02-2a8b-4f50-abb1-2d7c1ea3b0cd	true	access.token.claim
e019db02-2a8b-4f50-abb1-2d7c1ea3b0cd	realm_access.roles	claim.name
e019db02-2a8b-4f50-abb1-2d7c1ea3b0cd	String	jsonType.label
6ff088af-b631-4f16-abd1-28aa1f4285b2	true	multivalued
6ff088af-b631-4f16-abd1-28aa1f4285b2	foo	user.attribute
6ff088af-b631-4f16-abd1-28aa1f4285b2	true	access.token.claim
6ff088af-b631-4f16-abd1-28aa1f4285b2	resource_access.${client_id}.roles	claim.name
6ff088af-b631-4f16-abd1-28aa1f4285b2	String	jsonType.label
09c065d6-3dbc-4f9e-a7d1-2d524a866b64	formatted	user.attribute.formatted
09c065d6-3dbc-4f9e-a7d1-2d524a866b64	country	user.attribute.country
09c065d6-3dbc-4f9e-a7d1-2d524a866b64	postal_code	user.attribute.postal_code
09c065d6-3dbc-4f9e-a7d1-2d524a866b64	true	userinfo.token.claim
09c065d6-3dbc-4f9e-a7d1-2d524a866b64	street	user.attribute.street
09c065d6-3dbc-4f9e-a7d1-2d524a866b64	true	id.token.claim
09c065d6-3dbc-4f9e-a7d1-2d524a866b64	region	user.attribute.region
09c065d6-3dbc-4f9e-a7d1-2d524a866b64	true	access.token.claim
09c065d6-3dbc-4f9e-a7d1-2d524a866b64	locality	user.attribute.locality
0ea4d7ac-0d8a-40d4-ac8c-af595cbca6d1	true	userinfo.token.claim
0ea4d7ac-0d8a-40d4-ac8c-af595cbca6d1	emailVerified	user.attribute
0ea4d7ac-0d8a-40d4-ac8c-af595cbca6d1	true	id.token.claim
0ea4d7ac-0d8a-40d4-ac8c-af595cbca6d1	true	access.token.claim
0ea4d7ac-0d8a-40d4-ac8c-af595cbca6d1	email_verified	claim.name
0ea4d7ac-0d8a-40d4-ac8c-af595cbca6d1	boolean	jsonType.label
294ad6e0-6d95-4946-b026-f7efa4cec524	true	userinfo.token.claim
294ad6e0-6d95-4946-b026-f7efa4cec524	email	user.attribute
294ad6e0-6d95-4946-b026-f7efa4cec524	true	id.token.claim
294ad6e0-6d95-4946-b026-f7efa4cec524	true	access.token.claim
294ad6e0-6d95-4946-b026-f7efa4cec524	email	claim.name
294ad6e0-6d95-4946-b026-f7efa4cec524	String	jsonType.label
f007ca94-5832-4370-8cf3-d9037ee500a0	true	userinfo.token.claim
f007ca94-5832-4370-8cf3-d9037ee500a0	phoneNumber	user.attribute
f007ca94-5832-4370-8cf3-d9037ee500a0	true	id.token.claim
f007ca94-5832-4370-8cf3-d9037ee500a0	true	access.token.claim
f007ca94-5832-4370-8cf3-d9037ee500a0	phone_number	claim.name
f007ca94-5832-4370-8cf3-d9037ee500a0	String	jsonType.label
2d175494-ffb0-4f6d-a545-dfe74cff97db	true	userinfo.token.claim
2d175494-ffb0-4f6d-a545-dfe74cff97db	phoneNumberVerified	user.attribute
2d175494-ffb0-4f6d-a545-dfe74cff97db	true	id.token.claim
2d175494-ffb0-4f6d-a545-dfe74cff97db	true	access.token.claim
2d175494-ffb0-4f6d-a545-dfe74cff97db	phone_number_verified	claim.name
2d175494-ffb0-4f6d-a545-dfe74cff97db	boolean	jsonType.label
f6923e19-61a7-4ad6-8a46-60a5772872c1	true	userinfo.token.claim
f6923e19-61a7-4ad6-8a46-60a5772872c1	firstName	user.attribute
f6923e19-61a7-4ad6-8a46-60a5772872c1	true	id.token.claim
f6923e19-61a7-4ad6-8a46-60a5772872c1	true	access.token.claim
f6923e19-61a7-4ad6-8a46-60a5772872c1	given_name	claim.name
f6923e19-61a7-4ad6-8a46-60a5772872c1	String	jsonType.label
631de126-6cb8-4967-be21-32f7fdeaf6d4	true	userinfo.token.claim
631de126-6cb8-4967-be21-32f7fdeaf6d4	updatedAt	user.attribute
631de126-6cb8-4967-be21-32f7fdeaf6d4	true	id.token.claim
631de126-6cb8-4967-be21-32f7fdeaf6d4	true	access.token.claim
631de126-6cb8-4967-be21-32f7fdeaf6d4	updated_at	claim.name
631de126-6cb8-4967-be21-32f7fdeaf6d4	String	jsonType.label
e5717b57-4ca1-4299-8cb5-fb0fddb94807	true	userinfo.token.claim
e5717b57-4ca1-4299-8cb5-fb0fddb94807	birthdate	user.attribute
e5717b57-4ca1-4299-8cb5-fb0fddb94807	true	id.token.claim
e5717b57-4ca1-4299-8cb5-fb0fddb94807	true	access.token.claim
e5717b57-4ca1-4299-8cb5-fb0fddb94807	birthdate	claim.name
e5717b57-4ca1-4299-8cb5-fb0fddb94807	String	jsonType.label
7b2c83ca-a94b-4de6-8a24-960c28ba8b87	true	userinfo.token.claim
7b2c83ca-a94b-4de6-8a24-960c28ba8b87	profile	user.attribute
7b2c83ca-a94b-4de6-8a24-960c28ba8b87	true	id.token.claim
7b2c83ca-a94b-4de6-8a24-960c28ba8b87	true	access.token.claim
7b2c83ca-a94b-4de6-8a24-960c28ba8b87	profile	claim.name
7b2c83ca-a94b-4de6-8a24-960c28ba8b87	String	jsonType.label
eff9c53b-d3a6-4cea-99d8-108fd2efd904	true	userinfo.token.claim
eff9c53b-d3a6-4cea-99d8-108fd2efd904	locale	user.attribute
eff9c53b-d3a6-4cea-99d8-108fd2efd904	true	id.token.claim
eff9c53b-d3a6-4cea-99d8-108fd2efd904	true	access.token.claim
eff9c53b-d3a6-4cea-99d8-108fd2efd904	locale	claim.name
eff9c53b-d3a6-4cea-99d8-108fd2efd904	String	jsonType.label
67db5129-a67c-47d7-bcb8-8be68af4d33b	true	userinfo.token.claim
67db5129-a67c-47d7-bcb8-8be68af4d33b	gender	user.attribute
67db5129-a67c-47d7-bcb8-8be68af4d33b	true	id.token.claim
67db5129-a67c-47d7-bcb8-8be68af4d33b	true	access.token.claim
67db5129-a67c-47d7-bcb8-8be68af4d33b	gender	claim.name
67db5129-a67c-47d7-bcb8-8be68af4d33b	String	jsonType.label
abee741b-b4df-41d3-9295-68f3dd361e37	true	userinfo.token.claim
abee741b-b4df-41d3-9295-68f3dd361e37	zoneinfo	user.attribute
abee741b-b4df-41d3-9295-68f3dd361e37	true	id.token.claim
abee741b-b4df-41d3-9295-68f3dd361e37	true	access.token.claim
abee741b-b4df-41d3-9295-68f3dd361e37	zoneinfo	claim.name
abee741b-b4df-41d3-9295-68f3dd361e37	String	jsonType.label
2677e6b3-93a6-4eaf-8a2f-e5275117da3f	true	userinfo.token.claim
2677e6b3-93a6-4eaf-8a2f-e5275117da3f	nickname	user.attribute
2677e6b3-93a6-4eaf-8a2f-e5275117da3f	true	id.token.claim
2677e6b3-93a6-4eaf-8a2f-e5275117da3f	true	access.token.claim
2677e6b3-93a6-4eaf-8a2f-e5275117da3f	nickname	claim.name
2677e6b3-93a6-4eaf-8a2f-e5275117da3f	String	jsonType.label
517c8b0b-871a-473d-b5fd-a040a4d40a7d	true	userinfo.token.claim
517c8b0b-871a-473d-b5fd-a040a4d40a7d	username	user.attribute
517c8b0b-871a-473d-b5fd-a040a4d40a7d	true	id.token.claim
517c8b0b-871a-473d-b5fd-a040a4d40a7d	true	access.token.claim
517c8b0b-871a-473d-b5fd-a040a4d40a7d	preferred_username	claim.name
517c8b0b-871a-473d-b5fd-a040a4d40a7d	String	jsonType.label
95e0a4bc-ee28-4ecd-980c-f200ebbec750	true	userinfo.token.claim
95e0a4bc-ee28-4ecd-980c-f200ebbec750	lastName	user.attribute
95e0a4bc-ee28-4ecd-980c-f200ebbec750	true	id.token.claim
95e0a4bc-ee28-4ecd-980c-f200ebbec750	true	access.token.claim
95e0a4bc-ee28-4ecd-980c-f200ebbec750	family_name	claim.name
95e0a4bc-ee28-4ecd-980c-f200ebbec750	String	jsonType.label
01db02fe-0ddd-47a8-abb5-51b7ce631eed	true	userinfo.token.claim
01db02fe-0ddd-47a8-abb5-51b7ce631eed	picture	user.attribute
01db02fe-0ddd-47a8-abb5-51b7ce631eed	true	id.token.claim
01db02fe-0ddd-47a8-abb5-51b7ce631eed	true	access.token.claim
01db02fe-0ddd-47a8-abb5-51b7ce631eed	picture	claim.name
01db02fe-0ddd-47a8-abb5-51b7ce631eed	String	jsonType.label
7f0ec684-6c89-41be-8ea9-5d2092e3b3b0	true	userinfo.token.claim
7f0ec684-6c89-41be-8ea9-5d2092e3b3b0	website	user.attribute
7f0ec684-6c89-41be-8ea9-5d2092e3b3b0	true	id.token.claim
7f0ec684-6c89-41be-8ea9-5d2092e3b3b0	true	access.token.claim
7f0ec684-6c89-41be-8ea9-5d2092e3b3b0	website	claim.name
7f0ec684-6c89-41be-8ea9-5d2092e3b3b0	String	jsonType.label
1771f228-2b8f-44e0-b45b-d25c915576cd	true	userinfo.token.claim
1771f228-2b8f-44e0-b45b-d25c915576cd	middleName	user.attribute
1771f228-2b8f-44e0-b45b-d25c915576cd	true	id.token.claim
1771f228-2b8f-44e0-b45b-d25c915576cd	true	access.token.claim
1771f228-2b8f-44e0-b45b-d25c915576cd	middle_name	claim.name
1771f228-2b8f-44e0-b45b-d25c915576cd	String	jsonType.label
4e8e6ec9-62b4-4261-8263-0afd889af5bd	true	id.token.claim
4e8e6ec9-62b4-4261-8263-0afd889af5bd	true	access.token.claim
4e8e6ec9-62b4-4261-8263-0afd889af5bd	true	userinfo.token.claim
9ee5df25-3a34-4d28-a7c5-f3d01fb26a70	false	single
9ee5df25-3a34-4d28-a7c5-f3d01fb26a70	Basic	attribute.nameformat
9ee5df25-3a34-4d28-a7c5-f3d01fb26a70	Role	attribute.name
00196e52-03f8-48b5-8da2-9acdcdb33f8b	foo	user.attribute
00196e52-03f8-48b5-8da2-9acdcdb33f8b	true	access.token.claim
00196e52-03f8-48b5-8da2-9acdcdb33f8b	resource_access.${client_id}.roles	claim.name
00196e52-03f8-48b5-8da2-9acdcdb33f8b	String	jsonType.label
00196e52-03f8-48b5-8da2-9acdcdb33f8b	true	multivalued
37459c11-8053-47b0-8122-0dff2d3a4c9f	foo	user.attribute
37459c11-8053-47b0-8122-0dff2d3a4c9f	true	access.token.claim
37459c11-8053-47b0-8122-0dff2d3a4c9f	realm_access.roles	claim.name
37459c11-8053-47b0-8122-0dff2d3a4c9f	String	jsonType.label
37459c11-8053-47b0-8122-0dff2d3a4c9f	true	multivalued
a52ef9e4-b96c-4f19-a6a9-e67d6dfec267	clientId	user.session.note
a52ef9e4-b96c-4f19-a6a9-e67d6dfec267	true	userinfo.token.claim
a52ef9e4-b96c-4f19-a6a9-e67d6dfec267	true	id.token.claim
a52ef9e4-b96c-4f19-a6a9-e67d6dfec267	true	access.token.claim
a52ef9e4-b96c-4f19-a6a9-e67d6dfec267	clientId	claim.name
a52ef9e4-b96c-4f19-a6a9-e67d6dfec267	String	jsonType.label
25186ada-5bae-42d6-b600-687e04d8bcc7	clientHost	user.session.note
25186ada-5bae-42d6-b600-687e04d8bcc7	true	userinfo.token.claim
25186ada-5bae-42d6-b600-687e04d8bcc7	true	id.token.claim
25186ada-5bae-42d6-b600-687e04d8bcc7	true	access.token.claim
25186ada-5bae-42d6-b600-687e04d8bcc7	clientHost	claim.name
25186ada-5bae-42d6-b600-687e04d8bcc7	String	jsonType.label
ca55e51b-f8cc-48ac-9822-fb99d096a3c4	clientAddress	user.session.note
ca55e51b-f8cc-48ac-9822-fb99d096a3c4	true	userinfo.token.claim
ca55e51b-f8cc-48ac-9822-fb99d096a3c4	true	id.token.claim
ca55e51b-f8cc-48ac-9822-fb99d096a3c4	true	access.token.claim
ca55e51b-f8cc-48ac-9822-fb99d096a3c4	clientAddress	claim.name
ca55e51b-f8cc-48ac-9822-fb99d096a3c4	String	jsonType.label
3620f350-fbf4-42cd-8f0d-d40f5a43bbfc	true	userinfo.token.claim
3620f350-fbf4-42cd-8f0d-d40f5a43bbfc	locale	user.attribute
3620f350-fbf4-42cd-8f0d-d40f5a43bbfc	true	id.token.claim
3620f350-fbf4-42cd-8f0d-d40f5a43bbfc	true	access.token.claim
3620f350-fbf4-42cd-8f0d-d40f5a43bbfc	locale	claim.name
3620f350-fbf4-42cd-8f0d-d40f5a43bbfc	String	jsonType.label
0bc77849-ef09-4ad2-b59a-a41cfb45cc89	true	multivalued
0bc77849-ef09-4ad2-b59a-a41cfb45cc89	true	userinfo.token.claim
0bc77849-ef09-4ad2-b59a-a41cfb45cc89	true	id.token.claim
0bc77849-ef09-4ad2-b59a-a41cfb45cc89	true	access.token.claim
0bc77849-ef09-4ad2-b59a-a41cfb45cc89	groups	claim.name
0bc77849-ef09-4ad2-b59a-a41cfb45cc89	String	jsonType.label
0bc77849-ef09-4ad2-b59a-a41cfb45cc89	cmem-service-account	usermodel.clientRoleMapping.clientId
48023b14-b250-4c57-9ba4-e247f312baba	false	id.token.claim
48023b14-b250-4c57-9ba4-e247f312baba	true	access.token.claim
48023b14-b250-4c57-9ba4-e247f312baba	dataplatform	included.custom.audience
f59d19f0-7b90-4fed-94b4-87a3cce07f89	false	full.path
f59d19f0-7b90-4fed-94b4-87a3cce07f89	false	id.token.claim
f59d19f0-7b90-4fed-94b4-87a3cce07f89	true	access.token.claim
f59d19f0-7b90-4fed-94b4-87a3cce07f89	groups	claim.name
f59d19f0-7b90-4fed-94b4-87a3cce07f89	true	userinfo.token.claim
b8d4e62a-c193-4ecb-96d5-80e1a6918f32	false	full.path
b8d4e62a-c193-4ecb-96d5-80e1a6918f32	false	id.token.claim
b8d4e62a-c193-4ecb-96d5-80e1a6918f32	true	access.token.claim
b8d4e62a-c193-4ecb-96d5-80e1a6918f32	groups	claim.name
b8d4e62a-c193-4ecb-96d5-80e1a6918f32	true	userinfo.token.claim
245bc56a-8b24-4286-b70e-5719afdfd466	true	userinfo.token.claim
245bc56a-8b24-4286-b70e-5719afdfd466	username	user.attribute
245bc56a-8b24-4286-b70e-5719afdfd466	true	id.token.claim
245bc56a-8b24-4286-b70e-5719afdfd466	true	access.token.claim
245bc56a-8b24-4286-b70e-5719afdfd466	upn	claim.name
245bc56a-8b24-4286-b70e-5719afdfd466	String	jsonType.label
804b08db-20b8-4c5e-a65b-3ffcf4736999	true	multivalued
804b08db-20b8-4c5e-a65b-3ffcf4736999	foo	user.attribute
804b08db-20b8-4c5e-a65b-3ffcf4736999	true	id.token.claim
804b08db-20b8-4c5e-a65b-3ffcf4736999	true	access.token.claim
804b08db-20b8-4c5e-a65b-3ffcf4736999	groups	claim.name
804b08db-20b8-4c5e-a65b-3ffcf4736999	String	jsonType.label
97b826ea-af56-49b3-a46c-9f155fff2a2d	true	userinfo.token.claim
97b826ea-af56-49b3-a46c-9f155fff2a2d	username	user.attribute
97b826ea-af56-49b3-a46c-9f155fff2a2d	true	id.token.claim
97b826ea-af56-49b3-a46c-9f155fff2a2d	true	access.token.claim
97b826ea-af56-49b3-a46c-9f155fff2a2d	upn	claim.name
97b826ea-af56-49b3-a46c-9f155fff2a2d	String	jsonType.label
b5b53b3f-1133-4e66-8318-e7e350d694fd	true	multivalued
b5b53b3f-1133-4e66-8318-e7e350d694fd	foo	user.attribute
b5b53b3f-1133-4e66-8318-e7e350d694fd	true	id.token.claim
b5b53b3f-1133-4e66-8318-e7e350d694fd	true	access.token.claim
b5b53b3f-1133-4e66-8318-e7e350d694fd	groups	claim.name
b5b53b3f-1133-4e66-8318-e7e350d694fd	String	jsonType.label
23ebcb06-86b1-4f0c-a1d9-dd60eaaaebd6	true	id.token.claim
23ebcb06-86b1-4f0c-a1d9-dd60eaaaebd6	true	access.token.claim
d65c224c-b8ff-4e3e-9f9a-628f9b888a28	true	id.token.claim
d65c224c-b8ff-4e3e-9f9a-628f9b888a28	true	access.token.claim
06ac63f8-a19b-4d6f-823e-cae9bf1418a0	false	full.path
06ac63f8-a19b-4d6f-823e-cae9bf1418a0	false	id.token.claim
06ac63f8-a19b-4d6f-823e-cae9bf1418a0	true	access.token.claim
06ac63f8-a19b-4d6f-823e-cae9bf1418a0	groups	claim.name
06ac63f8-a19b-4d6f-823e-cae9bf1418a0	true	userinfo.token.claim
bf14e772-6b31-4fdc-9c2f-c53585724953	AUTH_TIME	user.session.note
bf14e772-6b31-4fdc-9c2f-c53585724953	true	introspection.token.claim
bf14e772-6b31-4fdc-9c2f-c53585724953	true	id.token.claim
bf14e772-6b31-4fdc-9c2f-c53585724953	true	access.token.claim
bf14e772-6b31-4fdc-9c2f-c53585724953	auth_time	claim.name
bf14e772-6b31-4fdc-9c2f-c53585724953	long	jsonType.label
de0e2f0b-bdbb-4d4d-9caf-99f63d1d16e9	true	introspection.token.claim
de0e2f0b-bdbb-4d4d-9caf-99f63d1d16e9	true	access.token.claim
695f6bb9-e734-4ae1-b12f-821b75766784	AUTH_TIME	user.session.note
695f6bb9-e734-4ae1-b12f-821b75766784	true	introspection.token.claim
695f6bb9-e734-4ae1-b12f-821b75766784	true	id.token.claim
695f6bb9-e734-4ae1-b12f-821b75766784	true	access.token.claim
695f6bb9-e734-4ae1-b12f-821b75766784	auth_time	claim.name
695f6bb9-e734-4ae1-b12f-821b75766784	long	jsonType.label
a46e3725-c8f1-4723-8853-1773eeb47bda	true	introspection.token.claim
a46e3725-c8f1-4723-8853-1773eeb47bda	true	access.token.claim
23f24498-a572-44c3-b1b1-571ad1a21e39	clientHost	user.session.note
23f24498-a572-44c3-b1b1-571ad1a21e39	true	introspection.token.claim
23f24498-a572-44c3-b1b1-571ad1a21e39	true	id.token.claim
23f24498-a572-44c3-b1b1-571ad1a21e39	true	access.token.claim
23f24498-a572-44c3-b1b1-571ad1a21e39	clientHost	claim.name
23f24498-a572-44c3-b1b1-571ad1a21e39	String	jsonType.label
92f164da-a7bb-4a30-bcfb-0e7070fb63d2	client_id	user.session.note
92f164da-a7bb-4a30-bcfb-0e7070fb63d2	true	introspection.token.claim
92f164da-a7bb-4a30-bcfb-0e7070fb63d2	true	id.token.claim
92f164da-a7bb-4a30-bcfb-0e7070fb63d2	true	access.token.claim
92f164da-a7bb-4a30-bcfb-0e7070fb63d2	client_id	claim.name
92f164da-a7bb-4a30-bcfb-0e7070fb63d2	String	jsonType.label
febda328-6f74-4927-a050-970512880198	clientAddress	user.session.note
febda328-6f74-4927-a050-970512880198	true	introspection.token.claim
febda328-6f74-4927-a050-970512880198	true	id.token.claim
febda328-6f74-4927-a050-970512880198	true	access.token.claim
febda328-6f74-4927-a050-970512880198	clientAddress	claim.name
febda328-6f74-4927-a050-970512880198	String	jsonType.label
1e2c72f2-84d4-450a-a46f-0a3fb21320a2	client_id	user.session.note
1e2c72f2-84d4-450a-a46f-0a3fb21320a2	true	introspection.token.claim
1e2c72f2-84d4-450a-a46f-0a3fb21320a2	true	id.token.claim
1e2c72f2-84d4-450a-a46f-0a3fb21320a2	true	access.token.claim
1e2c72f2-84d4-450a-a46f-0a3fb21320a2	client_id	claim.name
1e2c72f2-84d4-450a-a46f-0a3fb21320a2	String	jsonType.label
32c1288d-40c1-4326-a4c9-649fc6e44617	clientHost	user.session.note
32c1288d-40c1-4326-a4c9-649fc6e44617	true	introspection.token.claim
32c1288d-40c1-4326-a4c9-649fc6e44617	true	id.token.claim
32c1288d-40c1-4326-a4c9-649fc6e44617	true	access.token.claim
32c1288d-40c1-4326-a4c9-649fc6e44617	clientHost	claim.name
32c1288d-40c1-4326-a4c9-649fc6e44617	String	jsonType.label
e6bab1a2-896f-4962-a128-c95dd173eb09	clientAddress	user.session.note
e6bab1a2-896f-4962-a128-c95dd173eb09	true	introspection.token.claim
e6bab1a2-896f-4962-a128-c95dd173eb09	true	id.token.claim
e6bab1a2-896f-4962-a128-c95dd173eb09	true	access.token.claim
e6bab1a2-896f-4962-a128-c95dd173eb09	clientAddress	claim.name
e6bab1a2-896f-4962-a128-c95dd173eb09	String	jsonType.label
17196c53-810e-4751-bda3-ab40c7ddcfb7	false	id.token.claim
17196c53-810e-4751-bda3-ab40c7ddcfb7	true	access.token.claim
17196c53-810e-4751-bda3-ab40c7ddcfb7	dataplatform	included.custom.audience
17196c53-810e-4751-bda3-ab40c7ddcfb7	false	userinfo.token.claim
2a276af3-b30f-4cef-a32a-6ca305a0960c	clientId	user.session.note
2a276af3-b30f-4cef-a32a-6ca305a0960c	true	id.token.claim
2a276af3-b30f-4cef-a32a-6ca305a0960c	true	access.token.claim
2a276af3-b30f-4cef-a32a-6ca305a0960c	clientId	claim.name
2a276af3-b30f-4cef-a32a-6ca305a0960c	String	jsonType.label
2a276af3-b30f-4cef-a32a-6ca305a0960c	true	userinfo.token.claim
461e7bea-12f4-4280-9265-2d44a09cb35f	true	multivalued
461e7bea-12f4-4280-9265-2d44a09cb35f	true	userinfo.token.claim
461e7bea-12f4-4280-9265-2d44a09cb35f	true	id.token.claim
461e7bea-12f4-4280-9265-2d44a09cb35f	true	access.token.claim
461e7bea-12f4-4280-9265-2d44a09cb35f	groups	claim.name
461e7bea-12f4-4280-9265-2d44a09cb35f	String	jsonType.label
c8b775e8-c90c-4a63-8e89-e36d401978df	clientAddress	user.session.note
c8b775e8-c90c-4a63-8e89-e36d401978df	true	id.token.claim
c8b775e8-c90c-4a63-8e89-e36d401978df	true	access.token.claim
c8b775e8-c90c-4a63-8e89-e36d401978df	clientAddress	claim.name
c8b775e8-c90c-4a63-8e89-e36d401978df	String	jsonType.label
c8b775e8-c90c-4a63-8e89-e36d401978df	true	userinfo.token.claim
f581880e-bba8-4b2f-acdf-a9c4d4f93056	clientHost	user.session.note
f581880e-bba8-4b2f-acdf-a9c4d4f93056	true	id.token.claim
f581880e-bba8-4b2f-acdf-a9c4d4f93056	true	access.token.claim
f581880e-bba8-4b2f-acdf-a9c4d4f93056	clientHost	claim.name
f581880e-bba8-4b2f-acdf-a9c4d4f93056	String	jsonType.label
f581880e-bba8-4b2f-acdf-a9c4d4f93056	true	userinfo.token.claim
d86bf8b4-d933-4b18-873b-59e575d2ac4f	false	full.path
d86bf8b4-d933-4b18-873b-59e575d2ac4f	false	id.token.claim
d86bf8b4-d933-4b18-873b-59e575d2ac4f	true	access.token.claim
d86bf8b4-d933-4b18-873b-59e575d2ac4f	groups	claim.name
d86bf8b4-d933-4b18-873b-59e575d2ac4f	true	userinfo.token.claim
d86bf8b4-d933-4b18-873b-59e575d2ac4f	true	multivalued
461e7bea-12f4-4280-9265-2d44a09cb35f	graph-insights-service-account	usermodel.clientRoleMapping.clientId
461e7bea-12f4-4280-9265-2d44a09cb35f	true	introspection.token.claim
461e7bea-12f4-4280-9265-2d44a09cb35f	false	lightweight.claim
\.


--
-- Data for Name: realm; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.realm (id, access_code_lifespan, user_action_lifespan, access_token_lifespan, account_theme, admin_theme, email_theme, enabled, events_enabled, events_expiration, login_theme, name, not_before, password_policy, registration_allowed, remember_me, reset_password_allowed, social, ssl_required, sso_idle_timeout, sso_max_lifespan, update_profile_on_soc_login, verify_email, master_admin_client, login_lifespan, internationalization_enabled, default_locale, reg_email_as_username, admin_events_enabled, admin_events_details_enabled, edit_username_allowed, otp_policy_counter, otp_policy_window, otp_policy_period, otp_policy_digits, otp_policy_alg, otp_policy_type, browser_flow, registration_flow, direct_grant_flow, reset_credentials_flow, client_auth_flow, offline_session_idle_timeout, revoke_refresh_token, access_token_life_implicit, login_with_email_allowed, duplicate_emails_allowed, docker_auth_flow, refresh_token_max_reuse, allow_user_managed_access, sso_max_lifespan_remember_me, sso_idle_timeout_remember_me, default_role) FROM stdin;
master	60	300	60	\N	\N	\N	t	f	0	\N	master	0	\N	f	f	f	f	NONE	1800	36000	f	f	360b5c9e-6960-451f-b5d4-9eaae2dacdda	1800	f	\N	f	f	f	f	0	1	30	6	HmacSHA1	totp	f890fd5b-38c5-4df7-a5d6-b7cbdf410b51	1d54f170-d0c8-407b-b21c-ca2874086817	bc5b14ed-460a-43f5-b35a-98d633854427	d9ac52f8-8409-42d5-b770-c1cf0d36b338	cb2a9494-1724-4c24-b5ac-13140c538e62	2592000	f	900	t	f	9e65b1a4-1145-4b54-9ab1-e2b0ebb342f2	0	f	0	0	ca307c76-8087-436a-a34d-b2cedf5d75d7
cmem	60	300	300	eccenca	\N	\N	t	f	0	eccenca	cmem	1678955706	\N	f	f	f	f	NONE	3600	36000	f	f	688ef36e-12f7-462a-bf89-cceec001558f	1800	t	en	f	f	f	f	0	1	30	6	HmacSHA1	totp	33f564f5-744b-470d-b68d-ad5bf265138c	14c43aaa-6e87-45d6-bcec-0d089c948af1	5483b483-e820-4638-adeb-7218483f6303	d17934b3-018e-452a-8602-69f579abd0a8	c4efad04-66ca-4729-a116-26d0d144d136	2592000	f	28800	t	f	b0ef60b5-bc51-41c1-b22a-cbc35e9b276d	0	f	0	0	1a4b720e-9278-46d9-93ce-3c0dc7c6f51c
\.


--
-- Data for Name: realm_attribute; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.realm_attribute (name, realm_id, value) FROM stdin;
_browser_header.contentSecurityPolicyReportOnly	master	
_browser_header.xContentTypeOptions	master	nosniff
_browser_header.xRobotsTag	master	none
_browser_header.xFrameOptions	master	SAMEORIGIN
_browser_header.contentSecurityPolicy	master	frame-src 'self'; frame-ancestors 'self'; object-src 'none';
_browser_header.xXSSProtection	master	1; mode=block
_browser_header.strictTransportSecurity	master	max-age=31536000; includeSubDomains
bruteForceProtected	master	false
permanentLockout	master	false
maxFailureWaitSeconds	master	900
minimumQuickLoginWaitSeconds	master	60
waitIncrementSeconds	master	60
quickLoginCheckMilliSeconds	master	1000
maxDeltaTimeSeconds	master	43200
failureFactor	master	30
displayName	master	Keycloak
displayNameHtml	master	<div class="kc-logo-text"><span>Keycloak</span></div>
offlineSessionMaxLifespanEnabled	master	false
offlineSessionMaxLifespan	master	5184000
_browser_header.contentSecurityPolicyReportOnly	cmem	
_browser_header.xContentTypeOptions	cmem	nosniff
_browser_header.xRobotsTag	cmem	none
_browser_header.xFrameOptions	cmem	SAMEORIGIN
_browser_header.contentSecurityPolicy	cmem	frame-src 'self'; frame-ancestors 'self'; object-src 'none';
_browser_header.xXSSProtection	cmem	1; mode=block
_browser_header.strictTransportSecurity	cmem	max-age=31536000; includeSubDomains
bruteForceProtected	cmem	false
permanentLockout	cmem	false
maxFailureWaitSeconds	cmem	900
minimumQuickLoginWaitSeconds	cmem	60
waitIncrementSeconds	cmem	60
quickLoginCheckMilliSeconds	cmem	1000
maxDeltaTimeSeconds	cmem	43200
failureFactor	cmem	30
offlineSessionMaxLifespanEnabled	cmem	false
offlineSessionMaxLifespan	cmem	5184000
actionTokenGeneratedByAdminLifespan	cmem	43200
actionTokenGeneratedByUserLifespan	cmem	300
displayName	cmem	eccenca Corporate Memory
displayNameHtml	cmem	<span class="ecc-logo"></span>eccenca Corporate Memory
client-policies.profiles	cmem	{"profiles":[]}
client-policies.policies	cmem	{"policies":[]}
client-policies.profiles	master	{"profiles":[]}
client-policies.policies	master	{"policies":[]}
cibaAuthRequestedUserHint	cmem	login_hint
cibaBackchannelTokenDeliveryMode	cmem	poll
cibaExpiresIn	cmem	120
cibaInterval	cmem	5
oauth2DeviceCodeLifespan	cmem	600
oauth2DevicePollingInterval	cmem	5
parRequestUriLifespan	cmem	60
webAuthnPolicyAttestationConveyancePreference	cmem	not specified
webAuthnPolicyAttestationConveyancePreferencePasswordless	cmem	not specified
webAuthnPolicyAuthenticatorAttachment	cmem	not specified
webAuthnPolicyAuthenticatorAttachmentPasswordless	cmem	not specified
webAuthnPolicyAvoidSameAuthenticatorRegister	cmem	false
webAuthnPolicyAvoidSameAuthenticatorRegisterPasswordless	cmem	false
webAuthnPolicyCreateTimeout	cmem	0
webAuthnPolicyCreateTimeoutPasswordless	cmem	0
webAuthnPolicyRequireResidentKey	cmem	not specified
webAuthnPolicyRequireResidentKeyPasswordless	cmem	not specified
webAuthnPolicyRpEntityName	cmem	keycloak
webAuthnPolicyRpEntityNamePasswordless	cmem	keycloak
webAuthnPolicyRpId	cmem	
webAuthnPolicyRpIdPasswordless	cmem	
webAuthnPolicySignatureAlgorithms	cmem	ES256
webAuthnPolicySignatureAlgorithmsPasswordless	cmem	ES256
webAuthnPolicyUserVerificationRequirement	cmem	not specified
webAuthnPolicyUserVerificationRequirementPasswordless	cmem	not specified
firstBrokerLoginFlowId	master	521105ab-005a-463e-8ea9-2641afb0559e
firstBrokerLoginFlowId	cmem	922ee2f8-c90e-4696-a38e-96850189298b
\.


--
-- Data for Name: realm_default_groups; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.realm_default_groups (realm_id, group_id) FROM stdin;
\.


--
-- Data for Name: realm_enabled_event_types; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.realm_enabled_event_types (realm_id, value) FROM stdin;
\.


--
-- Data for Name: realm_events_listeners; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.realm_events_listeners (realm_id, value) FROM stdin;
master	jboss-logging
cmem	jboss-logging
\.


--
-- Data for Name: realm_localizations; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.realm_localizations (realm_id, locale, texts) FROM stdin;
\.


--
-- Data for Name: realm_required_credential; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.realm_required_credential (type, form_label, input, secret, realm_id) FROM stdin;
password	password	t	t	master
password	password	t	t	cmem
\.


--
-- Data for Name: realm_smtp_config; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.realm_smtp_config (realm_id, value, name) FROM stdin;
\.


--
-- Data for Name: realm_supported_locales; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.realm_supported_locales (realm_id, value) FROM stdin;
cmem	de
cmem	en
cmem	fr
\.


--
-- Data for Name: redirect_uris; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.redirect_uris (client_id, value) FROM stdin;
110e1f10-2989-4463-8f9b-f8f50d4b7ab4	/admin/master/console/*
75ba9e57-8bd3-4560-af7b-8d8bc74cae0d	/realms/master/account/*
3aa98620-e55f-4c26-af5a-37e7d694964e	/realms/master/account/*
f5473ca3-5293-4d61-b46c-422cf2664546	*
35c8443a-bcd5-40da-b3b7-805c6dc6bc5a	*
6338d0ff-f06e-4987-af63-197be726c44c	/realms/cmem/account/*
5748140e-1c07-4a3d-9302-26cb6208dd5d	/realms/cmem/account/*
d8c9cb3a-59eb-440a-9cb5-d8870bd8f180	/admin/cmem/console/*
e9ab4ab5-754b-4f19-9d50-232bdf8cb322	*
3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	*
8fae8698-811f-4da1-b479-dbcce9ac9de5	*
\.


--
-- Data for Name: required_action_config; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.required_action_config (required_action_id, value, name) FROM stdin;
\.


--
-- Data for Name: required_action_provider; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.required_action_provider (id, alias, name, realm_id, enabled, default_action, provider_id, priority) FROM stdin;
0213ae9d-a192-443c-b4d4-0c96bd01c36d	VERIFY_EMAIL	Verify Email	master	t	f	VERIFY_EMAIL	50
3d81cc8f-f8a1-400b-b5bc-16f0d73cedee	UPDATE_PROFILE	Update Profile	master	t	f	UPDATE_PROFILE	40
49169fa3-1708-48dc-a6a0-49f61c76fb3a	CONFIGURE_TOTP	Configure OTP	master	t	f	CONFIGURE_TOTP	10
fcdcce0d-9cd3-47b4-95f7-223906d43fc7	UPDATE_PASSWORD	Update Password	master	t	f	UPDATE_PASSWORD	30
dc509f3d-27f0-473d-83e0-0f3159ca5e79	CONFIGURE_TOTP	Configure OTP	cmem	t	f	CONFIGURE_TOTP	10
f6102b13-5213-44a6-b528-3af6345bb4bd	UPDATE_PASSWORD	Update Password	cmem	t	f	UPDATE_PASSWORD	30
ae741d27-21d4-44a8-9436-d63013b94fcf	UPDATE_PROFILE	Update Profile	cmem	t	f	UPDATE_PROFILE	40
5d49d867-15a9-4c98-bf88-83d59d07f447	VERIFY_EMAIL	Verify Email	cmem	t	f	VERIFY_EMAIL	50
b17477cd-b1bf-4e90-9259-c088d641c325	update_user_locale	Update User Locale	master	t	f	update_user_locale	1000
345c434a-30ed-4704-9cb3-d34171b56bd3	update_user_locale	Update User Locale	cmem	t	f	update_user_locale	1000
5d012467-6ef8-479e-b29c-8b3a3e4edb57	delete_account	Delete Account	master	f	f	delete_account	60
9cbe583f-5598-4d4a-8ecf-1a18bef53700	delete_account	Delete Account	cmem	f	f	delete_account	60
3a66f669-a46f-483e-a331-13c89f28aa74	TERMS_AND_CONDITIONS	Terms and Conditions	master	f	f	TERMS_AND_CONDITIONS	20
65401d49-9311-4ee8-b82b-ce31ba65858f	TERMS_AND_CONDITIONS	Terms and Conditions	cmem	f	f	TERMS_AND_CONDITIONS	20
bf299b1f-acc4-4782-9756-b2022bf4945b	delete_credential	Delete Credential	master	t	f	delete_credential	100
5dadc690-3231-4ee2-b6fd-ac18ae2be7de	delete_credential	Delete Credential	cmem	t	f	delete_credential	100
c3ad32ab-4201-47a3-93ee-6ea67bd72c7a	idp_link	Linking Identity Provider	master	t	f	idp_link	110
b1bea7da-e59a-4cc5-b9d7-aa6498f2b14d	idp_link	Linking Identity Provider	cmem	t	f	idp_link	110
\.


--
-- Data for Name: resource_attribute; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.resource_attribute (id, name, value, resource_id) FROM stdin;
\.


--
-- Data for Name: resource_policy; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.resource_policy (resource_id, policy_id) FROM stdin;
\.


--
-- Data for Name: resource_scope; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.resource_scope (resource_id, scope_id) FROM stdin;
\.


--
-- Data for Name: resource_server; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.resource_server (id, allow_rs_remote_mgmt, policy_enforce_mode, decision_strategy) FROM stdin;
\.


--
-- Data for Name: resource_server_perm_ticket; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.resource_server_perm_ticket (id, owner, requester, created_timestamp, granted_timestamp, resource_id, scope_id, resource_server_id, policy_id) FROM stdin;
\.


--
-- Data for Name: resource_server_policy; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.resource_server_policy (id, name, description, type, decision_strategy, logic, resource_server_id, owner) FROM stdin;
\.


--
-- Data for Name: resource_server_resource; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.resource_server_resource (id, name, type, icon_uri, owner, resource_server_id, owner_managed_access, display_name) FROM stdin;
\.


--
-- Data for Name: resource_server_scope; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.resource_server_scope (id, name, icon_uri, resource_server_id, display_name) FROM stdin;
\.


--
-- Data for Name: resource_uris; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.resource_uris (resource_id, value) FROM stdin;
\.


--
-- Data for Name: revoked_token; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.revoked_token (id, expire) FROM stdin;
\.


--
-- Data for Name: role_attribute; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.role_attribute (id, role_id, name, value) FROM stdin;
\.


--
-- Data for Name: scope_mapping; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.scope_mapping (client_id, role_id) FROM stdin;
3aa98620-e55f-4c26-af5a-37e7d694964e	37e3b8f2-8f1c-44f3-ae56-e298c46deed0
5748140e-1c07-4a3d-9302-26cb6208dd5d	3213869f-7ce1-4bcf-9c7a-50193557b1ca
5748140e-1c07-4a3d-9302-26cb6208dd5d	865b8c69-58d8-4827-b0c5-f4c7aee9c973
3aa98620-e55f-4c26-af5a-37e7d694964e	cbb78552-e80d-482b-b90d-0b99d4dbea0b
\.


--
-- Data for Name: scope_policy; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.scope_policy (scope_id, policy_id) FROM stdin;
\.


--
-- Data for Name: server_config; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.server_config (server_config_key, value, version) FROM stdin;
crt_jgroups	{"prvKey":"MIIEowIBAAKCAQEA0VokNkQGpAzr6d1Yn9pOc6pGxvILwMTckhpTVbDbQPv70cuYryQyOGcKYh1hG4kGrGYnx8ef4K88EFjyUrjq2epl8clRogtmFRiU3yn/ubsX41DL5KEzhGQ5dVQFMYd+jjX3fJTdeO7mtyhgYK9cxQgMcYaP5XUgsZfNMgx8SLzYJKLx7ZsrEs414WkQyqEVL+t+zPH4f1F9/wsVicjBZsr84rA+aGY5Dc9lDHwx8vYVgELbRkHhHkRH50vIgzlc8bmXS7BH8HL6UzqI1CaZT07w7L73BEaHjM+i37AQQbgb36rmnRNk4SJeOS0fTHYMu2cFIfN7jl4W9RM50XnS0QIDAQABAoIBAAC0my9WrQG8LemSTzyuZViI6o58AaAE9i12RmiBKlTlGwmya1ghqPhY2QBB++IkuUM/2mFlwSYjeKxnHIN8vNZS9HjJ1Y+IuXVx2sAfi/wDB8rFXvGelH63XhDiR1EQw8TtNkoxhEdSOLBizJhBXHwu0BzsDadhz755Gj+F064qkI1pb5nBn+fsOEWDqdW1yvUh0dl9lq1K/vngAMtY+Nk9atIjaHY6Cu7eccR/2rVTnFd9xYeawBBDCC9E4KcKFY76HeBV04VjzLptCwdhi+KK/duEzlW/J1WBtlCBNabdnHMIKepG0bkCoLLxZ4JiK7JjCXwBWcc3ateMybEO94ECgYEA8a/tTqV+673FF/dcratA+ZPPwwvFr1z0Pkyg2/6cObT/8wrknfrhSkhauUrbf6s3+u5SQ3ZI0Z+/o+q2pbwvBVuoHz2O2gAFR3xLZoL4pvzIHQPmtjj4hBvDQtlNqfo1kGy8oEuCkggzp/aq7gDT3Q6jXQkZZ4ksbnbU+MtAv8ECgYEA3cAAbYOf0eVjThcDq8FZkIUyXwTUrm7xrSzLecyRUdM7XZsYr535ZlGGbUEBcR5rs5PgXfIvh7BbKGLiVhmhu/qa/22QmO7HbAB3qagD19kk0vm2jqIJW+rPfXoFVA3akH/TsFt9QCmt/e0jjbToPBGnrvNAkjXV+nYpvdmi1xECgYA8ooCM7KRNDI04GA0eXQquEtFbA8cS2eVFBACPcO9M4wYbua3lnJ2M/14Tgp5TB2fCAqyM1E4smUGBJE+ygOXjGD2zqMQAGWU5rAtWqqErc9vYu7PUH7LpofV4/f+oF2f81er05Dzb2kbras0zbO26VgPSQYgoG5gUFqgTyxpxgQKBgDg7VyBuT1nfrIYB6glk93xhenuD8xbkxV5fzJ1vVa6FPTmoeeMW0Ua0B72uzVnNGAyqxCuunYTwIL2mDbU9vLi5fRKmyxMtAd8OY0nfdFIJG4BwmG2lA3COo90y0yUUekdIUvsWyDU8HIYW23w00utgosAHqWkqQ7/GtSESjmuxAoGBANTYNT/S9a29nW4DrN/hYmB5UtsWdujz1NbStX78aM373kiEU6dDg0PuhvR21BR0kTNxCpxf10AJ4zfjsFXrrK6iAhaSHtfOhOelt6+fareM/I0KNNBkOaIwvk5f1VGlx8pS1ObWIToxpx1gXUhG18KLVxkFFZyqFJ//ScPhN/N4","pubKey":"MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA0VokNkQGpAzr6d1Yn9pOc6pGxvILwMTckhpTVbDbQPv70cuYryQyOGcKYh1hG4kGrGYnx8ef4K88EFjyUrjq2epl8clRogtmFRiU3yn/ubsX41DL5KEzhGQ5dVQFMYd+jjX3fJTdeO7mtyhgYK9cxQgMcYaP5XUgsZfNMgx8SLzYJKLx7ZsrEs414WkQyqEVL+t+zPH4f1F9/wsVicjBZsr84rA+aGY5Dc9lDHwx8vYVgELbRkHhHkRH50vIgzlc8bmXS7BH8HL6UzqI1CaZT07w7L73BEaHjM+i37AQQbgb36rmnRNk4SJeOS0fTHYMu2cFIfN7jl4W9RM50XnS0QIDAQAB","crt":"MIICnTCCAYUCBgGZ4abZjzANBgkqhkiG9w0BAQsFADASMRAwDgYDVQQDDAdqZ3JvdXBzMB4XDTI1MTAxNDA3MzUzMloXDTI1MTIxMzA3MzcxMVowEjEQMA4GA1UEAwwHamdyb3VwczCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBANFaJDZEBqQM6+ndWJ/aTnOqRsbyC8DE3JIaU1Ww20D7+9HLmK8kMjhnCmIdYRuJBqxmJ8fHn+CvPBBY8lK46tnqZfHJUaILZhUYlN8p/7m7F+NQy+ShM4RkOXVUBTGHfo4193yU3Xju5rcoYGCvXMUIDHGGj+V1ILGXzTIMfEi82CSi8e2bKxLONeFpEMqhFS/rfszx+H9Rff8LFYnIwWbK/OKwPmhmOQ3PZQx8MfL2FYBC20ZB4R5ER+dLyIM5XPG5l0uwR/By+lM6iNQmmU9O8Oy+9wRGh4zPot+wEEG4G9+q5p0TZOEiXjktH0x2DLtnBSHze45eFvUTOdF50tECAwEAATANBgkqhkiG9w0BAQsFAAOCAQEAc7CRHW2h5M9bEVK6MNTV2juO1Xf4BI5YFcb6+lnk2gr4gQq8gbRqujl+BUZ84X8zzgxgvdqmm+fLXOWBn8nbz5UzowiHPAkypqKZI7WtVr7PmhWjG9siyAMhQ+iQ9FavmaF59jg8oCH6SV7TTQFeHPPljLEW8BazhYxMdCd9Aq46xM8O0We144yf369WO+Yg1Qa41DnldpSlTRiWDnTWROLIyNSogvgrMXmrKTLfeCA1mYZhdlcehy/j4zWv5qtosPV+NsHt847zfsLNWUEvO/aCBEcLKx1Q2MB0nKVvJ0DOMMuUCRYZ7tQc5qCy+yVO0y6OWyieh3uHmaG6NGtZcg==","alias":"a045c27b-59d4-4abb-9741-25e612e0d180","generatedMillis":1760427432379}	0
JGROUPS_ADDRESS_SEQUENCE	2	2
\.


--
-- Data for Name: user_attribute; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.user_attribute (name, value, user_id, id, long_value_hash, long_value_hash_lower_case, long_value) FROM stdin;
\.


--
-- Data for Name: user_consent; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.user_consent (id, client_id, user_id, created_date, last_updated_date, client_storage_provider, external_client_id) FROM stdin;
\.


--
-- Data for Name: user_consent_client_scope; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.user_consent_client_scope (user_consent_id, scope_id) FROM stdin;
\.


--
-- Data for Name: user_entity; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.user_entity (id, email, email_constraint, email_verified, enabled, federation_link, first_name, last_name, realm_id, username, created_timestamp, service_account_client_link, not_before) FROM stdin;
b25ae075-620c-46f8-880e-42405e06d1d4	\N	fde5b0dc-50e9-4369-83ad-009fa9c1ccce	f	t	\N	\N	\N	master	admin	1556199814807	\N	0
41d9200c-4676-42f4-ae48-f407bd5db1d8	\N	32a981fc-e199-430e-a61b-4127343603bc	t	t	\N			cmem	admin	1553007994105	\N	0
27e2d6ff-7671-45f2-a9c7-f9241a27337d	\N	20d5d177-c4fb-4556-9a04-3ab91e27316c	t	t	\N			cmem	service-account-cmem-service-account	1557410120607	e9ab4ab5-754b-4f19-9d50-232bdf8cb322	0
fcb3086d-680b-4433-b3b6-e544083232fa	\N	9acc9f95-1578-4976-8eb5-9555a1921862	f	t	\N	\N	\N	cmem	service-account-graph-insights-service-account	1760430843293	3083904d-41d8-4fe4-aaf0-bb4e42f0dea9	0
\.


--
-- Data for Name: user_federation_config; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.user_federation_config (user_federation_provider_id, value, name) FROM stdin;
\.


--
-- Data for Name: user_federation_mapper; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.user_federation_mapper (id, name, federation_provider_id, federation_mapper_type, realm_id) FROM stdin;
\.


--
-- Data for Name: user_federation_mapper_config; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.user_federation_mapper_config (user_federation_mapper_id, value, name) FROM stdin;
\.


--
-- Data for Name: user_federation_provider; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.user_federation_provider (id, changed_sync_period, display_name, full_sync_period, last_sync, priority, provider_name, realm_id) FROM stdin;
\.


--
-- Data for Name: user_group_membership; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.user_group_membership (group_id, user_id, membership_type) FROM stdin;
aac88e00-3c36-4001-9af3-b746c06eb773	41d9200c-4676-42f4-ae48-f407bd5db1d8	UNMANAGED
27294582-70ad-4ee7-8303-bc5ab783a954	41d9200c-4676-42f4-ae48-f407bd5db1d8	UNMANAGED
\.


--
-- Data for Name: user_required_action; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.user_required_action (user_id, required_action) FROM stdin;
\.


--
-- Data for Name: user_role_mapping; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.user_role_mapping (role_id, user_id) FROM stdin;
8393c807-bc46-4249-bdec-76afcd5676eb	41d9200c-4676-42f4-ae48-f407bd5db1d8
73819e85-b0fc-45c9-9d43-0cd4cfa8edf7	41d9200c-4676-42f4-ae48-f407bd5db1d8
3213869f-7ce1-4bcf-9c7a-50193557b1ca	41d9200c-4676-42f4-ae48-f407bd5db1d8
5fbde31c-9e26-4bd3-ae04-8126f74569df	41d9200c-4676-42f4-ae48-f407bd5db1d8
37e3b8f2-8f1c-44f3-ae56-e298c46deed0	b25ae075-620c-46f8-880e-42405e06d1d4
de1fa12a-0e9b-4c51-9a7d-0e6e69f44648	b25ae075-620c-46f8-880e-42405e06d1d4
5e57000a-9f7b-4d0a-839a-7d6e328ef8aa	b25ae075-620c-46f8-880e-42405e06d1d4
c41a715c-2c3d-4abc-ac16-cad7784b222c	b25ae075-620c-46f8-880e-42405e06d1d4
665badf5-9f53-4a3b-bea0-6268d02aa280	b25ae075-620c-46f8-880e-42405e06d1d4
8393c807-bc46-4249-bdec-76afcd5676eb	27e2d6ff-7671-45f2-a9c7-f9241a27337d
73819e85-b0fc-45c9-9d43-0cd4cfa8edf7	27e2d6ff-7671-45f2-a9c7-f9241a27337d
3213869f-7ce1-4bcf-9c7a-50193557b1ca	27e2d6ff-7671-45f2-a9c7-f9241a27337d
5fbde31c-9e26-4bd3-ae04-8126f74569df	27e2d6ff-7671-45f2-a9c7-f9241a27337d
b2690d78-24f5-4835-9435-5030e33bf476	27e2d6ff-7671-45f2-a9c7-f9241a27337d
601fdf42-dcc4-468a-9c0c-539aa3f0eee3	41d9200c-4676-42f4-ae48-f407bd5db1d8
601fdf42-dcc4-468a-9c0c-539aa3f0eee3	27e2d6ff-7671-45f2-a9c7-f9241a27337d
e0a80c5f-b0c2-4830-a8d6-bb99920fa39f	27e2d6ff-7671-45f2-a9c7-f9241a27337d
4f9d8043-706e-48ab-a2b8-73d7a7ee74e0	fcb3086d-680b-4433-b3b6-e544083232fa
\.


--
-- Data for Name: web_origins; Type: TABLE DATA; Schema: public; Owner: keycloak
--

COPY public.web_origins (client_id, value) FROM stdin;
110e1f10-2989-4463-8f9b-f8f50d4b7ab4	+
d8c9cb3a-59eb-440a-9cb5-d8870bd8f180	+
\.


--
-- Name: org_domain ORG_DOMAIN_pkey; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.org_domain
    ADD CONSTRAINT "ORG_DOMAIN_pkey" PRIMARY KEY (id, name);


--
-- Name: org ORG_pkey; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.org
    ADD CONSTRAINT "ORG_pkey" PRIMARY KEY (id);


--
-- Name: server_config SERVER_CONFIG_pkey; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.server_config
    ADD CONSTRAINT "SERVER_CONFIG_pkey" PRIMARY KEY (server_config_key);


--
-- Name: keycloak_role UK_J3RWUVD56ONTGSUHOGM184WW2-2; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.keycloak_role
    ADD CONSTRAINT "UK_J3RWUVD56ONTGSUHOGM184WW2-2" UNIQUE (name, client_realm_constraint);


--
-- Name: client_auth_flow_bindings c_cli_flow_bind; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.client_auth_flow_bindings
    ADD CONSTRAINT c_cli_flow_bind PRIMARY KEY (client_id, binding_name);


--
-- Name: client_scope_client c_cli_scope_bind; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.client_scope_client
    ADD CONSTRAINT c_cli_scope_bind PRIMARY KEY (client_id, scope_id);


--
-- Name: client_initial_access cnstr_client_init_acc_pk; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.client_initial_access
    ADD CONSTRAINT cnstr_client_init_acc_pk PRIMARY KEY (id);


--
-- Name: realm_default_groups con_group_id_def_groups; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.realm_default_groups
    ADD CONSTRAINT con_group_id_def_groups UNIQUE (group_id);


--
-- Name: broker_link constr_broker_link_pk; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.broker_link
    ADD CONSTRAINT constr_broker_link_pk PRIMARY KEY (identity_provider, user_id);


--
-- Name: component_config constr_component_config_pk; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.component_config
    ADD CONSTRAINT constr_component_config_pk PRIMARY KEY (id);


--
-- Name: component constr_component_pk; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.component
    ADD CONSTRAINT constr_component_pk PRIMARY KEY (id);


--
-- Name: fed_user_required_action constr_fed_required_action; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.fed_user_required_action
    ADD CONSTRAINT constr_fed_required_action PRIMARY KEY (required_action, user_id);


--
-- Name: fed_user_attribute constr_fed_user_attr_pk; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.fed_user_attribute
    ADD CONSTRAINT constr_fed_user_attr_pk PRIMARY KEY (id);


--
-- Name: fed_user_consent constr_fed_user_consent_pk; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.fed_user_consent
    ADD CONSTRAINT constr_fed_user_consent_pk PRIMARY KEY (id);


--
-- Name: fed_user_credential constr_fed_user_cred_pk; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.fed_user_credential
    ADD CONSTRAINT constr_fed_user_cred_pk PRIMARY KEY (id);


--
-- Name: fed_user_group_membership constr_fed_user_group; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.fed_user_group_membership
    ADD CONSTRAINT constr_fed_user_group PRIMARY KEY (group_id, user_id);


--
-- Name: fed_user_role_mapping constr_fed_user_role; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.fed_user_role_mapping
    ADD CONSTRAINT constr_fed_user_role PRIMARY KEY (role_id, user_id);


--
-- Name: federated_user constr_federated_user; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.federated_user
    ADD CONSTRAINT constr_federated_user PRIMARY KEY (id);


--
-- Name: realm_default_groups constr_realm_default_groups; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.realm_default_groups
    ADD CONSTRAINT constr_realm_default_groups PRIMARY KEY (realm_id, group_id);


--
-- Name: realm_enabled_event_types constr_realm_enabl_event_types; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.realm_enabled_event_types
    ADD CONSTRAINT constr_realm_enabl_event_types PRIMARY KEY (realm_id, value);


--
-- Name: realm_events_listeners constr_realm_events_listeners; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.realm_events_listeners
    ADD CONSTRAINT constr_realm_events_listeners PRIMARY KEY (realm_id, value);


--
-- Name: realm_supported_locales constr_realm_supported_locales; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.realm_supported_locales
    ADD CONSTRAINT constr_realm_supported_locales PRIMARY KEY (realm_id, value);


--
-- Name: identity_provider constraint_2b; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.identity_provider
    ADD CONSTRAINT constraint_2b PRIMARY KEY (internal_id);


--
-- Name: client_attributes constraint_3c; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.client_attributes
    ADD CONSTRAINT constraint_3c PRIMARY KEY (client_id, name);


--
-- Name: event_entity constraint_4; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.event_entity
    ADD CONSTRAINT constraint_4 PRIMARY KEY (id);


--
-- Name: federated_identity constraint_40; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.federated_identity
    ADD CONSTRAINT constraint_40 PRIMARY KEY (identity_provider, user_id);


--
-- Name: realm constraint_4a; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.realm
    ADD CONSTRAINT constraint_4a PRIMARY KEY (id);


--
-- Name: user_federation_provider constraint_5c; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.user_federation_provider
    ADD CONSTRAINT constraint_5c PRIMARY KEY (id);


--
-- Name: client constraint_7; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.client
    ADD CONSTRAINT constraint_7 PRIMARY KEY (id);


--
-- Name: scope_mapping constraint_81; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.scope_mapping
    ADD CONSTRAINT constraint_81 PRIMARY KEY (client_id, role_id);


--
-- Name: client_node_registrations constraint_84; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.client_node_registrations
    ADD CONSTRAINT constraint_84 PRIMARY KEY (client_id, name);


--
-- Name: realm_attribute constraint_9; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.realm_attribute
    ADD CONSTRAINT constraint_9 PRIMARY KEY (name, realm_id);


--
-- Name: realm_required_credential constraint_92; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.realm_required_credential
    ADD CONSTRAINT constraint_92 PRIMARY KEY (realm_id, type);


--
-- Name: keycloak_role constraint_a; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.keycloak_role
    ADD CONSTRAINT constraint_a PRIMARY KEY (id);


--
-- Name: admin_event_entity constraint_admin_event_entity; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.admin_event_entity
    ADD CONSTRAINT constraint_admin_event_entity PRIMARY KEY (id);


--
-- Name: authenticator_config_entry constraint_auth_cfg_pk; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.authenticator_config_entry
    ADD CONSTRAINT constraint_auth_cfg_pk PRIMARY KEY (authenticator_id, name);


--
-- Name: authentication_execution constraint_auth_exec_pk; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.authentication_execution
    ADD CONSTRAINT constraint_auth_exec_pk PRIMARY KEY (id);


--
-- Name: authentication_flow constraint_auth_flow_pk; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.authentication_flow
    ADD CONSTRAINT constraint_auth_flow_pk PRIMARY KEY (id);


--
-- Name: authenticator_config constraint_auth_pk; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.authenticator_config
    ADD CONSTRAINT constraint_auth_pk PRIMARY KEY (id);


--
-- Name: user_role_mapping constraint_c; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.user_role_mapping
    ADD CONSTRAINT constraint_c PRIMARY KEY (role_id, user_id);


--
-- Name: composite_role constraint_composite_role; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.composite_role
    ADD CONSTRAINT constraint_composite_role PRIMARY KEY (composite, child_role);


--
-- Name: identity_provider_config constraint_d; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.identity_provider_config
    ADD CONSTRAINT constraint_d PRIMARY KEY (identity_provider_id, name);


--
-- Name: policy_config constraint_dpc; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.policy_config
    ADD CONSTRAINT constraint_dpc PRIMARY KEY (policy_id, name);


--
-- Name: realm_smtp_config constraint_e; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.realm_smtp_config
    ADD CONSTRAINT constraint_e PRIMARY KEY (realm_id, name);


--
-- Name: credential constraint_f; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.credential
    ADD CONSTRAINT constraint_f PRIMARY KEY (id);


--
-- Name: user_federation_config constraint_f9; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.user_federation_config
    ADD CONSTRAINT constraint_f9 PRIMARY KEY (user_federation_provider_id, name);


--
-- Name: resource_server_perm_ticket constraint_fapmt; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.resource_server_perm_ticket
    ADD CONSTRAINT constraint_fapmt PRIMARY KEY (id);


--
-- Name: resource_server_resource constraint_farsr; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.resource_server_resource
    ADD CONSTRAINT constraint_farsr PRIMARY KEY (id);


--
-- Name: resource_server_policy constraint_farsrp; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.resource_server_policy
    ADD CONSTRAINT constraint_farsrp PRIMARY KEY (id);


--
-- Name: associated_policy constraint_farsrpap; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.associated_policy
    ADD CONSTRAINT constraint_farsrpap PRIMARY KEY (policy_id, associated_policy_id);


--
-- Name: resource_policy constraint_farsrpp; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.resource_policy
    ADD CONSTRAINT constraint_farsrpp PRIMARY KEY (resource_id, policy_id);


--
-- Name: resource_server_scope constraint_farsrs; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.resource_server_scope
    ADD CONSTRAINT constraint_farsrs PRIMARY KEY (id);


--
-- Name: resource_scope constraint_farsrsp; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.resource_scope
    ADD CONSTRAINT constraint_farsrsp PRIMARY KEY (resource_id, scope_id);


--
-- Name: scope_policy constraint_farsrsps; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.scope_policy
    ADD CONSTRAINT constraint_farsrsps PRIMARY KEY (scope_id, policy_id);


--
-- Name: user_entity constraint_fb; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.user_entity
    ADD CONSTRAINT constraint_fb PRIMARY KEY (id);


--
-- Name: user_federation_mapper_config constraint_fedmapper_cfg_pm; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.user_federation_mapper_config
    ADD CONSTRAINT constraint_fedmapper_cfg_pm PRIMARY KEY (user_federation_mapper_id, name);


--
-- Name: user_federation_mapper constraint_fedmapperpm; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.user_federation_mapper
    ADD CONSTRAINT constraint_fedmapperpm PRIMARY KEY (id);


--
-- Name: fed_user_consent_cl_scope constraint_fgrntcsnt_clsc_pm; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.fed_user_consent_cl_scope
    ADD CONSTRAINT constraint_fgrntcsnt_clsc_pm PRIMARY KEY (user_consent_id, scope_id);


--
-- Name: user_consent_client_scope constraint_grntcsnt_clsc_pm; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.user_consent_client_scope
    ADD CONSTRAINT constraint_grntcsnt_clsc_pm PRIMARY KEY (user_consent_id, scope_id);


--
-- Name: user_consent constraint_grntcsnt_pm; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.user_consent
    ADD CONSTRAINT constraint_grntcsnt_pm PRIMARY KEY (id);


--
-- Name: keycloak_group constraint_group; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.keycloak_group
    ADD CONSTRAINT constraint_group PRIMARY KEY (id);


--
-- Name: group_attribute constraint_group_attribute_pk; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.group_attribute
    ADD CONSTRAINT constraint_group_attribute_pk PRIMARY KEY (id);


--
-- Name: group_role_mapping constraint_group_role; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.group_role_mapping
    ADD CONSTRAINT constraint_group_role PRIMARY KEY (role_id, group_id);


--
-- Name: identity_provider_mapper constraint_idpm; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.identity_provider_mapper
    ADD CONSTRAINT constraint_idpm PRIMARY KEY (id);


--
-- Name: idp_mapper_config constraint_idpmconfig; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.idp_mapper_config
    ADD CONSTRAINT constraint_idpmconfig PRIMARY KEY (idp_mapper_id, name);


--
-- Name: jgroups_ping constraint_jgroups_ping; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.jgroups_ping
    ADD CONSTRAINT constraint_jgroups_ping PRIMARY KEY (address);


--
-- Name: migration_model constraint_migmod; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.migration_model
    ADD CONSTRAINT constraint_migmod PRIMARY KEY (id);


--
-- Name: offline_client_session constraint_offl_cl_ses_pk3; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.offline_client_session
    ADD CONSTRAINT constraint_offl_cl_ses_pk3 PRIMARY KEY (user_session_id, client_id, client_storage_provider, external_client_id, offline_flag);


--
-- Name: offline_user_session constraint_offl_us_ses_pk2; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.offline_user_session
    ADD CONSTRAINT constraint_offl_us_ses_pk2 PRIMARY KEY (user_session_id, offline_flag);


--
-- Name: protocol_mapper constraint_pcm; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.protocol_mapper
    ADD CONSTRAINT constraint_pcm PRIMARY KEY (id);


--
-- Name: protocol_mapper_config constraint_pmconfig; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.protocol_mapper_config
    ADD CONSTRAINT constraint_pmconfig PRIMARY KEY (protocol_mapper_id, name);


--
-- Name: redirect_uris constraint_redirect_uris; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.redirect_uris
    ADD CONSTRAINT constraint_redirect_uris PRIMARY KEY (client_id, value);


--
-- Name: required_action_config constraint_req_act_cfg_pk; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.required_action_config
    ADD CONSTRAINT constraint_req_act_cfg_pk PRIMARY KEY (required_action_id, name);


--
-- Name: required_action_provider constraint_req_act_prv_pk; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.required_action_provider
    ADD CONSTRAINT constraint_req_act_prv_pk PRIMARY KEY (id);


--
-- Name: user_required_action constraint_required_action; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.user_required_action
    ADD CONSTRAINT constraint_required_action PRIMARY KEY (required_action, user_id);


--
-- Name: resource_uris constraint_resour_uris_pk; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.resource_uris
    ADD CONSTRAINT constraint_resour_uris_pk PRIMARY KEY (resource_id, value);


--
-- Name: role_attribute constraint_role_attribute_pk; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.role_attribute
    ADD CONSTRAINT constraint_role_attribute_pk PRIMARY KEY (id);


--
-- Name: revoked_token constraint_rt; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.revoked_token
    ADD CONSTRAINT constraint_rt PRIMARY KEY (id);


--
-- Name: user_attribute constraint_user_attribute_pk; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.user_attribute
    ADD CONSTRAINT constraint_user_attribute_pk PRIMARY KEY (id);


--
-- Name: user_group_membership constraint_user_group; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.user_group_membership
    ADD CONSTRAINT constraint_user_group PRIMARY KEY (group_id, user_id);


--
-- Name: web_origins constraint_web_origins; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.web_origins
    ADD CONSTRAINT constraint_web_origins PRIMARY KEY (client_id, value);


--
-- Name: client_scope_attributes pk_cl_tmpl_attr; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.client_scope_attributes
    ADD CONSTRAINT pk_cl_tmpl_attr PRIMARY KEY (scope_id, name);


--
-- Name: client_scope pk_cli_template; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.client_scope
    ADD CONSTRAINT pk_cli_template PRIMARY KEY (id);


--
-- Name: databasechangeloglock pk_databasechangeloglock; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.databasechangeloglock
    ADD CONSTRAINT pk_databasechangeloglock PRIMARY KEY (id);


--
-- Name: resource_server pk_resource_server; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.resource_server
    ADD CONSTRAINT pk_resource_server PRIMARY KEY (id);


--
-- Name: client_scope_role_mapping pk_template_scope; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.client_scope_role_mapping
    ADD CONSTRAINT pk_template_scope PRIMARY KEY (scope_id, role_id);


--
-- Name: default_client_scope r_def_cli_scope_bind; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.default_client_scope
    ADD CONSTRAINT r_def_cli_scope_bind PRIMARY KEY (realm_id, scope_id);


--
-- Name: realm_localizations realm_localizations_pkey; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.realm_localizations
    ADD CONSTRAINT realm_localizations_pkey PRIMARY KEY (realm_id, locale);


--
-- Name: resource_attribute res_attr_pk; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.resource_attribute
    ADD CONSTRAINT res_attr_pk PRIMARY KEY (id);


--
-- Name: keycloak_group sibling_names; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.keycloak_group
    ADD CONSTRAINT sibling_names UNIQUE (realm_id, parent_group, name);


--
-- Name: identity_provider uk_2daelwnibji49avxsrtuf6xj33; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.identity_provider
    ADD CONSTRAINT uk_2daelwnibji49avxsrtuf6xj33 UNIQUE (provider_alias, realm_id);


--
-- Name: client uk_b71cjlbenv945rb6gcon438at; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.client
    ADD CONSTRAINT uk_b71cjlbenv945rb6gcon438at UNIQUE (realm_id, client_id);


--
-- Name: client_scope uk_cli_scope; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.client_scope
    ADD CONSTRAINT uk_cli_scope UNIQUE (realm_id, name);


--
-- Name: user_entity uk_dykn684sl8up1crfei6eckhd7; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.user_entity
    ADD CONSTRAINT uk_dykn684sl8up1crfei6eckhd7 UNIQUE (realm_id, email_constraint);


--
-- Name: user_consent uk_external_consent; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.user_consent
    ADD CONSTRAINT uk_external_consent UNIQUE (client_storage_provider, external_client_id, user_id);


--
-- Name: resource_server_resource uk_frsr6t700s9v50bu18ws5ha6; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.resource_server_resource
    ADD CONSTRAINT uk_frsr6t700s9v50bu18ws5ha6 UNIQUE (name, owner, resource_server_id);


--
-- Name: resource_server_perm_ticket uk_frsr6t700s9v50bu18ws5pmt; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.resource_server_perm_ticket
    ADD CONSTRAINT uk_frsr6t700s9v50bu18ws5pmt UNIQUE (owner, requester, resource_server_id, resource_id, scope_id);


--
-- Name: resource_server_policy uk_frsrpt700s9v50bu18ws5ha6; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.resource_server_policy
    ADD CONSTRAINT uk_frsrpt700s9v50bu18ws5ha6 UNIQUE (name, resource_server_id);


--
-- Name: resource_server_scope uk_frsrst700s9v50bu18ws5ha6; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.resource_server_scope
    ADD CONSTRAINT uk_frsrst700s9v50bu18ws5ha6 UNIQUE (name, resource_server_id);


--
-- Name: user_consent uk_local_consent; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.user_consent
    ADD CONSTRAINT uk_local_consent UNIQUE (client_id, user_id);


--
-- Name: migration_model uk_migration_update_time; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.migration_model
    ADD CONSTRAINT uk_migration_update_time UNIQUE (update_time);


--
-- Name: migration_model uk_migration_version; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.migration_model
    ADD CONSTRAINT uk_migration_version UNIQUE (version);


--
-- Name: org uk_org_alias; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.org
    ADD CONSTRAINT uk_org_alias UNIQUE (realm_id, alias);


--
-- Name: org uk_org_group; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.org
    ADD CONSTRAINT uk_org_group UNIQUE (group_id);


--
-- Name: org uk_org_name; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.org
    ADD CONSTRAINT uk_org_name UNIQUE (realm_id, name);


--
-- Name: realm uk_orvsdmla56612eaefiq6wl5oi; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.realm
    ADD CONSTRAINT uk_orvsdmla56612eaefiq6wl5oi UNIQUE (name);


--
-- Name: user_entity uk_ru8tt6t700s9v50bu18ws5ha6; Type: CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.user_entity
    ADD CONSTRAINT uk_ru8tt6t700s9v50bu18ws5ha6 UNIQUE (realm_id, username);


--
-- Name: fed_user_attr_long_values; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX fed_user_attr_long_values ON public.fed_user_attribute USING btree (long_value_hash, name);


--
-- Name: fed_user_attr_long_values_lower_case; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX fed_user_attr_long_values_lower_case ON public.fed_user_attribute USING btree (long_value_hash_lower_case, name);


--
-- Name: idx_admin_event_time; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_admin_event_time ON public.admin_event_entity USING btree (realm_id, admin_event_time);


--
-- Name: idx_assoc_pol_assoc_pol_id; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_assoc_pol_assoc_pol_id ON public.associated_policy USING btree (associated_policy_id);


--
-- Name: idx_auth_config_realm; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_auth_config_realm ON public.authenticator_config USING btree (realm_id);


--
-- Name: idx_auth_exec_flow; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_auth_exec_flow ON public.authentication_execution USING btree (flow_id);


--
-- Name: idx_auth_exec_realm_flow; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_auth_exec_realm_flow ON public.authentication_execution USING btree (realm_id, flow_id);


--
-- Name: idx_auth_flow_realm; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_auth_flow_realm ON public.authentication_flow USING btree (realm_id);


--
-- Name: idx_cl_clscope; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_cl_clscope ON public.client_scope_client USING btree (scope_id);


--
-- Name: idx_client_att_by_name_value; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_client_att_by_name_value ON public.client_attributes USING btree (name, substr(value, 1, 255));


--
-- Name: idx_client_id; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_client_id ON public.client USING btree (client_id);


--
-- Name: idx_client_init_acc_realm; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_client_init_acc_realm ON public.client_initial_access USING btree (realm_id);


--
-- Name: idx_clscope_attrs; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_clscope_attrs ON public.client_scope_attributes USING btree (scope_id);


--
-- Name: idx_clscope_cl; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_clscope_cl ON public.client_scope_client USING btree (client_id);


--
-- Name: idx_clscope_protmap; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_clscope_protmap ON public.protocol_mapper USING btree (client_scope_id);


--
-- Name: idx_clscope_role; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_clscope_role ON public.client_scope_role_mapping USING btree (scope_id);


--
-- Name: idx_compo_config_compo; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_compo_config_compo ON public.component_config USING btree (component_id);


--
-- Name: idx_component_provider_type; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_component_provider_type ON public.component USING btree (provider_type);


--
-- Name: idx_component_realm; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_component_realm ON public.component USING btree (realm_id);


--
-- Name: idx_composite; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_composite ON public.composite_role USING btree (composite);


--
-- Name: idx_composite_child; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_composite_child ON public.composite_role USING btree (child_role);


--
-- Name: idx_defcls_realm; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_defcls_realm ON public.default_client_scope USING btree (realm_id);


--
-- Name: idx_defcls_scope; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_defcls_scope ON public.default_client_scope USING btree (scope_id);


--
-- Name: idx_event_time; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_event_time ON public.event_entity USING btree (realm_id, event_time);


--
-- Name: idx_fedidentity_feduser; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_fedidentity_feduser ON public.federated_identity USING btree (federated_user_id);


--
-- Name: idx_fedidentity_user; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_fedidentity_user ON public.federated_identity USING btree (user_id);


--
-- Name: idx_fu_attribute; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_fu_attribute ON public.fed_user_attribute USING btree (user_id, realm_id, name);


--
-- Name: idx_fu_cnsnt_ext; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_fu_cnsnt_ext ON public.fed_user_consent USING btree (user_id, client_storage_provider, external_client_id);


--
-- Name: idx_fu_consent; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_fu_consent ON public.fed_user_consent USING btree (user_id, client_id);


--
-- Name: idx_fu_consent_ru; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_fu_consent_ru ON public.fed_user_consent USING btree (realm_id, user_id);


--
-- Name: idx_fu_credential; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_fu_credential ON public.fed_user_credential USING btree (user_id, type);


--
-- Name: idx_fu_credential_ru; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_fu_credential_ru ON public.fed_user_credential USING btree (realm_id, user_id);


--
-- Name: idx_fu_group_membership; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_fu_group_membership ON public.fed_user_group_membership USING btree (user_id, group_id);


--
-- Name: idx_fu_group_membership_ru; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_fu_group_membership_ru ON public.fed_user_group_membership USING btree (realm_id, user_id);


--
-- Name: idx_fu_required_action; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_fu_required_action ON public.fed_user_required_action USING btree (user_id, required_action);


--
-- Name: idx_fu_required_action_ru; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_fu_required_action_ru ON public.fed_user_required_action USING btree (realm_id, user_id);


--
-- Name: idx_fu_role_mapping; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_fu_role_mapping ON public.fed_user_role_mapping USING btree (user_id, role_id);


--
-- Name: idx_fu_role_mapping_ru; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_fu_role_mapping_ru ON public.fed_user_role_mapping USING btree (realm_id, user_id);


--
-- Name: idx_group_att_by_name_value; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_group_att_by_name_value ON public.group_attribute USING btree (name, ((value)::character varying(250)));


--
-- Name: idx_group_attr_group; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_group_attr_group ON public.group_attribute USING btree (group_id);


--
-- Name: idx_group_role_mapp_group; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_group_role_mapp_group ON public.group_role_mapping USING btree (group_id);


--
-- Name: idx_id_prov_mapp_realm; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_id_prov_mapp_realm ON public.identity_provider_mapper USING btree (realm_id);


--
-- Name: idx_ident_prov_realm; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_ident_prov_realm ON public.identity_provider USING btree (realm_id);


--
-- Name: idx_idp_for_login; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_idp_for_login ON public.identity_provider USING btree (realm_id, enabled, link_only, hide_on_login, organization_id);


--
-- Name: idx_idp_realm_org; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_idp_realm_org ON public.identity_provider USING btree (realm_id, organization_id);


--
-- Name: idx_keycloak_role_client; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_keycloak_role_client ON public.keycloak_role USING btree (client);


--
-- Name: idx_keycloak_role_realm; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_keycloak_role_realm ON public.keycloak_role USING btree (realm);


--
-- Name: idx_offline_uss_by_broker_session_id; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_offline_uss_by_broker_session_id ON public.offline_user_session USING btree (broker_session_id, realm_id);


--
-- Name: idx_offline_uss_by_last_session_refresh; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_offline_uss_by_last_session_refresh ON public.offline_user_session USING btree (realm_id, offline_flag, last_session_refresh);


--
-- Name: idx_offline_uss_by_user; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_offline_uss_by_user ON public.offline_user_session USING btree (user_id, realm_id, offline_flag);


--
-- Name: idx_org_domain_org_id; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_org_domain_org_id ON public.org_domain USING btree (org_id);


--
-- Name: idx_perm_ticket_owner; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_perm_ticket_owner ON public.resource_server_perm_ticket USING btree (owner);


--
-- Name: idx_perm_ticket_requester; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_perm_ticket_requester ON public.resource_server_perm_ticket USING btree (requester);


--
-- Name: idx_protocol_mapper_client; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_protocol_mapper_client ON public.protocol_mapper USING btree (client_id);


--
-- Name: idx_realm_attr_realm; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_realm_attr_realm ON public.realm_attribute USING btree (realm_id);


--
-- Name: idx_realm_clscope; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_realm_clscope ON public.client_scope USING btree (realm_id);


--
-- Name: idx_realm_def_grp_realm; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_realm_def_grp_realm ON public.realm_default_groups USING btree (realm_id);


--
-- Name: idx_realm_evt_list_realm; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_realm_evt_list_realm ON public.realm_events_listeners USING btree (realm_id);


--
-- Name: idx_realm_evt_types_realm; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_realm_evt_types_realm ON public.realm_enabled_event_types USING btree (realm_id);


--
-- Name: idx_realm_master_adm_cli; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_realm_master_adm_cli ON public.realm USING btree (master_admin_client);


--
-- Name: idx_realm_supp_local_realm; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_realm_supp_local_realm ON public.realm_supported_locales USING btree (realm_id);


--
-- Name: idx_redir_uri_client; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_redir_uri_client ON public.redirect_uris USING btree (client_id);


--
-- Name: idx_req_act_prov_realm; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_req_act_prov_realm ON public.required_action_provider USING btree (realm_id);


--
-- Name: idx_res_policy_policy; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_res_policy_policy ON public.resource_policy USING btree (policy_id);


--
-- Name: idx_res_scope_scope; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_res_scope_scope ON public.resource_scope USING btree (scope_id);


--
-- Name: idx_res_serv_pol_res_serv; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_res_serv_pol_res_serv ON public.resource_server_policy USING btree (resource_server_id);


--
-- Name: idx_res_srv_res_res_srv; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_res_srv_res_res_srv ON public.resource_server_resource USING btree (resource_server_id);


--
-- Name: idx_res_srv_scope_res_srv; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_res_srv_scope_res_srv ON public.resource_server_scope USING btree (resource_server_id);


--
-- Name: idx_rev_token_on_expire; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_rev_token_on_expire ON public.revoked_token USING btree (expire);


--
-- Name: idx_role_attribute; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_role_attribute ON public.role_attribute USING btree (role_id);


--
-- Name: idx_role_clscope; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_role_clscope ON public.client_scope_role_mapping USING btree (role_id);


--
-- Name: idx_scope_mapping_role; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_scope_mapping_role ON public.scope_mapping USING btree (role_id);


--
-- Name: idx_scope_policy_policy; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_scope_policy_policy ON public.scope_policy USING btree (policy_id);


--
-- Name: idx_update_time; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_update_time ON public.migration_model USING btree (update_time);


--
-- Name: idx_usconsent_clscope; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_usconsent_clscope ON public.user_consent_client_scope USING btree (user_consent_id);


--
-- Name: idx_usconsent_scope_id; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_usconsent_scope_id ON public.user_consent_client_scope USING btree (scope_id);


--
-- Name: idx_user_attribute; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_user_attribute ON public.user_attribute USING btree (user_id);


--
-- Name: idx_user_attribute_name; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_user_attribute_name ON public.user_attribute USING btree (name, value);


--
-- Name: idx_user_consent; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_user_consent ON public.user_consent USING btree (user_id);


--
-- Name: idx_user_credential; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_user_credential ON public.credential USING btree (user_id);


--
-- Name: idx_user_email; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_user_email ON public.user_entity USING btree (email);


--
-- Name: idx_user_group_mapping; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_user_group_mapping ON public.user_group_membership USING btree (user_id);


--
-- Name: idx_user_reqactions; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_user_reqactions ON public.user_required_action USING btree (user_id);


--
-- Name: idx_user_role_mapping; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_user_role_mapping ON public.user_role_mapping USING btree (user_id);


--
-- Name: idx_user_service_account; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_user_service_account ON public.user_entity USING btree (realm_id, service_account_client_link);


--
-- Name: idx_usr_fed_map_fed_prv; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_usr_fed_map_fed_prv ON public.user_federation_mapper USING btree (federation_provider_id);


--
-- Name: idx_usr_fed_map_realm; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_usr_fed_map_realm ON public.user_federation_mapper USING btree (realm_id);


--
-- Name: idx_usr_fed_prv_realm; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_usr_fed_prv_realm ON public.user_federation_provider USING btree (realm_id);


--
-- Name: idx_web_orig_client; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX idx_web_orig_client ON public.web_origins USING btree (client_id);


--
-- Name: user_attr_long_values; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX user_attr_long_values ON public.user_attribute USING btree (long_value_hash, name);


--
-- Name: user_attr_long_values_lower_case; Type: INDEX; Schema: public; Owner: keycloak
--

CREATE INDEX user_attr_long_values_lower_case ON public.user_attribute USING btree (long_value_hash_lower_case, name);


--
-- Name: identity_provider fk2b4ebc52ae5c3b34; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.identity_provider
    ADD CONSTRAINT fk2b4ebc52ae5c3b34 FOREIGN KEY (realm_id) REFERENCES public.realm(id);


--
-- Name: client_attributes fk3c47c64beacca966; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.client_attributes
    ADD CONSTRAINT fk3c47c64beacca966 FOREIGN KEY (client_id) REFERENCES public.client(id);


--
-- Name: federated_identity fk404288b92ef007a6; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.federated_identity
    ADD CONSTRAINT fk404288b92ef007a6 FOREIGN KEY (user_id) REFERENCES public.user_entity(id);


--
-- Name: client_node_registrations fk4129723ba992f594; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.client_node_registrations
    ADD CONSTRAINT fk4129723ba992f594 FOREIGN KEY (client_id) REFERENCES public.client(id);


--
-- Name: redirect_uris fk_1burs8pb4ouj97h5wuppahv9f; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.redirect_uris
    ADD CONSTRAINT fk_1burs8pb4ouj97h5wuppahv9f FOREIGN KEY (client_id) REFERENCES public.client(id);


--
-- Name: user_federation_provider fk_1fj32f6ptolw2qy60cd8n01e8; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.user_federation_provider
    ADD CONSTRAINT fk_1fj32f6ptolw2qy60cd8n01e8 FOREIGN KEY (realm_id) REFERENCES public.realm(id);


--
-- Name: realm_required_credential fk_5hg65lybevavkqfki3kponh9v; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.realm_required_credential
    ADD CONSTRAINT fk_5hg65lybevavkqfki3kponh9v FOREIGN KEY (realm_id) REFERENCES public.realm(id);


--
-- Name: resource_attribute fk_5hrm2vlf9ql5fu022kqepovbr; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.resource_attribute
    ADD CONSTRAINT fk_5hrm2vlf9ql5fu022kqepovbr FOREIGN KEY (resource_id) REFERENCES public.resource_server_resource(id);


--
-- Name: user_attribute fk_5hrm2vlf9ql5fu043kqepovbr; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.user_attribute
    ADD CONSTRAINT fk_5hrm2vlf9ql5fu043kqepovbr FOREIGN KEY (user_id) REFERENCES public.user_entity(id);


--
-- Name: user_required_action fk_6qj3w1jw9cvafhe19bwsiuvmd; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.user_required_action
    ADD CONSTRAINT fk_6qj3w1jw9cvafhe19bwsiuvmd FOREIGN KEY (user_id) REFERENCES public.user_entity(id);


--
-- Name: keycloak_role fk_6vyqfe4cn4wlq8r6kt5vdsj5c; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.keycloak_role
    ADD CONSTRAINT fk_6vyqfe4cn4wlq8r6kt5vdsj5c FOREIGN KEY (realm) REFERENCES public.realm(id);


--
-- Name: realm_smtp_config fk_70ej8xdxgxd0b9hh6180irr0o; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.realm_smtp_config
    ADD CONSTRAINT fk_70ej8xdxgxd0b9hh6180irr0o FOREIGN KEY (realm_id) REFERENCES public.realm(id);


--
-- Name: realm_attribute fk_8shxd6l3e9atqukacxgpffptw; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.realm_attribute
    ADD CONSTRAINT fk_8shxd6l3e9atqukacxgpffptw FOREIGN KEY (realm_id) REFERENCES public.realm(id);


--
-- Name: composite_role fk_a63wvekftu8jo1pnj81e7mce2; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.composite_role
    ADD CONSTRAINT fk_a63wvekftu8jo1pnj81e7mce2 FOREIGN KEY (composite) REFERENCES public.keycloak_role(id);


--
-- Name: authentication_execution fk_auth_exec_flow; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.authentication_execution
    ADD CONSTRAINT fk_auth_exec_flow FOREIGN KEY (flow_id) REFERENCES public.authentication_flow(id);


--
-- Name: authentication_execution fk_auth_exec_realm; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.authentication_execution
    ADD CONSTRAINT fk_auth_exec_realm FOREIGN KEY (realm_id) REFERENCES public.realm(id);


--
-- Name: authentication_flow fk_auth_flow_realm; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.authentication_flow
    ADD CONSTRAINT fk_auth_flow_realm FOREIGN KEY (realm_id) REFERENCES public.realm(id);


--
-- Name: authenticator_config fk_auth_realm; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.authenticator_config
    ADD CONSTRAINT fk_auth_realm FOREIGN KEY (realm_id) REFERENCES public.realm(id);


--
-- Name: user_role_mapping fk_c4fqv34p1mbylloxang7b1q3l; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.user_role_mapping
    ADD CONSTRAINT fk_c4fqv34p1mbylloxang7b1q3l FOREIGN KEY (user_id) REFERENCES public.user_entity(id);


--
-- Name: client_scope_attributes fk_cl_scope_attr_scope; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.client_scope_attributes
    ADD CONSTRAINT fk_cl_scope_attr_scope FOREIGN KEY (scope_id) REFERENCES public.client_scope(id);


--
-- Name: client_scope_role_mapping fk_cl_scope_rm_scope; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.client_scope_role_mapping
    ADD CONSTRAINT fk_cl_scope_rm_scope FOREIGN KEY (scope_id) REFERENCES public.client_scope(id);


--
-- Name: protocol_mapper fk_cli_scope_mapper; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.protocol_mapper
    ADD CONSTRAINT fk_cli_scope_mapper FOREIGN KEY (client_scope_id) REFERENCES public.client_scope(id);


--
-- Name: client_initial_access fk_client_init_acc_realm; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.client_initial_access
    ADD CONSTRAINT fk_client_init_acc_realm FOREIGN KEY (realm_id) REFERENCES public.realm(id);


--
-- Name: component_config fk_component_config; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.component_config
    ADD CONSTRAINT fk_component_config FOREIGN KEY (component_id) REFERENCES public.component(id);


--
-- Name: component fk_component_realm; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.component
    ADD CONSTRAINT fk_component_realm FOREIGN KEY (realm_id) REFERENCES public.realm(id);


--
-- Name: realm_default_groups fk_def_groups_realm; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.realm_default_groups
    ADD CONSTRAINT fk_def_groups_realm FOREIGN KEY (realm_id) REFERENCES public.realm(id);


--
-- Name: user_federation_mapper_config fk_fedmapper_cfg; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.user_federation_mapper_config
    ADD CONSTRAINT fk_fedmapper_cfg FOREIGN KEY (user_federation_mapper_id) REFERENCES public.user_federation_mapper(id);


--
-- Name: user_federation_mapper fk_fedmapperpm_fedprv; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.user_federation_mapper
    ADD CONSTRAINT fk_fedmapperpm_fedprv FOREIGN KEY (federation_provider_id) REFERENCES public.user_federation_provider(id);


--
-- Name: user_federation_mapper fk_fedmapperpm_realm; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.user_federation_mapper
    ADD CONSTRAINT fk_fedmapperpm_realm FOREIGN KEY (realm_id) REFERENCES public.realm(id);


--
-- Name: associated_policy fk_frsr5s213xcx4wnkog82ssrfy; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.associated_policy
    ADD CONSTRAINT fk_frsr5s213xcx4wnkog82ssrfy FOREIGN KEY (associated_policy_id) REFERENCES public.resource_server_policy(id);


--
-- Name: scope_policy fk_frsrasp13xcx4wnkog82ssrfy; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.scope_policy
    ADD CONSTRAINT fk_frsrasp13xcx4wnkog82ssrfy FOREIGN KEY (policy_id) REFERENCES public.resource_server_policy(id);


--
-- Name: resource_server_perm_ticket fk_frsrho213xcx4wnkog82sspmt; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.resource_server_perm_ticket
    ADD CONSTRAINT fk_frsrho213xcx4wnkog82sspmt FOREIGN KEY (resource_server_id) REFERENCES public.resource_server(id);


--
-- Name: resource_server_resource fk_frsrho213xcx4wnkog82ssrfy; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.resource_server_resource
    ADD CONSTRAINT fk_frsrho213xcx4wnkog82ssrfy FOREIGN KEY (resource_server_id) REFERENCES public.resource_server(id);


--
-- Name: resource_server_perm_ticket fk_frsrho213xcx4wnkog83sspmt; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.resource_server_perm_ticket
    ADD CONSTRAINT fk_frsrho213xcx4wnkog83sspmt FOREIGN KEY (resource_id) REFERENCES public.resource_server_resource(id);


--
-- Name: resource_server_perm_ticket fk_frsrho213xcx4wnkog84sspmt; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.resource_server_perm_ticket
    ADD CONSTRAINT fk_frsrho213xcx4wnkog84sspmt FOREIGN KEY (scope_id) REFERENCES public.resource_server_scope(id);


--
-- Name: associated_policy fk_frsrpas14xcx4wnkog82ssrfy; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.associated_policy
    ADD CONSTRAINT fk_frsrpas14xcx4wnkog82ssrfy FOREIGN KEY (policy_id) REFERENCES public.resource_server_policy(id);


--
-- Name: scope_policy fk_frsrpass3xcx4wnkog82ssrfy; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.scope_policy
    ADD CONSTRAINT fk_frsrpass3xcx4wnkog82ssrfy FOREIGN KEY (scope_id) REFERENCES public.resource_server_scope(id);


--
-- Name: resource_server_perm_ticket fk_frsrpo2128cx4wnkog82ssrfy; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.resource_server_perm_ticket
    ADD CONSTRAINT fk_frsrpo2128cx4wnkog82ssrfy FOREIGN KEY (policy_id) REFERENCES public.resource_server_policy(id);


--
-- Name: resource_server_policy fk_frsrpo213xcx4wnkog82ssrfy; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.resource_server_policy
    ADD CONSTRAINT fk_frsrpo213xcx4wnkog82ssrfy FOREIGN KEY (resource_server_id) REFERENCES public.resource_server(id);


--
-- Name: resource_scope fk_frsrpos13xcx4wnkog82ssrfy; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.resource_scope
    ADD CONSTRAINT fk_frsrpos13xcx4wnkog82ssrfy FOREIGN KEY (resource_id) REFERENCES public.resource_server_resource(id);


--
-- Name: resource_policy fk_frsrpos53xcx4wnkog82ssrfy; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.resource_policy
    ADD CONSTRAINT fk_frsrpos53xcx4wnkog82ssrfy FOREIGN KEY (resource_id) REFERENCES public.resource_server_resource(id);


--
-- Name: resource_policy fk_frsrpp213xcx4wnkog82ssrfy; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.resource_policy
    ADD CONSTRAINT fk_frsrpp213xcx4wnkog82ssrfy FOREIGN KEY (policy_id) REFERENCES public.resource_server_policy(id);


--
-- Name: resource_scope fk_frsrps213xcx4wnkog82ssrfy; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.resource_scope
    ADD CONSTRAINT fk_frsrps213xcx4wnkog82ssrfy FOREIGN KEY (scope_id) REFERENCES public.resource_server_scope(id);


--
-- Name: resource_server_scope fk_frsrso213xcx4wnkog82ssrfy; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.resource_server_scope
    ADD CONSTRAINT fk_frsrso213xcx4wnkog82ssrfy FOREIGN KEY (resource_server_id) REFERENCES public.resource_server(id);


--
-- Name: composite_role fk_gr7thllb9lu8q4vqa4524jjy8; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.composite_role
    ADD CONSTRAINT fk_gr7thllb9lu8q4vqa4524jjy8 FOREIGN KEY (child_role) REFERENCES public.keycloak_role(id);


--
-- Name: user_consent_client_scope fk_grntcsnt_clsc_usc; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.user_consent_client_scope
    ADD CONSTRAINT fk_grntcsnt_clsc_usc FOREIGN KEY (user_consent_id) REFERENCES public.user_consent(id);


--
-- Name: user_consent fk_grntcsnt_user; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.user_consent
    ADD CONSTRAINT fk_grntcsnt_user FOREIGN KEY (user_id) REFERENCES public.user_entity(id);


--
-- Name: group_attribute fk_group_attribute_group; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.group_attribute
    ADD CONSTRAINT fk_group_attribute_group FOREIGN KEY (group_id) REFERENCES public.keycloak_group(id);


--
-- Name: group_role_mapping fk_group_role_group; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.group_role_mapping
    ADD CONSTRAINT fk_group_role_group FOREIGN KEY (group_id) REFERENCES public.keycloak_group(id);


--
-- Name: realm_enabled_event_types fk_h846o4h0w8epx5nwedrf5y69j; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.realm_enabled_event_types
    ADD CONSTRAINT fk_h846o4h0w8epx5nwedrf5y69j FOREIGN KEY (realm_id) REFERENCES public.realm(id);


--
-- Name: realm_events_listeners fk_h846o4h0w8epx5nxev9f5y69j; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.realm_events_listeners
    ADD CONSTRAINT fk_h846o4h0w8epx5nxev9f5y69j FOREIGN KEY (realm_id) REFERENCES public.realm(id);


--
-- Name: identity_provider_mapper fk_idpm_realm; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.identity_provider_mapper
    ADD CONSTRAINT fk_idpm_realm FOREIGN KEY (realm_id) REFERENCES public.realm(id);


--
-- Name: idp_mapper_config fk_idpmconfig; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.idp_mapper_config
    ADD CONSTRAINT fk_idpmconfig FOREIGN KEY (idp_mapper_id) REFERENCES public.identity_provider_mapper(id);


--
-- Name: web_origins fk_lojpho213xcx4wnkog82ssrfy; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.web_origins
    ADD CONSTRAINT fk_lojpho213xcx4wnkog82ssrfy FOREIGN KEY (client_id) REFERENCES public.client(id);


--
-- Name: scope_mapping fk_ouse064plmlr732lxjcn1q5f1; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.scope_mapping
    ADD CONSTRAINT fk_ouse064plmlr732lxjcn1q5f1 FOREIGN KEY (client_id) REFERENCES public.client(id);


--
-- Name: protocol_mapper fk_pcm_realm; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.protocol_mapper
    ADD CONSTRAINT fk_pcm_realm FOREIGN KEY (client_id) REFERENCES public.client(id);


--
-- Name: credential fk_pfyr0glasqyl0dei3kl69r6v0; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.credential
    ADD CONSTRAINT fk_pfyr0glasqyl0dei3kl69r6v0 FOREIGN KEY (user_id) REFERENCES public.user_entity(id);


--
-- Name: protocol_mapper_config fk_pmconfig; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.protocol_mapper_config
    ADD CONSTRAINT fk_pmconfig FOREIGN KEY (protocol_mapper_id) REFERENCES public.protocol_mapper(id);


--
-- Name: default_client_scope fk_r_def_cli_scope_realm; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.default_client_scope
    ADD CONSTRAINT fk_r_def_cli_scope_realm FOREIGN KEY (realm_id) REFERENCES public.realm(id);


--
-- Name: required_action_provider fk_req_act_realm; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.required_action_provider
    ADD CONSTRAINT fk_req_act_realm FOREIGN KEY (realm_id) REFERENCES public.realm(id);


--
-- Name: resource_uris fk_resource_server_uris; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.resource_uris
    ADD CONSTRAINT fk_resource_server_uris FOREIGN KEY (resource_id) REFERENCES public.resource_server_resource(id);


--
-- Name: role_attribute fk_role_attribute_id; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.role_attribute
    ADD CONSTRAINT fk_role_attribute_id FOREIGN KEY (role_id) REFERENCES public.keycloak_role(id);


--
-- Name: realm_supported_locales fk_supported_locales_realm; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.realm_supported_locales
    ADD CONSTRAINT fk_supported_locales_realm FOREIGN KEY (realm_id) REFERENCES public.realm(id);


--
-- Name: user_federation_config fk_t13hpu1j94r2ebpekr39x5eu5; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.user_federation_config
    ADD CONSTRAINT fk_t13hpu1j94r2ebpekr39x5eu5 FOREIGN KEY (user_federation_provider_id) REFERENCES public.user_federation_provider(id);


--
-- Name: user_group_membership fk_user_group_user; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.user_group_membership
    ADD CONSTRAINT fk_user_group_user FOREIGN KEY (user_id) REFERENCES public.user_entity(id);


--
-- Name: policy_config fkdc34197cf864c4e43; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.policy_config
    ADD CONSTRAINT fkdc34197cf864c4e43 FOREIGN KEY (policy_id) REFERENCES public.resource_server_policy(id);


--
-- Name: identity_provider_config fkdc4897cf864c4e43; Type: FK CONSTRAINT; Schema: public; Owner: keycloak
--

ALTER TABLE ONLY public.identity_provider_config
    ADD CONSTRAINT fkdc4897cf864c4e43 FOREIGN KEY (identity_provider_id) REFERENCES public.identity_provider(internal_id);


--
-- PostgreSQL database dump complete
--

