<#import "template.ftl" as layout>
<#include "templates/components/notification.ftl">
<#include "templates/components/spacing.ftl">
<@layout.registrationLayout; section>

    <#if section = "header">
        ${msg("deleteAccountConfirm")}
    <#elseif section = "form">
        <form action="${url.loginAction}" method="post">
            <#assign deleteInfo>
                <p>${msg("irreversibleAction")!}</p>
                <p>${msg("finalDeletionConfirmation")}</p>
            </#assign>
            <@notification message=(deleteInfo) intent="danger" />

            <@spacing size="small" />

            <div class="${properties.cTypographyContentBlock!"eccgui-typography__contentblock"}">
                <p>${msg("deletingImplies")}</p>
                <ul>
                    <li>${msg("loggingOutImmediately")}</li>
                    <li>${msg("errasingData")}</li>
                </ul>
            </div>

            <@spacing size="medium" />

            <div>
                <input class="${properties.kcButtonClass!} ${properties.kcButtonDangerClass!} ${properties.kcButtonLargeClass!}" type="submit" value="${msg("doConfirmDelete")}" />
                <#if triggered_from_aia>
                <button class="${properties.kcButtonClass!} ${properties.kcButtonDefaultClass!} ${properties.kcButtonLargeClass!}" />${msg("doCancel")}</button>
                </#if>
            </div>
        </form>
    </#if>

</@layout.registrationLayout>
