#!/usr/bin/env bash

# Important: in this script we do not use the unofficial bash mode,
# because we actually rely on a proper failing status of curl

port="${1}"

if [ -z "${port}" ]; then
  (>&2 echo "testPort: Please provide an port as the first parameter")
  exit 1
fi


portStatus=$(lsof -i ":${port}")
portStatusExit=$?

if [[ "${portStatusExit}" -ne "0" ]]; then
  (>&2 echo "testPort (${port}): failed, unhealthy")
  exit 1
fi

echo "testPort (${port}): ${portStatus}, healthy"
exit 0
