#!/usr/bin/env bash
# @(#) output the used image versions

# Use the unofficial bash strict mode: http://redsymbol.net/articles/unofficial-bash-strict-mode/
set -euo pipefail; export FS=$'\n\t'
# NOTE: requires the `envsubst` tool from the `gettext` GNU package

labels="Image|Version\n"

for image in $(cat docker-compose.* compose/docker-compose.*.yml| grep -vE '^\s*#' | grep 'image:' | sed 's/\s*image: //g'); do
    {
        # replace bash-like variable expressions by env variable values
        solvedImage="$(echo $image | envsubst)"

        label=$(docker image inspect "$solvedImage" --format '{{index .Config.Labels "org.opencontainers.image.version"}}' 2>/dev/null )
        if [ "$?" -ne 0 ] ; then
            label="image not pulled"
        else
            label="${label:-no version}"
        fi
    } || {
        label="image not pulled"
    }
    labels="${labels}${solvedImage}|${label}\n"
done

echo -e "$labels" | uniq | column -t -s "|"
