# makefile targets related to the orchestration extension mechanism

## extend orchestration with a custom additional compose file (given with EXTENSION=xxx)
enable-extension:
ifneq ("$(wildcard ${DEST}/extensions/docker-compose.${EXTENSION}.yml)","")
    # extension is available
	@echo "Extend orchestration with extension file docker-compose.${EXTENSION}.yml";
	make installoidc
	${CMD} -f ${DEST}/docker-compose.yml -f ${DEST}/extensions/docker-compose.${EXTENSION}.yml up --build -d;
	ln -sf ../includes-available/${EXTENSION}.conf ${DEST}conf/apache2/includes-enabled/${EXTENSION}.conf || true;
	${CMD} restart apache2
else
    # extension is not available
	@echo "Please specify the name of an existing with EXTENSION=xxx";
	@echo "The following extension are available:";
	@echo "";
	@head -1 ${DEST}/extensions/docker-compose.*.yml | grep "#" | cut -d " " -f 2-;
endif

## disables a single extension for given env EXTENSION=xxx
disable-extension:
ifneq ("$(wildcard conf/apache2/includes-enabled/${EXTENSION}.conf)","")
    # extension is enabled
	rm -f ${DEST}conf/apache2/includes-enabled/${EXTENSION}.conf || true;
	${CMD} -f ${DEST}/extensions/docker-compose.${EXTENSION}.yml down;
	${CMD} restart apache2
else
    # extension is enabled
	@echo "Please specify the name of an enabled extension with EXTENSION=xxx";
	@echo "The following extension are enabled:";
	@echo "";
	@ls -1 conf/apache2/includes-enabled | cut -d "." -f 1;
endif

### install OIDC module in apache reverse proxy to enable keycloak auth for resource paths
installoidc:
	${CMD} exec apache2 sed -E -i.bak 's|http://deb.debian.org/debian-security|http://security.debian.org/debian-security|g' /etc/apt/sources.list.d/debian.sources
	${CMD} exec apache2 apt-get update
	${CMD} exec apache2 apt-get install -y libapache2-mod-auth-openidc
	${CMD} exec apache2 mkdir -p /etc/apache2/mods-enabled
	${CMD} exec apache2 ln -sf /etc/apache2/mods-available/auth_openidc.load /etc/apache2/mods-enabled/auth_openidc.load
	${CMD} exec apache2 ln -sf /etc/apache2/mods-available/auth_openidc.conf /etc/apache2/mods-enabled/auth_openidc.conf
	${CMD} restart apache2
