#!/usr/bin/env bash
# @(#) Asks a yes/no question based on an input string (first parameter)
# @(#) - returns exit 1 if user answers no, exit 0 if yes

# Use the unofficial bash strict mode: http://redsymbol.net/articles/unofficial-bash-strict-mode/
# NOTE: requires the `envsubst` tool from the `gettext` GNU package
set -euo pipefail; export FS=$'\n\t'

# test for shown question
if [ -z ${1+x} ];
then
    echo "Parameter 1 is a question"
    exit 1
fi

CO_I_KNOW_WHAT_I_DO=${CO_I_KNOW_WHAT_I_DO:=false}
# test for skip variable
if [ "${CO_I_KNOW_WHAT_I_DO}" == "true" ];
then
    exit 0
fi

echo "${1}"
printf "\nYou can avoid this question / interruption by setting CO_I_KNOW_WHAT_I_DO to true.\nType '1' for Yes or type '2' for No.\n\n"
select yn in "Yes" "No"; do
    case $yn in
        Yes ) exit 0;;
        No ) exit 1;;
    esac
done
