# How to deploy the semspect extension

First have the CO up and running in your preferred setup.
This is important because you need to have the apache httpd up for the next step

``` sh
# fresh start
make clean-pull-start-bootstrap

# or
make start
```

Start the extension.

``` sh
make enable-extension EXTENSION=semspect
```

You can do this also in one single call:

``` sh
make clean-pull-start-bootstrap enable-extension EXTENSION=semspect
```

## Caveats

### Internal Server Error

If you still see an Error 500 (Internal Server Error) please check the Apache log output.
In case there is an error like this: `AH01796: AuthType openid-connect configured without corresponding module` you have to run the command `make installoidc` again.

### Service not started - Log: A serialization issue occurred

After upgrading the extension, there could be an error like this in the log - with a service which was not started.

The easiest way to solve this, is by deleting the named volume and restarting everything:

``` sh
$ docker volume ls | grep semspect_volume
local     dockerlocalhost_semspect_volume

$ docker volume rm dockerlocalhost_semspect_volume
```

