# docker-includes

This repository provides re-usable assets to be included as `includes` submodule
in a Docker repository.

It provides a `Makefile` which eases the work with Docker in our company.

## Usage

To include this repository as submodule, follow these steps **assuming your are in the directory of your repository that should contain the `Dockerfile`**:

```bash
git submodule add -b master ssh://git@gitlab.eccenca.com:8101/devops/docker-includes.git includes
git submodule init
git submodule update
cp includes/Dockerfile.dist Dockerfile
cp includes/dockerignore.dist .dockerignore
cp includes/README.md.dist README.md
cp includes/CHANGELOG.md.dist CHANGELOG.md
ln -s includes/Makefile.dist Makefile
# may not be needed if you don't use an eccenca image as base
mkdir -p conf/supervisor/ conf/init/
touch conf/supervisor/.gitkeep
touch conf/init/.gitkeep
```

Then edit the `Dockerfile` according to your needs.

## Conventions

- Use this repo as submodule for `includes` subdirectory as described.
- Set `ECC_IMAGE_PREFIX` and `ECC_IMAGE_NAME` environment variables in your `Dockerfile` to use the automatic build functions of the provided `Makefile`.
- If your project needs custom targets for Docker support, put them into a `custom.Makefile` which will be included if it exists.

## Docker host

In order to provide access to a specific Docker host, you can prefix a `ECC_HOST` variable:

```bash
ECC_HOST=idas make shell
```

or you provide it for the whole session:

```bash
export ECC_HOST=idas
make shell
```

Please note that your eccenca certificates must exist in the folder `$(HOME)/.config/ssl/docker-eccenca`:

```bash
CA          : ca.pem
client-cert : client-cert.pem
client-key  : client-key.pem
```

You can find the description on how to get your certificates [here](https://confluence.brox.de/x/1YDwAQ).
