<#include "templates/components/overflowtext.ftl">
<#include "templates/components/card.ftl">
<#include "templates/components/notification.ftl">
<#include "templates/components/spacing.ftl">
<#macro registrationLayout moduleTemplate="login" bodyClass="" displayInfo=false displayMessage=true displayRequiredFields=false>
<#assign pageTitle>${msg("loginTitle",(realm.displayName!''))}</#assign>
<#assign pageContent>
    <#assign cardTitleOverflow><#nested "header"></#assign>
    <#assign cardTitle><h1 class="${properties.cCardTitle!""}"><@overflowtext content=(cardTitleOverflow) /></h1></#assign>
    <#assign cardContent>
        <#if auth?has_content && auth.showUsername() && !auth.showResetCredentials()>
            <div>
                <#assign showUsernameContent>
                    <#nested "show-username">
                    <label>${auth.attemptedUsername}</label>
                </#assign>
                <#assign showUsernameActions>
                    <a href="${url.loginRestartFlowUrl}" class="${properties.kcButtonClass!""}">
                        ${msg("restartLoginTooltip")}
                    </a>
                </#assign>
                <@notification message=(showUsernameContent) actions=(showUsernameActions) />
            </div>
            <@spacing size="tiny" />
        </#if>
        <#assign infoNotification><#compress><#nested "info"></#compress></#assign>
        <#include "templates/contents/notificationstack.ftl">
        <#nested "form">
    </#assign>
    <#assign tryAnotherWay>
        <#if auth?has_content && auth.showTryAnotherWayLink()>
            <!-- TODO: not sure what this is and how this is activated/displayed -->
            <form id="kc-select-try-another-way-form" action="${url.loginAction}" method="post">
                <div class="${properties.kcFormGroupClass!}">
                    <input type="hidden" name="tryAnotherWay" value="on"/>
                    <a href="#" id="try-another-way"
                       onclick="document.forms['kc-select-try-another-way-form'].submit();return false;">${msg("doTryAnotherWay")}</a>
                </div>
            </form>
        </#if>
    </#assign>
    <#assign socialProvider><#compress><#nested "socialProviders"></#compress></#assign>
    <#if tryAnotherWay?has_content || socialProvider?has_content>
    <div class="${properties.cGridWrapper!"ecc-keycloak__grid"}">
        <div class="${properties.cGridRow!"ecc-keycloak__grid__row"}">
            <div class="${properties.cGridColumn!"ecc-keycloak__grid__column"}">
                <@card
                    title=(cardTitle)
                    content=(cardContent)
                />
            </div>
            <div class="${properties.cGridColumnSidebar!"ecc-keycloak__grid__column-sidebar"}">
                <@spacing size="medium" />
                <#if tryAnotherWay?has_content><div class="tryAnotherWay">${tryAnotherWay}</div></#if>
                <#if socialProvider?has_content><div class="socialProvider">${socialProvider}</div></#if>
            </div>
        </div>
    </div>
    <#else>
        <@card
            title=(cardTitle)
            content=(cardContent)
        />
    </#if>
</#assign>
<#include "templates/layout/htmlWrapper.ftl">
</#macro>
