# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [3.13.0] 2023-04-24

### Changed

- always use the latest trivy image

## [3.12.0] 2023-02-20

### Changed

- in addition to bamboo env vars, gitlab CI vars are use if available now as well

### Added

- example `gitlab-ci.yml` to demonstrate usage

## [3.11.0] 2023-01-17

### Added

- TRIVY_SCAN env vat can be set to false in order to disable scans at all

## [3.10.1] 2023-01-16

### Changed

- TRIVY_ADDITIONAL_OPTIONS defaults to "--security-checks vuln --timeout 15m"

## [3.10.0] 2023-01-16

### Added

- add TRIVY_ADDITIONAL_OPTIONS option (default value: "--security-checks vuln")

### Changes

- update trivy to 0.36.0


## [3.9.0] 2022-11-10

### Added

- trivy is additionally executed to have raw JSON output

## [3.8.0] 2022-11-09

### Changed

- update trivy to 0.34.0

## [3.7.0] 2022-08-25

### Changed

- shell target now starts bash, not byobu anymore
- use BuildKit per default
- upgrade trivy security scan

## [3.6.0] 2022-03-01

### Changed

- help target is now the default target
- update trivy to 0.24.1

### Fixed

- fixed issue that trivy does not create an junit xml if there is no issue

### Changed

- change URI of testscript to docker.localhost (CMEM-4041)

## [3.5.0] 2021-05-07

### Added

- check-security target scans build image via trivy
  - bamboo-build includes check-security target
  - trivy vulnerability database is cached in user home (root on bamboo)

## [3.4.1] 2021-05-05

### Fixed

- add missing dockerignore statement

## [3.4.0] 2021-05-05

### Added

- check-security target: do a trivy security scan on the build image and create txt, xml and html results (OPS-1187)


## [3.3.0] 2020-06-25

### Fixed

- fix before/after build targets

## [3.2.0] 2020-05-06

### Added

- before-push
- before-build

## [3.1.0] 2019-10-16

### Changes

- do not remove ${TAG_BRANCH} in rmi: target --> this leads to conflicts with branches like :develop

## [3.0.0] 2019-06-24

### Added

- scripts from `eccenca-base` image

### Changed

- more conventions in `Dockerfile.dist` template
- cleaned up `README`

## [2.6.2] 2018-09-24

- do not fail `deploy` target if Docker container or volume are missing

## [2.6.1] 2018-06-21

### Fixed

- fail if existing image cannot be removed

## [2.6.0] 2017-11-09

### Added

- add `after-build` and `after-push` target for custom extensions

### Changed

- removed `MAINTAINER` from `Dockerfile.dist` template

### Fixed

- default `CHANGELOG` (fix first headline)

## [2.5.2] 2017-10-18

### Fixed

- do not fail if Docker images could not be removed (especially interesting for `bamboo-push`)

## [2.5.1] 2017-09-13

### Fixed

- only generate major and minor tags on `master` branch

## [2.5.0] 2017-09-13

### Added

- Support for floating minor and major targets on `master` branch:

    Assuming you have the base image at version `v10.11.23`, it will look like this:

    ```bash
    docker tag eccenca-base:v10.11.23 docker-registry.eccenca.com/eccenca-base:v10.11.23
    docker tag eccenca-base:v10.11.23 docker-registry.eccenca.com/eccenca-base:latest
    docker tag eccenca-base:v10.11.23 docker-registry.eccenca.com/eccenca-base:v10
    docker tag eccenca-base:v10.11.23 docker-registry.eccenca.com/eccenca-base:v10.11
    ```

## [2.4.0] 2017-07-04

### Changed

- enable removing images on container remove

### Fixed

- Use Bamboo variable `bamboo_repository_git_branch` for branch name if available. Otherwise fall back to `git rev-parse --abbrev-ref HEAD`.

## [2.3.0] 2017-03-23

### Added

- add `custom.Makefile` support

## [2.2.0] 2017-02-23

### Added

- Labels for Docker containers (adhering to: http://label-schema.org/rc1/). The following labels are set:

    - `org.label-schema.build-date` to the current timestamp (ISO-8601), e.g. `2017-02-23T11:50:23+01:00`
    - `org.label-schema.vcs-ref` to the result of `git describe`, e.g. `v3.4.0-2-g06e5310`
    - `org.label-schema.version` to the full qualifying name of the docker image, e.g. `docker-registry.eccenca.com/eccenca-node:v3.4.0-2-g06e5310`
    - `org.label-schema.schema-version` is set to `1.0.0-rc.1`

    To access the labels, simply use:

    ```bash
    docker inspect -f '{{ index .Config.Labels "org.label-schema.build-date" }}' docker-registry.eccenca.com/eccenca-node:develop
    # returns: 2017-02-23T11:50:23+01:00
    docker inspect -f '{{ index .Config.Labels "org.label-schema.version" }}' docker-registry.eccenca.com/eccenca-node:develop
    # returns: docker-registry.eccenca.com/eccenca-node:v3.4.0-2-g06e5310
    docker inspect -f '{{json .Config.Labels}}' docker-registry.eccenca.com/eccenca-node:develop
    # returns json: {"org.label-schema.build-date":"2017-02-23T11:50:23+01:00","org.label-schema.schema-version":"1.0.0-rc.1","org.label-schema.vcs-ref":"v3.4.0-2-g06e5310","org.label-schema.version":"docker-registry.eccenca.com/eccenca-node:v3.4.0-2-g06e5310"}
    ```

## [2.1.0] 2017-02-23

### Changed

- template files extended

## [2.0.1] 2017-01-10

### Fixed

- cleaned up Docker tags which will be created (only two: one based on the Git branch, the other on `git describe`)
