# SSL/TLS Deployment Documentation

<!-- vim-markdown-toc GitLab -->

* [Deploying With Letsencrypt Certificate](#deploying-with-letsencrypt-certificate)
    * [Renewing Letsencrypt Certificate](#renewing-letsencrypt-certificate)
* [Deploying With Trusted Certificate when behind company reverse proxy](#deploying-with-trusted-certificate-when-behind-company-reverse-proxy)
* [Deploying With Self-Signed Certificate](#deploying-with-self-signed-certificate)
* [Deploying With Provided/Third-Party Certificate](#deploying-with-providedthird-party-certificate)
* [Debugging certificates](#debugging-certificates)

<!-- vim-markdown-toc -->

## Deploying With Letsencrypt Certificate

Use this scenario in case:

* the corporate memory deployed without reverse proxy
* there is a public DNS entry pointing to the deployment host

```sh
cp environments/config.ssl.env environments/your.host.env
```

Modify host and letsencrypt configuration in `environments/your.host.env`:

```sh
DEPLOYHOST=your.host

SSLCONF=ssl.letsencrypt.conf
LETSENCRYPT_MAIL=your@email
```

Generate/renew a letsencrypt certificate and start the Corporate Memory:

```sh
CONFIGFILE=environments/your.host.env make letsencrypt-create
# or renew the certificate
#
CONFIGFILE=environments/your.host.env make start
```

### Renewing Letsencrypt Certificate

```sh
CONFIGFILE=environments/your.host.env make letsencrypt-renew
```

## Deploying With Trusted Certificate when behind company reverse proxy

Use this scenario in case:

* the corporate memory deployed with an external reverse proxy terminating TLS
* there is a public DNS entry pointing to the external reverse proxy

```sh
cp environments/config.ssl.env environments/your.host.env
```

Modify host in `environments/your.host.env`:

```sh
DEPLOYHOST=your.host

# DI config - this is needed to un-map the local reverse proxy with the DEPLOYHOST name.
# So Dataintegration will always use the external reverse proxy for connecting to e.g. keycloak
DATAINTEGRATION_LINK_APACHE="unlinkapache.com"

# apache2 config
DEPLOYPROTOCOL=https
# or choose any other port.
PORT=8823
PROXY_ADDRESS_FORWARDING=true

EXTERNAL_BASE_URL=https://your.host
OAUTH_AUTHORIZATION_URL=${EXTERNAL_BASE_URL}/auth/realms/cmem/protocol/openid-connect/auth
OAUTH_TOKEN_URL=${EXTERNAL_BASE_URL}/auth/realms/cmem/protocol/openid-connect/token
OAUTH_JWK_SET_URL=${EXTERNAL_BASE_URL}/auth/realms/cmem/protocol/openid-connect/certs
OAUTH_USERINFO_URL=${EXTERNAL_BASE_URL}/auth/realms/cmem/protocol/openid-connect/userinfo
OAUTH_LOGOUT_REDIRECT_URL=${EXTERNAL_BASE_URL}/auth/realms/cmem/protocol/openid-connect/logout?redirect_uri=${EXTERNAL_BASE_URL}
```

Assuming your deployment is deployed at `192.168.1.10` your apache httpd vhost configuration for the external reverse proxy has a configuration similar to this:

```
<VirtualHost *:80>
    ServerName your.host
    Redirect permanent / https://your.host/
</Virtualhost>
<VirtualHost *:443>
    ServerName your.host
    RequestHeader set "X-Forwarded-Proto" expr=%{REQUEST_SCHEME}
    RequestHeader set "X-Forwarded-SSL" expr=%{HTTPS}
    ProxyPass / http://192.168.1.10:8823/ nocanon retry=0
    ProxyPassReverse / http://192.168.1.10:8823
    # include ssl-config
    Include /etc/apache2/conf-includes/ssl-config.conf
    # include logging conf
    Include /etc/apache2/conf-includes/logging.conf
    # https://github.com/gitlabhq/gitlabhq/issues/8924
    AllowEncodedSlashes NoDecode
    ProxyTimeout 1200
</VirtualHost>
```

## Deploying With Self-Signed Certificate

Use this scenario in case:

* there is no connection to [letsencrypt](https://letsencrypt.org/) (e.g. blocked by corporate firewall).
* or there is a reverse proxy in front of the Corporate Memory instance, which requires SSL connection to the Corporate Memory.

Given that you deploy the Corporate Memory on the host your.host, copy the default SSL configuration:

```
cp environments/config.ssl.env environments/your.host.env
```

Modify DEPLOYHOST in the environments/your.host.env:

```
DEPLOYHOST=your.host
```

```
cp conf/cmemc/cmemc.ini.untrustedssl conf/cmemc/cmemc.ini
```
Modify the file conf/cmemc/cmemc.ini to this:
```
[cmem]
CMEM_BASE_URI=https://your.host
OAUTH_GRANT_TYPE=client_credentials
OAUTH_CLIENT_ID=cmem-service-account
SSL_VERIFY=false
```

Generate SSL key, CSR, certificate and truststore then start the Corporate Memory:

```
CONFIGFILE=environments/your.host.env make ssl-genkey ssl-gencsr ssl-gencert
CONFIGFILE=environments/your.host.env make startUntrustedSSL
```

## Deploying With Provided/Third-Party Certificate

Use this scenario in case:

* A certificate/key already exist (provided by customer/third-party)

```
cp environments/config.ssl.env environments/your.host.env
cp provided-fullchain.pem conf/ssl/your.host/fullchain.pem
cp provided-privkey.pem conf/ssl/your.host/privkey.pem
```

Modify DEPLOYHOST in the environments/your.host.env:

```
DEPLOYHOST=your.host
```

Build truststore and deploy the Corporate Memory:

```

CONFIGFILE=environments/your.host.env make startUntrustedSSL
```
## Debugging certificates

Here you have some examples commands to look into those deployed certificates:
```
openssl x509 -text -noout -in conf/ssl/YOURHOST/fullchain.pem
openssl req -text -noout -verify -in conf/ssl/YOURHOST/csr.pem
openssl s_client -connect DEPLOYHOST:443 -status
```

**NOTE**: In case of trusted third-party certificates building trust store is not required.

