<#macro textfield icon id type label value error="" disabled=false required=false inputparameters="">
    <div class="
            mdc-text-field mdc-text-field--outlined mdc-text-field--with-leading-icon ${properties.kcLabelClass!}
            <#if disabled>mdc-text-field--disabled</#if>
            <#if error?? && error!="">mdc-text-field--invalid</#if>
    ">
        <i class="material-icons mdc-text-field__icon" tabindex="-1" role="button">${icon}</i>
        <input
            id="${id}"
            name="${id}"
            type="${type}"
            value="${value}"
            class="mdc-text-field__input ${properties.kcInputClass!}"
            <#if required>required</#if>
            <#if disabled>disabled</#if>
            autocomplete="off"
            ${inputparameters}
        >
        <div class="${properties.kcLabelWrapperClass!}">
            <label for="password" class="mdc-floating-label ${properties.kcLabelClass!}">
                ${label}
                <#if required><span class="required">*</span></#if>
            </label>
        </div>
        <div class="mdc-notched-outline"><svg><path class="mdc-notched-outline__path"/></svg></div>
        <div class="mdc-notched-outline__idle"></div>
    </div>
</#macro>
