<!-- markdownlint-disable MD012 MD013 MD024 MD033 -->
# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](http://keepachangelog.com/) and this project adheres to [Semantic Versioning](http://semver.org/).

Note: This file is part of the CO distribution artifact.

## [25.2.4] 2025-09-19

### Changed

- Use mirrored versions of keycloak and postgres
  - docker-registry.eccenca.com/mirror/docker.io/bitnamilegacy/keycloak:25.0.6-debian-12-r4
  - docker-registry.eccenca.com/mirror/docker.io/bitnamilegacy/postgresql:16.6.0-debian-12-r2

## [25.2.3] 2025-09-08

### Changed

- update Corporate Memory images to:
  - Build v25.2.2

## [25.2.2] 2025-08-28

### Changed

- update Corporate Memory images to:
  - Explore v25.2.2
  - Build v25.2.1


## [25.2.1] 2025-08-11


### Changed

- update Corporate Memory images to:
  - Explore v25.2.1

### Fixed
- update Corporate Memory images to:
  - cmemc v25.4.0

## [25.2.0] 2025-08-03

### Added

- DI conf: workbench.logoSmall configuration variable added
- Support for GraphDB 11.0.x (CMEM-6711)
  - GraphDB AI GPT settings are deprecated s. default.env
- DI volumes buildTempFs and added a few tempFs mount points (CMEM-6186)
- CERTIFICATE_DIRECTORY env variable to adjust mount points in explore and DI
- `plugins` collection extension using the image v1.6.0

### Changed

- update Corporate Memory images to:
  - Explore v25.2.0
  - Build v25.2.0
  - cmemc v25.4.0
  - Plugins Collection v1.6.0
- Makefile: check-env target extended with creating folders in data. Change permissions for folders
- update Semspect extension to v18.2.0

## Fixed

- custom ssl cert: python plugins get the certificate as well now


## [25.1.2] 2025-07-14

### Changed

- update Corporate Memory images to:
  - EXPLORE_VERSION v25.1.2
- update GDB license (internal only)
- update derivo-semspect image to v18.1.0


## [25.1.1] 2025-05-19

### Changed

- update Corporate Memory images to:
  - EXPLORE_VERSION v25.1.1
  - DI_VERSION v25.1.1
  - CMEMC_VERSION v25.1.1
- BUILD Variable to change redirect after logout
  - `OAUTH_LOGOUT_REDIRECT_URL` now only defines the url where to redirect to after logout
- removed some legacy flags for Keycloak startup
- update and pin keycloak image to `docker.io/library/httpd:2.4.63-bookworm`

### Fixed

- Explore: CBD max depth config was on wrong position

### Added
- EXPLORE Variable to change redirect after logout
- BUILD Variable to change redirect after logout
  - `OAUTH_LOGOUT_URL` now gives the url to oidc logout endpoint


## [25.1.0] 2025-04-22

### Changed

- update Corporate Memory images to:
  - EXPLORE_VERSION v25.1.0
  - DI_VERSION v25.1.0
  - CMEMC_VERSION v25.1.1
- make target extend-orchestration to enable-extension EXTENSION=abc
- update and pin graphdb image to `docker.io/ontotext/graphdb:10.8.5` (CMEM-6576)
- restarts apache container after enable/disable an extension

### Added

- disable-extension EXTENSION=abc
- Grafana dashboards for build and explore
- Extension added containing all available python extensions for Corporate Memory Build/DataIntegration

### Fixed

- renamed `extend-orchestration` into `enable-extension` in the READMEs
- Modified `ssl-gencert` rule to include Subject Alternative Names (SANs) during certificate creation and correct extensions


## [24.3.2] 2025-02-12

### Changed

- update Corporate Memory images to:
  - CMEMC_VERSION v24.3.2
  - DI_VERSION v24.3.1
- update and pin graphdb image to `docker.io/ontotext/graphdb:10.8.3`


## [24.3.1] 2025-01-16

### Changed

- update Corporate Memory images to:
    - CMEMC_VERSION v24.3.1
- roll back and pin graphdb image to `docker.io/ontotext/graphdb:10.8.1`

### Added

- in preparation for upcoming repository switch introducing Repository Variables, defaulting to these:
  - EXPLORE_REPOSITORY_PATH=docker-registry.eccenca.com/eccenca-explore
  - DI_REPOSITORY_PATH=docker-registry.eccenca.com/eccenca-dataintegration
  - CMEMC_REPOSITORY_PATH=docker-registry.eccenca.com/eccenca-cmemc

## [24.3.0] 2024-12-19

### Changed

- BREAKING CHANGE: merged DM and DP into EXPLORE
- update Corporate Memory images to:
  - EXPLORE_VERSION v24.3
  - DI_VERSION v24.3
  - CMEMC_VERSION v24.3
- update Semspect extension to v17.0.0
- simplify `extend-orchestration` by adding `extend-reverse-proxy` logic and add `installoidc`
- update ENV default `DATAINTEGRATION_PRODUCTION_CONFIG_FILE` to reflect DI config merge
- DI: move `logback.xml` to `logback.xml.dist` since defaults also available inside DI image
- update and pin postgres image to `docker.io/bitnami/postgresql:16.6.0-debian-12-r2`
- update and pin keycloak image to `docker.io/bitnami/keycloak:25.0.6-debian-12-r4`
- update and pin graphdb image to `docker.io/ontotext/graphdb:10.8.2`
- update and pin eccenca keycloak theme to `v2.3.0`

### Removed

- move `extend-reverse-proxy` target into `extend-orchestration`
- DI: `production.conf` merged with `dataintegration.conf`
- DI: removed `hive-site.xml`and `spark-default.conf` since also available inside DI image
- DI: removed `logback.xml`, but left example in configuration
- CO: remove store alternatives allegrograph, anzograph, blazegraph, marklogic, rdfox

### Added

- introduce restart policy variable, defaulting to `unless-stopped`
- added GRAPHDB_GPT_MODEL and GRAPHDB_GPT_TOKEN in default.env. can be overwritten in config.env

## [24.2.2] 2024-12-06

### Changed
- update Corporate Memory images to:
    - DM_VERSION v24.2.3

## [24.2.1] 2024-09-20

### Changed

- update Corporate Memory images to:
    - DP_VERSION v24.2.1
    - DM_VERSION v24.2.1
    - DI_VERSION v24.2.1
- update and pin postgres image to `docker.io/bitnami/postgresql:16.4.0-debian-12-r9`
- update and pin keycloak image to `docker.io/bitnami/keycloak:25.0.6-debian-12-r0`

## [24.2.0] 2024-08-14

### Changed

- remove backup volume from graphdb, since it is unused
- remove stardog support (CMEM-5929)
- update Corporate Memory images to:
    - DP_VERSION v24.2.0
    - DM_VERSION v24.2.0
    - DI_VERSION v24.2.1
    - CMEMC_VERSION v24.2.0
- update and pin postgres image to `docker.io/bitnami/postgresql:16.4.0-debian-12-r0`
- update and pin keycloak image to `docker.io/bitnami/keycloak:25.0.2-debian-12-r2`

### Added

- `make extend-reverse-proxy EXTENSION=xxx` creating a symbolic link and including configs for apache reverse proxy
- include for `semspect.conf` for apache to adding `/semspect` proxyPath
- include for `metrics.conf` for apache to adding `/metrics` proxyPath
- include `docker-compose.metrics.yaml` extension, which adds Prometheus and Grafana to cmem-orchestration
- conf/metrics/prometheus.yml` config for prometheus scraper (scrapes GDB, Keycloak, not CMEM yet)

### Removed

- apache `healthcheck.sh` file, obsolete and not used since 1 year
- `default-semspect.conf`and `default-semspect.ssl.conf` no longer needed

## [24.1.5] 2024-07-29

### Changed

- update memory footprint of keycloak to 600MB max since it sometimes drops
- update memory footprint of apache to 250MB max since it sometimes drops
- update GraphDB image to `docker.io/ontotext/graphdb:10.7.1`
- update and pin postgres image to `docker.io/bitnami/postgresql:16.3.0-debian-12-r23`
- update and pin keycloak image to `docker.io/bitnami/keycloak:24.0.5-debian-12-r8`
- update and pin apache httpd image to `docker.io/library/httpd:2.4.62-bookworm`
- update Corporate Memory images to:
    - CMEMC_VERSION v24.1.5
- update Semspect extension image to `docker-registry.eccenca.com/derivo-semspect:v16.0.1`
- update jupyter extension image to `docker-registry.eccenca.com/eccenca-jupyter-docker:v4.2.3-1`


## [24.1.4] 2024-06-21

### Changed

- update Corporate Memory images to:
    - DP_VERSION v24.1.2
    - DM_VERSION v24.1.3
    - DI_VERSION v24.1.2
    - CMEMC_VERSION v24.1.2
- update and pin postgres image to `docker.io/bitnami/postgresql:16.3.0-debian-12-r14`
- update and pin keycloak image to `docker.io/bitnami/keycloak:24.0.5-debian-12-r0`
- update and pin apache httpd image to `docker.io/library/httpd:2.4.59-bookworm`
- update GraphDB image to `docker.io/ontotext/graphdb:10.6.4`
- update eccenca-keycloak-theme to `v2.2.2`
- rename STATE variable to BACKUP for restoring certain backups
- changed Java heap memory handling through container limits
- refactored the TLS handling of 'untrusted' certificates.
- clean up README.md
- clean up `make help` command to only show most important functions.
- move reduced content of `scripted-env.mk` into main Makefile

### Added

- container now have memory limits
- `config.mem.minmal.env` for running on ~5GB memory footprint
- `make generate-env`, a function to generate a .env file containing all defined environmental variables. This allows the usage of `docker compose` without make in this directory
- extension: semspect
- `make installoidc` installs the OIDC apache module into the running container, allowing securing certain resources
- `make startUntrustedSSL`, starts the CO but also injects TLS certificates (selfSigned or custom)
- `README.tls.md` for more detailed explanation how to handle certificates which are untrusted by default (self-signed or company signed)
- `make help-extend` to show most functions.
- gitlab CICD job for testing most targets

### Removed

- ECC_HOST variable (unused since ages)
- `make sbom`
- check for docker environment
- `compose/docker-compose.dataintegration-ssl.yml` since it's obsolete after the new TLS certificate injection


## [24.1.3] 2024-04-16

### Changed

- update release images
    - DM v24.1.3
    - DP v24.1.2
    - DI v24.1.1
    - CMEMC v24.1.1
- update GraphDB image to `docker.io/ontotext/graphdb:10.6.2`


## [24.1.2] 2024-04-02

### Changed

- update release images
    - DM v24.1.2
    - DP v24.1.1
- update apache image to `docker.io/library/httpd:2.4-bookworm`
- update keycloak image to `docker.io/bitnami/keycloak:24-debian-12`

### Deprecated

- We will upgrade to postgres 16 in the next release:
    - There is no upgrade path to upgrade from postgres15 to postgres 16
    - You will need to create a backup with `pg_dump` and restore this dump in postgres 16 afterwards
    - or in this distribution you can run `make keycloak-backup`


## [24.1.1] 2024-03-25

### Changed

- update memory presets for 16G and 32G
- update eccenca-keycloak-theme to v2.2.1
- update release images
    - DM v24.1.1
    - DP v24.1.1
- update keycloak image to `docker.io/bitnami/keycloak:23-debian-12`
- update postgres image to `docker.io/bitnami/postgresql:15-debian-12`

### Added

- memory presets for 48G 64G 128G


## [24.1.0] 2024-02-19

### Fixed

- version-list target now fetches `org.opencontainers.image.version` attribute
- fix 'dataintegration_base must be a mapping' for "Docker Compose version v2.24.3-desktop.1"

### Changed

- update release images
    - DI v24.1.0
    - DM v24.1.0
    - DP v24.1.0
    - CMEMC v24.1.0
- update GraphDB image
    - `docker.io/ontotext/graphdb:10.5.1`
- update keycloak theme to v2.2.0


## [23.3.2] 2023-01-30

### Changed

- update release images
    - DI v23.3.2
    - DM v23.3.1
- update GraphDB image
    - `docker.io/ontotext/graphdb:10.4.3`

## [23.3.1] 2023-12-06

### Changed

- update release images
    - DI v23.3.1
- update GraphDB image
    - `docker.io/ontotext/graphdb:10.4.2`


## [23.3.0] 2023-11-16

### Changed

- BREAKING CHANGE: change dataplatform oauth2 client config to adjust for spring boot update (CMEM-5171)
  - `spring.security.oauth2.client.registration.keycloak.client-authentication-method`: `basic` -> `client_secret_basic`
- BREAKING CHANGE: remove dataplatform property `authorization.abox.prefix` from configuration (CMEM-5227)
  - deployments which still set this property will fail on DP startup
- update release images
    - DP v23.3.0
    - DM v23.3.0
    - DI v23.3.0
- update eccenca Keycloak Theme v2.1.0


## [23.2.2] 2023-09-12

### Fixed

- heapdump paths in GraphDB environment adjusted to work with Ontotext image


## [23.2.1] 2023-09-04

### Changed

- update release images
    - DP v23.2.1
    - DI v23.2.1


## [23.2.0] 2023-08-16

### Changed

- update release images
    - DP v23.2.0
    - DM v23.2.0
    - DI v23.2.0
- Changed to use official docker images for postgres, keycloak, apache and graphdb
    - GRAPHDB_IMAGE=ontotext/graphdb:10.2.4
    - APACHE2_IMAGE=httpd:2.4-bullseye
    - KEYCLOAK_IMAGE=bitnami/keycloak:21-debian-11
    - POSTGRES_IMAGE=bitnami/postgresql:15-debian-11
    - VIRTUOSO_IMAGE=virtuoso-opensource-7:7.2
- now mounting keycloak theme as submodule instead of using prebuild container
- introduce new variable for switching graphdb edition, valid values are:
    - GRAPHDB_LICENSE=se|ee
- switch to eccenca-keycloak-theme:v2.0.0

### Deleted

- ontodia vhost configuration


## [23.1.3] 2023-06-16

### Changed

- update release images
    - DP v23.1.3
    - DM v23.1.5
    - DI v23.1.2
    - CMEMC v23.1.3


## [23.1.2] 2023-05-15

### Changed

- update release images
    - DP v23.1.2
    - DM v23.1.4
    - DI v23.1.1
    - CMEMC v23.1.2
    - Apache v5.1
    - Keycloak v20.0.5-3

- re-enable keycloak account-console


## [23.1.1] 2023-05-02

### Changed

- disabled X-Frame-Options SAMEORIGIN in `ssl.base.conf` to allow external keycloaks
- move `OAUTH_CLIENT_ID` to environments (DI / DP)
- move `OAUTH_LOGOUT_REDIRECT_URL` to environments (DI)
- add cookie settings and comments for DP session cookie
- externalize DM and DI healthcheck from image to orchestration


## [23.1] 2023-04-25

### Changed

- Use the `--network container:<id>` syntax to connect cmemc to bootstrap
- Use GraphDB 10 now, set by GRAPHDB_VERSION - breaking change: Usage of GDB9 now requires full version tag like: v9.11.2-se
- update Keycloak to v20.0.5-2
- (breaking change) Replaced DATAPLATFORM_AUTH_URL with OAUTH_ISSUER_URL (CMEM-4833)
    - OAUTH_AUTHORIZATION_URL (already used for DI)
    - OAUTH_TOKEN_URL (already used for DI)
- (breaking change) refactored keycloak default database
    - disabled unused keycloak clients
    - removed datamanger and dataintegration client
    - added cmem client for dataplatform and dataintegration
    - added descriptions to clients
    - removed groups_user_a and group_user_b
    - removed user "user"
- removed oauth configuration in datamanager
- changed configuration in dataintegration for using cmem client instead of dataintegration client

### Added

- keycloak default database:
  - user admin and client cmem-service-account: manage-users and manage-clients role added
  - This allows for using the `cmemc admin user` command group with these accounts

### Fixed

- postgres now uses its volume


## [22.2.3] 2023-02-21

### Changed

- DM version 22.2.3 used


## [22.2.2] 2023-01-23

### Changed

- easynav enabled
- DM version 22.2.2 used
- DP version 22.2.2 used


## [22.2.1] 2023-01-11

### Added

- config.mem.16g.env and config.mem.32g.env: default memory configuration templates
- DP property and config environment entries for graphdb which initializes the configured repository on startup (CMEM-3480)
  - GRAPHDB_REPOSITORY configures repository name (default: cmem)
  - GRAPHDB_CREATE_REPO_ON_STARTUP configures whether repository shall be created on DP startup (default: false)
- DP property and config environment entries for selective cache invalidation (CMEM-4100)
  - GRAPHDB_CHANGE_TRACKING_ACTIVE configures whether the graphdb change tracking should be used to more exactly analyze the results of an update
  - GRAPHDB_CHANGE_TRACKING_MAX_QUADS_MEM configures the max. no. of quads loaded from graphdb change tracking for analyzing update results
  - DATAPLATFORM_CACHE_FLUSH_SELECTIVE_ACTIVATED configured whether the DP caches are flushed selectively upon the result of the graph store operation
    - active for GraphList, OWL Import and Shapes Cache
  - DATAPLATFORM_CACHE_FLUSH_CRON configures cron for scheduled complete flush of DP caches
- installed DI packages available under ./data/python-packages
    - optional python-plugins.conf allows for plugin configuration

### Changed

- use network alias on default network instead of links section (used by DI only)
  - used as `services.apache2.networks.default.aliases`
- Removed support for multiple endpoints - new store configuration properties (CMEM-4282)
  - Type of store (general settings)
    - store.type: MEMORY, HTTP, GRAPHDB, STARDOG, VIRTUOSO, NEPTUNE
    - store.authorization: NONE, REWRITE_FROM
  - MEMORY:
    - store.memory.files: List of files loaded on startup
  - HTTP:
    - store.http.queryEndpointUrl: SPARQL Query endpoint (mandatory)
    - store.http.updateEndpointUrl: SPARQL Update endpoint (mandatory)
    - store.http.graphStoreEndpointUrl: SPARQL GSP endpoint (optional but highly recommended)
    - store.http.username: Username (optional)
    - store.http.password: Password (optional)
  - GRAPHDB:
    - store.graphdb.host: host of graphdb backend (i.e. localhost)
    - store.graphdb.port: port of graphdb backend (i.e. 7200)
    - store.graphdb.ssl-enabled: flag if ssl (https) is enabled (default: false)
    - store.graphdb.repository: name of repository (i.e. cmem)
    - store.graphdb.username: Username (optional)
    - store.graphdb.password: Password (optional)
    - store.graphdb.useDirectTransfer: flag if direct GSP endpoints of graphdb shall be used instead of workbench upload (default: true)
    - store.graphdb.importDirectory: Import directory to be utilized in the "workbench import with shared folder" approach.
    - store.graphdb.graphDbChangeTrackingActive: Whether change tracking for updates is active - better results for cache invalidation (default: true)
    - store.graphdb.graphDbChangeTrackingMaxQuadMemory: Amount of quads as a result of an update which are loaded into memory for analyzing consequences for caches (default: 1000)
  - STARDOG:
    - store.stardog.host: host of stardog backend (i.e. localhost)
    - store.stardog.port: port of stardog backend (i.e. 5820)
    - store.stardog.ssl-enabled: flag if ssl (https) is enabled (default: false)
    - store.stardog.repository: name of repository (i.e. cmem)
    - store.stardog.username: Username (optional)
    - store.stardog.password: Password (optional)
    - store.stardog.userPasswordSalt: salt for generated user password (optional)
    - store.stardog.updateTimeoutInMilliseconds: Timeout in ms for updates (default: 0 = deactivated)
    - store.stardog.graphListQuery: Query for graph list - graph must be bound to variable ?g
  - NEPTUNE:
    - store.neptune.host: host of neptune backend (i.e. neptune-cluster123.eu-central-1.neptune.amazonaws.com)
    - store.neptune.port: port of neptune backend (i.e. 8182)
    - store.neptune.graphListQuery: Query for graph list - graph must be bound to variable ?g
    - Settings under store.neptune.aws (mandatory):
      - store.neptune.aws.region: AWS region where the configured neptune cluster is located (i.e. eu-central-1)
      - store.neptune.aws.authEnabled: Flag on whether authentication is enabled on neptune cluster (default: true)
    - Settings under store.neptune.s3 for upload of large files (>150MB uncompressed) (optional):
      - store.neptune.s3.bucketNameOrAPAlias: Name of bucket or access point for S3 bulk load
      - store.neptune.s3.iamRoleArn: ARN of role under which neptune cluster loads from S3
      - store.neptune.s3.bulkLoadThresholdInMb: Load threshold in MB for GSP access, if graph data greater than S3 upload is used (default: 150)
      - store.neptune.s3.bulkLoadParallelism: Degree of parallelism for neptune S3 bulk loader (LOW (default), MEDIUM, HIGH, OVERSUBSCRIBE)
  - VIRTUOSO:
    - store.virtuoso.host: host of virtuoso backend (i.e. localhost)
    - store.virtuoso.port: http port of virtuoso backend (i.e. 8080)
    - store.virtuoso.databasePort: database port of virtuoso backend (i.e. 1111)
    - store.virtuoso.ssl-enabled: flag if ssl (https) is enabled (default: false)
    - store.virtuoso.username: Username (optional)
    - store.virtuoso.password: Password (optional)
- keycloak theme config of login and account screen
- allow for english, french and german language (english is default)
- use keycloak 19.0.2
  - see [release notes](https://www.keycloak.org/2022/04/keycloak-1800-released)

### Removed

- DI config: Python2ScriptTransformer config and volume for plugins


## [22.1.2] 2022-09-15

### Added

- make target `cmemc-create-showcase`

### Changed

- Set default charset to utf-8 in JVM (file.encoding, sun.jnu.encoding) and in the environment (LC_ALL=C.UTF-8, LANG=C.UTF-8)


## [22.1.1] 2022-06-17

### Changed

- use DataManager 22.1.1 image
- use cmemc 22.1.1 image


## [22.1] 2022-06-16

### Added

- added new properties / env variables for integration of neptune store (s. default.env)
- add new env variable to enable DI play session cookie secure flag (default off)

### Changed

- change postgres healthcheck to wait for entry in database
- upgrade to stardog v7.9.0 free images
- upgrade to keycloakx v16.1.1 image
- upgrade to graphdb v9.11.1 images
- adjusted spring config of DP for new handling of profiles (due to Spring update)
  - spring.profiles=PROFILE needs to be replaced by spring.config.activate.on-profile
  - introduction of spring.profiles.group entries for stores
- change apache config to disable server info
- update apache https ssl config

### Fixed

- apache container healthcheck


## [21.11.5] 2022-02-07

### Changed

- use stardog 7.8.3-1 image
- use graphdb 9.10.2 images
- update DM to 21.11.5


## [21.11.4] 2022-01-21

### Fixed

- DM upgrade to 21.11.1 due to broken configuration (CMEM-3911)
- fix Makefile targets 'backup-graphs' and 'export-workspace' storing exports in right place
- missing virtuoso httpPort property in DP (CMEM-4007)

### Changed

- set apache rewrite rule for DI to '^/dataintegration'
- use stardog 7.8.2-2 image
- use apache 2.4.52-1~deb11u2 / v5.0.0 image
- use graphdb v9.10.1 images


## [21.11] 2021-11-22

### Changed

- anonymous access now configurable via DATAPLATFORM_ANONYMOUS set to true (CMEM-3667)
- update graphdb to 9.9.0 (CMEM-3689)
- update component releases to 21.11
- dataplatform openapi UI and json enabled per default (can be disabled)


## [21.06.1] 2021-08-24

### Changed

- anonymous access disabled


## [21.06] 2021-07-30

### Added

- keycloak backup make targets
- CMEMC_CONNECTION enviroment when linked to local cmemc config
- neo4j extension
- optional overwrite in env: set DATAINTEGRATION_LINK_APACHE to somethingelse to remove link for DI to apache:DEPLOYHOST (for running CO behind reverse Proxy)

### Changed

- update DI/DM/DP to v21.06
- update graphdb (free/se/ee) to v9.7.0-3
- updated keycloak to v12.0.4-r105
- update logformat to harmonize all logs for DI/DM/DP/Keycloak/GraphDB
- graphdb now also logs into {DEST}/logs folder
- changed cmemc export graphs file scheme to iriname
- zip cmemc export started from Makefile (not extra script)
- DI plugin configuration is now easier to enable/disable

### Removed

- stardog backup targets, since they are replaced with cmemc targets


## [21.04] 2021-05-10

### Added

- configurable URL to change account settings in DM:
  - `js.config.modules.accountSettings.enable`: `true`
  - `js.config.modules.accountSettings.url`: `"${DEPLOY_BASE_URL}/auth/realms/cmem/account/"`

### Changed

- updated stardog to 7.6.1-1 .
- licenses moved to licenses directory

### Fixed

- distribution creation (OPS-1226)


## [21.02.1] 2021-03-31

### Added

- configuration for DI super user.

### Changed

- set default value for stardog optimization `STARDOG_AUTO_OPTIMIZE` to `false`.
- increase Query logging level in DP: set `com.eccenca.elds.backend.sparql.query.logging:` to `DEBUG`.
- apache2: enable compression via mod_deflate for all connections if requested (CMEMC-3020)
- GraphDB increased heap, global cache enabled

### Fixed

- properly inject environment variables into DI container


## [21.02] 2021-03-01

### Added

- support for different stores

### Changed

- default configuration uses now GraphDB
- all eccenca images changed to v21.02
- updated stardog to 7.4.5.

### Removed

- DP query log option `QUERY_LOGGING_FILE`.


## [20.12.1] 2021-01-12

### Changed

- label properties re-ordered (skos:prefLabel first)
- stardog image updated


## [20.12] 2020-12-22

### Changed

- all eccenca images changed to v20.12
  - https://documentation.eccenca.com/latest/release-notes/corporate-memory-20-12
- Bootstrap process changed to cmemc based

### Removed

- all bootstrap data (available now in DP directly)


## [20.10.1] 2020-11-12

### Added

- clean and dist-clean now ask for consent

### Changed

- DM, DP images to v20.10.1

### Fixed

- issues with apache


## [20.10] 2020-11-02

### Changed

- DM, DP, DI, CMEMC images to v20.10
- apache to v4.1.0
- stardog to v7.4.1
- keycloak still v6.0.1


## [20.06] 2020-06-15

### Changed

- bump stardog version to 7.2.1 (using docker image v7.2.1-1)


## [20.03.2] 2020-04-08

### Changed

- Add version slice to the dist-create make target


## [20.03.1] 2020-04-08

This repository is a continuation of the [CMEM hadoop orchestration](https://gitlab.eccenca.com/elds/cmem-hadoop-orchestration).

### Changed

- the `make bootstrap` target has been replaced by `BOOTSTRAP=true`. This enables Stardog to directly import the bootstrap data, without the usage of an importer.
- `APACHE_EXTENSION_FILE` has been renamed to `APACHE_BASE_FILE`
- update to docker compose v2.4
- introduce new structure for environment variables-based configuration
- add TRIG-based backup/restore approach

### Removed

- dummy container, as it is not required anymore
- E2E tests
- CMEM SYNC functionality
- DP versioning support
- general clean up
- SERVER_SERVLET_CONTEXTPATH from DP config

