#!/usr/bin/env bash
# Use the unofficial bash strict mode: http://redsymbol.net/articles/unofficial-bash-strict-mode/
set -euo pipefail; export FS=$'\n\t'

curlExitCode=$(curl --silent 'http:/localhost:7200/protocol' --write-out "%{http_code}" -o /dev/null)
curlExitStatus=$?
if [[ "$curlExitStatus" -ne "0" ]]; then
    echo "curl returned exit code $curlExitStatus, unhealthy"
    exit 1
fi
if [[ "$curlExitCode" -ne "200" ]]; then
    echo "HEAD returned $curlExitCode != 200, unhealthy"
    exit 1
fi
echo "healthy"
exit 0;
