# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](http://keepachangelog.com/) and this project adheres to [Semantic Versioning](http://semver.org/).

## [5.4.1] 2025-12-03

### Changed
- bugfix, typo .Values.dataintegration.config.mappingCreator.enabled (CMEM-7177)
- update Corporate Memory images to:
    - eccenca-dataintegration v25.3.1


## [5.4.0] 2025-12-01

### Changed

- DI/BUILD configuration - BREAKING CHANGE: for `.Values.dataintegration.config.workspaceRepository` `file` is no longer supported, use `sharedFileRepository` instead
- BREAKING CHANGE: Changed `.Values.dataintegration.strategy` and `.Values.explore.strategy` to `.Values.dataintegration.updateStrategy` resp. `.Values.explore.updateStrategy` to align with spec of StatefulSets`.Values.dataintegration.additionalCustomConfig`
- images used in the chart are now correctly used from Chart.yaml, or can be overwritten in values.yaml
- by default enable explore swaggerui
    - See `Values.explore.config.springdocSwaggerUIEnabled`
    - See `Values.explore.config.springdocApiDocsEnabled`
- update Corporate Memory images to:
    - eccenca-explore v25.3.0
    - eccenca-cmemc v25.5.0
    - eccenca-dataintegration-plugins v3.1.0
    - eccenca-dataintegration v25.3.0
    - eccenca-graphinsights v19.1.0-1

### Added

- Explore companion:
    - it can be enabled in the values file. See `Values.explore.companion.enabled=false`, default off.
    - companion requires LLM configuration in yaml syntax in `Values.explore.companion.config`
    - persistence requires a volume, configured to create on the fly or as predefined volume. See `Values.explore.companion.persistence`
- DataIntegration Mapping Creator settings
    - See `Values.dataintegration.config.mappingCreator`
- Graph-Insights configuration: default to disabled
    - See `Values.graphinsights`

## [5.3.4] 2025-10-29

### Changed
- update Corporate Memory images to:
    - EXPLORE_VERSION v25.2.6


## [5.3.3] 2025-10-28

### Changed
- update Corporate Memory images to:
    - EXPLRE_VERSION v25.2.5


## [5.3.2] 2025-10-06

### Changed
- update Corporate Memory images to:
    - EXPLRE_VERSION v25.2.3


## [5.3.1] 2025-09-08

### Changed
- update Corporate Memory images to:
    - DI_VERSION v25.2.2


## [5.3.0] 2025-08-28

### Changed
- update Corporate Memory images to:
    - EXPLRE_VERSION v25.2.2
    - DI_VERSION v25.2.1

### Added
- DI/BUILD configuration - introduced  value dataintegration.tmp.silkPath for adjusting silk temporary path, was fixed mount path before
    - fixed silk operators can't write temporary files
- automountServiceAccountToken for DI/Build configurable in values, default to false
- add serviceAccount value section for DI/Build, defaults to disabled

## [5.2.1] 2025-08-11


### Changed

- update Corporate Memory images to:
    - EXPLRE_VERSION v25.2.1


## [5.2.0] 2025-08-03


### Changed

- update Corporate Memory images to:
    - EXPLRE_VERSION v25.2
    - DI_VERSION v25.2
    - CMEMC_VERSION v25.4

### Added
- DI/Build initContainer securityContext at .Value.dataintegration.initContainer.securityContext
- DI/Build initContainer CustomCA option to disable this container. Enabled by default.
- eccenca-dataintegration-plugins option

### Fixed
- selfsigned SSL certs REQUESTS_CA_BUNDLE for DI/Build


## [5.1.1] 2025-06-13


### Fixed
- dataintegration.customCommand typo
- dataintegration.customVolumes wrong indentation
- missing extra container definition, e.g sidecar
- Python (cmempy) custom ssl cert handling for DI pod. (CMEM-6671)

## [5.1.0] 2025-05-21


### Fixed

- Setting `tolerations` does now take effect for explore and datatintegration

### Added

- Allow for [IAM roles for service accounts (IRSA)](https://docs.aws.amazon.com/eks/latest/userguide/iam-roles-for-service-accounts.html) for DI connecting to S3 by not setting `accessKeyId` and `secretKey`
- Allow for setting `nodeSelector`, `tolerations` and `affinity` for bootstrap job
- custom Method for Build/DataIntegration to allow overwrite with values files
  - customInitContainer
  - customVolumeMounts
  - customCommand
- Python plugins now can be installed with docker-registry.eccenca.com/eccenca-dataintegration-plugins, default to false


## [5.0.2] 2025-05-21

### Changed

- update Corporate Memory images to:
    - EXPLRE_VERSION v25.1.1
    - DI_VERSION v25.1.1
    - CMEMC_VERSION v25.1.1

### Added
- Value.global.validPostLogoutRedirectUri defaults to http(s)://deployhost
    - this is used in DI and EXPLORE configmaps
    - this is added to to fix the logout issue coming with Keycloak v26 when enforcing validPostLogoutRedirectUri

## [5.0.1] 2025-04-28

### Fixed

- remove debug output


## [5.0.0] 2025-04-22

### Changed

- update Corporate Memory images to:
    - EXPLRE_VERSION v25.1.0
    - DI_VERSION v25.1.0
    - CMEMC_VERSION v25.1.0

### Added

- bootstrap now also uses customCACerts provided if provided by user
- allow overwriting the keycloak oauth redirect URL (for DI only) (workaround for CMEM-6591)
- support prometheus service monitors for scraping prometheus metrics

### Fixed

- di-configmap: PYTHON_PATH variable correctly renamed to PYTHONPATH
- Build/Di: introduce variables for requestTimeout and idleTimeout (OPS-3173)

## [4.0.2] 2025-02-12

### Changed

- update Corporate Memory images to:
    - CMEMC_VERSION v24.3.2
    - DI_VERSION v24.3.1

## [4.0.1] 2025-01-16

### Changed

- update Corporate Memory images to:
    - CMEMC_VERSION v24.3.1

## [4.0.0] 2024-12-19

### Changed
- merge DataPlatform and DataManager into Explore
- change Deployments to StatefulSets
- update Corporate Memory images to:
    - EXPLRE_VERSION v24.3.0
    - DI_VERSION v24.3.0
    - CMEMC_VERSION v24.3.0

## [3.4.0] 2024-12-04

### Added
- DI: allow to use an already existent PVC for dataintegration (default: false)
- DI: allow configuring the [Execution Report Manager](https://documentation.eccenca.com/latest/deploy-and-configure/configuration/dataintegration/#execution-report-manager)
- update Corporate Memory images to:
    - DM_VERSION v24.2.3

## [3.3.0] 2024-09-24

### Added
- DI: allow config to be extended with additional custom configuration

## [3.2.4] 2024-09-20

### Changed

- update Corporate Memory images to:
    - DP_VERSION v24.2.1
    - DM_VERSION v24.2.1

## [3.2.3] 2024-09-11

### Changed
- bootstrap: do not fail on warnings, only on errors

### Added
- option to block incoming traffic on `/dataintegraion/api/python/installPackage*`


## [3.2.2] 2024-08-22

### Changed
- added `cmemc admin store migrate --workspaces` to the bootstrap job


## [3.2.1] 2024-08-15

### Changed
- add `/root/.silk` to tmp emptyDir definition. Needed if use readOnlyRootFilesystem: true
- tmp dir path is no longer configurable, mounted at `/tmp` and `/root/.silk`


## [3.2.0] 2024-08-14

### Added
- extend bootstrap job with capability to manage (install/upgrade) [Python Plugins](https://documentation.eccenca.com/latest/develop/python-plugins/) (DI)
- added provisioning for DI data volume (CMEM-5874)

### Changed
- snowflake-jdbc jar version 3.16.0
- update release images
    - DM v24.2.0
    - DP v24.2.0
    - DI v24.2.1
    - CMEMC v24.2.0

### Removed
- Stardog support


## [3.1.2] 2024-08-13

### Changed
- update release images
    - CMEMC v24.1.5
- fix usage of security context for DI deployment, therefore adding a `/tmp` emptyDir mount


## [3.1.1] 2024-04-31

### Changed
- update release images
    - DI v24.1.2
    - CMEMC v24.1.2


## [3.1.0] 2024-04-30

### Added
- Helm chart annotations for images to be used by the [Helm Distribution plugin](https://github.com/vmware-labs/distribution-tooling-for-helm) as defined per [Creating an images lock](https://github.com/vmware-labs/distribution-tooling-for-helm?tab=readme-ov-file#creating-an-images-lock)
- Configuration for Snowflake JDBC driver (DI)
- ingress: add CORS settings but left uncommented

## [3.0.5] 2024-04-16

### Changed
- update release images
    - DM v24.1.3
    - DP v24.1.2
    - DI v24.1.1
    - CMEMC v24.1.1

## [3.0.4] 2024-04-02

### Changed
- update release images
    - DM v24.1.2


## [3.0.3] 2024-03-25

### Changed
- update release images
    - DM v24.1.1
    - DP v24.1.1


## [3.0.2] 2024-03-06

### Changed
- DI: fixes path generation for logFolder and cache (quotes were wrong)


## [3.0.1] 2024-03-06

### Changed
- fixes name of DI cache variable in values file
- merge 3 dataintegration caches together as one and make them configurable in values
  - for java.io.tmpdir
  - for dataintegration-internal-cache
  - boot logging
- value to decide if cache is an emptyDir (default) or a PVC. StorageClass can be edited.
- fix the file permissions of the truststore by init-containers (DI/DP) in case of a custom CA cert

### Bug identified
- bootstrap job fails though job completed successful with GraphDB free (fixed in next DP patch version v24.1.1)

## [3.0.0] 2024-02-21

### Changed
- Changed default service port to 8080 for all services, therefor also introduce some configMap entries
- set `readOnlyRootFilesystem` for DM, DP, DI and bootstrap. Therefore introduce some volumes for java-processes as emptyDir type
- for DI,DM,DP, bootstrap set
  - automountServiceAccountToken: false
  - allowPrivilegeEscalation: false
- for DM,DP, bootstrap set
  - runAsNonRoot: true
- `datamanager.cache`, `dataintegration.cache`, `dataplatform.cache` is now added to JAVA_OPTs as -Djava.io.tmpdir= as emptyDir volume
- since now using temp volumes, deploy strategy needs to of type: Recreate
- now use cmemc image for bootstrapping and update bootstrap.sh script
- always run bootstrap after running helm update, but disable updating admin user by default


### Removed
- removed fileAppender in DIs logback.xml


## [2.5.0] 2024-02-19

### Changed
- Changed default service port to 8080 for all services
- set `readOnlyRootFilesystem` for DM, DP, Bootstrap, therefore introduce a temp volume for java-processes (DP already there), DI still missing
- for DI,DM,DP set
  - automountServiceAccountToken: false
  - allowPrivilegeEscalation: false
- for DM,DP set
  - runAsNonRoot: true
- since now using temp volumes, deploy strategy needs to of type: Recreate
- now use cmemc image for bootstrapping and update bootstrap.sh script

### Added
- add option to allow for custom CA certs to be injected/added to the Java TrustStore of DI and DP, allowing for TLS-based communication to keycloak with custom CA cert (chain) (see `global.customCACerts` and `global.initContainerResources`)
- add option to append to pod labels (see `global.additionalPodLabels`)
- add option to set global variables for DI (see `dataintegration.config.globalVariables`)
- add serverPort configuration for DI/DP/DM and set to 8080 as default
- add `dataintegration.extraHosts` and `dataplatform.extraHosts` to allow configuration of static IP/Hostnames
- add `datamanager.cache`,`dataintegration.cache`,`dataplatform.cache` to allow mounting empty volumes, eg. used for mounting `java.io.tmpdir`, and also when `readOnlyRootFilesystem`
- add default values for podSecurityContext and securityContext for DM, DP, bootstrap
- add plugin scripting python section for DI
- add extraHosts for DI/DP deployments, and bootstrap job to allow running on localhost

### Removed
- removed fileAppender in DIs logback.xml
- remove some default values in dp-application.yml

### Changed
- set `eccencaDataPlatform.writeGraphType = true` by default (aligned with defaults on cmem-orchestration)
- update release images
    - DI v24.1.0
    - DM v24.1.0
    - DP v24.1.0


## [2.4.1] 2023-12-06

### Changed
- update release images
    - DI v23.3.1

## [2.4.0] 2023-11-16

### Changed
- update release images
    - DP v23.3.0
    - DM v23.3.0
    - DI v23.3.0
- BREAKING CHANGE: change dataplatform oauth2 client config to adjust for spring boot update (CMEM-5171)
  - spring.security.oauth2.client.registration.keycloak.client-authentication-method: basic -> client_secret_basic
  - removed this from configuration-files/dp-application.yml and added as ENV in dp-configmap.yaml
- BREAKING CHANGE: remove dataplatform property authorization.abox.prefix from configuration (CMEM-5227)
  - deployments which still set this property will fail on DP startup
- with DP 23.3 comes improved liveness/readyness checks. Constant database checks are disabled now by default
- add possibility to configure affinity to all DI/DM/DP pods
- allow custom env vars for DM
- add possibility to configure max upload file size for DI

## [2.3.2] 2023-11-16

### Changed
- add option to add a volume for DP usage java temp dir

## [2.3.1] 2023-09-04

### Changed

- update DP to v23.2.1
- update DI to v23.2.1

## [2.3.0] 2023-08-15

### Changed

- update DM to v23.2.0
- update DP to v23.2.0
- update DI to v23.2.0
- update bootstrap container to v1.5.0

### Added

- allow for setting additional env vars within the ConfigMap of both DI & DP
- move accesskey and secretkey to secrets so they don't appear within the configmap
- allow configuring resource repository workspace storage

## [2.2.4] 2023-07-21

### Added

- allow for setting the update strategy for all cmem applications

## [2.2.3] 2023-07-18

### Added

- allow storing resource repositories in S3 for DataIntegration (based on [S3 Bucket, Project Specific - projectS3](https://documentation.eccenca.com/23.1/deploy-and-configure/configuration/dataintegration/?h=resource+repo#s3-bucket-project-specific-projects3))

## [2.2.2] 2023-07-04

### Added

- bootstrap job allows for setting resource section

## [2.2.1] 2023-06-08

### Changed

- update DM v23.1.5
- update DP v23.1.3

## [2.2.0] 2023-05-24

### Changed

- for bootstrap job, make activeDeadlineSeconds and ttlSecondsAfterFinished customizable
- update images: DI 23.1.2 (with some fixes)

## [2.1.0] 2023-05-08

### Changed

- update images: DP 23.1.2, DM 23.1.4
- update the health check extended fail threshold
- update the health check reduce check time until healthy
- refactor bootstrap mechanism and create separate configMap
- option to overwrite bootstrap configMap in values

## [2.0.1] 2022-04-28

### Changed

- update images: DP 23.1.1, DI 23.1.1, DM 23.1.3

## [2.0.0] 2022-04-26

This release is our first release based on cmem 23.1 release and comes with few breaking changes.

### Added

- more comments in our Helm values file `values.yaml`
- sample Helm values file `values.sample.yaml` with minimal required configuration
- bootstrap job image is now configurable
- allow user to enable/disable deployment of the imagePullSecret
- basic Gitlab CI job for `helm lint`

### Changed

- DI/DM/DP images from 23.1 release
- oauth client id changed from `dataintegration` to `cmem` (configurable)
- DP & DI configuration adapted for 23.1 release
- increase `proxy-body-size` for ingress to allow for larger upload of data for users
- enable ssl-redirect for ingress by default

### Removed

- DataManager configuration (part of 23.1 release)

## [1.1.0] 2022-04-25

Starting with this release, we switch over to the new Helm Chart Release versioning (see README Section "Releases and Compatibility matrix").

### Changed

- update images: DP 23.1.2, DM 23.1.4
- update the health check extended fail threshold
- update the health check reduce check time until healthy
- refactor bootstrap mechanism and create separate configMap
- option to overwrite bootstrap configMap in values

## [2.0.1] 2022-04-28

### Changed

- update images: DP 23.1.1, DI 23.1.1, DM 23.1.3

## [2.0.0] 2022-04-26

This release is our first release based on cmem 23.1 release and comes with few breaking changes.

### Added

- more comments in our Helm values file `values.yaml`
- sample Helm values file `values.sample.yaml` with minimal required configuration
- bootstrap job image is now configurable
- allow user to enable/disable deployment of the imagePullSecret
- basic Gitlab CI job for `helm lint`

### Changed

- DI/DM/DP images from 23.1 release
- oauth client id changed from `dataintegration` to `cmem` (configurable)
- DP & DI configuration adapted for 23.1 release
- increase `proxy-body-size` for ingress to allow for larger upload of data for users
- enable ssl-redirect for ingress by default

### Removed

- DataManager configuration (part of 23.1 release)

## [1.1.0] 2022-04-25

Starting with this release, we switch over to the new Helm Chart Release versioning (see README Section "Releases and Compatibility matrix").

### Added

- checksum for secrets on deployments (so pods get restarted if secrets change)
- allow for Helm-templating of all configuration files
- [NOTES.txt](https://helm.sh/docs/chart_template_guide/notes_files/) with basic post-installation notes shown to the user

### Changed

- container names should not depend on the Chart name; will affect metrics and logs (best-practice: static name)
- remove `kube-version/major` and `kube-version/minor` labels (misleading and not used; helm labels would not get updated with new k8s update anyway)
- fix checksum for configs on deployments (so pods get restarted if config changes)
- fix indentation for better readability
- only set `resources` if set in values file
- increase default memory limits (commented out though)
- recommendation to not use CPU limits (see also https://home.robusta.dev/blog/stop-using-cpu-limits)
- split secrets and volumes YAMLs to separate files for product components
- fix deployments without persistence/volume had reference to non-existent pvc
- unify and refactor labels to match best-practices (see also https://kubernetes.io/docs/concepts/overview/working-with-objects/common-labels/#labels)
- change `data` to `stringData` for secrets, so we can get rid of base64-function in this chart, and `helm template` will work with default `values.yaml`
- eccenca CMEM license can now be injected properly (see documentation in README.md)
- Datamanager version `22.2.3`

### Removed

- removed kind from resource name (e.g. bad practice to have a deployment with name `<name>-deployment`; best-practice: `<name>`)
- value option `dataplatform.secret`( as no need (yet) for having users deploy their own secret unmanaged by the chart)
- volume for DataPlatform logs (obsolete, as DP now logs to stdout)

## [v22.2.2] 2022-02-01

### Changed

- update CMEM DP & DM to latest patch release `22.2.2`
- enable logging in `json` format for DI & DP

## [v22.1.0] 2022-11-07

### Added

- First release version based on CMEM `22.1.0`
