# CMEM Helm chart

This chart deploys the core CMEM consisting of the following components:

- Explore
- Dataintegration
- bootstrap done with eccenca-cmemc

Please see below on how to install, upgrade or uninstall the chart.

## Prerequisites

- Kubernetes 1.23+
- Helm 3+

## Cluster requirements

This section always depends on the load to be expected for the instance. Default setup requires ~ 8 GBs RAM
- Ressources: ~ 4CPU
  - Explore: 2,5 GB RAM
  - DataIntegration: 5GB RAM
  - InitContainer cmemc: 128M RAM
- Volumes
  - Explore:
    - tempFS/emptyDir 1GB /tmp
    - optional: tempFS/emptyDir <10M trust store for custom SSL certifcatates
  - DataIntegration:
    - Volume 5GB for DI datasets, uploaded data/files.
    - tempFS/emptyDir 500MB /tmp
    - tempFS/emptyDir 5GB cache
    - optional: tempFS/emptyDir 500M pythonPluginImageInstall
    - optional: tempFS/emptyDir <10M trust store for custom SSL certifcatates
  - Bootstrap:
    - optional: tempFS/emptyDir <10M trust store for custom SSL certifcatatest

## Releases and Compatibility matrix

- Helm chart and CMEM releases are released independent from each other, with different version schema (you can find the current version of the Helm chart under the field `key` in the file `Chart.yaml`)
- Any given release of this Helm chart supports a specific `<major>.<minor>` release line of CMEM. Feel free to change the default value for `dataNNNN.image.tag.` in a given Helm chart release to e.g. the latest stable release.
- The default value for `dataNNNN.image.tag.` in a given Helm chart release
  should be the latest stable release, of the latest supported `<major>.<minor>` line, at the
  time the Helm chart is released.
- If we drop support for older CMEM releases in our Helm chart, we increase the `<major>` version of that Helm chart.
- The `appVersion` of a Helm chart (see `Chart.yaml`) corresponds to the latest CMEM release this Helm chart supports (in the form of `<major>.<minor>`, e.g. `v22.2`)

| Helm Chart Release | Supported CMEM Releases | Default Release |
|--------------------|-------------------------|-----------------|
| 2.5.y              | 23.3 - 24.1             | 24.1.*          |
| 3.0.y              | 24.1 - 24.*             | 24.1.*          |
| 3.1.y              | 24.1 - 24.2             | 24.2.*          |
| 3.2.y              | 24.1 - 24.2             | 24.2.*          |
| 3.3.y              | 24.1 - 24.2             | 24.2.*          |
| 4.x.y              | 24.3 - 25.1             | 24.3.*          |
| 5.x.y              | 24.3 - 25.1             | 25.1.*          |
| 5.2.y              | 25.2.*                  | 25.2.*          |
| 5.3.y              | 25.2.*                  | 25.2.*          |
| 5.4.y              | 25.3 - *                | 25.3.*          |

## Branch and tag naming
```
Branches
  master          Points to latest release/tag
  develop         Long-lived dev
  feature/*       Short-lived dev
  attic/*         Cool ideas

Tags
  x.y.z           Helm chart releases
```

## Getting started

### Prerequisites

Understanding this helm chart requires you to have some basic understandings in the following technologies. There you also find instructions on how to install them. Soon we also provide a repository to give a basic local setup based on k3d a k3s in docker environment.

- Docker https://docs.docker.com/get-started/
- Kubernetes concepts https://kubernetes.io/docs/concepts/
- Helm https://helm.sh/docs/intro/quickstart/

As this was already mentionend this Repository only installs Corporate Memory without Keycloak and GraphDB. Here we asume you already have Graphdb and Keycloak deployed. Please see configurations further below.

- https://github.com/Ontotext-AD/graphdb-helm
- https://github.com/bitnami/charts/tree/main/bitnami/keycloak

#### Binaries
- Install `helm`: https://helm.sh/docs/intro/install/
- Install `kubectl`: https://kubernetes.io/docs/tasks/tools/install-kubectl/
- If deploying on K3D, download a static binary from
  https://github.com/k3d-io/k3d/releases (or use the script at https://k3d.io/
  to do the same).



## License

By default, Corporate Memory is subject to the eccenca free Personal, Evaluation and Development License Agreement (PEDAL), a license intended for non-commercial usage.

If you have a dedicated license file, create a secret with a `license.asc` data entry:

```
kubectl -n corpmem create secret generic cmem-license --from-file cmem/license.asc
```

Then, add the secret name to your `values.yaml` file for the key `global.license`.

For more background on license, see also: https://documentation.eccenca.com/latest/deploy-and-configure/configuration/dataplatform/application-full/

## Install or upgrade chart

First, clone this repository and `cd` into it.

```console
helm upgrade --install --create-namespace -n [RELEASE_NAMESPACE] [RELEASE_NAME] . [-f values.yaml]
```

The flag `--create-namespace` will create the specified namespace `RELEASE_NAMESPACE` if it does not exist yet.

Freely set `RELEASE_NAME`. Using the name of the chart, in this case *cmem*, will result in short names for your Kubernetes objects.

Please set `-f values.yaml` to overwrite default values of the chart with specified ones in your custom `values.yaml` file.

_See [configuration](#configuration) below._

_See [helm install](https://helm.sh/docs/helm/helm_install/) for command documentation._

## Uninstall chart

```console
helm uninstall -n [RELEASE_NAMESPACE] [RELEASE_NAME]
```

This removes all the Kubernetes components associated with the chart and deletes the release.

_See [helm uninstall](https://helm.sh/docs/helm/helm_uninstall/) for command documentation._

## Preview Helm changes

The [helm-diff](https://github.com/databus23/helm-diff) plugin gives us the possibility to preview what a `helm upgrade` would change.

Install it via `helm plugin install https://github.com/databus23/helm-diff`, then you can run the following prior to an install or upgrade command:

```console
# Helm (requires helm-diff plugin)
helm diff upgrade --install -n [RELEASE_NAMESPACE] [RELEASE_NAME] [-f values.yaml] .
```

## Render Helm templates

To render plain Kubernetes manifests from the Helm chart, run:

```console
helm template -n [RELEASE_NAMESPACE] [RELEASE_NAME] .
```

## Configuration

See [Customizing the Chart Before Installing](https://helm.sh/docs/intro/using_helm/#customizing-the-chart-before-installing). To see all configurable options with detailed comments:

```console
helm show values .
```
### Configuring Graphdb as backend

Please visit https://github.com/Ontotext-AD/graphdb-helm to get familiar with Ontotext GraphDB. Here we show some 

```console
helm repo add --force-update ontotext http://maven.ontotext.com/repository/helm-public"
helm repo update ontotext"

kubectl create namespace graphdb || true"
kubectl -n graphdb create secret generic graphdb-license --from-file graphdb/graphdb.license"
helm upgrade \
    -i \
    -n graphdb \
    --create-namespace
    graphdb GRAPHDB-CHART-OR-PATH
    -f your-graphdb-values.yaml
    --set graphdb.node.license='graphdb-license'"
kubectl rollout status statefulset -n graphdb graphdb-node"
```

You will need to configure those values to set up GraphDB with Corporate Memory.

| Key | Type | Default | Description |
|-----|------|---------|-------------|
| explore.store.graphdb.enabled | bool | `false` | enable this to use GraphDB as backend |
| explore.store.graphdb.repository | string | `cmem` | the repository Corporate Memory stores its data inside GraphDB |
| explore.store.graphdb.user | string | `provisioner` | the GraphDB user used by explore |
| explore.store.graphdb.password | string | `` | the GraphDB users password used by explore |
| explore.store.graphdb.host | string | `` | the GraphDB hostname of the instance (not the URL) |
| explore.store.graphdb.port | string | `7200` | the GraphDB port of the instance or service |
| explore.store.graphdb.sslEnabled | bool | `false` | in case the connections is encrypted (be aware for potential pitfalls here) |


### Configuring Keycloak as authentication provider


```console
helm repo add --force-update bitnami https://charts.bitnami.com/bitnami"
helm repo update bitnami"
kubectl create namespace keycloak --dry-run=client -o yaml | kubectl apply -f -"
# in case you have a working postgres dump
kubectl -n keycloak delete ConfigMap keycloak-postgresql-init-scripts || true "
# in case you have a working postgres dump
cat keycloak/keycloak-postgresql-init-scripts.template.json
          | jq -M --rawfile keycloak_db_sql keycloak/keycloak_db.sql '.data[\"keycloak_db.sql\"] = $keycloak_db_sql'
          | kubectl -n keycloak create -f -"
      kubectl -n keycloak apply -f keycloak/keycloak-secret.yaml"
      kubectl -n keycloak apply -f keycloak/keycloak-postgres-secret.yaml"
      kubectl -n keycloak delete --ignore-not-found=true secret eccenca-docker-registry-credentials"
      kubectl -n keycloak apply -f eccenca-docker-registry-credentials.yaml"
      - defer: rm -f eccenca-docker-registry-credentials.yaml
helm upgrade
          -i
          -n keycloak
          --create-namespace
          keycloak bitnami/keycloak
          -f keycloak/keycloak-values.yaml
          --set ingress.hostname={{ .KEYCLOAK_HOSTNAME }}
          --set initContainers[0].image={{ .KEYCLOAK_THEME_VERSION }}"
      - "cat keycloak/keycloak_separate_ingress.yml
          | sed s/KEYCLOAK_HOSTNAME/{{ .KEYCLOAK_HOSTNAME }}/g
          | sed s/CLUSTER_ISSUER_NAME/{{ .CLUSTER_ISSUER_NAME }}/g
          | kubectl apply -f -"
kubectl rollout status statefulset -n keycloak keycloak-postgresql"
kubectl rollout status statefulset -n keycloak keycloak"
```


You will need to configure those values to set up Keycloak with Corporate Memory.

| Key | Type | Default | Description |
|-----|------|---------|-------------|
| global.cmemClientId | string | `false` | cmem client ID and secret; see also: https://documentation.eccenca.com/24.1/deploy-and-configure/configuration/keycloak/ |
| global.cmemClientSecret | string | `cmem` |  |
| global.keycloakBaseUrl | string | `cmem` | keycloak base url (e.g. https://cmem.example.com/auth) |
| global.keycloakIssuerUrl | string | `cmem` | keycloak cmem realm url (e.g. https://cmem.example.com/auth/realms/cmem)|
| global.oauthClientId | string | `cmem` | keycloak oauth client id (used for explore connection and DataIntegration)|


To configure the installation, please specify additional helm value files via `-f values.yaml`.

We provide a (pre-filled) `values.sample.yaml` file with a minimal set of configuration parameters you would need to provide.
