{{/*
---
cmem helpers
---
*/}}

{{/*
Expand the name of the chart.
*/}}
{{- define "cmem.name" -}}
{{- default .Chart.Name .Values.nameOverride | trunc 63 | trimSuffix "-" }}
{{- end }}

{{/*
Create a default fully qualified app name.
We truncate at 63 chars because some Kubernetes name fields are limited to this (by the DNS naming spec).
If release name contains chart name it will be used as a full name.
*/}}
{{- define "cmem.fullname" -}}
{{- if .Values.fullnameOverride }}
{{- .Values.fullnameOverride | trunc 63 | trimSuffix "-" }}
{{- else }}
{{- $name := default .Chart.Name .Values.nameOverride }}
{{- if contains $name .Release.Name }}
{{- .Release.Name | trunc 63 | trimSuffix "-" }}
{{- else }}
{{- printf "%s-%s" .Release.Name $name | trunc 63 | trimSuffix "-" }}
{{- end }}
{{- end }}
{{- end }}

{{/*
Create chart name and version as used by the chart label.
*/}}
{{- define "cmem.chart" -}}
{{- printf "%s-%s" .Chart.Name .Chart.Version | replace "+" "_" | trunc 63 | trimSuffix "-" }}
{{- end }}

{{/*
Common labels
*/}}
{{- define "cmem.labels" -}}
helm.sh/chart: {{ include "cmem.chart" . }}
{{ include "cmem.selectorLabels" . }}
{{- if .Chart.AppVersion }}
app.kubernetes.io/version: {{ .Chart.AppVersion | quote }}
{{- end }}
app.kubernetes.io/managed-by: {{ .Release.Service }}
{{- end }}

{{/*
Selector labels
*/}}
{{- define "cmem.selectorLabels" -}}
app.kubernetes.io/name: {{ include "cmem.name" . }}
app.kubernetes.io/instance: {{ .Release.Name }}
{{- end }}

{{/*
Image Pull Secret
*/}}
{{- define "eccenca.imagePullSecret" }}
{{- printf "{\"%s\": {\"auth\": \"%s\", \"username\": \"%s\", \"password\": \"%s\"}}" .Values.imageCredentials.registry (printf "%s:%s" .Values.imageCredentials.username .Values.imageCredentials.password | b64enc) .Values.imageCredentials.username .Values.imageCredentials.password | b64enc }}
{{- end }}

{{/*
---
Explore helpers
---
*/}}

{{- define "cmem.name-explore" -}}
{{- "explore" }}
{{- end }}

{{- define "cmem.servicename-explore" -}}
{{- default .Chart.Name .Values.explore.service.name | trunc 63 | trimSuffix "-" }}
{{- end }}

{{- define "cmem.labels-explore" -}}
helm.sh/chart: {{ include "cmem.chart" . }}
{{ include "cmem.selectorLabels-explore" . }}
{{- if .Chart.AppVersion }}
app.kubernetes.io/version: {{ .Chart.AppVersion | quote }}
{{- end }}
app.kubernetes.io/managed-by: {{ .Release.Service }}
{{- end }}

{{- define "cmem.selectorLabels-explore" -}}
{{ include "cmem.selectorLabels" . }}
app.kubernetes.io/component: {{ include "cmem.name-explore" . }}
{{- end }}

{{/*
---
Dataintegration helpers
---
*/}}

{{- define "cmem.name-di" -}}
{{- "dataintegration" }}
{{- end }}

{{- define "cmem.servicename-di" -}}
{{- default .Chart.Name .Values.dataintegration.service.name | trunc 63 | trimSuffix "-" }}
{{- end }}

{{- define "cmem.labels-di" -}}
helm.sh/chart: {{ include "cmem.chart" . }}
{{ include "cmem.selectorLabels-di" . }}
{{- if .Chart.AppVersion }}
app.kubernetes.io/version: {{ .Chart.AppVersion | quote }}
{{- end }}
app.kubernetes.io/managed-by: {{ .Release.Service }}
{{- end }}

{{- define "cmem.selectorLabels-di" -}}
{{ include "cmem.selectorLabels" . }}
app.kubernetes.io/component: {{ include "cmem.name-di" . }}
{{- end }}